/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.security.PrivilegedExceptionAction;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TransformationChain;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerSourceTaskContext;
import org.apache.kafka.connect.runtime.WorkerTask;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerSourceTask
extends WorkerTask {
    private static final Logger log = LoggerFactory.getLogger(WorkerSourceTask.class);
    private static final long SEND_FAILED_BACKOFF_MS = 100L;
    private final WorkerConfig workerConfig;
    private final SourceTask task;
    private final Converter keyConverter;
    private final Converter valueConverter;
    private final HeaderConverter headerConverter;
    private final TransformationChain<SourceRecord> transformationChain;
    private KafkaProducer<byte[], byte[]> producer;
    private final OffsetStorageReader offsetReader;
    private final OffsetStorageWriter offsetWriter;
    private final Time time;
    private final SourceTaskMetricsGroup sourceTaskMetricsGroup;
    private String taskOwner;
    private List<SourceRecord> toSend;
    private boolean lastSendFailed;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessages;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessagesBacklog;
    private boolean flushing;
    private CountDownLatch stopRequestedLatch;
    private Map<String, String> taskConfig;
    private boolean finishedStart = false;
    private boolean startedShutdownBeforeStartCompleted = false;

    public WorkerSourceTask(ConnectorTaskId id, SourceTask task, TaskStatus.Listener statusListener, TargetState initialState, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, TransformationChain<SourceRecord> transformationChain, KafkaProducer<byte[], byte[]> producer, OffsetStorageReader offsetReader, OffsetStorageWriter offsetWriter, WorkerConfig workerConfig, ConnectMetrics connectMetrics, ClassLoader loader, Time time) {
        super(id, statusListener, initialState, loader, connectMetrics);
        this.workerConfig = workerConfig;
        this.task = task;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.headerConverter = headerConverter;
        this.transformationChain = transformationChain;
        this.producer = producer;
        this.offsetReader = offsetReader;
        this.offsetWriter = offsetWriter;
        this.time = time;
        this.toSend = null;
        this.lastSendFailed = false;
        this.outstandingMessages = new IdentityHashMap();
        this.outstandingMessagesBacklog = new IdentityHashMap();
        this.flushing = false;
        this.stopRequestedLatch = new CountDownLatch(1);
        this.sourceTaskMetricsGroup = new SourceTaskMetricsGroup(id, connectMetrics);
    }

    @Override
    public void initialize(TaskConfig taskConfig) {
        this.taskOwner = taskConfig.getString("task.user");
        try {
            this.taskConfig = taskConfig.originalsStrings();
        }
        catch (Throwable t) {
            log.error("{} Task failed initialization and will not be started.", (Object)this, (Object)t);
            this.onFailure(t);
        }
    }

    @Override
    protected void close() {
        this.producer.close(30L, TimeUnit.SECONDS);
        this.transformationChain.close();
    }

    @Override
    protected void releaseResources() {
        this.sourceTaskMetricsGroup.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        this.stopRequestedLatch.countDown();
        WorkerSourceTask workerSourceTask = this;
        synchronized (workerSourceTask) {
            if (this.finishedStart) {
                this.task.stop();
            } else {
                this.startedShutdownBeforeStartCompleted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            this.task.initialize((SourceTaskContext)new WorkerSourceTaskContext(this.offsetReader));
            this.task.start(this.taskConfig);
            log.info("{} Source task finished initialization and start", (Object)this);
            WorkerSourceTask workerSourceTask = this;
            synchronized (workerSourceTask) {
                block13: {
                    if (!this.startedShutdownBeforeStartCompleted) break block13;
                    this.task.stop();
                    return;
                }
                this.finishedStart = true;
            }
            while (!this.isStopping()) {
                if (this.shouldPause()) {
                    this.onPause();
                    if (!this.awaitUnpause()) continue;
                    this.onResume();
                    continue;
                }
                if (this.toSend == null) {
                    log.trace("{} Nothing to send to Kafka. Polling source for additional records", (Object)this);
                    long start = this.time.milliseconds();
                    this.toSend = this.task.poll();
                    if (this.toSend != null) {
                        this.recordPollReturned(this.toSend.size(), this.time.milliseconds() - start);
                    }
                }
                if (this.toSend == null) continue;
                log.debug("{} About to send " + this.toSend.size() + " records to Kafka", (Object)this);
                if (this.sendRecords()) continue;
                this.stopRequestedLatch.await(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.commitOffsets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRecords() {
        int processed = 0;
        this.recordBatch(this.toSend.size());
        final SourceRecordWriteCounter counter = new SourceRecordWriteCounter(this.toSend.size(), this.sourceTaskMetricsGroup);
        for (final SourceRecord preTransformRecord : this.toSend) {
            SourceRecord record = this.transformationChain.apply(preTransformRecord);
            if (record == null) {
                counter.skipRecord();
                this.commitTaskRecord(preTransformRecord);
                continue;
            }
            RecordHeaders headers = this.convertHeaderFor(record);
            byte[] key = this.keyConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            byte[] value = this.valueConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            final ProducerRecord producerRecord = new ProducerRecord(record.topic(), record.kafkaPartition(), ConnectUtils.checkAndConvertTimestamp(record.timestamp()), (Object)key, (Object)value, (Iterable)headers);
            log.trace("{} Appending record with key {}, value {}", new Object[]{this, record.key(), record.value()});
            WorkerSourceTask workerSourceTask = this;
            synchronized (workerSourceTask) {
                if (!this.lastSendFailed) {
                    if (!this.flushing) {
                        this.outstandingMessages.put((ProducerRecord<byte[], byte[]>)producerRecord, (ProducerRecord<byte[], byte[]>)producerRecord);
                    } else {
                        this.outstandingMessagesBacklog.put((ProducerRecord<byte[], byte[]>)producerRecord, (ProducerRecord<byte[], byte[]>)producerRecord);
                    }
                    this.offsetWriter.offset(record.sourcePartition(), record.sourceOffset());
                }
            }
            try {
                if (this.workerConfig.getBoolean("connect.enable.doAs")) {
                    try {
                        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.taskOwner, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() {
                                WorkerSourceTask.this.produceRecord(producerRecord, preTransformRecord, counter);
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        log.error("{} failed to impersonate user {}: {}", new Object[]{this, this.taskOwner, e});
                    }
                } else {
                    this.produceRecord(producerRecord, preTransformRecord, counter);
                }
                this.lastSendFailed = false;
            }
            catch (RetriableException e) {
                log.warn("{} Failed to send {}, backing off before retrying:", new Object[]{this, producerRecord, e});
                this.toSend = this.toSend.subList(processed, this.toSend.size());
                this.lastSendFailed = true;
                counter.retryRemaining();
                return false;
            }
            catch (KafkaException e) {
                throw new ConnectException("Unrecoverable exception trying to send", (Throwable)e);
            }
            ++processed;
        }
        this.toSend = null;
        return true;
    }

    private RecordHeaders convertHeaderFor(SourceRecord record) {
        Headers headers = record.headers();
        RecordHeaders result = new RecordHeaders();
        if (headers != null) {
            String topic = record.topic();
            for (Header header : headers) {
                String key = header.key();
                byte[] rawHeader = this.headerConverter.fromConnectHeader(topic, key, header.schema(), header.value());
                result.add(key, rawHeader);
            }
        }
        return result;
    }

    private void commitTaskRecord(SourceRecord record) {
        try {
            this.task.commitRecord(record);
        }
        catch (Throwable t) {
            log.error("{} Exception thrown while calling task.commitRecord()", (Object)this, (Object)t);
        }
    }

    private synchronized void recordSent(ProducerRecord<byte[], byte[]> record) {
        ProducerRecord<byte[], byte[]> removed = this.outstandingMessages.remove(record);
        if (removed == null && this.flushing) {
            removed = this.outstandingMessagesBacklog.remove(record);
        }
        if (removed == null) {
            log.error("{} CRITICAL Saw callback for record that was not present in the outstanding message set: {}", (Object)this, record);
        } else if (this.flushing && this.outstandingMessages.isEmpty()) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitOffsets() {
        long commitTimeoutMs = this.workerConfig.getLong("offset.flush.timeout.ms");
        log.info("{} Committing offsets", (Object)this);
        long started = this.time.milliseconds();
        long timeout = started + commitTimeoutMs;
        WorkerSourceTask workerSourceTask = this;
        synchronized (workerSourceTask) {
            this.flushing = true;
            boolean flushStarted = this.offsetWriter.beginFlush();
            log.info("{} flushing {} outstanding messages for offset commit", (Object)this, (Object)this.outstandingMessages.size());
            while (!this.outstandingMessages.isEmpty()) {
                try {
                    long timeoutMs = timeout - this.time.milliseconds();
                    if (timeoutMs <= 0L) {
                        log.error("{} Failed to flush, timed out while waiting for producer to flush outstanding {} messages", (Object)this, (Object)this.outstandingMessages.size());
                        this.finishFailedFlush();
                        this.recordCommitFailure(this.time.milliseconds() - started, null);
                        return false;
                    }
                    this.wait(timeoutMs);
                }
                catch (InterruptedException e) {
                    log.error("{} Interrupted while flushing messages, offsets will not be committed", (Object)this);
                    this.finishFailedFlush();
                    this.recordCommitFailure(this.time.milliseconds() - started, null);
                    return false;
                }
            }
            if (!flushStarted) {
                this.finishSuccessfulFlush();
                long durationMillis = this.time.milliseconds() - started;
                this.recordCommitSuccess(durationMillis);
                log.debug("{} Finished offset commitOffsets successfully in {} ms", (Object)this, (Object)durationMillis);
                this.commitSourceTask();
                return true;
            }
        }
        Future<Void> flushFuture = this.offsetWriter.doFlush(new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    log.error("{} Failed to flush offsets to storage: ", (Object)this, (Object)error);
                } else {
                    log.trace("{} Finished flushing offsets to storage", (Object)this);
                }
            }
        });
        if (flushFuture == null) {
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, null);
            return false;
        }
        try {
            flushFuture.get(Math.max(timeout - this.time.milliseconds(), 0L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("{} Flush of offsets interrupted, cancelling", (Object)this);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, e);
            return false;
        }
        catch (ExecutionException e) {
            log.error("{} Flush of offsets threw an unexpected exception: ", (Object)this, (Object)e);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, e);
            return false;
        }
        catch (TimeoutException e) {
            log.error("{} Timed out waiting to flush offsets to storage", (Object)this);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, null);
            return false;
        }
        this.finishSuccessfulFlush();
        long durationMillis = this.time.milliseconds() - started;
        this.recordCommitSuccess(durationMillis);
        log.info("{} Finished commitOffsets successfully in {} ms", (Object)this, (Object)durationMillis);
        this.commitSourceTask();
        return true;
    }

    private void commitSourceTask() {
        try {
            this.task.commit();
        }
        catch (Throwable t) {
            log.error("{} Exception thrown while calling task.commit()", (Object)this, (Object)t);
        }
    }

    private synchronized void finishFailedFlush() {
        this.offsetWriter.cancelFlush();
        this.outstandingMessages.putAll(this.outstandingMessagesBacklog);
        this.outstandingMessagesBacklog.clear();
        this.flushing = false;
    }

    private synchronized void finishSuccessfulFlush() {
        IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> temp = this.outstandingMessages;
        this.outstandingMessages = this.outstandingMessagesBacklog;
        this.outstandingMessagesBacklog = temp;
        this.flushing = false;
    }

    private void produceRecord(final ProducerRecord producerRecord, final SourceRecord preTransformRecord, final SourceRecordWriteCounter counter) {
        final String topic = producerRecord.topic();
        this.producer.send(producerRecord, new org.apache.kafka.clients.producer.Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                if (e != null) {
                    log.error("{} failed to send record to {}: {}", new Object[]{this, topic, e});
                    log.debug("{} Failed record: {}", (Object)this, (Object)preTransformRecord);
                } else {
                    log.trace("{} Wrote record successfully: topic {} partition {} offset {}", new Object[]{this, recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                    WorkerSourceTask.this.commitTaskRecord(preTransformRecord);
                }
                WorkerSourceTask.this.recordSent((ProducerRecord<byte[], byte[]>)producerRecord);
                counter.completeRecord();
            }
        });
    }

    public String toString() {
        return "WorkerSourceTask{id=" + this.id + '}';
    }

    protected void recordPollReturned(int numRecordsInBatch, long duration) {
        this.sourceTaskMetricsGroup.recordPoll(numRecordsInBatch, duration);
    }

    SourceTaskMetricsGroup sourceTaskMetricsGroup() {
        return this.sourceTaskMetricsGroup;
    }

    static class SourceTaskMetricsGroup {
        private final ConnectMetrics.MetricGroup metricGroup;
        private final Sensor sourceRecordPoll;
        private final Sensor sourceRecordWrite;
        private final Sensor sourceRecordActiveCount;
        private final Sensor pollTime;
        private int activeRecordCount;

        public SourceTaskMetricsGroup(ConnectorTaskId id, ConnectMetrics connectMetrics) {
            ConnectMetricsRegistry registry = connectMetrics.registry();
            this.metricGroup = connectMetrics.group(registry.sourceTaskGroupName(), registry.connectorTagName(), id.connector(), registry.taskTagName(), Integer.toString(id.task()));
            this.metricGroup.close();
            this.sourceRecordPoll = this.metricGroup.sensor("source-record-poll");
            this.sourceRecordPoll.add(this.metricGroup.metricName(registry.sourceRecordPollRate), (MeasurableStat)new Rate());
            this.sourceRecordPoll.add(this.metricGroup.metricName(registry.sourceRecordPollTotal), (MeasurableStat)new Total());
            this.sourceRecordWrite = this.metricGroup.sensor("source-record-write");
            this.sourceRecordWrite.add(this.metricGroup.metricName(registry.sourceRecordWriteRate), (MeasurableStat)new Rate());
            this.sourceRecordWrite.add(this.metricGroup.metricName(registry.sourceRecordWriteTotal), (MeasurableStat)new Total());
            this.pollTime = this.metricGroup.sensor("poll-batch-time");
            this.pollTime.add(this.metricGroup.metricName(registry.sourceRecordPollBatchTimeMax), (MeasurableStat)new Max());
            this.pollTime.add(this.metricGroup.metricName(registry.sourceRecordPollBatchTimeAvg), (MeasurableStat)new Avg());
            this.sourceRecordActiveCount = this.metricGroup.sensor("source-record-active-count");
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCount), (MeasurableStat)new Value());
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCountMax), (MeasurableStat)new Max());
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCountAvg), (MeasurableStat)new Avg());
        }

        void close() {
            this.metricGroup.close();
        }

        void recordPoll(int batchSize, long duration) {
            this.sourceRecordPoll.record((double)batchSize);
            this.pollTime.record((double)duration);
            this.activeRecordCount += batchSize;
            this.sourceRecordActiveCount.record((double)this.activeRecordCount);
        }

        void recordWrite(int recordCount) {
            this.sourceRecordWrite.record((double)recordCount);
            this.activeRecordCount -= recordCount;
            this.activeRecordCount = Math.max(0, this.activeRecordCount);
            this.sourceRecordActiveCount.record((double)this.activeRecordCount);
        }

        protected ConnectMetrics.MetricGroup metricGroup() {
            return this.metricGroup;
        }
    }

    static class SourceRecordWriteCounter {
        private final SourceTaskMetricsGroup metricsGroup;
        private final int batchSize;
        private boolean completed = false;
        private int counter;

        public SourceRecordWriteCounter(int batchSize, SourceTaskMetricsGroup metricsGroup) {
            assert (batchSize > 0);
            assert (metricsGroup != null);
            this.batchSize = batchSize;
            this.counter = batchSize;
            this.metricsGroup = metricsGroup;
        }

        public void skipRecord() {
            if (this.counter > 0 && --this.counter == 0) {
                this.finishedAllWrites();
            }
        }

        public void completeRecord() {
            if (this.counter > 0 && --this.counter == 0) {
                this.finishedAllWrites();
            }
        }

        public void retryRemaining() {
            this.finishedAllWrites();
        }

        private void finishedAllWrites() {
            if (!this.completed) {
                this.metricsGroup.recordWrite(this.batchSize - this.counter);
                this.completed = true;
            }
        }
    }
}

