/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

public abstract class AbstractStatus<T> {
    private final T id;
    private final State state;
    private final String trace;
    private final String workerId;
    private final int generation;

    public AbstractStatus(T id, State state, String workerId, int generation, String trace) {
        this.id = id;
        this.state = state;
        this.workerId = workerId;
        this.generation = generation;
        this.trace = trace;
    }

    public T id() {
        return this.id;
    }

    public State state() {
        return this.state;
    }

    public String trace() {
        return this.trace;
    }

    public String workerId() {
        return this.workerId;
    }

    public int generation() {
        return this.generation;
    }

    public String toString() {
        return "Status{id=" + this.id + ", state=" + (Object)((Object)this.state) + ", workerId='" + this.workerId + '\'' + ", generation=" + this.generation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatus that = (AbstractStatus)o;
        if (this.generation != that.generation) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.trace != null ? !this.trace.equals(that.trace) : that.trace != null) {
            return false;
        }
        return this.workerId != null ? this.workerId.equals(that.workerId) : that.workerId == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.trace != null ? this.trace.hashCode() : 0);
        result = 31 * result + (this.workerId != null ? this.workerId.hashCode() : 0);
        result = 31 * result + this.generation;
        return result;
    }

    public static enum State {
        UNASSIGNED,
        RUNNING,
        PAUSED,
        FAILED,
        DESTROYED;

    }
}

