/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.WorkerInfo;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedHerder;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.KafkaConfigBackingStore;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.apache.kafka.connect.storage.KafkaStatusBackingStore;
import org.apache.kafka.connect.util.ConnectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDistributed {
    private static final Logger log = LoggerFactory.getLogger(ConnectDistributed.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            log.info("Usage: ConnectDistributed worker.properties");
            Exit.exit((int)1);
        }
        try {
            Time time = Time.SYSTEM;
            log.info("Kafka Connect distributed worker initializing ...");
            long initStart = time.hiResClockMs();
            WorkerInfo initInfo = new WorkerInfo();
            initInfo.logAll();
            String workerPropsFile = args[0];
            Map workerProps = !workerPropsFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)workerPropsFile)) : Collections.emptyMap();
            DistributedConfig config = new DistributedConfig(workerProps);
            String configTopic = (String)config.originals().get("config.storage.topic");
            if (configTopic.startsWith("/") || configTopic.contains(":")) {
                log.info("Loading MarlinClient");
                Class.forName("com.mapr.streams.impl.MarlinClient");
            }
            log.info("Scanning for plugin classes. This might take a moment ...");
            Plugins plugins = new Plugins(workerProps);
            plugins.compareAndSwapWithDelegatingLoader();
            String kafkaClusterId = ConnectUtils.lookupKafkaClusterId(config);
            log.debug("Kafka cluster ID: {}", (Object)kafkaClusterId);
            RestServer rest = new RestServer(config);
            URI advertisedUrl = rest.advertisedUrl();
            String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
            KafkaOffsetBackingStore offsetBackingStore = new KafkaOffsetBackingStore();
            offsetBackingStore.configure(config);
            Worker worker = new Worker(workerId, time, plugins, config, offsetBackingStore);
            Converter internalValueConverter = worker.getInternalValueConverter();
            KafkaStatusBackingStore statusBackingStore = new KafkaStatusBackingStore(time, internalValueConverter);
            statusBackingStore.configure(config);
            KafkaConfigBackingStore configBackingStore = new KafkaConfigBackingStore(internalValueConverter, config);
            DistributedHerder herder = new DistributedHerder(config, time, worker, kafkaClusterId, statusBackingStore, configBackingStore, advertisedUrl.toString());
            Connect connect = new Connect(herder, rest);
            log.info("Kafka Connect distributed worker initialization took {}ms", (Object)(time.hiResClockMs() - initStart));
            try {
                connect.start();
            }
            catch (Exception e) {
                log.error("Failed to start Connect", (Throwable)e);
                connect.stop();
                Exit.exit((int)3);
            }
            connect.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit((int)2);
        }
    }
}

