/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.testutils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;

public class MetricListener {
    public static final String DELIMITER = ".";
    public static final String ROOT_METRIC_GROUP_NAME = "rootMetricGroup";
    private final MetricGroup rootMetricGroup;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();

    public MetricListener() {
        TestingMetricRegistry registry = TestingMetricRegistry.builder().setDelimiter(DELIMITER.charAt(0)).setRegisterConsumer((metric, name, group) -> this.metrics.put(group.getMetricIdentifier(name), (Metric)metric)).build();
        this.rootMetricGroup = new GenericMetricGroup((MetricRegistry)registry, null, ROOT_METRIC_GROUP_NAME);
    }

    public MetricGroup getMetricGroup() {
        return this.rootMetricGroup;
    }

    public <T extends Metric> Optional<T> getMetric(Class<T> metricType, String ... identifier) {
        if (!this.metrics.containsKey(this.getActualIdentifier(identifier))) {
            return Optional.empty();
        }
        return Optional.of((Metric)metricType.cast(this.metrics.get(this.getActualIdentifier(identifier))));
    }

    public Optional<Meter> getMeter(String ... identifier) {
        return this.getMetric(Meter.class, identifier);
    }

    public Optional<Counter> getCounter(String ... identifier) {
        return this.getMetric(Counter.class, identifier);
    }

    public Optional<Histogram> getHistogram(String ... identifier) {
        return this.getMetric(Histogram.class, identifier);
    }

    public <T> Optional<Gauge<T>> getGauge(String ... identifier) {
        if (!this.metrics.containsKey(this.getActualIdentifier(identifier))) {
            return Optional.empty();
        }
        return Optional.of((Gauge)this.metrics.get(this.getActualIdentifier(identifier)));
    }

    private String getActualIdentifier(String ... identifier) {
        return "rootMetricGroup." + String.join((CharSequence)DELIMITER, identifier);
    }
}

