/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.packaging;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.flink.packaging.PackagingTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PackagingTestUtilsTest {
    PackagingTestUtilsTest() {
    }

    @Test
    void testAssertJarContainsOnlyFilesMatching(@TempDir Path tmp) throws Exception {
        Path jar = PackagingTestUtilsTest.createJar(tmp, Entry.fileEntry("", Arrays.asList("META-INF", "NOTICES")));
        PackagingTestUtils.assertJarContainsOnlyFilesMatching((Path)jar, Collections.singleton("META-INF/"));
        PackagingTestUtils.assertJarContainsOnlyFilesMatching((Path)jar, Collections.singleton("META-INF/NOTICES"));
        Assertions.assertThatThrownBy(() -> PackagingTestUtils.assertJarContainsOnlyFilesMatching((Path)jar, Collections.singleton("META-INF"))).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> PackagingTestUtils.assertJarContainsOnlyFilesMatching((Path)jar, Collections.singleton("META-INF/NOTICE"))).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> PackagingTestUtils.assertJarContainsOnlyFilesMatching((Path)jar, Collections.singleton("META-INF/NOTICES/"))).isInstanceOf(AssertionError.class);
    }

    @Test
    void testAssertJarContainsServiceEntry(@TempDir Path tmp) throws Exception {
        String service = PackagingTestUtilsTest.class.getName();
        Path jar = PackagingTestUtilsTest.createJar(tmp, Entry.fileEntry("", Arrays.asList("META-INF", "services", service)));
        PackagingTestUtils.assertJarContainsServiceEntry((Path)jar, PackagingTestUtilsTest.class);
        Assertions.assertThatThrownBy(() -> PackagingTestUtils.assertJarContainsServiceEntry((Path)jar, PackagingTestUtils.class)).isInstanceOf(AssertionError.class);
    }

    private static Path createJar(Path tempDir, Entry ... entries) throws Exception {
        Path path = tempDir.resolve(UUID.randomUUID().toString() + ".jar");
        URI uri = path.toUri();
        URI jarUri = new URI("jar:file", uri.getHost(), uri.getPath(), uri.getFragment());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem zip = FileSystems.newFileSystem(jarUri, env);){
            Path root = zip.getPath("/", new String[0]);
            for (Entry entry : entries) {
                Path zipPath = root.resolve(zip.getPath(entry.path.get(0), entry.path.subList(1, entry.path.size()).toArray(new String[0])));
                if (entry.isDirectory) {
                    Files.createDirectories(zipPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
                Files.write(zipPath, entry.contents.getBytes(), new OpenOption[0]);
            }
        }
        return path;
    }

    private static class Entry {
        final String contents;
        final List<String> path;
        final boolean isDirectory;

        public static Entry directoryEntry(List<String> path) {
            return new Entry("", path, true);
        }

        public static Entry fileEntry(String contents, List<String> path) {
            return new Entry(contents, path, false);
        }

        private Entry(String contents, List<String> path, boolean isDirectory) {
            this.contents = contents;
            this.path = path;
            this.isDirectory = isDirectory;
        }
    }
}

