/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.ReturnAndJumpCounter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStreams;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.Token;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.flink.util.CollectionUtil;

@Internal
public class BlockStatementGrouper {
    private final long maxMethodLength;
    private final String parameters;
    private final TokenStreamRewriter rewriter;
    private final JavaParser.StatementContext topStatement;

    public BlockStatementGrouper(String code, long maxMethodLength, String parameters) {
        this.maxMethodLength = maxMethodLength;
        this.parameters = parameters;
        CommonTokenStream tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
        JavaParser javaParser = new JavaParser(tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        this.topStatement = javaParser.statement();
        this.rewriter = new TokenStreamRewriter(tokenStream);
    }

    public RewriteGroupedCode rewrite(String context) {
        BlockStatementGrouperVisitor visitor = new BlockStatementGrouperVisitor(this.maxMethodLength, this.parameters);
        visitor.visitStatement(this.topStatement, context);
        Map<String, List<String>> groupStrings = visitor.rewrite(this.rewriter);
        return new RewriteGroupedCode(this.rewriter.getText(), groupStrings);
    }

    private static class BlockStatementGrouperVisitor {
        private final Map<String, List<LocalGroupElement>> groups = new LinkedHashMap<String, List<LocalGroupElement>>();
        private final long maxMethodLength;
        private final String parameters;
        private int counter = 0;

        private BlockStatementGrouperVisitor(long maxMethodLength, String parameters) {
            this.maxMethodLength = maxMethodLength;
            this.parameters = parameters;
        }

        public void visitStatement(JavaParser.StatementContext ctx, String context) {
            if (ctx.getChildCount() == 0) {
                return;
            }
            if (ctx.WHILE() != null || ctx.IF() != null || ctx.ELSE() != null) {
                for (JavaParser.StatementContext statement : ctx.statement()) {
                    if (!this.shouldExtract(statement)) continue;
                    String localContext = String.format("%s_%d", context, this.counter++);
                    this.groupBlock(statement, localContext);
                }
            } else if (this.shouldExtract(ctx)) {
                this.groupBlock(ctx, context);
            }
        }

        private void groupBlock(JavaParser.StatementContext ctx, String context) {
            int localGroupCodeLength = 0;
            ArrayList<LocalGroupElement> localGroup = new ArrayList<LocalGroupElement>();
            for (JavaParser.BlockStatementContext bsc : ctx.block().blockStatement()) {
                JavaParser.StatementContext statement = bsc.statement();
                if (statement.IF() != null || statement.ELSE() != null || statement.WHILE() != null) {
                    String localContext = context + "_rewriteGroup" + this.counter++;
                    this.visitStatement(statement, localContext);
                    localGroup.add(new RewriteContextGroupElement(statement));
                    localGroupCodeLength += 3 + localContext.length() + this.parameters.length();
                    continue;
                }
                if ((long)(localGroupCodeLength + 1 + bsc.getText().length()) <= this.maxMethodLength) {
                    localGroup.add(new ContextGroupElement(bsc));
                    localGroupCodeLength += bsc.getText().length();
                    continue;
                }
                if (this.addLocalGroup(localGroup, context)) {
                    localGroup = new ArrayList();
                    localGroupCodeLength = 0;
                }
                localGroupCodeLength += bsc.getText().length();
                localGroup.add(new ContextGroupElement(bsc));
            }
            this.addLocalGroup(localGroup, context);
        }

        private boolean addLocalGroup(List<LocalGroupElement> localGroup, String context) {
            if (localGroup.size() > 1 || localGroup.size() == 1 && this.canGroupAsSingleStatement(localGroup.get(0).getContext())) {
                String localContext = context + "_rewriteGroup" + this.counter++;
                this.groups.put(localContext, localGroup);
                return true;
            }
            return false;
        }

        private boolean canGroupAsSingleStatement(ParserRuleContext context) {
            JavaParser.StatementContext statement;
            if (context instanceof JavaParser.StatementContext) {
                statement = (JavaParser.StatementContext)context;
            } else if (context instanceof JavaParser.BlockStatementContext) {
                statement = ((JavaParser.BlockStatementContext)context).statement();
            } else {
                return false;
            }
            return statement != null && (statement.IF() != null || statement.ELSE() != null || statement.WHILE() != null);
        }

        private boolean shouldExtract(JavaParser.StatementContext ctx) {
            return ctx != null && ctx.block() != null && ctx.block().blockStatement() != null && ctx.block().blockStatement().size() > 1 && this.getNumOfReturnOrJumpStatements(ctx.block()) == 0;
        }

        private int getNumOfReturnOrJumpStatements(ParserRuleContext ctx) {
            ReturnAndJumpCounter counter = new ReturnAndJumpCounter();
            counter.visit(ctx);
            return counter.getCounter();
        }

        private Map<String, List<String>> rewrite(TokenStreamRewriter rewriter) {
            HashMap groupStrings = CollectionUtil.newHashMapWithExpectedSize((int)this.groups.size());
            for (Map.Entry<String, List<LocalGroupElement>> group : this.groups.entrySet()) {
                List<LocalGroupElement> groupElements = group.getValue();
                List collectedStringGroups = groupElements.stream().map(el -> el.getBody(rewriter)).collect(Collectors.toList());
                rewriter.replace(groupElements.get(0).getStart(), groupElements.get(groupElements.size() - 1).getStop(), (Object)(group.getKey() + "(" + this.parameters + ");"));
                groupStrings.put(group.getKey(), collectedStringGroups);
            }
            return groupStrings;
        }
    }

    public static class RewriteGroupedCode {
        private final String rewriteCode;
        private final Map<String, List<String>> groups;

        public RewriteGroupedCode(String rewriteCode, Map<String, List<String>> groups) {
            this.rewriteCode = rewriteCode;
            this.groups = groups;
        }

        public String getRewriteCode() {
            return this.rewriteCode;
        }

        public Map<String, List<String>> getGroups() {
            return this.groups;
        }
    }

    private static class RewriteContextGroupElement
    implements LocalGroupElement {
        private final ParserRuleContext parserRuleContext;

        private RewriteContextGroupElement(ParserRuleContext parserRuleContext) {
            this.parserRuleContext = parserRuleContext;
        }

        @Override
        public Token getStart() {
            return this.parserRuleContext.start;
        }

        @Override
        public Token getStop() {
            return this.parserRuleContext.stop;
        }

        @Override
        public String getBody(TokenStreamRewriter rewriter) {
            return rewriter.getText(this.parserRuleContext.getSourceInterval());
        }

        @Override
        public ParserRuleContext getContext() {
            return this.parserRuleContext;
        }
    }

    private static class ContextGroupElement
    implements LocalGroupElement {
        private final ParserRuleContext parserRuleContext;

        private ContextGroupElement(ParserRuleContext parserRuleContext) {
            this.parserRuleContext = parserRuleContext;
        }

        @Override
        public Token getStart() {
            return this.parserRuleContext.start;
        }

        @Override
        public Token getStop() {
            return this.parserRuleContext.stop;
        }

        @Override
        public String getBody(TokenStreamRewriter rewriter) {
            return rewriter.getText(this.parserRuleContext.getSourceInterval());
        }

        @Override
        public ParserRuleContext getContext() {
            return this.parserRuleContext;
        }
    }

    private static interface LocalGroupElement {
        public Token getStart();

        public Token getStop();

        public String getBody(TokenStreamRewriter var1);

        public ParserRuleContext getContext();
    }
}

