/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.util.Set;
import java.util.function.Function;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.asyncprocessing.AsyncKeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class StreamingJoinOperatorTestBase {
    protected InternalTypeInfo<RowData> leftTypeInfo = InternalTypeInfo.of((RowType)RowType.of((LogicalType[])new LogicalType[]{new CharType(false, 20), new CharType(false, 20), VarCharType.STRING_TYPE}, (String[])new String[]{"order_id", "line_order_id", "shipping_address"}));
    protected InternalTypeInfo<RowData> rightTypeInfo = InternalTypeInfo.of((RowType)RowType.of((LogicalType[])new LogicalType[]{new CharType(false, 20), new CharType(true, 10)}, (String[])new String[]{"line_order_id0", "line_order_ship_mode"}));
    protected RowDataKeySelector leftKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{1}, this.leftTypeInfo.toRowType().getChildren().toArray(new LogicalType[0]));
    protected RowDataKeySelector rightKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{0}, this.rightTypeInfo.toRowType().getChildren().toArray(new LogicalType[0]));
    protected final JoinInputSideSpec leftInputSpec = JoinInputSideSpec.withUniqueKeyContainedByJoinKey(this.leftTypeInfo, (KeySelector)this.leftKeySelector);
    protected final JoinInputSideSpec rightInputSpec = JoinInputSideSpec.withUniqueKeyContainedByJoinKey(this.rightTypeInfo, (KeySelector)this.rightKeySelector);
    protected final InternalTypeInfo<RowData> joinKeyTypeInfo = InternalTypeInfo.of((LogicalType)new CharType(false, 20));
    protected final String funcCode = "public class ConditionFunction extends org.apache.flink.api.common.functions.AbstractRichFunction implements org.apache.flink.table.runtime.generated.JoinCondition {\n\n    public ConditionFunction(Object[] reference) {\n    }\n\n    @Override\n    public boolean apply(org.apache.flink.table.data.RowData in1, org.apache.flink.table.data.RowData in2) {\n        return true;\n    }\n\n    @Override\n    public void close() throws Exception {\n        super.close();\n    }}\n";
    protected final GeneratedJoinCondition joinCondition = new GeneratedJoinCondition("ConditionFunction", "public class ConditionFunction extends org.apache.flink.api.common.functions.AbstractRichFunction implements org.apache.flink.table.runtime.generated.JoinCondition {\n\n    public ConditionFunction(Object[] reference) {\n    }\n\n    @Override\n    public boolean apply(org.apache.flink.table.data.RowData in1, org.apache.flink.table.data.RowData in2) {\n        return true;\n    }\n\n    @Override\n    public void close() throws Exception {\n        super.close();\n    }}\n", new Object[0]);
    protected RowDataHarnessAssertor assertor;
    protected KeyedTwoInputStreamOperatorTestHarness<RowData, RowData, RowData, RowData> testHarness;
    protected static final Function<Set<String>, Long[]> STATE_RETENTION_TIME_EXTRACTOR = tags -> {
        if (tags.isEmpty()) {
            return new Long[]{0L, 0L};
        }
        Long[] ttl = new Long[]{0L, 0L};
        for (String tag : tags) {
            String[] splits = tag.split("=");
            long value = Long.parseLong(splits[1].trim());
            if (splits[0].trim().startsWith("left")) {
                ttl[0] = value;
                continue;
            }
            ttl[1] = value;
        }
        return ttl;
    };

    @BeforeEach
    void beforeEach(TestInfo testInfo) throws Exception {
        TwoInputStreamOperator<RowData, RowData, RowData> operator = this.createJoinOperator(testInfo);
        this.testHarness = operator instanceof AsyncStateProcessingOperator ? AsyncKeyedTwoInputStreamOperatorTestHarness.create(operator, (KeySelector)this.leftKeySelector, (KeySelector)this.rightKeySelector, this.joinKeyTypeInfo) : new KeyedTwoInputStreamOperatorTestHarness(operator, (KeySelector)this.leftKeySelector, (KeySelector)this.rightKeySelector, this.joinKeyTypeInfo);
        this.testHarness.open();
        this.assertor = new RowDataHarnessAssertor(this.getOutputType().getChildren().toArray(new LogicalType[0]));
    }

    @AfterEach
    void afterEach() throws Exception {
        this.testHarness.close();
    }

    protected abstract TwoInputStreamOperator<RowData, RowData, RowData> createJoinOperator(TestInfo var1);

    protected abstract RowType getOutputType();
}

