/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.streaming.util.retryable.RetryPredicates;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.runtime.operators.join.lookup.ResultRetryStrategy;
import org.apache.flink.table.runtime.operators.join.lookup.RetryableLookupFunctionDelegator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.types.logical.LogicalType;
import org.junit.jupiter.api.Test;

class RetryableLookupFunctionDelegatorTest {
    private final LookupFunction userLookupFunc = new TestingLookupFunction();
    private final ResultRetryStrategy retryStrategy = ResultRetryStrategy.fixedDelayRetry((int)3, (long)10L, (Predicate)RetryPredicates.EMPTY_RESULT_PREDICATE);
    private final RetryableLookupFunctionDelegator delegator = new RetryableLookupFunctionDelegator(this.userLookupFunc, this.retryStrategy);
    private static final Map<RowData, Collection<RowData>> data = new HashMap<RowData, Collection<RowData>>();
    private final RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType()});

    RetryableLookupFunctionDelegatorTest() {
    }

    @Test
    void testLookupWithRetry() throws Exception {
        this.delegator.open(new FunctionContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0)));
        for (int i = 1; i <= 5; ++i) {
            GenericRowData key = GenericRowData.of((Object[])new Object[]{i});
            this.assertor.assertOutputEquals("output wrong", Collections.singleton(data.get(key)), Collections.singleton(this.delegator.lookup((RowData)key)));
        }
        this.delegator.close();
    }

    static {
        data.put((RowData)GenericRowData.of((Object[])new Object[]{1}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"Julian")})));
        data.put((RowData)GenericRowData.of((Object[])new Object[]{3}), Arrays.asList(GenericRowData.of((Object[])new Object[]{3, StringData.fromString((String)"Jark")}), GenericRowData.of((Object[])new Object[]{3, StringData.fromString((String)"Jackson")})));
        data.put((RowData)GenericRowData.of((Object[])new Object[]{4}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{4, StringData.fromString((String)"Fabian")})));
    }

    public static final class TestingLookupFunction
    extends LookupFunction {
        private static final long serialVersionUID = 1L;

        public Collection<RowData> lookup(RowData keyRow) throws IOException {
            return data.get(keyRow);
        }
    }
}

