/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.time.Duration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.asyncprocessing.AsyncKeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;

abstract class RowTimeDeduplicateFunctionTestBase {
    protected final long miniBatchSize = 4L;
    protected Duration minTtlTime = Duration.ofMillis(10L);
    protected InternalTypeInfo inputRowType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, new IntType(), new BigIntType()});
    protected TypeSerializer<RowData> serializer = this.inputRowType.toSerializer();
    protected int rowTimeIndex = 2;
    protected int rowKeyIndex = 0;
    protected RowDataKeySelector rowKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.rowKeyIndex}, this.inputRowType.toRowFieldTypes());
    protected RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(this.inputRowType.toRowFieldTypes(), new GenericRowRecordSortComparator(this.rowKeyIndex, this.inputRowType.toRowFieldTypes()[this.rowKeyIndex]));

    RowTimeDeduplicateFunctionTestBase() {
    }

    protected OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(OneInputStreamOperator<RowData, RowData> operator) throws Exception {
        if (operator instanceof AsyncStateProcessingOperator) {
            return AsyncKeyedOneInputStreamOperatorTestHarness.create(operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
        }
        return new KeyedOneInputStreamOperatorTestHarness(operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }
}

