/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalTimeSerializer;
import org.apache.flink.api.common.typeutils.base.SqlDateSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimeSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimestampSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.RandomAccessOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.util.DataFormatTestUtil;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.RawValueDataAsserter;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;

class BinaryRowDataTest {
    BinaryRowDataTest() {
    }

    @Test
    void testBasic() {
        Assertions.assertThat((int)new BinaryRowData(0).getFixedLengthPartSize()).isEqualTo(8);
        Assertions.assertThat((int)new BinaryRowData(1).getFixedLengthPartSize()).isEqualTo(16);
        Assertions.assertThat((int)new BinaryRowData(65).getFixedLengthPartSize()).isEqualTo(536);
        Assertions.assertThat((int)new BinaryRowData(128).getFixedLengthPartSize()).isEqualTo(1048);
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])new byte[100]);
        BinaryRowData row = new BinaryRowData(2);
        row.pointTo(segment, 10, 48);
        Assertions.assertThat((Object)segment).isSameAs((Object)row.getSegments()[0]);
        row.setInt(0, 5);
        row.setDouble(1, 5.8);
    }

    @Test
    void testSetAndGet() {
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])new byte[80]);
        BinaryRowData row = new BinaryRowData(9);
        row.pointTo(segment, 0, 80);
        row.setNullAt(0);
        row.setInt(1, 11);
        row.setLong(2, 22L);
        row.setDouble(3, 33.0);
        row.setBoolean(4, true);
        row.setShort(5, (short)55);
        row.setByte(6, (byte)66);
        row.setFloat(7, 77.0f);
        Assertions.assertThat((long)((long)row.getDouble(3))).isEqualTo(33L);
        Assertions.assertThat((int)row.getInt(1)).isEqualTo(11);
        Assertions.assertThat((boolean)row.isNullAt(0)).isTrue();
        Assertions.assertThat((short)row.getShort(5)).isEqualTo((short)55);
        Assertions.assertThat((long)row.getLong(2)).isEqualTo(22L);
        Assertions.assertThat((boolean)row.getBoolean(4)).isTrue();
        Assertions.assertThat((byte)row.getByte(6)).isEqualTo((byte)66);
        Assertions.assertThat((float)row.getFloat(7)).isEqualTo(77.0f);
    }

    @Test
    void testWriter() {
        int arity = 13;
        BinaryRowData row = new BinaryRowData(arity);
        BinaryRowWriter writer = new BinaryRowWriter(row, 20);
        writer.writeString(0, StringData.fromString((String)"1"));
        writer.writeString(3, StringData.fromString((String)"1234567"));
        writer.writeString(5, StringData.fromString((String)"12345678"));
        writer.writeString(9, StringData.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320"));
        writer.writeBoolean(1, true);
        writer.writeByte(2, (byte)99);
        writer.writeDouble(6, 87.1);
        writer.writeFloat(7, 26.1f);
        writer.writeInt(8, 88);
        writer.writeLong(10, 284L);
        writer.writeShort(11, (short)292);
        writer.setNullAt(12);
        writer.complete();
        this.assertTestWriterRow(row);
        this.assertTestWriterRow(row.copy());
        int subSize = row.getFixedLengthPartSize() + 10;
        MemorySegment subMs1 = MemorySegmentFactory.wrap((byte[])new byte[subSize]);
        MemorySegment subMs2 = MemorySegmentFactory.wrap((byte[])new byte[subSize]);
        row.getSegments()[0].copyTo(0, subMs1, 0, subSize);
        row.getSegments()[0].copyTo(subSize, subMs2, 0, row.getSizeInBytes() - subSize);
        BinaryRowData toCopy = new BinaryRowData(arity);
        toCopy.pointTo(new MemorySegment[]{subMs1, subMs2}, 0, row.getSizeInBytes());
        Assertions.assertThat((Object)toCopy).isEqualTo((Object)row);
        this.assertTestWriterRow(toCopy);
        this.assertTestWriterRow(toCopy.copy(new BinaryRowData(arity)));
    }

    @Test
    void testWriteString() {
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        char[] chars = new char[]{'\uffff', '\u0000'};
        writer.writeString(0, StringData.fromString((String)new String(chars)));
        writer.complete();
        String str = row.getString(0).toString();
        Assertions.assertThat((char)str.charAt(0)).isEqualTo(chars[0]);
        Assertions.assertThat((char)str.charAt(1)).isEqualTo(chars[1]);
        String str2 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320";
        BinaryRowData row2 = new BinaryRowData(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeString(0, StringData.fromString((String)str2));
        writer2.writeString(1, StringData.fromBytes((byte[])str2.getBytes(StandardCharsets.UTF_8)));
        writer2.complete();
        Assertions.assertThat((String)row2.getString(0).toString()).isEqualTo(str2);
        Assertions.assertThat((String)row2.getString(1).toString()).isEqualTo(str2);
    }

    @Test
    void testPagesSer() throws IOException {
        MemorySegment[] memorySegments = new MemorySegment[5];
        ArrayList<MemorySegment> memorySegmentList = new ArrayList<MemorySegment>();
        for (int i = 0; i < 5; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
            memorySegmentList.add(memorySegments[i]);
        }
        String str = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)str));
        writer.complete();
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(1);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        BinaryRowData mapRow = serializer.createInstance();
        mapRow = serializer.mapFromPages(mapRow, (AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        writer.reset();
        writer.writeString(0, mapRow.getString(0));
        writer.complete();
        Assertions.assertThat((String)row.getString(0).toString()).isEqualTo(str);
        BinaryRowData deserRow = serializer.deserializeFromPages((AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        writer.reset();
        writer.writeString(0, deserRow.getString(0));
        writer.complete();
        Assertions.assertThat((String)row.getString(0).toString()).isEqualTo(str);
        String str1 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        String str2 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        BinaryRowData row2 = new BinaryRowData(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeString(0, StringData.fromString((String)str1));
        writer2.writeString(1, StringData.fromString((String)str2));
        writer2.complete();
        RandomAccessOutputView out2 = new RandomAccessOutputView(memorySegments, 64);
        out2.skipBytesToWrite(40);
        BinaryRowDataSerializer serializer2 = new BinaryRowDataSerializer(2);
        serializer2.serializeToPages(row2, (AbstractPagedOutputView)out2);
        RandomAccessInputView in = new RandomAccessInputView(memorySegmentList, 64);
        in.skipBytesToRead(40);
        BinaryRowData mapRow2 = serializer2.createInstance();
        mapRow2 = serializer2.mapFromPages(mapRow2, (AbstractPagedInputView)in);
        writer2.reset();
        writer2.writeString(0, mapRow2.getString(0));
        writer2.writeString(1, mapRow2.getString(1));
        writer2.complete();
        Assertions.assertThat((String)row2.getString(0).toString()).isEqualTo(str1);
        Assertions.assertThat((String)row2.getString(1).toString()).isEqualTo(str2);
        in = new RandomAccessInputView(memorySegmentList, 64);
        in.skipBytesToRead(40);
        BinaryRowData deserRow2 = serializer2.deserializeFromPages((AbstractPagedInputView)in);
        writer2.reset();
        writer2.writeString(0, deserRow2.getString(0));
        writer2.writeString(1, deserRow2.getString(1));
        writer2.complete();
        Assertions.assertThat((String)row2.getString(0).toString()).isEqualTo(str1);
        Assertions.assertThat((String)row2.getString(1).toString()).isEqualTo(str2);
    }

    private void assertTestWriterRow(BinaryRowData row) {
        Assertions.assertThat((String)row.getString(0).toString()).isEqualTo("1");
        Assertions.assertThat((int)row.getInt(8)).isEqualTo(88);
        Assertions.assertThat((short)row.getShort(11)).isEqualTo((short)292);
        Assertions.assertThat((long)row.getLong(10)).isEqualTo(284L);
        Assertions.assertThat((byte)row.getByte(2)).isEqualTo((byte)99);
        Assertions.assertThat((double)row.getDouble(6)).isEqualTo(87.1);
        Assertions.assertThat((float)row.getFloat(7)).isEqualTo(26.1f);
        Assertions.assertThat((boolean)row.getBoolean(1)).isTrue();
        Assertions.assertThat((String)row.getString(3).toString()).isEqualTo("1234567");
        Assertions.assertThat((String)row.getString(5).toString()).isEqualTo("12345678");
        Assertions.assertThat((String)row.getString(9).toString()).isEqualTo("\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320");
        Assertions.assertThat((int)row.getString(9).hashCode()).isEqualTo(StringData.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320").hashCode());
        Assertions.assertThat((boolean)row.isNullAt(12)).isTrue();
    }

    @Test
    void testReuseWriter() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)"01234567"));
        writer.writeString(1, StringData.fromString((String)"012345678"));
        writer.complete();
        Assertions.assertThat((String)row.getString(0).toString()).isEqualTo("01234567");
        Assertions.assertThat((String)row.getString(1).toString()).isEqualTo("012345678");
        writer.reset();
        writer.writeString(0, StringData.fromString((String)"1"));
        writer.writeString(1, StringData.fromString((String)"0123456789"));
        writer.complete();
        Assertions.assertThat((String)row.getString(0).toString()).isEqualTo("1");
        Assertions.assertThat((String)row.getString(1).toString()).isEqualTo("0123456789");
    }

    @Test
    void anyNullTest() {
        BinaryRowData row = new BinaryRowData(3);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        Assertions.assertThat((boolean)row.anyNull()).isFalse();
        row.setRowKind(RowKind.UPDATE_BEFORE);
        Assertions.assertThat((boolean)row.anyNull()).isFalse();
        writer.setNullAt(2);
        Assertions.assertThat((boolean)row.anyNull()).isTrue();
        writer.setNullAt(0);
        Assertions.assertThat((boolean)row.anyNull(new int[]{0, 1, 2})).isTrue();
        Assertions.assertThat((boolean)row.anyNull(new int[]{1})).isFalse();
        writer.setNullAt(1);
        Assertions.assertThat((boolean)row.anyNull()).isTrue();
        int numFields = 80;
        for (int i = 0; i < numFields; ++i) {
            BinaryRowData row2 = new BinaryRowData(numFields);
            BinaryRowWriter writer2 = new BinaryRowWriter(row2);
            row2.setRowKind(RowKind.DELETE);
            Assertions.assertThat((boolean)row2.anyNull()).isFalse();
            writer2.setNullAt(i);
            Assertions.assertThat((boolean)row2.anyNull()).isTrue();
        }
    }

    @Test
    void testSingleSegmentBinaryRowHashCode() {
        int i;
        Random rnd = new Random(System.currentTimeMillis());
        BinaryRowData row = new BinaryRowData(13);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int i2 = 0; i2 < 99; ++i2) {
            writer.reset();
            writer.writeString(0, StringData.fromString((String)("" + rnd.nextInt())));
            writer.writeString(3, StringData.fromString((String)"01234567"));
            writer.writeString(5, StringData.fromString((String)"012345678"));
            writer.writeString(9, StringData.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320"));
            writer.writeBoolean(1, true);
            writer.writeByte(2, (byte)99);
            writer.writeDouble(6, 87.1);
            writer.writeFloat(7, 26.1f);
            writer.writeInt(8, 88);
            writer.writeLong(10, 284L);
            writer.writeShort(11, (short)292);
            writer.setNullAt(12);
            writer.complete();
            BinaryRowData copy = row.copy();
            Assertions.assertThat((int)copy.hashCode()).isEqualTo(row.hashCode());
        }
        int count = 999999;
        HashSet<Integer> hashCodes = new HashSet<Integer>(count);
        for (i = 0; i < count; ++i) {
            row.setInt(8, i);
            hashCodes.add(row.hashCode());
        }
        Assertions.assertThat(hashCodes).hasSize(count);
        hashCodes.clear();
        row = new BinaryRowData(1);
        writer = new BinaryRowWriter(row);
        for (i = 0; i < count; ++i) {
            writer.reset();
            writer.writeString(0, StringData.fromString((String)("\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320" + i)));
            writer.complete();
            hashCodes.add(row.hashCode());
        }
        Assertions.assertThat((int)hashCodes.size()).isGreaterThan((int)((double)count * 0.997));
    }

    @Test
    void testHeaderSize() {
        Assertions.assertThat((int)BinaryRowData.calculateBitSetWidthInBytes((int)56)).isEqualTo(8);
        Assertions.assertThat((int)BinaryRowData.calculateBitSetWidthInBytes((int)57)).isEqualTo(16);
        Assertions.assertThat((int)BinaryRowData.calculateBitSetWidthInBytes((int)120)).isEqualTo(16);
        Assertions.assertThat((int)BinaryRowData.calculateBitSetWidthInBytes((int)121)).isEqualTo(24);
    }

    @Test
    void testHeader() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeInt(0, 10);
        writer.setNullAt(1);
        writer.writeRowKind(RowKind.UPDATE_BEFORE);
        writer.complete();
        BinaryRowData newRow = row.copy();
        Assertions.assertThat((Object)newRow).isEqualTo((Object)row);
        Assertions.assertThat((Comparable)newRow.getRowKind()).isEqualTo((Object)RowKind.UPDATE_BEFORE);
        newRow.setRowKind(RowKind.DELETE);
        Assertions.assertThat((Comparable)newRow.getRowKind()).isEqualTo((Object)RowKind.DELETE);
    }

    @Test
    void testDecimal() {
        int precision = 4;
        int scale = 2;
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeDecimal(0, DecimalData.fromUnscaledLong((long)5L, (int)precision, (int)scale), precision);
        writer.setNullAt(1);
        writer.complete();
        Assertions.assertThat((String)row.getDecimal(0, precision, scale).toString()).isEqualTo("0.05");
        Assertions.assertThat((boolean)row.isNullAt(1)).isTrue();
        row.setDecimal(0, DecimalData.fromUnscaledLong((long)6L, (int)precision, (int)scale), precision);
        Assertions.assertThat((String)row.getDecimal(0, precision, scale).toString()).isEqualTo("0.06");
        precision = 25;
        scale = 5;
        DecimalData decimal1 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(5.55), (int)precision, (int)scale);
        DecimalData decimal2 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.55), (int)precision, (int)scale);
        BinaryRowData row2 = new BinaryRowData(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeDecimal(0, decimal1, precision);
        writer2.writeDecimal(1, null, precision);
        writer2.complete();
        Assertions.assertThat((String)row2.getDecimal(0, precision, scale).toString()).isEqualTo("5.55000");
        Assertions.assertThat((boolean)row2.isNullAt(1)).isTrue();
        row2.setDecimal(0, decimal2, precision);
        Assertions.assertThat((String)row2.getDecimal(0, precision, scale).toString()).isEqualTo("6.55000");
    }

    @Test
    void testRawValueData() {
        BinaryRowData row = new BinaryRowData(3);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        RawValueDataSerializer binarySerializer = new RawValueDataSerializer((TypeSerializer)StringSerializer.INSTANCE);
        RawValueData hahah = RawValueData.fromObject((Object)"hahah");
        writer.writeRawValue(0, hahah, binarySerializer);
        writer.setNullAt(1);
        writer.writeRawValue(2, hahah, binarySerializer);
        writer.complete();
        RawValueData generic0 = row.getRawValue(0);
        Assertions.assertThat((Object)generic0).satisfies((Condition)HamcrestCondition.matching((Matcher)RawValueDataAsserter.equivalent(hahah, binarySerializer)));
        Assertions.assertThat((boolean)row.isNullAt(1)).isTrue();
        RawValueData generic2 = row.getRawValue(2);
        Assertions.assertThat((Object)generic2).satisfies((Condition)HamcrestCondition.matching((Matcher)RawValueDataAsserter.equivalent(hahah, binarySerializer)));
    }

    @Test
    void testNested() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeRow(0, (RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"1"), 1}), new RowDataSerializer(RowType.of((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, new IntType()})));
        writer.setNullAt(1);
        writer.complete();
        RowData nestedRow = row.getRow(0, 2);
        Assertions.assertThat((String)nestedRow.getString(0).toString()).isEqualTo("1");
        Assertions.assertThat((int)nestedRow.getInt(1)).isEqualTo(1);
        Assertions.assertThat((boolean)row.isNullAt(1)).isTrue();
    }

    @Test
    void testBinary() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        byte[] bytes1 = new byte[]{1, -1, 5};
        byte[] bytes2 = new byte[]{1, -1, 5, 5, 1, 5, 1, 5};
        writer.writeBinary(0, bytes1);
        writer.writeBinary(1, bytes2);
        writer.complete();
        Assertions.assertThat((byte[])row.getBinary(0)).isEqualTo((Object)bytes1);
        Assertions.assertThat((byte[])row.getBinary(1)).isEqualTo((Object)bytes2);
    }

    @Test
    void testBinaryArray() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter arrayWriter = new BinaryArrayWriter(array, 3, BinaryArrayData.calculateFixLengthPartSize((LogicalType)DataTypes.INT().getLogicalType()));
        arrayWriter.writeInt(0, 6);
        arrayWriter.setNullInt(1);
        arrayWriter.writeInt(2, 666);
        arrayWriter.complete();
        Assertions.assertThat((int)6).isEqualTo(array.getInt(0));
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        Assertions.assertThat((int)666).isEqualTo(array.getInt(2));
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        ArrayDataSerializer serializer = new ArrayDataSerializer(DataTypes.INT().getLogicalType());
        rowWriter.writeArray(0, (ArrayData)array, serializer);
        rowWriter.complete();
        BinaryArrayData array2 = (BinaryArrayData)row.getArray(0);
        Assertions.assertThat((Object)array2).isEqualTo((Object)array);
        Assertions.assertThat((int)array2.getInt(0)).isEqualTo(6);
        Assertions.assertThat((boolean)array2.isNullAt(1)).isTrue();
        Assertions.assertThat((int)array2.getInt(2)).isEqualTo(666);
    }

    @Test
    void testGenericArray() {
        Object[] javaArray = new Integer[]{6, null, 666};
        GenericArrayData array = new GenericArrayData(javaArray);
        Assertions.assertThat((int)6).isEqualTo(array.getInt(0));
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        Assertions.assertThat((int)666).isEqualTo(array.getInt(2));
        BinaryRowData row2 = new BinaryRowData(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        ArrayDataSerializer serializer = new ArrayDataSerializer(DataTypes.INT().getLogicalType());
        writer2.writeArray(0, (ArrayData)array, serializer);
        writer2.complete();
        ArrayData array2 = row2.getArray(0);
        Assertions.assertThat((int)array2.getInt(0)).isEqualTo(6);
        Assertions.assertThat((boolean)array2.isNullAt(1)).isTrue();
        Assertions.assertThat((int)array2.getInt(2)).isEqualTo(666);
    }

    @Test
    void testBinaryMap() {
        BinaryArrayData array1 = new BinaryArrayData();
        BinaryArrayWriter writer1 = new BinaryArrayWriter(array1, 4, BinaryArrayData.calculateFixLengthPartSize((LogicalType)DataTypes.INT().getLogicalType()));
        writer1.writeInt(0, 6);
        writer1.writeInt(1, 5);
        writer1.writeInt(2, 666);
        writer1.writeInt(3, 0);
        writer1.complete();
        BinaryArrayData array2 = new BinaryArrayData();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 4, BinaryArrayData.calculateFixLengthPartSize((LogicalType)DataTypes.STRING().getLogicalType()));
        writer2.writeString(0, StringData.fromString((String)"6"));
        writer2.writeString(1, StringData.fromString((String)"5"));
        writer2.writeString(2, StringData.fromString((String)"666"));
        writer2.setNullAt(3, DataTypes.STRING().getLogicalType());
        writer2.complete();
        BinaryMapData binaryMap = BinaryMapData.valueOf((BinaryArrayData)array1, (BinaryArrayData)array2);
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        MapDataSerializer serializer = new MapDataSerializer(DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType());
        rowWriter.writeMap(0, (MapData)binaryMap, serializer);
        rowWriter.complete();
        BinaryMapData map = (BinaryMapData)row.getMap(0);
        BinaryArrayData key = map.keyArray();
        BinaryArrayData value = map.valueArray();
        Assertions.assertThat((Object)map).isEqualTo((Object)binaryMap);
        Assertions.assertThat((Object)key).isEqualTo((Object)array1);
        Assertions.assertThat((Object)value).isEqualTo((Object)array2);
        Assertions.assertThat((int)key.getInt(1)).isEqualTo(5);
        Assertions.assertThat((Comparable)value.getString(1)).isEqualTo((Object)StringData.fromString((String)"5"));
        Assertions.assertThat((int)key.getInt(3)).isEqualTo(0);
        Assertions.assertThat((boolean)value.isNullAt(3)).isTrue();
    }

    @Test
    void testGenericMap() {
        HashMap<Integer, StringData> javaMap = new HashMap<Integer, StringData>();
        javaMap.put(6, StringData.fromString((String)"6"));
        javaMap.put(5, StringData.fromString((String)"5"));
        javaMap.put(666, StringData.fromString((String)"666"));
        javaMap.put(0, null);
        GenericMapData genericMap = new GenericMapData(javaMap);
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        MapDataSerializer serializer = new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType());
        rowWriter.writeMap(0, (MapData)genericMap, serializer);
        rowWriter.complete();
        Map map = MapDataUtil.convertToJavaMap((MapData)row.getMap(0), (LogicalType)DataTypes.INT().getLogicalType(), (LogicalType)DataTypes.STRING().getLogicalType());
        Assertions.assertThat(map.get(6)).isEqualTo((Object)StringData.fromString((String)"6"));
        Assertions.assertThat(map.get(5)).isEqualTo((Object)StringData.fromString((String)"5"));
        Assertions.assertThat(map.get(666)).isEqualTo((Object)StringData.fromString((String)"666"));
        Assertions.assertThat((Map)map).containsKey((Object)0);
        Assertions.assertThat(map.get(0)).isNull();
    }

    @Test
    void testGenericObject() throws Exception {
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer((SerializerConfig)new SerializerConfigImpl());
        RawValueDataSerializer binarySerializer = new RawValueDataSerializer(genericSerializer);
        BinaryRowData row = new BinaryRowData(4);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeInt(0, 0);
        RawValueData myObj1 = RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(0, 1.0));
        writer.writeRawValue(1, myObj1, binarySerializer);
        RawValueData myObj2 = RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(123, 5.0));
        writer.writeRawValue(2, myObj2, binarySerializer);
        RawValueData myObj3 = RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(1, 1.0));
        writer.writeRawValue(3, myObj3, binarySerializer);
        writer.complete();
        this.assertTestGenericObjectRow(row, (TypeSerializer<DataFormatTestUtil.MyObj>)genericSerializer);
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(4);
        MemorySegment[] memorySegments = new MemorySegment[3];
        ArrayList<MemorySegment> memorySegmentList = new ArrayList<MemorySegment>();
        for (int i = 0; i < 3; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
            memorySegmentList.add(memorySegments[i]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        BinaryRowData mapRow = serializer.createInstance();
        mapRow = serializer.mapFromPages(mapRow, (AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        this.assertTestGenericObjectRow(mapRow, (TypeSerializer<DataFormatTestUtil.MyObj>)genericSerializer);
    }

    private void assertTestGenericObjectRow(BinaryRowData row, TypeSerializer<DataFormatTestUtil.MyObj> serializer) {
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(0);
        RawValueData rawValue1 = row.getRawValue(1);
        RawValueData rawValue2 = row.getRawValue(2);
        RawValueData rawValue3 = row.getRawValue(3);
        Assertions.assertThat((Object)((DataFormatTestUtil.MyObj)rawValue1.toObject(serializer))).isEqualTo((Object)new DataFormatTestUtil.MyObj(0, 1.0));
        Assertions.assertThat((Object)((DataFormatTestUtil.MyObj)rawValue2.toObject(serializer))).isEqualTo((Object)new DataFormatTestUtil.MyObj(123, 5.0));
        Assertions.assertThat((Object)((DataFormatTestUtil.MyObj)rawValue3.toObject(serializer))).isEqualTo((Object)new DataFormatTestUtil.MyObj(1, 1.0));
    }

    @Test
    void testDateAndTimeAsGenericObject() {
        BinaryRowData row = new BinaryRowData(7);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        LocalDate localDate = LocalDate.of(2019, 7, 16);
        LocalTime localTime = LocalTime.of(17, 31);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        writer.writeInt(0, 0);
        writer.writeRawValue(1, RawValueData.fromObject((Object)new Date(123L)), new RawValueDataSerializer((TypeSerializer)SqlDateSerializer.INSTANCE));
        writer.writeRawValue(2, RawValueData.fromObject((Object)new Time(456L)), new RawValueDataSerializer((TypeSerializer)SqlTimeSerializer.INSTANCE));
        writer.writeRawValue(3, RawValueData.fromObject((Object)new Timestamp(789L)), new RawValueDataSerializer((TypeSerializer)SqlTimestampSerializer.INSTANCE));
        writer.writeRawValue(4, RawValueData.fromObject((Object)localDate), new RawValueDataSerializer((TypeSerializer)LocalDateSerializer.INSTANCE));
        writer.writeRawValue(5, RawValueData.fromObject((Object)localTime), new RawValueDataSerializer((TypeSerializer)LocalTimeSerializer.INSTANCE));
        writer.writeRawValue(6, RawValueData.fromObject((Object)localDateTime), new RawValueDataSerializer((TypeSerializer)LocalDateTimeSerializer.INSTANCE));
        writer.complete();
        Assertions.assertThat((java.util.Date)((java.util.Date)row.getRawValue(1).toObject((TypeSerializer)SqlDateSerializer.INSTANCE))).isEqualTo((Object)new Date(123L));
        Assertions.assertThat((java.util.Date)((java.util.Date)row.getRawValue(2).toObject((TypeSerializer)SqlTimeSerializer.INSTANCE))).isEqualTo((Object)new Time(456L));
        Assertions.assertThat((java.util.Date)((java.util.Date)row.getRawValue(3).toObject((TypeSerializer)SqlTimestampSerializer.INSTANCE))).isEqualTo((Object)new Timestamp(789L));
        Assertions.assertThat((LocalDate)((LocalDate)row.getRawValue(4).toObject((TypeSerializer)LocalDateSerializer.INSTANCE))).isEqualTo((Object)localDate);
        Assertions.assertThat((LocalTime)((LocalTime)row.getRawValue(5).toObject((TypeSerializer)LocalTimeSerializer.INSTANCE))).isEqualTo((Object)localTime);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)row.getRawValue(6).toObject((TypeSerializer)LocalDateTimeSerializer.INSTANCE))).isEqualTo((Object)localDateTime);
    }

    @Test
    void testSerializeVariousSize() throws IOException {
        int segSize = 64;
        int segTotalNumber = 3;
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        Random random = new Random();
        byte[] bytes = new byte[1024];
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.complete();
        MemorySegment[] memorySegments = new MemorySegment[segTotalNumber];
        HashMap<MemorySegment, Integer> msIndex = new HashMap<MemorySegment, Integer>();
        for (int i = 0; i < segTotalNumber; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[segSize]);
            msIndex.put(memorySegments[i], i);
        }
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(1);
        int rowSizeInt = 4;
        int rowFixLength = 16;
        for (int i = 0; i < segSize; ++i) {
            int maxRowSize = segSize * segTotalNumber - i - rowSizeInt;
            if (segSize - i < rowFixLength + rowSizeInt) {
                maxRowSize -= segSize - i;
            }
            for (int j = rowFixLength; j < maxRowSize; ++j) {
                this.testSerialize(row, memorySegments, msIndex, serializer, i, j);
            }
        }
    }

    private void testSerialize(BinaryRowData row, MemorySegment[] memorySegments, Map<MemorySegment, Integer> msIndex, BinaryRowDataSerializer serializer, int position, int rowSize) throws IOException {
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        out.skipBytesToWrite(position);
        row.setTotalSize(rowSize);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        int segNumber = msIndex.get(out.getCurrentSegment()) + 1;
        int lastSegSize = out.getCurrentPositionInSegment();
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>(Arrays.asList(memorySegments).subList(0, segNumber));
        RandomAccessInputView input = new RandomAccessInputView(segments, 64, lastSegSize);
        input.skipBytesToRead(position);
        BinaryRowData mapRow = serializer.createInstance();
        mapRow = serializer.mapFromPages(mapRow, (AbstractPagedInputView)input);
        Assertions.assertThat((Object)mapRow).isEqualTo((Object)row);
    }

    @Test
    void testZeroOutPaddingGeneric() {
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer((SerializerConfig)new SerializerConfigImpl());
        Random random = new Random();
        byte[] bytes = new byte[1024];
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeRawValue(0, RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(0, 1.0)), new RawValueDataSerializer(genericSerializer));
        writer.complete();
        int hash1 = row.hashCode();
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeRawValue(0, RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(0, 1.0)), new RawValueDataSerializer(genericSerializer));
        writer.complete();
        int hash2 = row.hashCode();
        Assertions.assertThat((int)hash2).isEqualTo(hash1);
    }

    @Test
    void testZeroOutPaddingString() {
        Random random = new Random();
        byte[] bytes = new byte[1024];
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeString(0, StringData.fromString((String)"wahahah"));
        writer.complete();
        int hash1 = row.hashCode();
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeString(0, StringData.fromString((String)"wahahah"));
        writer.complete();
        int hash2 = row.hashCode();
        Assertions.assertThat((int)hash2).isEqualTo(hash1);
    }

    @Test
    void testHashAndCopy() throws IOException {
        MemorySegment[] segments = new MemorySegment[3];
        for (int i = 0; i < 3; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(segments, 64);
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(2);
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)"hahahahahahahahahahahahahahahahahahahhahahahahahahahahah"));
        writer.writeString(1, StringData.fromString((String)"hahahahahahahahahahahahahahahahahahahhahahahahahahahahaa"));
        writer.complete();
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        ArrayList<MemorySegment> segmentList = new ArrayList<MemorySegment>(Arrays.asList(segments));
        RandomAccessInputView input = new RandomAccessInputView(segmentList, 64, 64);
        BinaryRowData mapRow = serializer.createInstance();
        mapRow = serializer.mapFromPages(mapRow, (AbstractPagedInputView)input);
        Assertions.assertThat((Object)mapRow).isEqualTo((Object)row);
        Assertions.assertThat((Comparable)mapRow.getString(0)).isEqualTo((Object)row.getString(0));
        Assertions.assertThat((Comparable)mapRow.getString(1)).isEqualTo((Object)row.getString(1));
        Assertions.assertThat((Comparable)mapRow.getString(1)).isNotEqualTo((Object)row.getString(0));
        Assertions.assertThat((int)mapRow.hashCode()).isEqualTo(row.hashCode());
        Assertions.assertThat((int)mapRow.getString(0).hashCode()).isEqualTo(row.getString(0).hashCode());
        Assertions.assertThat((int)mapRow.getString(1).hashCode()).isEqualTo(row.getString(1).hashCode());
        Assertions.assertThat((Object)mapRow.copy()).isEqualTo((Object)row.copy());
        Assertions.assertThat((Comparable)((BinaryStringData)mapRow.getString(0)).copy()).isEqualTo((Object)((BinaryStringData)row.getString(0)).copy());
        Assertions.assertThat((Comparable)((BinaryStringData)mapRow.getString(1)).copy()).isEqualTo((Object)((BinaryStringData)row.getString(1)).copy());
    }

    @Test
    void testSerStringToKryo() throws IOException {
        KryoSerializer serializer = new KryoSerializer(BinaryStringData.class, (SerializerConfig)new SerializerConfigImpl());
        BinaryStringData string = BinaryStringData.fromString((String)"hahahahaha");
        RandomAccessOutputView out = new RandomAccessOutputView(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[1024])}, 64);
        serializer.serialize((Object)string, (DataOutputView)out);
        RandomAccessInputView input = new RandomAccessInputView(new ArrayList<MemorySegment>(Collections.singletonList(out.getCurrentSegment())), 64, 64);
        StringData newStr = (StringData)serializer.deserialize((DataInputView)input);
        Assertions.assertThat((Comparable)newStr).isEqualTo((Object)string);
    }

    @Test
    void testSerializerPages() throws IOException {
        BinaryRowData row24 = DataFormatTestUtil.get24BytesBinaryRow();
        BinaryRowData row160 = DataFormatTestUtil.get160BytesBinaryRow();
        this.testSerializerPagesInternal(row24, row160);
        this.testSerializerPagesInternal(row24, DataFormatTestUtil.getMultiSeg160BytesBinaryRow(row160));
    }

    private void testSerializerPagesInternal(BinaryRowData row24, BinaryRowData row160) throws IOException {
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(2);
        MemorySegment[] segments = new MemorySegment[4];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        RandomAccessInputView in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        BinaryRowData retRow = new BinaryRowData(2);
        ArrayList<BinaryRowData> rets = new ArrayList<BinaryRowData>();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assertions.assertThat((Object)((BinaryRowData)rets.get(0))).isEqualTo((Object)row24);
        Assertions.assertThat((Object)((BinaryRowData)rets.get(1))).isEqualTo((Object)row160);
        Assertions.assertThat((Object)((BinaryRowData)rets.get(2))).isEqualTo((Object)row24);
        segments = new MemorySegment[7];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        retRow = new BinaryRowData(2);
        rets = new ArrayList();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assertions.assertThat((Object)((BinaryRowData)rets.get(0))).isEqualTo((Object)row24);
        Assertions.assertThat((Object)((BinaryRowData)rets.get(1))).isEqualTo((Object)row160);
        Assertions.assertThat((Object)((BinaryRowData)rets.get(2))).isEqualTo((Object)row160);
        segments = new MemorySegment[3];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        retRow = new BinaryRowData(2);
        rets = new ArrayList();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assertions.assertThat((Object)((BinaryRowData)rets.get(0))).isEqualTo((Object)row24);
        Assertions.assertThat((Object)((BinaryRowData)rets.get(1))).isEqualTo((Object)row160);
    }

    @Test
    void testTimestampData() {
        int precision = 3;
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeTimestamp(0, TimestampData.fromEpochMillis((long)123L), 3);
        writer.setNullAt(1);
        writer.complete();
        Assertions.assertThat((String)row.getTimestamp(0, 3).toString()).isEqualTo("1970-01-01T00:00:00.123");
        Assertions.assertThat((boolean)row.isNullAt(1)).isTrue();
        row.setTimestamp(0, TimestampData.fromEpochMillis((long)-123L), 3);
        Assertions.assertThat((String)row.getTimestamp(0, 3).toString()).isEqualTo("1969-12-31T23:59:59.877");
        precision = 9;
        TimestampData timestamp1 = TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(1969, 1, 1, 0, 0, 0, 123456789));
        TimestampData timestamp2 = TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("1970-01-01 00:00:00.123456789"));
        BinaryRowData row2 = new BinaryRowData(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeTimestamp(0, timestamp1, 9);
        writer2.writeTimestamp(1, null, 9);
        writer2.complete();
        Assertions.assertThat((int)row2.getSizeInBytes()).isEqualTo(40);
        Assertions.assertThat((String)row2.getTimestamp(0, 9).toString()).isEqualTo("1969-01-01T00:00:00.123456789");
        Assertions.assertThat((boolean)row2.isNullAt(1)).isTrue();
        row2.setTimestamp(0, timestamp2, 9);
        Assertions.assertThat((String)row2.getTimestamp(0, 9).toString()).isEqualTo("1970-01-01T00:00:00.123456789");
    }

    @Test
    void testNestedRowWithBinaryRowEquals() {
        BinaryRowData nestedBinaryRow = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(nestedBinaryRow);
        writer.writeInt(0, 42);
        LogicalType innerType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.DOUBLE())}).getLogicalType();
        RowDataSerializer innerSerializer = (RowDataSerializer)InternalSerializers.create((LogicalType)innerType);
        writer.writeRow(1, (RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"Test"), 12.345}), innerSerializer);
        writer.complete();
        BinaryRowData innerBinaryRow = new BinaryRowData(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(innerBinaryRow);
        writer2.writeString(0, StringData.fromString((String)"Test"));
        writer2.writeDouble(1, 12.345);
        writer2.complete();
        Assertions.assertThat((Object)nestedBinaryRow.getRow(1, 2)).isEqualTo((Object)innerBinaryRow);
        Assertions.assertThat((Object)innerBinaryRow).isEqualTo((Object)nestedBinaryRow.getRow(1, 2));
    }
}

