/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.lang.constant.Constable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.TimeString;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.plan.stats.WithLower;
import org.apache.flink.table.planner.plan.stats.WithUpper;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class SelectivityEstimator$ {
    public static SelectivityEstimator$ MODULE$;

    static {
        new SelectivityEstimator$();
    }

    public ValueInterval convertValueInterval(ValueInterval interval, RelDataType dataType) {
        Predef$.MODULE$.require(interval != null && dataType != null);
        return this.convertValueInterval(interval, dataType.getFamily());
    }

    public ValueInterval convertValueInterval(ValueInterval interval, RelDataTypeFamily typeFamily) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        Tuple2 tuple24;
        boolean bl;
        Predef$.MODULE$.require(interval != null && typeFamily != null);
        ValueInterval valueInterval = interval;
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.empty();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            bl = true;
        } else {
            ValueInterval valueInterval4 = ValueInterval$.MODULE$.infinite();
            ValueInterval valueInterval5 = valueInterval;
            bl = !(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null);
        }
        if (bl) {
            return interval;
        }
        ValueInterval valueInterval6 = interval;
        if (valueInterval6 instanceof WithLower) {
            WithLower withLower = (WithLower)valueInterval6;
            tuple24 = new Tuple2(withLower.lower(), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
        } else {
            tuple24 = tuple23 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Comparable lower = (Comparable)tuple23._1();
        boolean includeLower = tuple23._2$mcZ$sp();
        Tuple2 tuple25 = new Tuple2((Object)lower, (Object)BoxesRunTime.boxToBoolean((boolean)includeLower));
        Comparable lower2 = (Comparable)tuple25._1();
        boolean includeLower2 = tuple25._2$mcZ$sp();
        ValueInterval valueInterval7 = interval;
        if (valueInterval7 instanceof WithUpper) {
            WithUpper withUpper = (WithUpper)valueInterval7;
            tuple22 = new Tuple2(withUpper.upper(), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
        } else {
            tuple22 = tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Comparable upper = (Comparable)tuple2._1();
        boolean includeUpper = tuple2._2$mcZ$sp();
        Tuple2 tuple26 = new Tuple2((Object)upper, (Object)BoxesRunTime.boxToBoolean((boolean)includeUpper));
        Comparable upper2 = (Comparable)tuple26._1();
        boolean includeUpper2 = tuple26._2$mcZ$sp();
        RelDataTypeFamily relDataTypeFamily = typeFamily;
        if (SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))))) {
            return ValueInterval$.MODULE$.apply(this.comparableToDouble(lower2), this.comparableToDouble(upper2), includeLower2, includeUpper2);
        }
        if (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily)) {
            return ValueInterval$.MODULE$.apply(lower2.toString(), upper2.toString(), includeLower2, includeUpper2);
        }
        throw new UnsupportedOperationException(new StringBuilder(24).append("Unsupported typeFamily: ").append(typeFamily).toString());
    }

    public Comparable<?> literalToComparable(RexLiteral literal) {
        if (!literal.isNull()) {
            Constable constable;
            RelDataTypeFamily relDataTypeFamily = literal.getType().getFamily();
            if (SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))))) {
                constable = this.literalToDouble(literal);
            } else if (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily)) {
                constable = (Constable)((Object)literal.getValueAs(String.class));
            } else {
                throw new UnsupportedOperationException(new StringBuilder(49).append("Can't get value as comparable from literal type: ").append(literal.getType()).toString());
            }
            return constable;
        }
        return null;
    }

    public Double comparableToDouble(Object value) {
        Object object = value;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return Predef$.MODULE$.double2Double(number.doubleValue());
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            if (bl) {
                return Predef$.MODULE$.double2Double(1.0);
            }
            return Predef$.MODULE$.double2Double(0.0);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return date.getTime() / 86400000L;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.getTime();
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new TimeString(time.toString()).getMillisOfDay();
        }
        throw new UnsupportedOperationException(new StringBuilder(41).append("Can't convert comparable type: ").append(value.getClass()).append(" to Double").toString());
    }

    public Double literalToDouble(RexLiteral literal) {
        if (!literal.isNull()) {
            RelDataTypeFamily relDataTypeFamily = literal.getType().getFamily();
            if (SqlTypeFamily.NUMERIC.equals(relDataTypeFamily)) {
                return Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(literal.getValue3().toString())).toDouble());
            }
            if (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily)) {
                if (RexLiteral.booleanValue(literal)) {
                    return Predef$.MODULE$.double2Double(1.0);
                }
                return Predef$.MODULE$.double2Double(0.0);
            }
            if (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))) {
                return Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(literal.getValue2().toString())).toDouble());
            }
            throw new UnsupportedOperationException(new StringBuilder(45).append("Can't get value as Double from literal type: ").append(literal.getType()).toString());
        }
        return null;
    }

    public boolean lessThan(Comparable<?> left, Comparable<?> right) {
        if (left == null || right == null) {
            return false;
        }
        return left.compareTo(right) < 0;
    }

    public boolean lessThanOrEqualTo(Comparable<?> left, Comparable<?> right) {
        if (left == null || right == null) {
            return false;
        }
        return left.compareTo(right) <= 0;
    }

    public boolean greaterThan(Comparable<?> left, Comparable<?> right) {
        if (left == null || right == null) {
            return false;
        }
        return left.compareTo(right) > 0;
    }

    public boolean greaterThanOrEqualTo(Comparable<?> left, Comparable<?> right) {
        if (left == null || right == null) {
            return false;
        }
        return left.compareTo(right) >= 0;
    }

    public boolean isSupportedComparisonType(RelDataType relType) {
        RelDataTypeFamily relDataTypeFamily = relType.getFamily();
        return SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily)))));
    }

    public boolean canConvertToNumericType(RelDataType relType) {
        RelDataTypeFamily relDataTypeFamily = relType.getFamily();
        return SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))));
    }

    private SelectivityEstimator$() {
        MODULE$ = this;
    }
}

