/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.legacy.table.sources.StreamTableSource;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.bridge.PlannerExternalQueryOperation;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.sources.LookupableTableSource;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.operations.AggregateQueryOperation;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.DataStreamQueryOperation;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.ExternalQueryOperation;
import org.apache.flink.table.operations.FilterQueryOperation;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.SortQueryOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.ValuesQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.operations.utils.QueryOperationDefaultVisitor;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.expressions.SqlAggFunctionVisitor;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.operations.InternalDataStreamQueryOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.RichTableSourceQueryOperation;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.schema.CatalogSourceTable;
import org.apache.flink.table.planner.plan.schema.DataStreamTable;
import org.apache.flink.table.planner.plan.schema.DataStreamTable$;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.schema.TypedFlinkTableFunction;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.ProctimeAttribute;
import org.apache.flink.table.runtime.groupwindow.RowtimeAttribute;
import org.apache.flink.table.runtime.groupwindow.WindowEnd;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.runtime.groupwindow.WindowStart;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import scala.Option;

@Internal
public class QueryOperationConverter
extends QueryOperationDefaultVisitor<RelNode> {
    private final FlinkRelBuilder relBuilder;
    private final SingleRelVisitor singleRelVisitor = new SingleRelVisitor();
    private final ExpressionConverter expressionConverter;
    private final AggregateVisitor aggregateVisitor = new AggregateVisitor();
    private final TableAggregateVisitor tableAggregateVisitor = new TableAggregateVisitor();
    private final JoinExpressionVisitor joinExpressionVisitor = new JoinExpressionVisitor();
    private final boolean isBatchMode;

    public QueryOperationConverter(FlinkRelBuilder relBuilder, boolean isBatchMode) {
        this.relBuilder = relBuilder;
        this.expressionConverter = new ExpressionConverter(relBuilder);
        this.isBatchMode = isBatchMode;
    }

    public RelNode defaultMethod(QueryOperation other) {
        other.getChildren().forEach(child -> this.relBuilder.push((RelNode)child.accept((QueryOperationVisitor)this)));
        return (RelNode)other.accept((QueryOperationVisitor)this.singleRelVisitor);
    }

    private RexNode convertExprToRexNode(Expression expr) {
        return (RexNode)expr.accept((ExpressionVisitor)this.expressionConverter);
    }

    private class SingleRelVisitor
    implements QueryOperationVisitor<RelNode> {
        private SingleRelVisitor() {
        }

        public RelNode visit(ProjectQueryOperation projection) {
            List<RexNode> rexNodes = this.convertToRexNodes(projection.getProjectList());
            return QueryOperationConverter.this.relBuilder.project(rexNodes, projection.getResolvedSchema().getColumnNames(), true).build();
        }

        public RelNode visit(AggregateQueryOperation aggregate) {
            List<RelBuilder.AggCall> aggregations = aggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(aggregate.getGroupingExpressions());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            return QueryOperationConverter.this.relBuilder.aggregate(groupKey, (Iterable<RelBuilder.AggCall>)aggregations).build();
        }

        public RelNode visit(WindowAggregateQueryOperation windowAggregate) {
            List<RelBuilder.AggCall> aggregations = windowAggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(windowAggregate.getGroupingExpressions());
            LogicalWindow logicalWindow = this.toLogicalWindow(windowAggregate.getGroupWindow());
            WindowReference windowReference = logicalWindow.aliasAttribute();
            List<NamedWindowProperty> windowProperties = windowAggregate.getWindowPropertiesExpressions().stream().map(expr -> this.convertToWindowProperty((Expression)expr, windowReference)).collect(Collectors.toList());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            return QueryOperationConverter.this.relBuilder.windowAggregate(logicalWindow, groupKey, windowProperties, aggregations).build();
        }

        private NamedWindowProperty convertToWindowProperty(Expression expression, WindowReference windowReference) {
            Preconditions.checkArgument((boolean)(expression instanceof CallExpression), (Object)"This should never happened");
            CallExpression aliasExpr = (CallExpression)expression;
            Preconditions.checkArgument((BuiltInFunctionDefinitions.AS == aliasExpr.getFunctionDefinition() ? 1 : 0) != 0, (Object)"This should never happened");
            String name = (String)((ValueLiteralExpression)aliasExpr.getChildren().get(1)).getValueAs(String.class).orElseThrow(() -> new TableException("Invalid literal."));
            Expression windowPropertyExpr = (Expression)aliasExpr.getChildren().get(0);
            Preconditions.checkArgument((boolean)(windowPropertyExpr instanceof CallExpression), (Object)"This should never happened");
            CallExpression windowPropertyCallExpr = (CallExpression)windowPropertyExpr;
            FunctionDefinition fd = windowPropertyCallExpr.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.WINDOW_START == fd) {
                return new NamedWindowProperty(name, (WindowProperty)new WindowStart(windowReference));
            }
            if (BuiltInFunctionDefinitions.WINDOW_END == fd) {
                return new NamedWindowProperty(name, (WindowProperty)new WindowEnd(windowReference));
            }
            if (BuiltInFunctionDefinitions.PROCTIME == fd) {
                return new NamedWindowProperty(name, (WindowProperty)new ProctimeAttribute(windowReference));
            }
            if (BuiltInFunctionDefinitions.ROWTIME == fd) {
                return new NamedWindowProperty(name, (WindowProperty)new RowtimeAttribute(windowReference));
            }
            throw new TableException("Invalid literal.");
        }

        private RelBuilder.AggCall getAggCall(Expression aggregateExpression) {
            if (ApiExpressionUtils.isFunctionOfKind((Expression)aggregateExpression, (FunctionKind)FunctionKind.TABLE_AGGREGATE)) {
                return (RelBuilder.AggCall)aggregateExpression.accept((ExpressionVisitor)QueryOperationConverter.this.tableAggregateVisitor);
            }
            return (RelBuilder.AggCall)aggregateExpression.accept((ExpressionVisitor)QueryOperationConverter.this.aggregateVisitor);
        }

        public RelNode visit(JoinQueryOperation join) {
            Set<CorrelationId> corSet = join.isCorrelated() ? Collections.singleton(QueryOperationConverter.this.relBuilder.peek().getCluster().createCorrel()) : Collections.emptySet();
            return QueryOperationConverter.this.relBuilder.join(this.convertJoinType(join.getJoinType()), (RexNode)join.getCondition().accept((ExpressionVisitor)QueryOperationConverter.this.joinExpressionVisitor), corSet).build();
        }

        public RelNode visit(SetQueryOperation setOperation) {
            switch (setOperation.getType()) {
                case INTERSECT: {
                    QueryOperationConverter.this.relBuilder.intersect(setOperation.isAll());
                    break;
                }
                case MINUS: {
                    QueryOperationConverter.this.relBuilder.minus(setOperation.isAll());
                    break;
                }
                case UNION: {
                    QueryOperationConverter.this.relBuilder.union(setOperation.isAll());
                }
            }
            return QueryOperationConverter.this.relBuilder.build();
        }

        public RelNode visit(FilterQueryOperation filter) {
            RexNode rexNode = QueryOperationConverter.this.convertExprToRexNode((Expression)filter.getCondition());
            return QueryOperationConverter.this.relBuilder.filter(rexNode).build();
        }

        public RelNode visit(DistinctQueryOperation distinct) {
            return QueryOperationConverter.this.relBuilder.distinct().build();
        }

        public RelNode visit(SortQueryOperation sort) {
            List<RexNode> rexNodes = this.convertToRexNodes(sort.getOrder());
            return QueryOperationConverter.this.relBuilder.sortLimit(sort.getOffset(), sort.getFetch(), rexNodes).build();
        }

        public RelNode visit(CalculatedQueryOperation calculatedTable) {
            ContextResolvedFunction resolvedFunction = calculatedTable.getResolvedFunction();
            List<RexNode> parameters = this.convertToRexNodes(calculatedTable.getArguments());
            FunctionDefinition functionDefinition = resolvedFunction.getDefinition();
            if (functionDefinition instanceof TableFunctionDefinition) {
                FlinkTypeFactory typeFactory = QueryOperationConverter.this.relBuilder.getTypeFactory();
                return this.convertLegacyTableFunction(calculatedTable, (TableFunctionDefinition)functionDefinition, parameters, typeFactory);
            }
            BridgingSqlFunction sqlFunction = BridgingSqlFunction.of(QueryOperationConverter.this.relBuilder.getCluster(), resolvedFunction);
            FlinkRelBuilder.pushFunctionScan(QueryOperationConverter.this.relBuilder, sqlFunction, 0, parameters, calculatedTable.getResolvedSchema().getColumnNames());
            return QueryOperationConverter.this.relBuilder.build();
        }

        private RelNode convertLegacyTableFunction(CalculatedQueryOperation calculatedTable, TableFunctionDefinition functionDefinition, List<RexNode> parameters, FlinkTypeFactory typeFactory) {
            List fieldNames = calculatedTable.getResolvedSchema().getColumnNames();
            TableFunction tableFunction = functionDefinition.getTableFunction();
            DataType resultType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getResultType());
            TypedFlinkTableFunction function = new TypedFlinkTableFunction(tableFunction, fieldNames.toArray(new String[0]), resultType);
            TableSqlFunction sqlFunction = new TableSqlFunction(calculatedTable.getResolvedFunction().getIdentifier().orElse(null), tableFunction.toString(), tableFunction, resultType, typeFactory, function, (Option<SqlOperandMetadata>)Option.empty());
            return LogicalTableFunctionScan.create(QueryOperationConverter.this.relBuilder.peek().getCluster(), Collections.emptyList(), QueryOperationConverter.this.relBuilder.getRexBuilder().makeCall(function.getRowType(typeFactory), sqlFunction, parameters), function.getElementType((List<?>)null), function.getRowType(typeFactory), null);
        }

        public RelNode visit(SourceQueryOperation queryOperation) {
            ContextResolvedTable contextResolvedTable = queryOperation.getContextResolvedTable();
            if (contextResolvedTable.isAnonymous()) {
                return CatalogSourceTable.createAnonymous(QueryOperationConverter.this.relBuilder, contextResolvedTable, QueryOperationConverter.this.isBatchMode).toRel(ViewExpanders.simpleContext(QueryOperationConverter.this.relBuilder.getCluster()));
            }
            return QueryOperationConverter.this.relBuilder.scan(queryOperation.getContextResolvedTable().getIdentifier().toList()).build();
        }

        public RelNode visit(ValuesQueryOperation values) {
            RelDataType rowType = QueryOperationConverter.this.relBuilder.getTypeFactory().buildRelNodeRowType(TableSchema.fromResolvedSchema((ResolvedSchema)values.getResolvedSchema()));
            if (values.getValues().isEmpty()) {
                QueryOperationConverter.this.relBuilder.values(rowType);
                return QueryOperationConverter.this.relBuilder.build();
            }
            ArrayList<List<RexLiteral>> rexLiterals = new ArrayList<List<RexLiteral>>();
            ArrayList<List<RexNode>> rexProjections = new ArrayList<List<RexNode>>();
            this.splitToProjectionsAndLiterals(values, rexLiterals, rexProjections);
            int inputs = 0;
            if (rexLiterals.size() != 0) {
                ++inputs;
                QueryOperationConverter.this.relBuilder.values(rexLiterals, rowType);
            }
            if (rexProjections.size() != 0) {
                inputs += rexProjections.size();
                this.applyProjections(values, rexProjections);
            }
            if (inputs > 1) {
                QueryOperationConverter.this.relBuilder.union(true, inputs);
            }
            return QueryOperationConverter.this.relBuilder.build();
        }

        private void applyProjections(ValuesQueryOperation values, List<List<RexNode>> rexProjections) {
            List relNodes = rexProjections.stream().map(exprs -> {
                QueryOperationConverter.this.relBuilder.push(LogicalValues.createOneRow(QueryOperationConverter.this.relBuilder.getCluster()));
                QueryOperationConverter.this.relBuilder.project((Iterable<? extends RexNode>)exprs, values.getResolvedSchema().getColumnNames());
                return QueryOperationConverter.this.relBuilder.build();
            }).collect(Collectors.toList());
            QueryOperationConverter.this.relBuilder.pushAll(relNodes);
        }

        private void splitToProjectionsAndLiterals(ValuesQueryOperation values, List<List<RexLiteral>> rexValues, List<List<RexNode>> rexProjections) {
            values.getValues().stream().map(this::convertToRexNodes).forEach(row -> {
                boolean allLiterals = row.stream().allMatch(expr -> expr instanceof RexLiteral);
                if (allLiterals) {
                    rexValues.add(row.stream().map(expr -> (RexLiteral)expr).collect(Collectors.toList()));
                } else {
                    rexProjections.add((List<RexNode>)row);
                }
            });
        }

        public RelNode visit(QueryOperation other) {
            if (other instanceof PlannerQueryOperation) {
                return ((PlannerQueryOperation)other).getCalciteTree();
            }
            if (other instanceof PlannerExternalQueryOperation) {
                return ((PlannerExternalQueryOperation)other).getCalciteTree();
            }
            if (other instanceof InternalDataStreamQueryOperation) {
                return this.convertToDataStreamScan((InternalDataStreamQueryOperation)other);
            }
            if (other instanceof ExternalQueryOperation) {
                ExternalQueryOperation externalQueryOperation = (ExternalQueryOperation)other;
                return this.convertToExternalScan(externalQueryOperation.getContextResolvedTable(), externalQueryOperation.getDataStream(), externalQueryOperation.getPhysicalDataType(), externalQueryOperation.isTopLevelRecord(), externalQueryOperation.getChangelogMode());
            }
            if (other instanceof DataStreamQueryOperation) {
                DataStreamQueryOperation dataStreamQueryOperation = (DataStreamQueryOperation)other;
                return this.convertToDataStreamScan(dataStreamQueryOperation.getDataStream(), dataStreamQueryOperation.getFieldIndices(), dataStreamQueryOperation.getResolvedSchema(), dataStreamQueryOperation.getIdentifier());
            }
            throw new TableException("Unknown table operation: " + other);
        }

        public <U> RelNode visit(TableSourceQueryOperation<U> tableSourceOperation) {
            FlinkStatistic statistic;
            ObjectIdentifier tableIdentifier;
            boolean isBatch;
            TableSource tableSource = tableSourceOperation.getTableSource();
            if (tableSource instanceof LookupableTableSource) {
                isBatch = tableSourceOperation.isBatch();
            } else if (tableSource instanceof StreamTableSource) {
                isBatch = ((StreamTableSource)tableSource).isBounded();
            } else {
                throw new TableException(String.format("%s is not supported.", tableSource.getClass().getSimpleName()));
            }
            if (tableSourceOperation instanceof RichTableSourceQueryOperation && ((RichTableSourceQueryOperation)tableSourceOperation).getIdentifier() != null) {
                tableIdentifier = ((RichTableSourceQueryOperation)tableSourceOperation).getIdentifier();
                statistic = ((RichTableSourceQueryOperation)tableSourceOperation).getStatistic();
            } else {
                statistic = FlinkStatistic.UNKNOWN();
                String refId = "Unregistered_TableSource_" + System.identityHashCode(tableSource);
                CatalogManager catalogManager = QueryOperationConverter.this.relBuilder.getCluster().getPlanner().getContext().unwrap(FlinkContext.class).getCatalogManager();
                tableIdentifier = catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{refId}));
            }
            RelDataType rowType = TableSourceUtil.getSourceRowTypeFromSource(QueryOperationConverter.this.relBuilder.getTypeFactory(), tableSource, !isBatch);
            LegacyTableSourceTable tableSourceTable = new LegacyTableSourceTable(QueryOperationConverter.this.relBuilder.getRelOptSchema(), tableIdentifier, rowType, statistic, tableSource, !isBatch, (CatalogTable)ConnectorCatalogTable.source((TableSource)tableSource, (boolean)isBatch));
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), tableSourceTable, Collections.emptyList());
        }

        private RelNode convertToExternalScan(ContextResolvedTable contextResolvedTable, DataStream<?> dataStream, DataType physicalDataType, boolean isTopLevelRecord, ChangelogMode changelogMode) {
            FlinkContext flinkContext = ShortcutUtils.unwrapContext(QueryOperationConverter.this.relBuilder);
            return DynamicSourceUtils.convertDataStreamToRel(flinkContext.isBatchMode(), (ReadableConfig)flinkContext.getTableConfig(), QueryOperationConverter.this.relBuilder, contextResolvedTable, dataStream, physicalDataType, isTopLevelRecord, changelogMode);
        }

        private RelNode convertToDataStreamScan(InternalDataStreamQueryOperation<?> operation) {
            List<String> names;
            ObjectIdentifier identifier = operation.getIdentifier();
            if (identifier != null) {
                names = Arrays.asList(identifier.getCatalogName(), identifier.getDatabaseName(), identifier.getObjectName());
            } else {
                String refId = String.format("Unregistered_DataStream_%s", operation.getDataStream().getId());
                names = Collections.singletonList(refId);
            }
            RelDataType rowType = DataStreamTable$.MODULE$.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory(), operation.getDataStream(), operation.getResolvedSchema().getColumnNames().toArray(new String[0]), operation.getFieldIndices(), (Option<boolean[]>)Option.apply((Object)operation.getFieldNullables()));
            DataStreamTable dataStreamTable = new DataStreamTable(QueryOperationConverter.this.relBuilder.getRelOptSchema(), names, rowType, operation.getDataStream(), operation.getFieldIndices(), operation.getResolvedSchema().getColumnNames().toArray(new String[0]), operation.getStatistic(), (Option<boolean[]>)Option.apply((Object)operation.getFieldNullables()));
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), dataStreamTable, Collections.emptyList());
        }

        private RelNode convertToDataStreamScan(DataStream<?> dataStream, int[] fieldIndices, ResolvedSchema resolvedSchema, Optional<ObjectIdentifier> identifier) {
            List<String> names;
            if (identifier.isPresent()) {
                names = Arrays.asList(identifier.get().getCatalogName(), identifier.get().getDatabaseName(), identifier.get().getObjectName());
            } else {
                String refId = String.format("Unregistered_DataStream_%s", dataStream.getId());
                names = Collections.singletonList(refId);
            }
            RelDataType rowType = DataStreamTable$.MODULE$.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory(), dataStream, resolvedSchema.getColumnNames().toArray(new String[0]), fieldIndices, (Option<boolean[]>)Option.empty());
            DataStreamTable dataStreamTable = new DataStreamTable(QueryOperationConverter.this.relBuilder.getRelOptSchema(), names, rowType, dataStream, fieldIndices, resolvedSchema.getColumnNames().toArray(new String[0]), FlinkStatistic.UNKNOWN(), (Option<boolean[]>)Option.empty());
            return LogicalTableScan.create(QueryOperationConverter.this.relBuilder.getCluster(), dataStreamTable, Collections.emptyList());
        }

        private List<RexNode> convertToRexNodes(List<ResolvedExpression> expressions) {
            return expressions.stream().map(x$0 -> QueryOperationConverter.this.convertExprToRexNode((Expression)x$0)).collect(Collectors.toList());
        }

        private LogicalWindow toLogicalWindow(WindowAggregateQueryOperation.ResolvedGroupWindow window) {
            DataType windowType = window.getTimeAttribute().getOutputDataType();
            WindowReference windowReference = new WindowReference(window.getAlias(), TypeConversions.fromDataToLogicalType((DataType)windowType));
            switch (window.getType()) {
                case SLIDE: {
                    return new SlidingGroupWindow(windowReference, window.getTimeAttribute(), (ValueLiteralExpression)window.getSize().orElseThrow(() -> new TableException("missed size parameters!")), (ValueLiteralExpression)window.getSlide().orElseThrow(() -> new TableException("missed slide parameters!")));
                }
                case SESSION: {
                    return new SessionGroupWindow(windowReference, window.getTimeAttribute(), (ValueLiteralExpression)window.getGap().orElseThrow(() -> new TableException("missed gap parameters!")));
                }
                case TUMBLE: {
                    return new TumblingGroupWindow(windowReference, window.getTimeAttribute(), (ValueLiteralExpression)window.getSize().orElseThrow(() -> new TableException("missed size parameters!")));
                }
            }
            throw new TableException("Unknown window type");
        }

        private JoinRelType convertJoinType(JoinQueryOperation.JoinType joinType) {
            switch (joinType) {
                case INNER: {
                    return JoinRelType.INNER;
                }
                case LEFT_OUTER: {
                    return JoinRelType.LEFT;
                }
                case RIGHT_OUTER: {
                    return JoinRelType.RIGHT;
                }
                case FULL_OUTER: {
                    return JoinRelType.FULL;
                }
            }
            throw new TableException("Unknown join type: " + joinType);
        }
    }

    private class AggregateVisitor
    extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
        private AggregateVisitor() {
        }

        public RelBuilder.AggCall visit(CallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                String aggregateName = (String)ExpressionUtils.extractValue((Expression)((Expression)unresolvedCall.getChildren().get(1)), String.class).orElseThrow(() -> new TableException("Unexpected name."));
                Expression aggregate = (Expression)unresolvedCall.getChildren().get(0);
                if (ApiExpressionUtils.isFunctionOfKind((Expression)aggregate, (FunctionKind)FunctionKind.AGGREGATE)) {
                    return (RelBuilder.AggCall)aggregate.accept((ExpressionVisitor)new AggCallVisitor(QueryOperationConverter.this.relBuilder, QueryOperationConverter.this.expressionConverter, aggregateName, false));
                }
            }
            throw new TableException("Expected named aggregate. Got: " + unresolvedCall);
        }

        protected RelBuilder.AggCall defaultMethod(Expression expression) {
            throw new TableException("Unexpected expression: " + expression);
        }

        private class AggCallVisitor
        extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
            private final RelBuilder relBuilder;
            private final SqlAggFunctionVisitor sqlAggFunctionVisitor;
            private final ExpressionConverter expressionConverter;
            private final String name;
            private final boolean isDistinct;

            public AggCallVisitor(RelBuilder relBuilder, ExpressionConverter expressionConverter, String name, boolean isDistinct) {
                this.relBuilder = relBuilder;
                this.sqlAggFunctionVisitor = new SqlAggFunctionVisitor(relBuilder);
                this.expressionConverter = expressionConverter;
                this.name = name;
                this.isDistinct = isDistinct;
            }

            public RelBuilder.AggCall visit(CallExpression call) {
                FunctionDefinition def = call.getFunctionDefinition();
                if (BuiltInFunctionDefinitions.DISTINCT == def) {
                    Expression innerAgg = (Expression)call.getChildren().get(0);
                    return (RelBuilder.AggCall)innerAgg.accept((ExpressionVisitor)new AggCallVisitor(this.relBuilder, this.expressionConverter, this.name, true));
                }
                SqlAggFunction sqlAggFunction = (SqlAggFunction)call.accept((ExpressionVisitor)this.sqlAggFunctionVisitor);
                return this.relBuilder.aggregateCall(sqlAggFunction, this.isDistinct, false, null, this.name, call.getChildren().stream().map(expr -> (RexNode)expr.accept((ExpressionVisitor)this.expressionConverter)).collect(Collectors.toList()));
            }

            protected RelBuilder.AggCall defaultMethod(Expression expression) {
                throw new TableException("Unexpected expression: " + expression);
            }
        }
    }

    private class TableAggregateVisitor
    extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
        private TableAggregateVisitor() {
        }

        public RelBuilder.AggCall visit(CallExpression call) {
            if (ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.TABLE_AGGREGATE)) {
                return (RelBuilder.AggCall)call.accept((ExpressionVisitor)new TableAggCallVisitor(QueryOperationConverter.this.relBuilder, QueryOperationConverter.this.expressionConverter));
            }
            return this.defaultMethod((Expression)call);
        }

        protected RelBuilder.AggCall defaultMethod(Expression expression) {
            throw new TableException("Expected table aggregate. Got: " + expression);
        }

        private class TableAggCallVisitor
        extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
            private final RelBuilder relBuilder;
            private final SqlAggFunctionVisitor sqlAggFunctionVisitor;
            private final ExpressionConverter expressionConverter;

            public TableAggCallVisitor(RelBuilder relBuilder, ExpressionConverter expressionConverter) {
                this.relBuilder = relBuilder;
                this.sqlAggFunctionVisitor = new SqlAggFunctionVisitor(relBuilder);
                this.expressionConverter = expressionConverter;
            }

            public RelBuilder.AggCall visit(CallExpression call) {
                SqlAggFunction sqlAggFunction = (SqlAggFunction)call.accept((ExpressionVisitor)this.sqlAggFunctionVisitor);
                return this.relBuilder.aggregateCall(sqlAggFunction, false, false, null, sqlAggFunction.toString(), call.getChildren().stream().map(expr -> (RexNode)expr.accept((ExpressionVisitor)this.expressionConverter)).collect(Collectors.toList()));
            }

            protected RelBuilder.AggCall defaultMethod(Expression expression) {
                throw new TableException("Expected table aggregate. Got: " + expression);
            }
        }
    }

    private class JoinExpressionVisitor
    extends ExpressionDefaultVisitor<RexNode> {
        private static final int numberOfJoinInputs = 2;

        private JoinExpressionVisitor() {
        }

        public RexNode visit(CallExpression callExpression) {
            List newChildren = callExpression.getChildren().stream().map(expr -> {
                RexNode convertedNode = (RexNode)expr.accept((ExpressionVisitor)this);
                return new RexNodeExpression(convertedNode, ((ResolvedExpression)expr).getOutputDataType(), null, null);
            }).collect(Collectors.toList());
            CallExpression newCall = callExpression.replaceArgs(newChildren, callExpression.getOutputDataType());
            return QueryOperationConverter.this.convertExprToRexNode((Expression)newCall);
        }

        public RexNode visit(FieldReferenceExpression fieldReference) {
            return QueryOperationConverter.this.relBuilder.field(2, fieldReference.getInputIndex(), fieldReference.getFieldIndex());
        }

        protected RexNode defaultMethod(Expression expression) {
            return QueryOperationConverter.this.convertExprToRexNode(expression);
        }
    }
}

