/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FileUtils;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public abstract class TableITCaseBase {
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_EXTENSION = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());
    @TempDir
    protected Path tmpDir;

    protected String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    protected File createTempFolder() throws IOException {
        return TempDirUtils.newFolder((Path)this.tmpDir);
    }

    protected File createTempFile() throws IOException {
        Path tmpDirPath = this.createTempFolder().toPath();
        return TempDirUtils.newFile((Path)tmpDirPath);
    }

    protected File createTempFile(String fileName) throws IOException {
        Path tmpDirPath = this.createTempFolder().toPath();
        return TempDirUtils.newFile((Path)tmpDirPath, (String)fileName);
    }

    protected String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileUtils.writeFileUtf8((File)f, (String)contents);
        return f.toURI().toString();
    }

    protected File createAndRegisterTempFile(String fileName) throws IOException {
        return new File(TempDirUtils.newFolder((Path)this.tmpDir), fileName);
    }
}

