/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class OperationMatchers {
    @SafeVarargs
    public static Matcher<Operation> isCreateTableOperation(Matcher<CreateTableOperation> ... nestedMatchers) {
        return new CreateTableOperationMatcher(nestedMatchers);
    }

    @SafeVarargs
    public static Matcher<CreateTableOperation> withOptions(MapEntry<String, String> ... entries) {
        return new FeatureMatcher<CreateTableOperation, Map<String, String>>(CoreMatchers.equalTo(OperationMatchers.mapOf(entries)), "options of the derived table", "options"){

            protected Map<String, String> featureValueOf(CreateTableOperation actual) {
                return actual.getCatalogTable().getOptions();
            }
        };
    }

    public static MapEntry<String, String> entry(String key, String value) {
        return new MapEntry<String, String>(key, value);
    }

    public static Matcher<CreateTableOperation> partitionedBy(String ... fields) {
        return new FeatureMatcher<CreateTableOperation, List<String>>(CoreMatchers.equalTo(Arrays.asList(fields)), "partitions of the derived table", "partitions"){

            protected List<String> featureValueOf(CreateTableOperation actual) {
                return actual.getCatalogTable().getPartitionKeys();
            }
        };
    }

    public static Matcher<CreateTableOperation> withDistribution(TableDistribution distribution) {
        return new FeatureMatcher<CreateTableOperation, Optional<TableDistribution>>(CoreMatchers.equalTo(Optional.ofNullable(distribution)), "distribution of the derived table", "distribution"){

            protected Optional<TableDistribution> featureValueOf(CreateTableOperation actual) {
                return actual.getCatalogTable().getDistribution();
            }
        };
    }

    public static Matcher<CreateTableOperation> withNoDistribution() {
        return OperationMatchers.withDistribution(null);
    }

    public static Matcher<CreateTableOperation> withSchema(Schema schema) {
        return new FeatureMatcher<CreateTableOperation, Schema>(CoreMatchers.equalTo((Object)schema), "schema of the derived table", "schema"){

            protected Schema featureValueOf(CreateTableOperation actual) {
                return actual.getCatalogTable().getUnresolvedSchema();
            }
        };
    }

    @SafeVarargs
    private static Map<String, String> mapOf(MapEntry<String, String> ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MapEntry<String, String> entry : entries) {
            map.put((String)entry.key, (String)entry.value);
        }
        return map;
    }

    private static class CreateTableOperationMatcher
    extends TypeSafeDiagnosingMatcher<Operation> {
        private final Matcher<CreateTableOperation>[] nestedMatchers;

        public CreateTableOperationMatcher(Matcher<CreateTableOperation>[] nestedMatchers) {
            this.nestedMatchers = nestedMatchers;
        }

        protected boolean matchesSafely(Operation item, Description mismatchDescription) {
            if (!(item instanceof CreateTableOperation)) {
                return false;
            }
            for (Matcher<CreateTableOperation> nestedMatcher : this.nestedMatchers) {
                if (nestedMatcher.matches((Object)item)) continue;
                nestedMatcher.describeMismatch((Object)item, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("\n");
            Arrays.stream(this.nestedMatchers).forEach(matcher -> {
                matcher.describeTo(description);
                description.appendText("\n");
            });
        }
    }

    public static class MapEntry<K, V> {
        private final K key;
        private final V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

