/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.utils.FloatingAvgAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0003\u0006\u0002\u0002]AQ!\r\u0001\u0005\u0002IBQ\u0001\u000e\u0001\u0005BUBQA\u000e\u0001\u0005\u0002]BQa\u0010\u0001\u0005\u0002\u0001CQa\u0011\u0001\u0005B\u0011CQA\u0012\u0001\u0005\u0002\u001dCQa\u0015\u0001\u0005BQCQa\u0018\u0001\u0007\u0002\u0001\u0014aC\u00127pCRLgnZ!wO\u0006;wMR;oGRLwN\u001c\u0006\u0003\u00171\tQ!\u001e;jYNT!!\u0004\b\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0002E\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003#I\tQA\u001a7j].T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u0001QC\u0001\r\"'\t\u0001\u0011\u0004\u0005\u0003\u001b;}iS\"A\u000e\u000b\u0005qq\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\tq2DA\tBO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u0004\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\tA+\u0005\u0002%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t9aj\u001c;iS:<\u0007CA\u0013,\u0013\tacEA\u0002B]f\u0004\"AL\u0018\u000e\u0003)I!\u0001\r\u0006\u0003-\u0019cw.\u0019;j]\u001e\feoZ!dGVlW\u000f\\1u_J\fa\u0001P5oSRtD#A\u001a\u0011\u00079\u0002q$A\tde\u0016\fG/Z!dGVlW\u000f\\1u_J$\u0012!L\u0001\u000bC\u000e\u001cW/\\;mCR,Gc\u0001\u001d<{A\u0011Q%O\u0005\u0003u\u0019\u0012A!\u00168ji\")Ah\u0001a\u0001[\u0005\u0019\u0011mY2\t\u000by\u001a\u0001\u0019\u0001\u0016\u0002\u000bY\fG.^3\u0002\u000fI,GO]1diR\u0019\u0001(\u0011\"\t\u000bq\"\u0001\u0019A\u0017\t\u000by\"\u0001\u0019\u0001\u0016\u0002\u0011\u001d,GOV1mk\u0016$\"aH#\t\u000bq*\u0001\u0019A\u0017\u0002\u000b5,'oZ3\u0015\u0007aB\u0015\nC\u0003=\r\u0001\u0007Q\u0006C\u0003K\r\u0001\u00071*A\u0002jiN\u00042\u0001T).\u001b\u0005i%B\u0001(P\u0003\u0011a\u0017M\\4\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\t\u0013R,'/\u00192mK\u0006\u0011r-\u001a;BG\u000e,X.\u001e7bi>\u0014H+\u001f9f)\u0005)\u0006c\u0001,^[5\tqK\u0003\u0002Y3\u0006AA/\u001f9fS:4wN\u0003\u0002[7\u000611m\\7n_:T!\u0001\u0018\t\u0002\u0007\u0005\u0004\u0018.\u0003\u0002_/\nyA+\u001f9f\u0013:4wN]7bi&|g.A\tsKN,H\u000e\u001e+za\u0016\u001cuN\u001c<feR$\"aH1\t\u000byB\u0001\u0019\u00012\u0011\u0005\u0015\u001a\u0017B\u00013'\u0005\u0019!u.\u001e2mK\u0002")
public abstract class FloatingAvgAggFunction<T>
extends AggregateFunction<T, FloatingAvgAccumulator> {
    public FloatingAvgAccumulator createAccumulator() {
        return new FloatingAvgAccumulator();
    }

    public void accumulate(FloatingAvgAccumulator acc, Object value) {
        if (value != null) {
            double v = ((Number)value).doubleValue();
            acc.f0 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)acc.f0) + v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
            return;
        }
    }

    public void retract(FloatingAvgAccumulator acc, Object value) {
        if (value != null) {
            double v = ((Number)value).doubleValue();
            acc.f0 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)acc.f0) - v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
            return;
        }
    }

    public T getValue(FloatingAvgAccumulator acc) {
        if (BoxesRunTime.unboxToLong((Object)acc.f1) == 0L) {
            return null;
        }
        return this.resultTypeConvert(BoxesRunTime.unboxToDouble((Object)acc.f0) / (double)BoxesRunTime.unboxToLong((Object)acc.f1));
    }

    public void merge(FloatingAvgAccumulator acc, Iterable<FloatingAvgAccumulator> its) {
        for (FloatingAvgAccumulator a : its) {
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
            acc.f0 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)acc.f0) + BoxesRunTime.unboxToDouble((Object)a.f0)));
        }
    }

    public TypeInformation<FloatingAvgAccumulator> getAccumulatorType() {
        return new TupleTypeInfo(FloatingAvgAccumulator.class, new TypeInformation[]{Types.DOUBLE(), Types.LONG()});
    }

    public abstract T resultTypeConvert(double var1);
}

