/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.utils.DecimalSumAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0002\u0005\u0001+!)\u0001\u0006\u0001C\u0001S!)1\u0006\u0001C!Y!)Q\u0006\u0001C\u0001]!)A\b\u0001C!{!)q\b\u0001C\u0001\u0001\")!\n\u0001C!\u0017\n)B)Z2j[\u0006d7+^7BO\u001e4UO\\2uS>t'BA\u0005\u000b\u0003\u0015)H/\u001b7t\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0005/iaB%D\u0001\u0019\u0015\tIB\"A\u0005gk:\u001cG/[8og&\u00111\u0004\u0007\u0002\u0012\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011i\u0017\r\u001e5\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u000b\u0005&<G)Z2j[\u0006d\u0007CA\u0013'\u001b\u0005A\u0011BA\u0014\t\u0005U!UmY5nC2\u001cV/\\!dGVlW\u000f\\1u_J\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005\u0015\u0002\u0011!E2sK\u0006$X-Q2dk6,H.\u0019;peR\tA%\u0001\u0006bG\u000e,X.\u001e7bi\u0016$2aL\u001b8!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0011)f.\u001b;\t\u000bY\u001a\u0001\u0019\u0001\u0013\u0002\u0007\u0005\u001c7\rC\u00039\u0007\u0001\u0007\u0011(A\u0003wC2,X\r\u0005\u00021u%\u00111(\r\u0002\u0004\u0003:L\u0018\u0001C4fiZ\u000bG.^3\u0015\u0005qq\u0004\"\u0002\u001c\u0005\u0001\u0004!\u0013!B7fe\u001e,GcA\u0018B\u0005\")a'\u0002a\u0001I!)1)\u0002a\u0001\t\u0006\u0019\u0011\u000e^:\u0011\u0007\u0015CE%D\u0001G\u0015\t9\u0005%\u0001\u0003mC:<\u0017BA%G\u0005!IE/\u001a:bE2,\u0017AE4fi\u0006\u001b7-^7vY\u0006$xN\u001d+za\u0016$\u0012\u0001\u0014\t\u0004\u001bR#S\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u0003;za\u0016LgNZ8\u000b\u0005E\u0013\u0016AB2p[6|gN\u0003\u0002T\u001d\u0005\u0019\u0011\r]5\n\u0005Us%a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8")
public class DecimalSumAggFunction
extends AggregateFunction<BigDecimal, DecimalSumAccumulator> {
    public DecimalSumAccumulator createAccumulator() {
        return new DecimalSumAccumulator();
    }

    public void accumulate(DecimalSumAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToBoolean((boolean)true);
            return;
        }
    }

    public BigDecimal getValue(DecimalSumAccumulator acc) {
        if (BoxesRunTime.unboxToBoolean((Object)acc.f1)) {
            return (BigDecimal)acc.f0;
        }
        return null;
    }

    public void merge(DecimalSumAccumulator acc, Iterable<DecimalSumAccumulator> its) {
        for (DecimalSumAccumulator a : its) {
            if (!BoxesRunTime.unboxToBoolean((Object)a.f1)) continue;
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToBoolean((boolean)true);
        }
    }

    public TypeInformation<DecimalSumAccumulator> getAccumulatorType() {
        return new TupleTypeInfo(DecimalSumAccumulator.class, new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO});
    }
}

