/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.planner.factories.TestTimeTravelCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.DateTimeTestUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.types.Row;

public class TimeTravelTestUtil {
    public static final List<Tuple3<String, Schema, List<Row>>> TEST_TIME_TRAVEL_DATE = Arrays.asList(Tuple3.of((Object)"2023-01-01 01:00:00", (Object)Schema.newBuilder().column("f1", (AbstractDataType)DataTypes.INT()).build(), Collections.singletonList(Row.of((Object[])new Object[]{1}))), Tuple3.of((Object)"2023-01-01 02:00:00", (Object)Schema.newBuilder().column("f1", (AbstractDataType)DataTypes.INT()).column("f2", (AbstractDataType)DataTypes.INT()).build(), Collections.singletonList(Row.of((Object[])new Object[]{1, 2}))), Tuple3.of((Object)"2023-01-01 03:00:00", (Object)Schema.newBuilder().column("f1", (AbstractDataType)DataTypes.INT()).column("f2", (AbstractDataType)DataTypes.INT()).column("f3", (AbstractDataType)DataTypes.INT()).build(), Collections.singletonList(Row.of((Object[])new Object[]{1, 2, 3}))));

    public static TestTimeTravelCatalog getTestingCatalogWithVersionedTable(String catalogName, String tableName) {
        TestTimeTravelCatalog catalog = new TestTimeTravelCatalog(catalogName);
        TEST_TIME_TRAVEL_DATE.forEach(t -> {
            String dataId = TestValuesTableFactory.registerData((Collection)t.f2);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("bounded", "true");
            options.put("data-id", dataId);
            try {
                catalog.registerTableForTimeTravel(tableName, (Schema)t.f1, options, DateTimeTestUtil.toEpochMills((String)t.f0, "yyyy-MM-dd HH:mm:ss", ZoneId.of("UTC")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return catalog;
    }
}

