/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.RangeInputFormat;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.planner.utils.TestingTableEnvironment$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011}c\u0001\u0002$H\u0001YCQa\u0017\u0001\u0005\u0002qCqA\u0018\u0001A\u0002\u0013Eq\fC\u0004g\u0001\u0001\u0007I\u0011C4\t\rA\u0004\u0001\u0015)\u0003a\u0011%\t\b\u00011AA\u0002\u0013E!\u000fC\u0005y\u0001\u0001\u0007\t\u0019!C\ts\"I1\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001d\u0005\ny\u0002\u0001\r\u00111A\u0005\u0012uD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\u0006!Q\u0011\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u00151\u0003\u0001\u0019!a\u0001\n#\tY\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\u0012\u0005m\u0001bCA\u0010\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bA1\"!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002$!Y\u0011q\u0007\u0001A\u0002\u0003\u0007I\u0011CA\u001d\u0011-\ti\u0004\u0001a\u0001\u0002\u0003\u0006K!!\n\t\u0017\u0005}\u0002\u00011AA\u0002\u0013E\u0011\u0011\t\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n#\tY\u0005C\u0006\u0002P\u0001\u0001\r\u0011!Q!\n\u0005\r\u0003\"CA)\u0001\t\u0007I\u0011AA*\u0011!\tI\u0007\u0001Q\u0001\n\u0005U\u0003\"CA6\u0001\t\u0007I\u0011AA*\u0011!\ti\u0007\u0001Q\u0001\n\u0005U\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003S\u0003A\u0011AA9\u0011\u001d\ty\u000b\u0001C\u0001\u0003cBq!!/\u0001\t\u0003\tY\fC\u0005\u0002r\u0002\t\n\u0011\"\u0001\u0002t\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001\"\u0003B\r\u0001E\u0005I\u0011AAz\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005/\u0002A\u0011\u0001B/\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003v\u0001!\u0019Aa\u001e\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\"9!Q\u000f\u0001\u0005\u0002\tE\u0007b\u0002B;\u0001\u0011\u0005!q\u001e\u0005\b\u00073\u0001A\u0011AB\u000e\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007Bqa!\u0011\u0001\t\u0003\u0019\t\u0006C\u0004\u0004\\\u0001!\ta!\u0018\t\u000f\re\u0004\u0001\"\u0005\u0004|\u001d91qQ$\t\u0002\r%eA\u0002$H\u0011\u0003\u0019Y\t\u0003\u0004\\e\u0011\u000511\u0013\u0005\b\u0007+\u0013D\u0011ABL\u0011\u001d\u0019YJ\rC\u0001\u0007;Cqaa03\t\u0003\u0019\t\rC\u0005\u0004\\J\n\n\u0011\"\u0001\u0004^\"91\u0011\u001d\u001a\u0005\u0002\r\r\bbBBte\u0011\u00051\u0011\u001e\u0005\b\u0003s\u0013D\u0011AB}\u0011%!\u0019AMI\u0001\n\u0003\t\u0019\u0010C\u0004\u0005\u0006I\"\t\u0001b\u0002\t\u000f\tE#\u0007\"\u0001\u0005\u0010!9!q\u000b\u001a\u0005\u0002\u0011U\u0001b\u0002B,e\u0011\u0005A\u0011\u0004\u0005\b\t?\u0011D\u0011\u0001C\u0011\u0011\u001d!9C\rC\u0005\tSAq\u0001\"\u00113\t\u0003!\u0019\u0005C\u0005\u0005LI\n\n\u0011\"\u0001\u0002t\"9!\u0011\r\u001a\u0005\n\u00115\u0003b\u0002C*e\u0011%AQ\u000b\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\u000b\u0005!K\u0015!B;uS2\u001c(B\u0001&L\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001T'\u0002\u000fAd\u0017M\u001c8fe*\u0011ajT\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003!F\u000bQA\u001a7j].T!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO\u000e\u00011C\u0001\u0001X!\tA\u0016,D\u0001H\u0013\tQvIA\u000bCCR\u001c\u0007.\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005i\u0006C\u0001-\u0001\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rl\u0015aA1qS&\u0011QM\u0019\u0002\u0014\u000b:4\u0018N]8o[\u0016tGoU3ui&twm]\u0001\rg\u0016$H/\u001b8hg~#S-\u001d\u000b\u0003Q:\u0004\"!\u001b7\u000e\u0003)T\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\u0014A!\u00168ji\"9qnAA\u0001\u0002\u0004\u0001\u0017a\u0001=%c\u0005I1/\u001a;uS:<7\u000fI\u0001\u0010i\u0016\u001cH/\u001b8h)\u0006\u0014G.Z#omV\t1\u000f\u0005\u0002um6\tQO\u0003\u0002I\u0017&\u0011q/\u001e\u0002\u0018)\u0016\u001cH/\u001b8h)\u0006\u0014G.Z#om&\u0014xN\\7f]R\f1\u0003^3ti&tw\rV1cY\u0016,eN^0%KF$\"\u0001\u001b>\t\u000f=4\u0011\u0011!a\u0001g\u0006\u0001B/Z:uS:<G+\u00192mK\u0016sg\u000fI\u0001\u0005i\u0016sg/F\u0001\u007f!\t\tw0C\u0002\u0002\u0002\t\u0014\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\u0002\u0011Q,eN^0%KF$2\u0001[A\u0004\u0011\u001dy\u0017\"!AA\u0002y\fQ\u0001^#om\u0002*\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005L\u0003)!W\r\\3hCRLwN\\\u0005\u0005\u0003/\t\tBA\u0006QY\u0006tg.\u001a:CCN,\u0017a\u00039mC:tWM]0%KF$2\u0001[A\u000f\u0011!yG\"!AA\u0002\u00055\u0011\u0001\u00039mC:tWM\u001d\u0011\u0002\u0007\u0015tg/\u0006\u0002\u0002&A!\u0011qEA\u001a\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012aC3om&\u0014xN\\7f]RT1aYA\u0018\u0015\r\t\tdT\u0001\ngR\u0014X-Y7j]\u001eLA!!\u000e\u0002*\tQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\u00069QM\u001c<`I\u0015\fHc\u00015\u0002<!AqnDA\u0001\u0002\u0004\t)#\u0001\u0003f]Z\u0004\u0013a\u0003;bE2,7i\u001c8gS\u001e,\"!a\u0011\u0011\u0007\u0005\f)%C\u0002\u0002H\t\u00141\u0002V1cY\u0016\u001cuN\u001c4jO\u0006yA/\u00192mK\u000e{gNZ5h?\u0012*\u0017\u000fF\u0002i\u0003\u001bB\u0001b\u001c\n\u0002\u0002\u0003\u0007\u00111I\u0001\ri\u0006\u0014G.Z\"p]\u001aLw\rI\u0001\u0011\u0019&sUiX\"P\u0019~\u0003\u0016\t\u0016+F%:+\"!!\u0016\u0011\t\u0005]\u0013QM\u0007\u0003\u00033RA!a\u0017\u0002^\u0005)!/Z4fq*!\u0011qLA1\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002Z\t9\u0001+\u0019;uKJt\u0017!\u0005'J\u001d\u0016{6i\u0014'`!\u0006#F+\u0012*OA\u00051B*\u0013(F?\u000e{Ej\u0018+X\u0013\u000e+u\fU!U)\u0016\u0013f*A\fM\u0013:+ulQ(M?R;\u0016jQ#`!\u0006#F+\u0012*OA\u0005A1/\u001a;va\u0016sg\u000fF\u0001iQ\rA\u0012Q\u000f\t\u0005\u0003o\n\u0019)\u0004\u0002\u0002z)\u00191-a\u001f\u000b\t\u0005u\u0014qP\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tiU\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u000b\u000bIH\u0001\u0006CK\u001a|'/Z#bG\"DS\u0001GAE\u0003O\u0003R![AF\u0003\u001fK1!!$k\u0005\u0019!\bN]8xgB!\u0011\u0011SAQ\u001d\u0011\t\u0019*!(\u000f\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'V\u0003\u0019a$o\\8u}%\t1.C\u0002\u0002 *\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006\u0015&!C#yG\u0016\u0004H/[8o\u0015\r\tyJ[\u0012\u0003\u0003\u001f\u000baAY3g_J,\u0007fA\r\u0002v!*\u0011$!#\u0002(\u0006)\u0011M\u001a;fe\"\u001a!$a-\u0011\t\u0005]\u0014QW\u0005\u0005\u0003o\u000bIHA\u0005BMR,'/R1dQ\u0006Y1\r[3dWJ+7/\u001e7u)\u001dA\u0017QXAi\u0003ODq!a0\u001c\u0001\u0004\t\t-\u0001\u0005tc2\fV/\u001a:z!\u0011\t\u0019-a3\u000f\t\u0005\u0015\u0017q\u0019\t\u0004\u0003+S\u0017bAAeU\u00061\u0001K]3eK\u001aLA!!4\u0002P\n11\u000b\u001e:j]\u001eT1!!3k\u0011\u001d\t\u0019n\u0007a\u0001\u0003+\fa\"\u001a=qK\u000e$X\r\u001a*fgVdG\u000f\u0005\u0004\u0002\u0012\u0006]\u00171\\\u0005\u0005\u00033\f)KA\u0002TKF\u0004B!!8\u0002d6\u0011\u0011q\u001c\u0006\u0004\u0003C|\u0015!\u0002;za\u0016\u001c\u0018\u0002BAs\u0003?\u00141AU8x\u0011%\tIo\u0007I\u0001\u0002\u0004\tY/\u0001\u0005jgN{'\u000f^3e!\rI\u0017Q^\u0005\u0004\u0003_T'a\u0002\"p_2,\u0017M\\\u0001\u0016G\",7m\u001b*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)P\u000b\u0003\u0002l\u0006]8FAA}!\u0011\tYP!\u0002\u000e\u0005\u0005u(\u0002BA\u0000\u0005\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\r!.\u0001\u0006b]:|G/\u0019;j_:LAAa\u0002\u0002~\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!\rDWmY6UC\ndWMU3tk2$Hc\u00025\u0003\u000e\tU!q\u0003\u0005\u0007\u001dv\u0001\rAa\u0004\u0011\u0007\u0005\u0014\t\"C\u0002\u0003\u0014\t\u0014Q\u0001V1cY\u0016Dq!a5\u001e\u0001\u0004\t)\u000eC\u0005\u0002jv\u0001\n\u00111\u0001\u0002l\u0006Q2\r[3dWR\u000b'\r\\3SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005I1\r[3dWNK'0\u001a\u000b\u0006Q\n}!\u0011\u0005\u0005\b\u0003\u007f{\u0002\u0019AAa\u0011\u001d\u0011\u0019c\ba\u0001\u0005K\tA\"\u001a=qK\u000e$X\rZ*ju\u0016\u00042!\u001bB\u0014\u0013\r\u0011IC\u001b\u0002\u0004\u0013:$\u0018AC2iK\u000e\\G+\u00192mKR)\u0001Na\f\u00032!1a\n\ta\u0001\u0005\u001fAqAa\r!\u0001\u0004\u0011)$A\u0005dQ\u0016\u001c7NR;oGB9\u0011Na\u000e\u0002V\nm\u0012b\u0001B\u001dU\nIa)\u001e8di&|g.\r\t\u0006S\nu\u0012\u0011Y\u0005\u0004\u0005\u007fQ'AB(qi&|g.A\u0006dQ\u0016\u001c7NR1jY\u0016$G#\u00025\u0003F\t\u001d\u0003bBA`C\u0001\u0007\u0011\u0011\u0019\u0005\b\u0005\u0013\n\u0003\u0019AAa\u0003I)\u0007\u0010]3di\u0016$Wj]4QCR$XM\u001d8\u0002!\rDWmY6F[B$\u0018PU3tk2$Hc\u00015\u0003P!9\u0011q\u0018\u0012A\u0002\u0005\u0005\u0017A\u00039beN,\u0017+^3ssR!!q\u0002B+\u0011\u001d\tyl\ta\u0001\u0003\u0003\fA\"\u001a=fGV$X-U;fef$B!!6\u0003\\!1a\n\na\u0001\u0005\u001f!B!!6\u0003`!9\u0011qX\u0013A\u0002\u0005\u0005\u0017!\u00049sKB\f'/\u001a*fgVdG\u000f\u0006\u0004\u0003f\t\u001d$1\u000e\t\u0007\u0003#\u000b9.!1\t\u000f\t%d\u00051\u0001\u0002V\u0006\u00191/Z9\t\u000f\u0005%h\u00051\u0001\u0002l\u0006Q1\r[3dW\u0016k\u0007\u000f^=\u0015\t\tm\"\u0011\u000f\u0005\b\u0005g:\u0003\u0019AAk\u0003\u0019\u0011Xm];mi\u0006\u0011\"/Z4jgR,'oQ8mY\u0016\u001cG/[8o)%A'\u0011\u0010B?\u0005\u000f\u0013i\nC\u0004\u0003|!\u0002\r!!1\u0002\u0013Q\f'\r\\3OC6,\u0007b\u0002B@Q\u0001\u0007!\u0011Q\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002\u0012\n\r\u00151\\\u0005\u0005\u0005\u000b\u000b)K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011I\t\u000ba\u0001\u0005\u0017\u000b\u0001\u0002^=qK&sgm\u001c\t\u0007\u0005\u001b\u0013I*a7\u000e\u0005\t=%\u0002\u0002BI\u0005'\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u0005\u0005+\u00139*\u0001\u0004d_6lwN\u001c\u0006\u0003G>KAAa'\u0003\u0010\nyA+\u001f9f\u0013:4wN]7bi&|g\u000eC\u0004\u0003 \"\u0002\r!!1\u0002\r\u0019LW\r\u001c3t\u0003Y\u0011XmZ5ti\u0016\u0014(*\u0019<b\u0007>dG.Z2uS>tW\u0003\u0002BS\u0005s#\u0012\u0002\u001bBT\u0005S\u0013YMa4\t\u000f\tm\u0014\u00061\u0001\u0002B\"9!qP\u0015A\u0002\t-\u0006C\u0002BW\u0005g\u0013),\u0004\u0002\u00030*!!\u0011WA1\u0003\u0011a\u0017M\\4\n\t\t\u0015%q\u0016\t\u0005\u0005o\u0013I\f\u0004\u0001\u0005\u000f\tm\u0016F1\u0001\u0003>\n\tA+\u0005\u0003\u0003@\n\u0015\u0007cA5\u0003B&\u0019!1\u00196\u0003\u000f9{G\u000f[5oOB\u0019\u0011Na2\n\u0007\t%'NA\u0002B]fDqA!#*\u0001\u0004\u0011i\r\u0005\u0004\u0003\u000e\ne%Q\u0017\u0005\b\u0005?K\u0003\u0019AAa+\u0011\u0011\u0019N!8\u0015\u0017!\u0014)Na6\u0003`\n\r(Q\u001d\u0005\b\u0005wR\u0003\u0019AAa\u0011\u001d\u0011yH\u000ba\u0001\u00053\u0004b!!%\u0003\u0004\nm\u0007\u0003\u0002B\\\u0005;$qAa/+\u0005\u0004\u0011i\fC\u0004\u0003\n*\u0002\rA!9\u0011\r\t5%\u0011\u0014Bn\u0011\u001d\u0011yJ\u000ba\u0001\u0003\u0003DqAa:+\u0001\u0004\u0011I/\u0001\bgS\u0016dGMT;mY\u0006\u0014G.Z:\u0011\u000b%\u0014Y/a;\n\u0007\t5(NA\u0003BeJ\f\u00170\u0006\u0003\u0003r\nmH#\u00045\u0003t\nU(Q`B\u0001\u0007\u0007\u0019)\u0001C\u0004\u0003|-\u0002\r!!1\t\u000f\t}4\u00061\u0001\u0003xB1\u0011\u0011\u0013BB\u0005s\u0004BAa.\u0003|\u00129!1X\u0016C\u0002\tu\u0006b\u0002BEW\u0001\u0007!q \t\u0007\u0005\u001b\u0013IJ!?\t\u000f\t}5\u00061\u0001\u0002B\"9!q]\u0016A\u0002\t%\bbBB\u0004W\u0001\u00071\u0011B\u0001\ngR\fG/[:uS\u000e\u0004Baa\u0003\u0004\u00165\u00111Q\u0002\u0006\u0005\u0007\u001f\u0019\t\"A\u0003ti\u0006$8OC\u0002\u0004\u0014-\u000bA\u0001\u001d7b]&!1qCB\u0007\u000591E.\u001b8l'R\fG/[:uS\u000e\fqD]3hSN$XM\u001d+f[B|'/\u0019:z'f\u001cH/Z7Gk:\u001cG/[8o)\u0015A7QDB\u0011\u0011\u001d\u0019y\u0002\fa\u0001\u0003\u0003\fAA\\1nK\"911\u0005\u0017A\u0002\r\u0015\u0012!\u00044v]\u000e$\u0018n\u001c8DY\u0006\u001c8\u000f\r\u0003\u0004(\r=\u0002CBAb\u0007S\u0019i#\u0003\u0003\u0004,\u0005='!B\"mCN\u001c\b\u0003\u0002B\\\u0007_!Ab!\r\u0004\"\u0005\u0005\t\u0011!B\u0001\u0007g\u00111a\u0018\u00132#\u0011\u0011yl!\u000e\u0011\t\r]2QH\u0007\u0003\u0007sQ1aa\u000fN\u0003%1WO\\2uS>t7/\u0003\u0003\u0004@\re\"aE+tKJ$UMZ5oK\u00124UO\\2uS>t\u0017!\u0004:fO&\u001cH/\u001a:SC:<W\rF\u0003i\u0007\u000b\u001a9\u0005C\u0004\u0004 5\u0002\r!!1\t\u000f\r%S\u00061\u0001\u0004L\u0005\u0019QM\u001c3\u0011\u0007%\u001ci%C\u0002\u0004P)\u0014A\u0001T8oOR9\u0001na\u0015\u0004V\re\u0003bBB\u0010]\u0001\u0007\u0011\u0011\u0019\u0005\b\u0007/r\u0003\u0019AB&\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0019IE\fa\u0001\u0007\u0017\naB\\3x%\u0006tw-Z*pkJ\u001cW\r\u0006\u0004\u0004`\rU4q\u000f\t\u0007\u0007C\u001a9ga\u001b\u000e\u0005\r\r$\u0002BB3\u0003[\t!\u0002Z1uCN$(/Z1n\u0013\u0011\u0019Iga\u0019\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0003\u0004n\rETBAB8\u0015\r\u0011y(T\u0005\u0005\u0007g\u001ayGA\u0004S_^$\u0015\r^1\t\u000f\r]s\u00061\u0001\u0004L!91\u0011J\u0018A\u0002\r-\u0013!\u0002:po>3G\u0003BAn\u0007{Bqaa 1\u0001\u0004\u0019\t)\u0001\u0003be\u001e\u001c\b#B5\u0004\u0004\n\u0015\u0017bABCU\nQAH]3qK\u0006$X\r\u001a \u0002\u001b\t\u000bGo\u00195UKN$()Y:f!\tA&gE\u00023\u0007\u001b\u00032![BH\u0013\r\u0019\tJ\u001b\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r%\u0015a\u0001:poR!\u00111\\BM\u0011\u001d\u0019y\b\u000ea\u0001\u0007\u0003\u000b\u0011BY5oCJL(k\\<\u0015\r\r}51VB_!\u0011\u0019\tka*\u000e\u0005\r\r&\u0002BBS\u0007_\naAY5oCJL\u0018\u0002BBU\u0007G\u0013QBQ5oCJL(k\\<ECR\f\u0007bBAqk\u0001\u00071Q\u0016\t\u0006S\n-8q\u0016\t\u0005\u0007c\u001bI,\u0004\u0002\u00044*!1QWB\\\u0003\u001dawnZ5dC2T1!!9N\u0013\u0011\u0019Yla-\u0003\u00171{w-[2bYRK\b/\u001a\u0005\b\u0005?+\u0004\u0019ABA\u00035\u0019w.\u001c9be\u0016\u0014Vm];miV!11YBi)%A7QYBf\u0007'\u001c9\u000eC\u0004\u0004HZ\u0002\ra!3\u0002\u001f\u0015D\b/Z2uK\u0012\u001cFO]5oON\u0004R!\u001bBv\u0003\u0003DqAa\u001d7\u0001\u0004\u0019i\rE\u0003j\u0005W\u001cy\r\u0005\u0003\u00038\u000eEGa\u0002B^m\t\u0007!Q\u0018\u0005\b\u0007+4\u0004\u0019AAv\u0003\u0011\u0019xN\u001d;\t\u0013\reg\u0007%AA\u0002\u0005-\u0018\u0001C1t)V\u0004H.Z:\u0002/\r|W\u000e]1sKJ+7/\u001e7uI\u0011,g-Y;mi\u0012\"T\u0003BAz\u0007?$qAa/8\u0005\u0004\u0011i,\u0001\u000bd_:4\u0017n\u001a$pe6Kg.[\"mkN$XM\u001d\u000b\u0004Q\u000e\u0015\bbBA q\u0001\u0007\u00111I\u0001\u0017G>tg-[4CCR\u001c\u0007n\u00155vM\u001adW-T8eKR)\u0001na;\u0004n\"9\u0011qH\u001dA\u0002\u0005\r\u0003bBBxs\u0001\u00071\u0011_\u0001\fg\",hM\u001a7f\u001b>$W\r\u0005\u0003\u0004t\u000eUXB\u0001BJ\u0013\u0011\u00199Pa%\u0003!\t\u000bGo\u00195TQV4g\r\\3N_\u0012,G#\u00035\u0004|\u000eu8q C\u0001\u0011\u001d\tyL\u000fa\u0001\u0003\u0003Dq!a5;\u0001\u0004\t)\u000eC\u0003}u\u0001\u0007a\u0010C\u0005\u0002jj\u0002\n\u00111\u0001\u0002l\u0006)2\r[3dWJ+7/\u001e7uI\u0011,g-Y;mi\u0012\"\u0014!B2iK\u000e\\Gc\u00025\u0005\n\u0011-AQ\u0002\u0005\b\u0003\u007fc\u0004\u0019AAa\u0011\u001d\u0011\u0019\u0004\u0010a\u0001\u0005kAQ\u0001 \u001fA\u0002y$bAa\u0004\u0005\u0012\u0011M\u0001bBA`{\u0001\u0007\u0011\u0011\u0019\u0005\u0006yv\u0002\rA \u000b\u0005\u0003+$9\u0002\u0003\u0004O}\u0001\u0007!q\u0002\u000b\u0007\u0003+$Y\u0002\"\b\t\u000f\u0005}v\b1\u0001\u0002B\")Ap\u0010a\u0001}\u0006qQ\r\u001f9mC&tGj\\4jG\u0006dGCBAa\tG!)\u0003\u0003\u0004O\u0001\u0002\u0007!q\u0002\u0005\u0006y\u0002\u0003\rA`\u0001\bO\u0016$\b\u000b\\1o)\u0019\t\t\rb\u000b\u0005@!9AQF!A\u0002\u0011=\u0012a\u0002:fY:{G-\u001a\t\u0005\tc!Y$\u0004\u0002\u00054)!AQ\u0007C\u001c\u0003\r\u0011X\r\u001c\u0006\u0004\ts\t\u0016aB2bY\u000eLG/Z\u0005\u0005\t{!\u0019DA\u0004SK2tu\u000eZ3\t\u000bq\f\u0005\u0019\u0001@\u0002\u0013\rDWmY6TC6,G\u0003\u0003B\u001e\t\u000b\"9\u0005\"\u0013\t\u000f\u0005M'\t1\u0001\u0002V\"9!1\u000f\"A\u0002\u0005U\u0007\"CAu\u0005B\u0005\t\u0019AAv\u0003M\u0019\u0007.Z2l'\u0006lW\r\n3fM\u0006,H\u000e\u001e\u00134)\u0019\u0011)\u0007b\u0014\u0005R!9!\u0011\u000e#A\u0002\u0005U\u0007bBAu\t\u0002\u0007\u00111^\u0001\u000bg&$WMQ=TS\u0012,GC\u0002B3\t/\"Y\u0006C\u0004\u0005Z\u0015\u0003\rA!\u001a\u0002\t1,g\r\u001e\u0005\b\t;*\u0005\u0019\u0001B3\u0003\u0015\u0011\u0018n\u001a5u\u0001")
public class BatchTestBase
extends BatchAbstractTestBase {
    private EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
    private TestingTableEnvironment testingTableEnv;
    private TableEnvironment tEnv;
    private PlannerBase planner;
    private StreamExecutionEnvironment env;
    private TableConfig tableConfig;
    private final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");

    public static boolean checkSame$default$3() {
        return BatchTestBase$.MODULE$.checkSame$default$3();
    }

    public static Option<String> checkSame(Seq<Row> seq, Seq<Row> seq2, boolean bl) {
        return BatchTestBase$.MODULE$.checkSame(seq, seq2, bl);
    }

    public static String explainLogical(Table table, TableEnvironment tableEnvironment) {
        return BatchTestBase$.MODULE$.explainLogical(table, tableEnvironment);
    }

    public static void check(String string, Function1<Seq<Row>, Option<String>> function1, TableEnvironment tableEnvironment) {
        BatchTestBase$.MODULE$.check(string, function1, tableEnvironment);
    }

    public static boolean checkResult$default$4() {
        return BatchTestBase$.MODULE$.checkResult$default$4();
    }

    public static void configBatchShuffleMode(TableConfig tableConfig, BatchShuffleMode batchShuffleMode) {
        BatchTestBase$.MODULE$.configBatchShuffleMode(tableConfig, batchShuffleMode);
    }

    public static void configForMiniCluster(TableConfig tableConfig) {
        BatchTestBase$.MODULE$.configForMiniCluster(tableConfig);
    }

    public static <T> boolean compareResult$default$4() {
        return BatchTestBase$.MODULE$.compareResult$default$4();
    }

    public static <T> void compareResult(String[] stringArray, Object object, boolean bl, boolean bl2) {
        BatchTestBase$.MODULE$.compareResult(stringArray, object, bl, bl2);
    }

    public static BinaryRowData binaryRow(LogicalType[] logicalTypeArray, Seq<Object> seq) {
        return BatchTestBase$.MODULE$.binaryRow(logicalTypeArray, seq);
    }

    public static Row row(Seq<Object> seq) {
        return BatchTestBase$.MODULE$.row(seq);
    }

    public EnvironmentSettings settings() {
        return this.settings;
    }

    public void settings_$eq(EnvironmentSettings x$1) {
        this.settings = x$1;
    }

    public TestingTableEnvironment testingTableEnv() {
        return this.testingTableEnv;
    }

    public void testingTableEnv_$eq(TestingTableEnvironment x$1) {
        this.testingTableEnv = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    public PlannerBase planner() {
        return this.planner;
    }

    public void planner_$eq(PlannerBase x$1) {
        this.planner = x$1;
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public void env_$eq(StreamExecutionEnvironment x$1) {
        this.env = x$1;
    }

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public void tableConfig_$eq(TableConfig x$1) {
        this.tableConfig = x$1;
    }

    public Pattern LINE_COL_PATTERN() {
        return this.LINE_COL_PATTERN;
    }

    public Pattern LINE_COL_TWICE_PATTERN() {
        return this.LINE_COL_TWICE_PATTERN;
    }

    @BeforeEach
    public void setupEnv() throws Exception {
        this.testingTableEnv_$eq(TestingTableEnvironment$.MODULE$.create(this.settings(), (Option<CatalogManager>)None$.MODULE$, TableConfig.getDefault()));
        this.tEnv_$eq((TableEnvironment)this.testingTableEnv());
        this.tEnv().getConfig().set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.planner_$eq((PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner());
        this.env_$eq(this.planner().getExecEnv());
        this.env().getConfig().enableObjectReuse();
        this.tableConfig_$eq(this.tEnv().getConfig());
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
    }

    @BeforeEach
    public void before() throws Exception {
    }

    @AfterEach
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, boolean isSorted) {
        BatchTestBase$.MODULE$.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> BatchTestBase$.MODULE$.checkSame(expectedResult, (Seq<Row>)result, isSorted), this.tEnv());
    }

    public boolean checkResult$default$3() {
        return false;
    }

    public void checkTableResult(Table table, Seq<Row> expectedResult, boolean isSorted) {
        this.checkTable(table, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> BatchTestBase$.MODULE$.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkSize(String sqlQuery, int expectedSize) {
        BatchTestBase$.MODULE$.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> {
            if (result.size() != expectedSize) {
                String string = new StringBuilder(23).append("== Correct Result - ").append(expectedSize).append(" ==").toString();
                String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
                String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               |Results\n               |").append(BatchTestBase$.MODULE$.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide((Seq<String>)((Seq)this.prepareResult((Seq<Row>)((Seq)Nil$.MODULE$), false).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult((Seq<Row>)result, false).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
                return new Some((Object)errorMessage);
            }
            return None$.MODULE$;
        }, this.tEnv());
    }

    public void checkTable(Table table, Function1<Seq<Row>, Option<String>> checkFunc) {
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            String plan = BatchTestBase$.MODULE$.explainLogical(table, this.tEnv());
            return (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n                |Results do not match:\n                |").append((String)results).append("\n                |Plan:\n                |  ").append(plan).append("\n       ").toString())).stripMargin());
        });
    }

    public boolean checkTableResult$default$3() {
        return false;
    }

    public void checkFailed(String sqlQuery, String expectedMsgPattern) {
        block26: {
            try {
                Table table = this.parseQuery(sqlQuery);
                Seq<Row> _ = this.executeQuery(table);
                if (expectedMsgPattern != null) {
                    throw new AssertionError((Object)new StringBuilder(73).append("Expected query to throw exception, but it did not;").append(" query [").append(sqlQuery).append(" ];").append(" expected [").append(expectedMsgPattern).append("]").toString());
                }
            }
            catch (SqlParserException spe) {
                String errMsg = spe.getMessage();
                if (expectedMsgPattern == null) {
                    throw new RuntimeException(new StringBuilder(27).append("Error while parsing query: ").append(sqlQuery).toString(), spe);
                }
                if (errMsg == null || !errMsg.matches(expectedMsgPattern)) {
                    throw new RuntimeException(new StringBuilder(54).append("Error did not match expected [").append(expectedMsgPattern).append("] while ").append("parsing query [").append(sqlQuery).append("]").toString(), spe);
                }
            }
            catch (Throwable thrown) {
                Object object;
                Throwable actualExp = thrown;
                String actualMsg = actualExp.getMessage();
                int actualLine = -1;
                int actualColumn = -1;
                int actualEndLine = 100;
                int actualEndColumn = 99;
                CalciteContextException ece = null;
                SqlParseException spe = null;
                Throwable ex = actualExp;
                boolean found = false;
                while (ex != null && !found) {
                    Throwable throwable = ex;
                    if (throwable instanceof CalciteContextException) {
                        CalciteContextException calciteContextException;
                        ece = calciteContextException = (CalciteContextException)throwable;
                        found = true;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        Throwable throwable3 = throwable2.getCause();
                        Throwable throwable4 = ex;
                        if (!(throwable3 != null ? !throwable3.equals(throwable4) : throwable4 != null)) {
                            found = true;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                }
                ex = actualExp;
                found = false;
                while (ex != null && !found) {
                    SqlParseException sqlParseException;
                    Throwable throwable = ex;
                    if (throwable instanceof SqlParseException && (sqlParseException = (SqlParseException)throwable).getPos() != null) {
                        spe = sqlParseException;
                        found = true;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable5 = throwable;
                        Throwable throwable6 = throwable5.getCause();
                        Throwable throwable7 = ex;
                        if (!(throwable6 != null ? !throwable6.equals(throwable7) : throwable7 != null)) {
                            found = true;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                }
                if (ece != null) {
                    actualLine = ece.getPosLine();
                    actualColumn = ece.getPosColumn();
                    actualEndLine = ece.getEndPosLine();
                    actualEndColumn = ece.getEndPosColumn();
                    if (ece.getCause() != null) {
                        actualExp = ece.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else if (spe != null) {
                    actualLine = spe.getPos().getLineNum();
                    actualColumn = spe.getPos().getColumnNum();
                    actualEndLine = spe.getPos().getEndLineNum();
                    actualEndColumn = spe.getPos().getEndColumnNum();
                    if (spe.getCause() != null) {
                        actualExp = spe.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else {
                    String message = actualMsg;
                    if (message != null) {
                        Matcher matcher = this.LINE_COL_TWICE_PATTERN().matcher(message);
                        if (matcher.matches()) {
                            actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                            actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            actualEndLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt();
                            actualEndColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(4))).toInt();
                            actualMsg = matcher.group(5);
                        } else {
                            matcher = this.LINE_COL_PATTERN().matcher(message);
                            if (matcher.matches()) {
                                actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            }
                        }
                    }
                }
                if (expectedMsgPattern == null) {
                    actualExp.printStackTrace();
                    object = Assertions.fail((String)new StringBuilder(113).append("Validator threw unexpected exception; query [").append(sqlQuery).append("];").append(" exception [").append(actualMsg).append("]; class [").append(actualExp).append(".getClass];").append(" pos [line ").append(actualLine).append(" col ").append(actualColumn).append(" thru line ").append(actualLine).append(" col ").append(actualColumn).append("]").toString());
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (actualMsg != null && actualMsg.matches(expectedMsgPattern)) break block26;
                actualExp.printStackTrace();
                Assertions.fail((String)new StringBuilder(124).append("Validator threw different ").append("exception than expected; query [").append(sqlQuery).append("];\n").append(" expected pattern [").append(expectedMsgPattern).append("];\n").append(" actual [").append(actualMsg).append("];\n").append(" pos [").append(actualLine).append(" col ").append(actualColumn).append(" thru line ").append(actualEndLine).append(" col ").append(actualEndColumn).append("].").toString());
            }
        }
    }

    public void checkEmptyResult(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        this.checkEmpty(result).foreach((Function1 & Serializable & scala.Serializable)results -> (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n                |Results do not match for query:\n                |").append((String)results).append("\n       ").toString())).stripMargin()));
    }

    public Table parseQuery(String sqlQuery) {
        return BatchTestBase$.MODULE$.parseQuery(sqlQuery, this.tEnv());
    }

    public Seq<Row> executeQuery(Table table) {
        return BatchTestBase$.MODULE$.executeQuery(table);
    }

    public Seq<Row> executeQuery(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        return this.executeQuery(table);
    }

    private Seq<String> prepareResult(Seq<Row> seq, boolean isSorted) {
        if (!isSorted) {
            return (Seq)((SeqLike)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)s -> s, (Ordering)Ordering.String$.MODULE$);
        }
        return (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom());
    }

    private Option<String> checkEmpty(Seq<Row> result) {
        Nil$ expectedResult = Nil$.MODULE$;
        return BatchTestBase$.MODULE$.checkSame((Seq<Row>)expectedResult, result, true);
    }

    public void registerCollection(String tableName, Iterable<Row> data, TypeInformation<Row> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields);
    }

    public <T> void registerJavaCollection(String tableName, java.lang.Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala(), typeInfo, fields);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables, FlinkStatistic statistic) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)new Some((Object)statistic));
    }

    public void registerTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        this.testingTableEnv().createTemporarySystemFunction(name, functionClass);
    }

    public void registerRange(String name, long end) {
        this.registerRange(name, 0L, end);
    }

    public void registerRange(String name, long start, long end) {
        BatchTableEnvUtil$.MODULE$.registerBoundedStreamInternal(this.tEnv(), name, this.newRangeSource(start, end), (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)}), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public DataStream<RowData> newRangeSource(long start, long end) {
        InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BigIntType()});
        DataStreamSource boundedStream = this.env().createInput((InputFormat)new RangeInputFormat(start, end), (TypeInformation)typeInfo);
        boundedStream.setParallelism(1);
        return boundedStream;
    }

    public Row rowOf(Seq<Object> args) {
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return row;
    }
}

