/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0002\u0004\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u00037\u0001\u0011\u0005q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003O\u0001\u0011\u0005AH\u0001\u000bUS6,\u0017\t\u001e;sS\n,H/Z:J)\u000e\u000b7/\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\rM$(/Z1n\u0015\tYA\"A\u0004sk:$\u0018.\\3\u000b\u00055q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f=Q!\u0001E\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0015\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0001\u0005[>$W\r\u0005\u0002 g9\u0011\u0001%\r\b\u0003CAr!AI\u0018\u000f\u0005\rrcB\u0001\u0013.\u001d\t)CF\u0004\u0002'W9\u0011qEK\u0007\u0002Q)\u0011\u0011&F\u0001\u0007yI|w\u000e\u001e \n\u0003QI!AE\n\n\u0005A\t\u0012BA\u0004\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011!DC\u0005\u0003ee\t!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!\u0001N\u001b\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'B\u0001\u001a\u001a\u0003\u0019a\u0014N\\5u}Q\u0011\u0001H\u000f\t\u0003s\u0001i\u0011A\u0002\u0005\u0006;\t\u0001\rAH\u0001=i\u0016\u001cH/T5tg&tw\rV5nK\u0006#HO]5ckR,\u0017J\u001c'fO\u0006\u001c\u0017pU8ve\u000e,G\u000b\u001b:poN\u001cuN\u001d:fGR,\u0005pY3qi&|g\u000eF\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0011)f.\u001b;)\u0005\r!\u0005CA#M\u001b\u00051%BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u0013*\u000bqA[;qSR,'O\u0003\u0002L'\u0005)!.\u001e8ji&\u0011QJ\u0012\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001-i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BiR\u0014\u0018NY;uKN<\u0016\u000e\u001e5XCR,'/\\1sWN#(/\u0019;fOfD#\u0001\u0002#)\t\u0001\tv\u000b\u0017\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u001a\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005Y\u001b&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\n\u0011lI\u0001[!\tY6-D\u0001]\u0015\tif,A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003?\u0002\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\tY\u0015M\u0003\u0002c\u001f\u0005IA/Z:ukRLGn]\u0005\u0003Ir\u0013!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\u0004")
public class TimeAttributesITCase
extends StreamingWithStateTestBase {
    @TestTemplate
    public void testMissingTimeAttributeInLegacySourceThrowsCorrectException() {
        DataStreamSource stream = this.env().addSource((SourceFunction)new SourceFunction<Tuple2<Object, String>>(null){

            public void run(SourceFunction.SourceContext<Tuple2<Object, String>> ctx) {
                ctx.collect((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)"hello"));
                ctx.collect((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)"world"));
            }

            public void cancel() {
            }
        });
        this.tEnv().createTemporaryView("test", (DataStream)stream, Schema.newBuilder().columnByMetadata("event_time", (AbstractDataType)DataTypes.TIMESTAMP((int)3), "rowtime", true).build());
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result).addSink((SinkFunction)sink);
        Assertions.assertThatThrownBy(() -> this.env().execute()).hasMessageNotContaining("Rowtime timestamp is not defined. Please make sure that a proper TimestampAssigner is defined and the stream environment uses the EventTime time characteristic.");
    }

    @TestTemplate
    public void testTimestampAttributesWithWatermarkStrategy() {
        .colon.colon data = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"hello"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"world"), (List)Nil$.MODULE$));
        SingleOutputStreamOperator stream = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$$anon$2 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(WatermarkStrategy.forBoundedOutOfOrderness((Duration)Duration.ofMinutes(5L)).withTimestampAssigner((SerializableTimestampAssigner)new SerializableTimestampAssigner<Tuple2<Object, String>>(null){

            public long extractTimestamp(Tuple2<Object, String> element, long recordTimestamp) {
                return element._1$mcJ$sp();
            }
        }));
        this.tEnv().createTemporaryView("test", (DataStream)stream, Schema.newBuilder().columnByMetadata("event_time", (AbstractDataType)DataTypes.TIMESTAMP((int)3), "rowtime", true).build());
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result).addSink((SinkFunction)sink);
        this.env().execute();
        List formattedData = (List)data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long timestamp = tuple2._1$mcJ$sp();
                String data = (String)tuple2._2();
                String formattedTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).toString();
                return new StringBuilder(2).append(timestamp).append(",").append(data).append(",").append(formattedTimestamp).toString();
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertThat((Object)formattedData.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TimeAttributesITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

