/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql.join;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.planner.runtime.utils.JoinReorderITCaseBase;
import org.apache.flink.table.planner.runtime.utils.StreamTestSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import scala.Tuple2;

public class JoinReorderITCase
extends JoinReorderITCaseBase {
    private StreamExecutionEnvironment env;

    @Override
    @AfterEach
    public void after() {
        super.after();
        StreamTestSink.clear();
    }

    @Override
    protected TableEnvironment getTableEnvironment() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.env = StreamExecutionEnvironment.getExecutionEnvironment();
        return StreamTableEnvironment.create((StreamExecutionEnvironment)this.env, (EnvironmentSettings)settings);
    }

    @Override
    protected void assertEquals(String query, List<String> expectedList) {
        StreamTableEnvironment streamTableEnvironment = (StreamTableEnvironment)this.tEnv;
        Table table = streamTableEnvironment.sqlQuery(query);
        TestingRetractSink sink = new TestingRetractSink();
        streamTableEnvironment.toRetractStream(table, Row.class).map(JavaScalaConversionUtil::toScala, TypeInformation.of(Tuple2.class)).addSink((SinkFunction)sink);
        try {
            this.env.execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList results = JavaScalaConversionUtil.toJava(sink.getRetractResults());
        results = new ArrayList(results);
        results.sort(String::compareTo);
        expectedList.sort(String::compareTo);
        Assertions.assertThat(results).isEqualTo(expectedList);
    }
}

