/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001!3AAC\u0006\u00019!)1\u0005\u0001C\u0001I!)q\u0005\u0001C\u0001Q!)!\b\u0001C\u0001Q!)A\b\u0001C\u0001Q!)a\b\u0001C\u0001Q!)\u0001\t\u0001C\u0001Q!)!\t\u0001C\u0001Q!)A\t\u0001C\u0001Q!)a\t\u0001C\u0001Q\t\u0011B*[7jiB\u0012V-\\8wK&#6)Y:f\u0015\taQ\"A\u0002tc2T!AD\b\u0002\rM$(/Z1n\u0015\t\u0001\u0012#A\u0004sk:$\u0018.\\3\u000b\u0005I\u0019\u0012a\u00029mC:tWM\u001d\u0006\u0003)U\tQ\u0001^1cY\u0016T!AF\f\u0002\u000b\u0019d\u0017N\\6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001f\u0005)Q\u000f^5mg&\u0011!e\b\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\f\u0003U!Xm\u001d;TS6\u0004H.\u001a'j[&$(+Z7pm\u0016$\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0003aA\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\u0004CBL'BA\u001b7\u0003\u001dQW\u000f]5uKJT!aN\r\u0002\u000b),h.\u001b;\n\u0005e\u0012$\u0001\u0002+fgR\f!\u0004^3ti2KW.\u001b;SK6|g/Z,ji\"|%\u000fZ3s\u0005fD#a\u0001\u0019\u00023Q,7\u000f\u001e'j[&$(+Z7pm\u0016<\u0016\u000e\u001e5TK2,7\r\u001e\u0015\u0003\tA\nQ\u0003^3ti2KW.\u001b;SK6|g/Z,ji\"Le\u000e\u000b\u0002\u0006a\u0005AB/Z:u\u0019&l\u0017\u000e\u001e*f[>4XmV5uQ:{G/\u00138)\u0005\u0019\u0001\u0014!\u0007;fgRd\u0015.\\5u%\u0016lwN^3XSRDW\t_5tiND#a\u0002\u0019\u00029Q,7\u000f\u001e'j[&$(+Z7pm\u0016<\u0016\u000e\u001e5O_R,\u00050[:ug\"\u0012\u0001\u0002M\u0001\u0018i\u0016\u001cH\u000fT5nSR\u0014V-\\8wK^KG\u000f\u001b&pS:D#!\u0003\u0019")
public class Limit0RemoveITCase
extends StreamingTestBase {
    @Test
    public void testSimpleLimitRemove() {
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "SELECT * FROM MyTable LIMIT 0";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getResults(sinkName).size()).isZero();
    }

    @Test
    public void testLimitRemoveWithOrderBy() {
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "SELECT * FROM MyTable ORDER BY a LIMIT 0";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getResults(sinkName).size()).isZero();
    }

    @Test
    public void testLimitRemoveWithSelect() {
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "select a2 from (select cast(a as int) a2 from MyTable limit 0)";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getResults(sinkName).size()).isZero();
    }

    @Test
    public void testLimitRemoveWithIn() {
        DataStreamSource ds1 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStreamSource ds2 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE a IN (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getResults(sinkName).size()).isZero();
    }

    @Test
    public void testLimitRemoveWithNotIn() {
        DataStreamSource ds1 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStreamSource ds2 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE a NOT IN (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Seq expected = (Seq)new .colon.colon((Object)"+I[1]", (List)new .colon.colon((Object)"+I[2]", (List)new .colon.colon((Object)"+I[3]", (List)new .colon.colon((Object)"+I[4]", (List)new .colon.colon((Object)"+I[5]", (List)new .colon.colon((Object)"+I[6]", (List)Nil$.MODULE$))))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings(sinkName)).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testLimitRemoveWithExists() {
        DataStreamSource ds1 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStreamSource ds2 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE EXISTS (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.all());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getRawResults(sinkName).size()).isZero();
    }

    @Test
    public void testLimitRemoveWithNotExists() {
        DataStreamSource ds1 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStreamSource ds2 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE NOT EXISTS (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.all());
        result.executeInsert(sinkName).await();
        Seq expected = (Seq)new .colon.colon((Object)"+I[1]", (List)new .colon.colon((Object)"+I[2]", (List)new .colon.colon((Object)"+I[3]", (List)new .colon.colon((Object)"+I[4]", (List)new .colon.colon((Object)"+I[5]", (List)new .colon.colon((Object)"+I[6]", (List)Nil$.MODULE$))))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings(sinkName)).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testLimitRemoveWithJoin() {
        DataStreamSource ds1 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStreamSource ds2 = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT a1 FROM MyTable1 INNER JOIN (SELECT a2 FROM MyTable2 LIMIT 0) ON true";
        Table result = this.tEnv().sqlQuery(sql);
        String sinkName = "MySink";
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), sinkName, result, ChangelogMode.insertOnly());
        result.executeInsert(sinkName).await();
        Assertions.assertThat((int)TestValuesTableFactory.getResults(sinkName).size()).isZero();
    }
}

