/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.runtime.stream.sql.DataStreamScalaITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r]b\u0001B%K\u0001mCQA\u0019\u0001\u0005\u0002\rD\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011B4\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0013\u0019\b\"C=\u0001\u0001\u0004\u0005\t\u0015)\u0003i\u0011%Q\b\u00011AA\u0002\u0013%1\u0010C\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\n\u0005-\u0001BCA\b\u0001\u0001\u0007\t\u0011)Q\u0005y\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003g\u0001A\u0011AA\n\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002\\\u0001!I!a\u001f\b\u000f\u0005-&\n#\u0001\u0002.\u001a1\u0011J\u0013E\u0001\u0003_CaAY\b\u0005\u0002\u0005E\u0006\"CAZ\u001f\t\u0007I\u0011BA[\u0011!\t9m\u0004Q\u0001\n\u0005]fABAl\u001f\u0001\u000bI\u000e\u0003\u0006\u0002hN\u0011\t\u001a!C\u0001\u0003SD!\"!=\u0014\u0005\u0003\u0007I\u0011AAz\u0011)\t9p\u0005B\tB\u0003&\u00111\u001e\u0005\u000b\u0003s\u001c\"\u00113A\u0005\u0002\u0005m\bB\u0003B\n'\t\u0005\r\u0011\"\u0001\u0003\u0016!Q!\u0011D\n\u0003\u0012\u0003\u0006K!!@\t\u0015\tm1C!e\u0001\n\u0003\u0011i\u0002\u0003\u0006\u0003*N\u0011\t\u0019!C\u0001\u0005WC!Ba,\u0014\u0005#\u0005\u000b\u0015\u0002B\u0010\u0011\u0019\u00117\u0003\"\u0001\u00032\"I!qJ\n\u0002\u0002\u0013\u0005!1\u0018\u0005\n\u0005/\u001a\u0012\u0013!C\u0001\u0005\u0007D\u0011Ba\u001c\u0014#\u0003%\tAa2\t\u0013\t-7#%A\u0005\u0002\t5\u0007\"\u0003B;'\u0005\u0005I\u0011\tB<\u0011%\u0011ihEA\u0001\n\u0003\tI\u000fC\u0005\u0003\u0000M\t\t\u0011\"\u0001\u0003R\"I!QQ\n\u0002\u0002\u0013\u0005#q\u0011\u0005\n\u0005+\u001b\u0012\u0011!C\u0001\u0005+D\u0011Ba'\u0014\u0003\u0003%\tE!(\t\u0013\t}5#!A\u0005B\t\u0005\u0006\"\u0003BR'\u0005\u0005I\u0011\tBm\u000f%\u0011inDA\u0001\u0012\u0003\u0011yNB\u0005\u0002X>\t\t\u0011#\u0001\u0003b\"1!m\u000bC\u0001\u0005[D\u0011Ba(,\u0003\u0003%)E!)\t\u0013\t=8&!A\u0005\u0002\nE\b\"\u0003B}W\u0005\u0005I\u0011\u0011B~\u0011%\u0019iaKA\u0001\n\u0013\u0019yA\u0002\u0004\u0003$=\u0001%Q\u0005\u0005\u000b\u0005O\t$Q3A\u0005\u0002\t%\u0002B\u0003B\u001ec\tE\t\u0015!\u0003\u0003,!Q!QH\u0019\u0003\u0016\u0004%\tAa\u0010\t\u0015\t\u001d\u0013G!E!\u0002\u0013\u0011\t\u0005\u0003\u0004cc\u0011\u0005!\u0011\n\u0005\n\u0005\u001f\n\u0014\u0011!C\u0001\u0005#B\u0011Ba\u00162#\u0003%\tA!\u0017\t\u0013\t=\u0014'%A\u0005\u0002\tE\u0004\"\u0003B;c\u0005\u0005I\u0011\tB<\u0011%\u0011i(MA\u0001\n\u0003\tI\u000fC\u0005\u0003\u0000E\n\t\u0011\"\u0001\u0003\u0002\"I!QQ\u0019\u0002\u0002\u0013\u0005#q\u0011\u0005\n\u0005+\u000b\u0014\u0011!C\u0001\u0005/C\u0011Ba'2\u0003\u0003%\tE!(\t\u0013\t}\u0015'!A\u0005B\t\u0005\u0006\"\u0003BRc\u0005\u0005I\u0011\tBS\u000f%\u00199bDA\u0001\u0012\u0003\u0019IBB\u0005\u0003$=\t\t\u0011#\u0001\u0004\u001c!1!m\u0011C\u0001\u0007GA\u0011Ba(D\u0003\u0003%)E!)\t\u0013\t=8)!A\u0005\u0002\u000e\u0015\u0002\"\u0003B}\u0007\u0006\u0005I\u0011QB\u0016\u0011%\u0019iaQA\u0001\n\u0013\u0019yAA\u000bECR\f7\u000b\u001e:fC6\u001c6-\u00197b\u0013R\u001b\u0015m]3\u000b\u0005-c\u0015aA:rY*\u0011QJT\u0001\u0007gR\u0014X-Y7\u000b\u0005=\u0003\u0016a\u0002:v]RLW.\u001a\u0006\u0003#J\u000bq\u0001\u001d7b]:,'O\u0003\u0002T)\u0006)A/\u00192mK*\u0011QKV\u0001\u0006M2Lgn\u001b\u0006\u0003/b\u000ba!\u00199bG\",'\"A-\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0006CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002IB\u0011Q\rA\u0007\u0002\u0015\u0006\u0019QM\u001c<\u0016\u0003!\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u0003[:\f1!\u00199j\u0015\tyG+A\u0005tiJ,\u0017-\\5oO&\u0011\u0011O\u001b\u0002\u001b'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0016sg/\u001b:p]6,g\u000e^\u0001\bK:4x\fJ3r)\t!x\u000f\u0005\u0002^k&\u0011aO\u0018\u0002\u0005+:LG\u000fC\u0004y\u0007\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0013'\u0001\u0003f]Z\u0004\u0013\u0001\u0003;bE2,WI\u001c<\u0016\u0003q\u00042!`A\u0003\u001b\u0005q(BA0\u0000\u0015\u0011\t\t!a\u0001\u0002\r\t\u0014\u0018\u000eZ4f\u0015\ti'+C\u0002\u0002\by\u0014ac\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e^\u0001\ri\u0006\u0014G.Z#om~#S-\u001d\u000b\u0004i\u00065\u0001b\u0002=\u0007\u0003\u0003\u0005\r\u0001`\u0001\ni\u0006\u0014G.Z#om\u0002\naAY3g_J,G#\u0001;)\u0007!\t9\u0002\u0005\u0003\u0002\u001a\u0005\u0015RBAA\u000e\u0015\ri\u0017Q\u0004\u0006\u0005\u0003?\t\t#A\u0004kkBLG/\u001a:\u000b\u0007\u0005\r\u0002,A\u0003kk:LG/\u0003\u0003\u0002(\u0005m!A\u0003\"fM>\u0014X-R1dQ\u0006!C/Z:u\rJ|W.\u00118e)>$\u0015\r^1TiJ,\u0017-\\,ji\"\u001c\u0015m]3DY\u0006\u001c8\u000fK\u0002\n\u0003[\u0001B!!\u0007\u00020%!\u0011\u0011GA\u000e\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^%na2L7-\u001b;D_:4XM]:j_:\u001c\bf\u0001\u0006\u0002.\u0005QA/Z:u'\u000eDW-\\1\u0015\u000bQ\fY$!\u0012\t\rM[\u0001\u0019AA\u001f!\u0011\ty$!\u0011\u000e\u0005\u0005\r\u0011\u0002BA\"\u0003\u0007\u0011Q\u0001V1cY\u0016Dq!a\u0012\f\u0001\u0004\tI%A\bfqB,7\r^3e\u0007>dW/\u001c8t!\u0015i\u00161JA(\u0013\r\tiE\u0018\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U#+A\u0004dCR\fGn\\4\n\t\u0005e\u00131\u000b\u0002\u0007\u0007>dW/\u001c8\u0002\u0015Q,7\u000f\u001e*fgVdG\u000fF\u0003u\u0003?\nI\u0007C\u0004\u0002b1\u0001\r!a\u0019\u0002\rI,7/\u001e7u!\u0011\ty$!\u001a\n\t\u0005\u001d\u00141\u0001\u0002\f)\u0006\u0014G.\u001a*fgVdG\u000fC\u0004\u0002l1\u0001\r!!\u001c\u0002\u0019\u0015D\b/Z2uK\u0012\u0014vn^:\u0011\u000bu\u000bY%a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eU\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI(a\u001d\u0003\u0007I{w/\u0006\u0003\u0002~\u0005ME#\u0002;\u0002\u0000\u0005\u0015\u0006bBAA\u001b\u0001\u0007\u00111Q\u0001\u000bI\u0006$\u0018m\u0015;sK\u0006l\u0007CBAC\u0003\u0017\u000by)\u0004\u0002\u0002\b*\u0019\u0011\u0011\u00127\u0002\u0015\u0011\fG/Y:ue\u0016\fW.\u0003\u0003\u0002\u000e\u0006\u001d%A\u0003#bi\u0006\u001cFO]3b[B!\u0011\u0011SAJ\u0019\u0001!q!!&\u000e\u0005\u0004\t9JA\u0001U#\u0011\tI*a(\u0011\u0007u\u000bY*C\u0002\u0002\u001ez\u0013qAT8uQ&tw\rE\u0002^\u0003CK1!a)_\u0005\r\te.\u001f\u0005\b\u0003Ok\u0001\u0019AAU\u00039)\u0007\u0010]3di\u0016$'+Z:vYR\u0004R!XA&\u0003\u001f\u000bQ\u0003R1uCN#(/Z1n'\u000e\fG.Y%U\u0007\u0006\u001cX\r\u0005\u0002f\u001fM\u0011q\u0002\u0018\u000b\u0003\u0003[\u000b\u0011aX\u000b\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0004kk:LG/\u000e\u0006\u0004\u0003\u0003$\u0016\u0001\u0002;fgRLA!!2\u0002<\n!R*\u001b8j\u00072,8\u000f^3s\u000bb$XM\\:j_:\f!a\u0018\u0011)\u0007I\tY\r\u0005\u0003\u0002N\u0006MWBAAh\u0015\u0011\t\t.a\u0007\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BAk\u0003\u001f\u0014\u0011CU3hSN$XM]#yi\u0016t7/[8o\u0005A\u0019u.\u001c9mKb\u001c\u0015m]3DY\u0006\u001c8o\u0005\u0004\u00149\u0006m\u0017\u0011\u001d\t\u0004;\u0006u\u0017bAAp=\n9\u0001K]8ek\u000e$\bcA/\u0002d&\u0019\u0011Q\u001d0\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0003\r,\"!a;\u0011\u0007u\u000bi/C\u0002\u0002pz\u00131!\u00138u\u0003\u0015\u0019w\fJ3r)\r!\u0018Q\u001f\u0005\tqV\t\t\u00111\u0001\u0002l\u0006\u00111\rI\u0001\u0002CV\u0011\u0011Q \t\u0005\u0003\u007f\u0014iA\u0004\u0003\u0003\u0002\t%\u0001c\u0001B\u0002=6\u0011!Q\u0001\u0006\u0004\u0005\u000fQ\u0016A\u0002\u001fs_>$h(C\u0002\u0003\fy\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\b\u0005#\u0011aa\u0015;sS:<'b\u0001B\u0006=\u0006)\u0011m\u0018\u0013fcR\u0019AOa\u0006\t\u0011aD\u0012\u0011!a\u0001\u0003{\f!!\u0019\u0011\u0002\u0003A,\"Aa\b\u0011\u0007\t\u0005\u0012'D\u0001\u0010\u0005IIU.\\;uC\ndWmQ1tK\u000ec\u0017m]:\u0014\rEb\u00161\\Aq\u0003\u0005!WC\u0001B\u0016!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\tA\u0001\\1oO*\u0011!QG\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003:\t=\"A\u0002#pk\ndW-\u0001\u0002eA\u0005\t!-\u0006\u0002\u0003BA\u0019QLa\u0011\n\u0007\t\u0015cLA\u0004C_>dW-\u00198\u0002\u0005\t\u0004CC\u0002B\u0010\u0005\u0017\u0012i\u0005C\u0004\u0003(Y\u0002\rAa\u000b\t\u000f\tub\u00071\u0001\u0003B\u0005!1m\u001c9z)\u0019\u0011yBa\u0015\u0003V!I!qE\u001c\u0011\u0002\u0003\u0007!1\u0006\u0005\n\u0005{9\u0004\u0013!a\u0001\u0005\u0003\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\\)\"!1\u0006B/W\t\u0011y\u0006\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B5=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5$1\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005gRCA!\u0011\u0003^\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u001f\u0011\t\t5\"1P\u0005\u0005\u0005\u001f\u0011y#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}%1\u0011\u0005\tqr\n\t\u00111\u0001\u0002l\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\nB1!1\u0012BI\u0003?k!A!$\u000b\u0007\t=e,\u0001\u0006d_2dWm\u0019;j_:LAAa%\u0003\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tE!'\t\u0011at\u0014\u0011!a\u0001\u0003?\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003W\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005s\na!Z9vC2\u001cH\u0003\u0002B!\u0005OC\u0001\u0002_!\u0002\u0002\u0003\u0007\u0011qT\u0001\u0006a~#S-\u001d\u000b\u0004i\n5\u0006\u0002\u0003=\u001c\u0003\u0003\u0005\rAa\b\u0002\u0005A\u0004C\u0003\u0003BZ\u0005k\u00139L!/\u0011\u0007\t\u00052\u0003C\u0004\u0002hv\u0001\r!a;\t\u000f\u0005eX\u00041\u0001\u0002~\"9!1D\u000fA\u0002\t}A\u0003\u0003BZ\u0005{\u0013yL!1\t\u0013\u0005\u001dh\u0004%AA\u0002\u0005-\b\"CA}=A\u0005\t\u0019AA\u007f\u0011%\u0011YB\bI\u0001\u0002\u0004\u0011y\"\u0006\u0002\u0003F*\"\u00111\u001eB/+\t\u0011IM\u000b\u0003\u0002~\nu\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001fTCAa\b\u0003^Q!\u0011q\u0014Bj\u0011!AH%!AA\u0002\u0005-H\u0003\u0002B!\u0005/D\u0001\u0002\u001f\u0014\u0002\u0002\u0003\u0007\u0011q\u0014\u000b\u0005\u0005\u0003\u0012Y\u000e\u0003\u0005yS\u0005\u0005\t\u0019AAP\u0003A\u0019u.\u001c9mKb\u001c\u0015m]3DY\u0006\u001c8\u000fE\u0002\u0003\"-\u001aRa\u000bBr\u0003C\u0004BB!:\u0003j\u0006-\u0018Q B\u0010\u0005gk!Aa:\u000b\u0005=s\u0016\u0002\u0002Bv\u0005O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011y.A\u0003baBd\u0017\u0010\u0006\u0005\u00034\nM(Q\u001fB|\u0011\u001d\t9O\fa\u0001\u0003WDq!!?/\u0001\u0004\ti\u0010C\u0004\u0003\u001c9\u0002\rAa\b\u0002\u000fUt\u0017\r\u001d9msR!!Q`B\u0005!\u0015i&q`B\u0002\u0013\r\u0019\tA\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013u\u001b)!a;\u0002~\n}\u0011bAB\u0004=\n1A+\u001e9mKNB\u0011ba\u00030\u0003\u0003\u0005\rAa-\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\t!\u0011\u0011ica\u0005\n\t\rU!q\u0006\u0002\u0007\u001f\nTWm\u0019;\u0002%%kW.\u001e;bE2,7)Y:f\u00072\f7o\u001d\t\u0004\u0005C\u00195#B\"\u0004\u001e\u0005\u0005\bC\u0003Bs\u0007?\u0011YC!\u0011\u0003 %!1\u0011\u0005Bt\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u00073!bAa\b\u0004(\r%\u0002b\u0002B\u0014\r\u0002\u0007!1\u0006\u0005\b\u0005{1\u0005\u0019\u0001B!)\u0011\u0019ic!\u000e\u0011\u000bu\u0013ypa\f\u0011\u000fu\u001b\tDa\u000b\u0003B%\u001911\u00070\u0003\rQ+\b\u000f\\33\u0011%\u0019YaRA\u0001\u0002\u0004\u0011y\u0002")
public class DataStreamScalaITCase {
    private StreamExecutionEnvironment env;
    private StreamTableEnvironment tableEnv;

    private StreamExecutionEnvironment env() {
        return this.env;
    }

    private void env_$eq(StreamExecutionEnvironment x$1) {
        this.env = x$1;
    }

    private StreamTableEnvironment tableEnv() {
        return this.tableEnv;
    }

    private void tableEnv_$eq(StreamTableEnvironment x$1) {
        this.tableEnv = x$1;
    }

    @BeforeEach
    public void before() {
        this.env_$eq(StreamExecutionEnvironment.getExecutionEnvironment());
        this.env().setParallelism(4);
        this.tableEnv_$eq(StreamTableEnvironment$.MODULE$.create(this.env()));
    }

    @Test
    public void testFromAndToDataStreamWithCaseClass() {
        ComplexCaseClass[] caseClasses = (ComplexCaseClass[])((Object[])new ComplexCaseClass[]{new ComplexCaseClass(42, "hello", new ImmutableCaseClass(Predef$.MODULE$.double2Double(42.0), true)), new ComplexCaseClass(42, null, new ImmutableCaseClass(Predef$.MODULE$.double2Double(42.0), false))});
        DataStreamSource dataStream = StreamingEnvUtil$.MODULE$.fromElements(this.env(), Predef$.MODULE$.wrapRefArray((Object[])caseClasses), new CaseClassTypeInfo<ComplexCaseClass>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<ComplexCaseClass> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<ComplexCaseClass> unused = new ScalaCaseClassSerializer<ComplexCaseClass>(this, fieldSerializers){

                    public ComplexCaseClass createInstance(Object[] fields) {
                        return new ComplexCaseClass(BoxesRunTime.unboxToInt((Object)fields[0]), (String)fields[1], (ImmutableCaseClass)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.DataStreamScalaITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table table = this.tableEnv().fromDataStream(dataStream);
        this.testSchema(table, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.INT().notNull().bridgedTo(Integer.TYPE))), Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"p", (DataType)((DataType)DataTypes.STRUCTURED(ImmutableCaseClass.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"d", (DataType)((DataType)DataTypes.DOUBLE().notNull())), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.BOOLEAN().notNull().bridgedTo(Boolean.TYPE)))}).notNull()))}));
        this.testResult(table.execute(), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)42), "hello", new ImmutableCaseClass(Predef$.MODULE$.double2Double(42.0), true)}), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)42), null, new ImmutableCaseClass(Predef$.MODULE$.double2Double(42.0), false)})}));
        DataStream resultStream = this.tableEnv().toDataStream(table, ComplexCaseClass.class);
        this.testResult((DataStream)resultStream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])caseClasses));
    }

    @Test
    public void testImplicitConversions() {
        Table table = package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromElements(this.env(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)42), (Object)"hello")}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.DataStreamScalaITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tableEnv());
        Assertions.assertEquals((Object)new .colon.colon((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)42), "hello"}), (List)Nil$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaIterator((java.util.Iterator)package$.MODULE$.tableToChangelogDataStream(table).executeAndCollect()).toList());
    }

    private void testSchema(Table table, Seq<Column> expectedColumns) {
        Assertions.assertEquals((Object)ResolvedSchema.of((Column[])((Column[])expectedColumns.toArray(ClassTag$.MODULE$.apply(Column.class)))), (Object)table.getResolvedSchema());
    }

    private void testResult(TableResult result, Seq<Row> expectedRows) {
        java.util.List actualRows = CollectionUtil.iteratorToList((java.util.Iterator)result.collect());
        MatcherAssert.assertThat((Object)actualRows, (Matcher)Matchers.containsInAnyOrder((Object[])((Object[])expectedRows.toArray(ClassTag$.MODULE$.apply(Row.class)))));
    }

    private <T> void testResult(DataStream<T> dataStream, Seq<T> expectedResult) {
        try (CloseableIterator iterator = null;){
            iterator = dataStream.executeAndCollect();
            java.util.List list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)JavaConversions$.MODULE$.asScalaIterator((java.util.Iterator)iterator).toList()).asJava();
            MatcherAssert.assertThat((Object)list, (Matcher)Matchers.containsInAnyOrder((Object[])ScalaRunTime$.MODULE$.toObjectArray(expectedResult.toArray(ClassTag$.MODULE$.Any()))));
        }
    }

    public static class ComplexCaseClass
    implements Product,
    scala.Serializable {
        private int c;
        private String a;
        private ImmutableCaseClass p;

        public int c() {
            return this.c;
        }

        public void c_$eq(int x$1) {
            this.c = x$1;
        }

        public String a() {
            return this.a;
        }

        public void a_$eq(String x$1) {
            this.a = x$1;
        }

        public ImmutableCaseClass p() {
            return this.p;
        }

        public void p_$eq(ImmutableCaseClass x$1) {
            this.p = x$1;
        }

        public ComplexCaseClass copy(int c, String a, ImmutableCaseClass p) {
            return new ComplexCaseClass(c, a, p);
        }

        public int copy$default$1() {
            return this.c();
        }

        public String copy$default$2() {
            return this.a();
        }

        public ImmutableCaseClass copy$default$3() {
            return this.p();
        }

        public String productPrefix() {
            return "ComplexCaseClass";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.c());
                }
                case 1: {
                    return this.a();
                }
                case 2: {
                    return this.p();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ComplexCaseClass;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.c());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.a()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.p()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ComplexCaseClass)) return false;
            boolean bl = true;
            if (!bl) return false;
            ComplexCaseClass complexCaseClass = (ComplexCaseClass)x$1;
            if (this.c() != complexCaseClass.c()) return false;
            String string = this.a();
            String string2 = complexCaseClass.a();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ImmutableCaseClass immutableCaseClass = this.p();
            ImmutableCaseClass immutableCaseClass2 = complexCaseClass.p();
            if (immutableCaseClass == null) {
                if (immutableCaseClass2 != null) {
                    return false;
                }
            } else if (!((Object)immutableCaseClass).equals(immutableCaseClass2)) return false;
            if (!complexCaseClass.canEqual(this)) return false;
            return true;
        }

        public ComplexCaseClass(int c, String a, ImmutableCaseClass p) {
            this.c = c;
            this.a = a;
            this.p = p;
            Product.$init$((Product)this);
        }
    }

    public static class ImmutableCaseClass
    implements Product,
    scala.Serializable {
        private final Double d;
        private final boolean b;

        public Double d() {
            return this.d;
        }

        public boolean b() {
            return this.b;
        }

        public ImmutableCaseClass copy(Double d, boolean b) {
            return new ImmutableCaseClass(d, b);
        }

        public Double copy$default$1() {
            return this.d();
        }

        public boolean copy$default$2() {
            return this.b();
        }

        public String productPrefix() {
            return "ImmutableCaseClass";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.d();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.b());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ImmutableCaseClass;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.d()));
            n = Statics.mix((int)n, (int)(this.b() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ImmutableCaseClass)) return false;
            boolean bl = true;
            if (!bl) return false;
            ImmutableCaseClass immutableCaseClass = (ImmutableCaseClass)x$1;
            if (!BoxesRunTime.equalsNumNum((Number)this.d(), (Number)immutableCaseClass.d())) return false;
            if (this.b() != immutableCaseClass.b()) return false;
            if (!immutableCaseClass.canEqual(this)) return false;
            return true;
        }

        public ImmutableCaseClass(Double d, boolean b) {
            this.d = d;
            this.b = b;
            Product.$init$((Product)this);
        }
    }
}

