/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;

class SargJsonPlanITCase
extends JsonPlanTestBase {
    SargJsonPlanITCase() {
    }

    @Test
    void testSarg() throws ExecutionException, InterruptedException {
        List<Row> data = Arrays.asList(Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2}), Row.of((Object[])new Object[]{null}), Row.of((Object[])new Object[]{4}), Row.of((Object[])new Object[]{5}));
        this.createTestValuesSourceTable("MyTable", data, "a int");
        this.createTestNonInsertOnlyValuesSinkTable("`result`", "a int");
        String sql = "insert into `result` SELECT a\nFROM MyTable WHERE a = 1 OR a = 2 OR a IS NULL";
        this.compileSqlAndExecutePlan(sql).await();
        List<String> expected = Arrays.asList("+I[1]", "+I[2]", "+I[null]");
        this.assertResult(expected, TestValuesTableFactory.getResultsAsStrings("result"));
    }
}

