/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowAggregateUseDaylightTimeHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0007\u000f\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)a\t\u0001C\u0001\u000f\")1\n\u0001C!\u0019\")a\f\u0001C\u0001\u0019\")1\r\u0001C\u0005I\")A\u000f\u0001C\u0005k\"9\u0011q\u0001\u0001\u0005\n\u0005%qaBA*\u001d!\u0005\u0011Q\u000b\u0004\u0007\u001b9A\t!a\u0016\t\r\u0019SA\u0011AA0\u0011\u001d\t\tG\u0003C\u0001\u0003G\u0012\u0011fV5oI><\u0018iZ4sK\u001e\fG/Z+tK\u0012\u000b\u0017\u0010\\5hQR$\u0016.\\3ICJtWm]:UKN$(BA\b\u0011\u0003\u001dA\u0017M\u001d8fgNT!!\u0005\n\u0002\u000fI,h\u000e^5nK*\u00111\u0003F\u0001\ba2\fgN\\3s\u0015\t)b#A\u0003uC\ndWM\u0003\u0002\u00181\u0005)a\r\\5oW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0001S\"\u0001\b\n\u0005\u0005r!a\u0004%be:,7o\u001d+fgR\u0014\u0015m]3\u0002\u000f\t\f7m[3oIB\u0011AE\u000f\b\u0003K]r!AJ\u001b\u000f\u0005\u001d\"dB\u0001\u00154\u001d\tI#G\u0004\u0002+c9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]q\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\t)b#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003mA\tQ!\u001e;jYNL!\u0001O\u001d\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\u000b\u0005Y\u0002\u0012BA\u001e=\u0005A\u0019F/\u0019;f\u0005\u0006\u001c7.\u001a8e\u001b>$WM\u0003\u00029s\u0005AA/[7f5>tW\r\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\u0011QKW.\u001a.p]\u0016\fa\u0001P5oSRtDc\u0001%J\u0015B\u0011q\u0004\u0001\u0005\u0006E\r\u0001\ra\t\u0005\u0006{\r\u0001\rAP\u0001\u0007E\u00164wN]3\u0015\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013A!\u00168ji\"\u0012A\u0001\u0016\t\u0003+rk\u0011A\u0016\u0006\u0003/b\u000b1!\u00199j\u0015\tI&,A\u0004kkBLG/\u001a:\u000b\u0005mS\u0012!\u00026v]&$\u0018BA/W\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0019i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lWmV5oI><\bFA\u0003a!\t)\u0016-\u0003\u0002c-\naA+Z:u)\u0016l\u0007\u000f\\1uK\u0006Q\u0011N\\4fgR$\u0015\r^1\u0015\u00055+\u0007\"\u00024\u0007\u0001\u00049\u0017a\u0003;fgRD\u0015M\u001d8fgN\u0004R\u0001\u001b7o]:l\u0011!\u001b\u0006\u0003\u0003*T!a\u001b\f\u0002\u0013M$(/Z1nS:<\u0017BA7j\u0005\u0019ZU-_3e\u001f:,\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peR+7\u000f\u001e%be:,7o\u001d\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cR\tA\u0001Z1uC&\u00111\u000f\u001d\u0002\b%><H)\u0019;b\u0003\t!8\u000f\u0006\u0002wsB\u0011qn^\u0005\u0003qB\u0014Q\u0002V5nKN$\u0018-\u001c9ECR\f\u0007\"\u0002>\b\u0001\u0004Y\u0018A\u00013u!\ra\u0018\u0011\u0001\b\u0003{z\u0004\"\u0001L(\n\u0005}|\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u0000\u001f\u00061!/Z2pe\u0012$B!a\u0003\u0002\u001aA)\u0011QBA\u000b]6\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0007tiJ,\u0017-\u001c:fG>\u0014HM\u0003\u0002\u0012U&!\u0011qCA\b\u00051\u0019FO]3b[J+7m\u001c:e\u0011\u001d\tY\u0002\u0003a\u0001\u0003;\tA!\u0019:hgB)a*a\b\u0002$%\u0019\u0011\u0011E(\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002O\u0003KI1!a\nP\u0005\r\te.\u001f\u0015\b\u0001\u0005-\u0012qGA\u001d!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019-\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003k\tyC\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a\u000f$\u0005\u0005u\u0002\u0003BA \u0003\u001fj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\u0005\u001d\u0013\u0011J\u0001\u000bKb$XM\\:j_:\u001c(bA.\u0002L)\u0019\u0011Q\n\f\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002BA)\u0003\u0003\u0012!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\f\u0011fV5oI><\u0018iZ4sK\u001e\fG/Z+tK\u0012\u000b\u0017\u0010\\5hQR$\u0016.\\3ICJtWm]:UKN$\bCA\u0010\u000b'\rQ\u0011\u0011\f\t\u0004\u001d\u0006m\u0013bAA/\u001f\n1\u0011I\\=SK\u001a$\"!!\u0016\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002fA)q(a\u001a\u0002l%\u0019\u0011\u0011\u000e!\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003O\u0003[\n\t(C\u0002\u0002p=\u0013Q!\u0011:sCf\u0004B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0012\u0015\u0001\u00027b]\u001eLA!a\u001f\u0002v\t1qJ\u00196fGRDs\u0001DA@\u0003\u000b\u000b9\t\u0005\u0003\u0002@\u0005\u0005\u0015\u0002BAB\u0003\u0003\u0012!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005%\u0015AH*uCR,')Y2lK:$Wh\u001f\u0019~Y\u0001\"\u0016.\\3[_:,Wh_\u0019~\u0001")
public class WindowAggregateUseDaylightTimeHarnessTest
extends HarnessTestBase {
    private final TimeZone timeZone;

    @Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateUseDaylightTimeHarnessTest$.MODULE$.parameters();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.timeZone.toZoneId());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testProcessingTimeWindow() {
        boolean bl;
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(proctime),\n        |     INTERVAL '1' HOUR,\n        |     INTERVAL '3' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        if (this.timeZone.useDaylightTime()) {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T03:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T04:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T05:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T06:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T03:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T03:00:00"), this.ts("2021-11-07T04:00:00")})));
        } else {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T06:00:00"), this.ts("2021-03-14T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T11:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T12:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T13:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T14:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T15:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T08:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T11:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T12:00:00")})));
        }
        assertor.assertOutputEquals("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1615708800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(1615712400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615716000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615719600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1615723200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1636268400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Hi", null})));
        testHarness.setProcessingTime(1636272000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), null, null})));
        testHarness.setProcessingTime(1636275600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636279200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636282800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636286400000L);
    }

    private TimestampData ts(String dt) {
        return TimestampData.fromEpochMillis((long)LocalDateTime.parse(dt).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli());
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return BoxesRunTime.boxToLong((long)l);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return BoxesRunTime.boxToDouble((double)d);
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    public WindowAggregateUseDaylightTimeHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, TimeZone timeZone) {
        this.timeZone = timeZone;
        super(backend);
    }
}

