/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.RankHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\f\u0018\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")Q\n\u0001C\u0001\u001d\")!\u000b\u0001C!'\")!\r\u0001C\u0001'\")q\r\u0001C\u0001'\")\u0011\u000e\u0001C\u0001U\"1\u0011Q\u0001\u0001\u0005\u0002MCa!!\u0003\u0001\t\u0003\u0019\u0006BBA\u0007\u0001\u0011\u00051\u000b\u0003\u0004\u0002\u0012\u0001!\ta\u0015\u0005\u0007\u0003+\u0001A\u0011A*\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!1\u0011q\n\u0001\u0005\u0002MCa!a\u0015\u0001\t\u0003\u0019\u0006BBA,\u0001\u0011\u00051\u000b\u0003\u0004\u0002\\\u0001!\taU\u0004\b\u0003\u0013;\u0002\u0012AAF\r\u00191r\u0003#\u0001\u0002\u000e\"1Qj\u0005C\u0001\u0003+Cq!a&\u0014\t\u0003\tIJA\bSC:\\\u0007*\u0019:oKN\u001cH+Z:u\u0015\tA\u0012$A\u0004iCJtWm]:\u000b\u0005iY\u0012a\u0002:v]RLW.\u001a\u0006\u00039u\tq\u0001\u001d7b]:,'O\u0003\u0002\u001f?\u0005)A/\u00192mK*\u0011\u0001%I\u0001\u0006M2Lgn\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005=A\u0015M\u001d8fgN$Vm\u001d;CCN,\u0017\u0001B7pI\u0016\u0004\"!L\"\u000f\u00059\u0002eBA\u0018?\u001d\t\u0001TH\u0004\u00022y9\u0011!g\u000f\b\u0003gir!\u0001N\u001d\u000f\u0005UBT\"\u0001\u001c\u000b\u0005]*\u0013A\u0002\u001fs_>$h(C\u0001%\u0013\t\u00113%\u0003\u0002!C%\u0011adH\u0005\u00039uI!AG\u000e\n\u0005}J\u0012!B;uS2\u001c\u0018BA!C\u0003i\u0019FO]3b[&twmV5uQN#\u0018\r^3UKN$()Y:f\u0015\ty\u0014$\u0003\u0002E\u000b\n\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0003\u0003\n\u000b\u0001#\u001a8bE2,\u0017i]=oGN#\u0018\r^3\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"2a\u0014)R!\tA\u0003\u0001C\u0003,\u0007\u0001\u0007A\u0006C\u0003G\u0007\u0001\u0007q)\u0001\u0004cK\u001a|'/\u001a\u000b\u0002)B\u0011\u0001*V\u0005\u0003-&\u0013A!\u00168ji\"\u0012A\u0001\u0017\t\u00033\u0002l\u0011A\u0017\u0006\u00037r\u000b1!\u00199j\u0015\tif,A\u0004kkBLG/\u001a:\u000b\u0005}\u001b\u0013!\u00026v]&$\u0018BA1[\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001di\u0016\u001cHOU3ue\u0006\u001cGOU1oW^KG\u000f\u001b*po:+XNY3sQ\t)A\r\u0005\u0002ZK&\u0011aM\u0017\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001 i\u0016\u001cHOU3ue\u0006\u001cGOU1oW^KG\u000f[8viJ{wOT;nE\u0016\u0014\bF\u0001\u0004e\u0003\u0011\u0002(/\u001a9be\u0016,\u0006\u000fZ1uKJ\u000bgn[,ji\"\u0014vn\u001e(v[\n,'\u000fV3ti\u0016\u0014H#A6\u0011\t!cg\u000e`\u0005\u0003[&\u0013a\u0001V;qY\u0016\u0014\u0004#B8umZ4X\"\u00019\u000b\u0005E\u0014\u0018\u0001B;uS2T!a]\u0010\u0002\u0013M$(/Z1nS:<\u0017BA;q\u0005\u0019ZU-_3e\u001f:,\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peR+7\u000f\u001e%be:,7o\u001d\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sv\tA\u0001Z1uC&\u00111\u0010\u001f\u0002\b%><H)\u0019;b!\ri\u0018\u0011A\u0007\u0002}*\u0011\u0011o \u0006\u00035uI1!a\u0001\u007f\u0005Y\u0011vn\u001e#bi\u0006D\u0015M\u001d8fgN\f5o]3si>\u0014\u0018!\f;fgR,\u0006\u000fZ1uKJ\u000bgn[,ji\"\u0014vn\u001e(v[\n,'oU8si.+\u0017\u0010\u0012:paN$v\u000eT1ti\"\u0012\u0001\u0002Z\u00017i\u0016\u001cH/\u00169eCR,'+\u00198l/&$\bNU8x\u001dVl'-\u001a:T_J$8*Z=Ee>\u00048OQ;u%\u0006t7.\u00168dQ\u0006tw-\u001a\u0015\u0003\u0013\u0011\f\u0001\u0007^3tiV\u0003H-\u0019;f%\u0006t7nV5uQJ{wOT;nE\u0016\u00148k\u001c:u\u0017\u0016LHI]8qgR{gj\u001c;MCN$\bF\u0001\u0006e\u0003Y\"Xm\u001d;Va\u0012\fG/\u001a*b].<\u0016\u000e\u001e5S_^tU/\u001c2fe\u000e\u000bg\u000eZ5eCR,7\u000fT1sO\u0016\u0014H\u000b[1o%\u0006t7.\u00128eQ\tYA-A\u001auKN$X\u000b\u001d3bi\u0016\u0014\u0016M\\6XSRD'k\\<Ok6\u0014WM]*peR\\U-\u001f#s_B\u001cx*\u001e;PMJ\u000bg\u000eZ#oI\"\u0012A\u0002Z\u0001\u0012aJ,\u0007/\u0019:f%\u0006t7\u000eV3ti\u0016\u0014HcB6\u0002\u001e\u0005E\u0012Q\u0007\u0005\b\u0003?i\u0001\u0019AA\u0011\u0003\u0015\tX/\u001a:z!\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012q\u0005\t\u0003k%K1!!\u000bJ\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011F%\t\u000f\u0005MR\u00021\u0001\u0002\"\u00051r\u000e]3sCR|'OT1nK&#WM\u001c;jM&,'\u000fC\u0004\u000285\u0001\r!!\u000f\u00025=\u0004XM]1u_J|U\u000f\u001e9vi2{w-[2bYRK\b/Z:\u0011\u000b!\u000bY$a\u0010\n\u0007\u0005u\u0012JA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u000f1|w-[2bY*\u0019\u0011\u0011J\u000f\u0002\u000bQL\b/Z:\n\t\u00055\u00131\t\u0002\f\u0019><\u0017nY1m)f\u0004X-\u0001\nuKN$\u0018\t\u001d9f]\u00124\u0015m\u001d;U_B\f\u0004F\u0001\be\u0003I!Xm\u001d;Va\u0012\fG/\u001a$bgR$v\u000e]\u0019)\u0005=!\u0017a\b;fgR\f\u0005\u000f]3oI>sG.\u001f+pa:;\u0016\u000e\u001e5S_^tU/\u001c2fe\"\u0012\u0001\u0003Z\u0001#i\u0016\u001cH/\u00119qK:$wJ\u001c7z)>\u0004hjV5uQ>,HOU8x\u001dVl'-\u001a:)\u0005E!\u0007f\u0002\u0001\u0002b\u00055\u0014q\u000e\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r.\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA6\u0003K\u0012!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\t\th\t\u0002\u0002tA!\u0011QOAC\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002~\u0005}\u0014AC3yi\u0016t7/[8og*\u0019q,!!\u000b\u0007\u0005\ru$A\u0005uKN$X\u000f^5mg&!\u0011qQA<\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003=\u0011\u0016M\\6ICJtWm]:UKN$\bC\u0001\u0015\u0014'\r\u0019\u0012q\u0012\t\u0004\u0011\u0006E\u0015bAAJ\u0013\n1\u0011I\\=SK\u001a$\"!a#\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u001cB1\u0011QTAS\u0003Sk!!a(\u000b\u0007E\f\tK\u0003\u0002\u0002$\u0006!!.\u0019<b\u0013\u0011\t9+a(\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003I\u0003w\tY\u000b\u0005\u0003\u0002.\u0006MVBAAX\u0015\u0011\t\t,!)\u0002\t1\fgnZ\u0005\u0005\u0003k\u000byK\u0001\u0004PE*,7\r\u001e\u0015\b+\u0005e\u0016qXAa!\u0011\t)(a/\n\t\u0005u\u0016q\u000f\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a1\u0002QM#\u0018\r^3CC\u000e\\WM\u001c3>wBjH\u0006I#oC\ndW-Q:z]\u000e\u001cF/\u0019;fAu\u000230M?")
public class RankHarnessTest
extends HarnessTestBase {
    private final boolean enableAsyncState;

    @Parameters(name="StateBackend={0}, EnableAsyncState = {1}")
    public static Collection<Object[]> parameters() {
        return RankHarnessTest$.MODULE$.parameters();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_STATE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.enableAsyncState));
    }

    @TestTemplate
    public void testRetractRankWithRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id, rn1\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 <= 2\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isFalse();
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRetractRankWithoutRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 = 1\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType()}));
        Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isFalse();
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    public Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> prepareUpdateRankWithRowNumberTester() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "type"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT word, cnt, rank_num\n        |FROM (\n        |  SELECT word, cnt,\n        |      ROW_NUMBER() OVER (PARTITION BY type ORDER BY cnt DESC) as rank_num\n        |  FROM (\n        |     select word, type, sum(cnt) filter (where cnt > 0) cnt from T group by word, type\n        |   )\n        |  )\n        |WHERE rank_num <= 6\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[UpdateFastStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isFalse();
        return new Tuple2(testHarness, (Object)assertor);
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsToLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsButRankUnchange() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88), Predef$.MODULE$.long2Long(3L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsToNotLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberCandidatesLargerThanRankEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateRankWithRowNumberSortKeyDropsOutOfRandEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    public Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> prepareRankTester(String query, String operatorNameIdentifier, LogicalType[] operatorOutputLogicalTypes) {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TEMPORARY TABLE T(\n         |  a STRING PRIMARY KEY NOT ENFORCED,\n         |  b BIGINT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'changelog-mode' = 'I'\n         |)\n         |")).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        Table t1 = this.tEnv().sqlQuery(query);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), operatorNameIdentifier);
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(operatorOutputLogicalTypes);
        return new Tuple2(testHarness, (Object)assertor);
    }

    @TestTemplate
    public void testAppendFastTop1() {
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM\n        |(\n        |    SELECT a, b,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC) AS rn\n        |    FROM T\n        |) t1\n        |WHERE rn <= 1\n      ")).stripMargin();
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareRankTester(query, "Rank(strategy=[AppendFastStrategy", (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        AbstractBooleanAssert abstractBooleanAssert = this.enableAsyncState ? Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isTrue() : Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isFalse();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testUpdateFastTop1() {
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM\n        |(\n        |    SELECT a, b,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC) AS rn\n        |    FROM (\n        |       select a, count(*) as b from T group by a\n        |    ) t1\n        |) t2\n        |WHERE rn <= 1\n      ")).stripMargin();
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareRankTester(query, "Rank(strategy=[UpdateFastStrategy", (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        AbstractBooleanAssert abstractBooleanAssert = this.enableAsyncState ? Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isTrue() : Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isFalse();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(4L)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(4L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testAppendOnlyTopNWithRowNumber() {
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, rn\n        |FROM\n        |(\n        |    SELECT a, b,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC) AS rn\n        |    FROM T\n        |) t1\n        |WHERE rn <= 3\n      ")).stripMargin();
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareRankTester(query, "Rank(strategy=[AppendFastStrategy", (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        AbstractBooleanAssert abstractBooleanAssert = this.enableAsyncState ? Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isTrue() : Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isFalse();
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(0L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @TestTemplate
    public void testAppendOnlyTopNWithoutRowNumber() {
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM\n        |(\n        |    SELECT a, b,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC) AS rn\n        |    FROM T\n        |) t1\n        |WHERE rn <= 3\n      ")).stripMargin();
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareRankTester(query, "Rank(strategy=[AppendFastStrategy", (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple22._2();
        AbstractBooleanAssert abstractBooleanAssert = this.enableAsyncState ? Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isTrue() : Assertions.assertThat((boolean)this.isAsyncStateOperator((KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>)testHarness2)).isFalse();
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(2L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(0L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.long2Long(3L)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    public RankHarnessTest(StreamingWithStateTestBase.StateBackendMode mode, boolean enableAsyncState) {
        this.enableAsyncState = enableAsyncState;
        super(mode);
    }
}

