/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0007\u000f\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006)\u0002!\tA\u0011\u0005\u00063\u0002!IA\u0017\u0005\u0006o\u0002!\tA\u0011\u0005\u0006s\u0002!\tA\u0011\u0005\u0006w\u0002!\tA\u0011\u0005\u0006{\u0002!\tA\u0011\u0005\u0006\u007f\u0002!\tA\u0011\u0005\u0007\u0003\u0007\u0001A\u0011\u0001\"\t\r\u0005\u001d\u0001\u0001\"\u0001C\u0005aye/\u001a:BO\u001e\u0014XmZ1uK\"\u000b'O\\3tgR+7\u000f\u001e\u0006\u0003\u001fA\tq\u0001[1s]\u0016\u001c8O\u0003\u0002\u0012%\u00059!/\u001e8uS6,'BA\n\u0015\u0003\u001d\u0001H.\u00198oKJT!!\u0006\f\u0002\u000bQ\f'\r\\3\u000b\u0005]A\u0012!\u00024mS:\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002\u001d%\u0011\u0011E\u0004\u0002\u0010\u0011\u0006\u0014h.Z:t)\u0016\u001cHOQ1tK\u0006!Qn\u001c3f!\t!#H\u0004\u0002&o9\u0011a%\u000e\b\u0003OQr!\u0001K\u001a\u000f\u0005%\u0012dB\u0001\u00162\u001d\tY\u0003G\u0004\u0002-_5\tQF\u0003\u0002/9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA\n\u0015\u0013\t\t\"#\u0003\u00027!\u0005)Q\u000f^5mg&\u0011\u0001(O\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0006\u0003mAI!a\u000f\u001f\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'B\u0001\u001d:\u0003\u0019a\u0014N\\5u}Q\u0011q\b\u0011\t\u0003?\u0001AQA\t\u0002A\u0002\r\naAY3g_J,G#A\"\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007)\u0003\"a\u0013*\u000e\u00031S!!\u0014(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002P!\u00069!.\u001e9ji\u0016\u0014(BA)\u001b\u0003\u0015QWO\\5u\u0013\t\u0019FJ\u0001\u0006CK\u001a|'/Z#bG\"\f1\u0004^3tiB\u0013xn\u0019+j[\u0016\u0014u.\u001e8eK\u0012\u0014vn^:Pm\u0016\u0014\bF\u0001\u0003W!\tYu+\u0003\u0002Y\u0019\naA+Z:u)\u0016l\u0007\u000f\\1uK\u0006i2M]3bi\u0016\u0004&o\\2US6,'i\\;oI\u0016$'k\\<t\u001fZ,'\u000fF\u0001\\!\u0011!EL\u00187\n\u0005u+%A\u0002+va2,'\u0007E\u0003`I\u001a4g-D\u0001a\u0015\t\t'-\u0001\u0003vi&d'BA2\u0017\u0003%\u0019HO]3b[&tw-\u0003\u0002fA\n13*Z=fI>sW-\u00138qkR\u001cFO]3b[>\u0003XM]1u_J$Vm\u001d;ICJtWm]:\u0011\u0005\u001dTW\"\u00015\u000b\u0005%$\u0012\u0001\u00023bi\u0006L!a\u001b5\u0003\u000fI{w\u000fR1uCB\u0019A)\\8\n\u00059,%!B!se\u0006L\bC\u00019v\u001b\u0005\t(B\u0001:t\u0003\u001dawnZ5dC2T!\u0001\u001e\u000b\u0002\u000bQL\b/Z:\n\u0005Y\f(a\u0003'pO&\u001c\u0017\r\u001c+za\u0016\fA\u0004^3tiB\u0013xn\u0019+j[\u0016\u0014u.\u001e8eK\u0012\u0014\u0016M\\4f\u001fZ,'\u000f\u000b\u0002\u0007-\u0006IB/Z:u!J|7\rV5nKVs'm\\;oI\u0016$wJ^3sQ\t9a+A\u000euKN$(k\\<US6,'i\\;oI\u0016$'+\u00198hK>3XM\u001d\u0015\u0003\u0011Y\u000b!\u0004^3tiJ{w\u000fV5nK\n{WO\u001c3fIJ{wo](wKJD#!\u0003,\u0002;Q,7\u000f\u001e*poRKW.Z+oE>,h\u000eZ3e%\u0006tw-Z(wKJD#A\u0003,\u00029Q,7\u000f\u001e*poRKW.Z+oE>,h\u000eZ3e%><8o\u0014<fe\"\u00121BV\u0001\u0015i\u0016\u001cHo\u00117pg\u0016<\u0016\u000e\u001e5pkR|\u0005/\u001a8)\u000511\u0006f\u0002\u0001\u0002\u000e\u0005e\u00111\u0004\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003'\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA\f\u0003#\u0011!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\tib\t\u0002\u0002 A!\u0011\u0011EA\u0019\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002*\u0005-\u0012AC3yi\u0016t7/[8og*\u0019\u0011+!\f\u000b\u0007\u0005=b#A\u0005uKN$X\u000f^5mg&!\u00111GA\u0012\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0001")
public class OverAggregateHarnessTest
extends HarnessTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
    }

    @TestTemplate
    public void testProcTimeBoundedRowsOver() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcTimeBoundedRowsOver();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputType2 = (LogicalType[])tuple22._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputType2);
        testHarness2.open();
        testHarness2.setProcessingTime(1L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness2.setProcessingTime(1100L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness2.setProcessingTime(3001L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness2.setProcessingTime(6002L);
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness2.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createProcTimeBoundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN 1 PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN 1 PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        LogicalType[] outputType = (LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        return new Tuple2(testHarness, (Object)outputType);
    }

    @TestTemplate
    public void testProcTimeBoundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(3L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.setProcessingTime(4L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness.setProcessingTime(3003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness.setProcessingTime(5L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness.setProcessingTime(6002L);
        testHarness.setProcessingTime(7002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness.setProcessingTime(11002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness.setProcessingTime(11004L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        testHarness.setProcessingTime(11006L);
        ConcurrentLinkedQueue result = testHarness.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness.close();
    }

    @TestTemplate
    public void testProcTimeUnboundedOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT currtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null})));
        testHarness.setStateTtlProcessingTime(5003L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null})));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(1L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(2L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(3L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(20L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(4L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(5L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(6L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(30L), null, Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(7L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(8L), null, Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(9L), null, Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "aaa", Predef$.MODULE$.long2Long(10L), null, Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(0L), "bbb", Predef$.MODULE$.long2Long(40L), null, Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeBoundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN INTERVAL '4' SECOND PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.processWatermark(1L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(3L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processWatermark(4001L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4002L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processWatermark(4002L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4003L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "bbb", Predef$.MODULE$.long2Long(25L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(3L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4002L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4003L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "bbb", Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(25L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(25L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(40L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeBoundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN 2 PRECEDING AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(4499L);
        testHarness.setProcessingTime(4500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20011L), "ccc", Predef$.MODULE$.long2Long(3L)})));
        testHarness.setProcessingTime(6500L);
        testHarness.processWatermark(20020L);
        testHarness.setProcessingTime(8499L);
        testHarness.setProcessingTime(8500L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20011L), "ccc", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(3L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeUnboundedRangeOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$11 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   RANGE BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(2999L);
        testHarness.setProcessingTime(3000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20000L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.setProcessingTime(5000L);
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(6999L);
        testHarness.setProcessingTime(7000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testRowTimeUnboundedRowsOver() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.harness.OverAggregateHarnessTest$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, b, c,\n        | min(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW),\n        | max(c) OVER\n        |   (PARTITION BY b ORDER BY rowtime\n        |   ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW)\n        |FROM T\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toDataStream(), "OverAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setProcessingTime(1000L);
        testHarness.processWatermark(800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L)})));
        testHarness.processWatermark(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processWatermark(4000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L)})));
        testHarness.processWatermark(4800L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L)})));
        testHarness.processWatermark(6500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L)})));
        testHarness.processWatermark(7000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L)})));
        testHarness.processWatermark(8000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L)})));
        testHarness.processWatermark(12000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L)})));
        testHarness.processWatermark(19000L);
        testHarness.setProcessingTime(2999L);
        testHarness.setProcessingTime(3000L);
        testHarness.processWatermark(20000L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20000L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L)})));
        testHarness.setProcessingTime(2500L);
        testHarness.processElement(new StreamRecord((Object)StreamRecordUtils.binaryrow((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L)})));
        testHarness.setProcessingTime(5000L);
        testHarness.processWatermark(20010L);
        testHarness.setProcessingTime(6999L);
        testHarness.setProcessingTime(7000L);
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(801L), "aaa", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(2501L), "bbb", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "aaa", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4001L), "bbb", Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(20L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(4801L), "aaa", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(5L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "aaa", Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(6L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(6501L), "bbb", Predef$.MODULE$.long2Long(30L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(30L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(7001L), "aaa", Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(7L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(8001L), "aaa", Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(8L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(9L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "aaa", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(10L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(12001L), "bbb", Predef$.MODULE$.long2Long(40L), Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(40L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20001L), "ccc", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)})));
        expectedOutput.add(new StreamRecord((Object)StreamRecordUtils.row((Object[])new Object[]{Predef$.MODULE$.long2Long(20002L), "ccc", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)})));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @TestTemplate
    public void testCloseWithoutOpen() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createProcTimeBoundedRowsOver();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputType2 = (LogicalType[])tuple22._2();
        testHarness2.setup((TypeSerializer)new RowDataSerializer(outputType2));
        testHarness2.open();
    }

    public OverAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

