/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.time.Duration;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase$;
import org.apache.flink.table.runtime.operators.join.temporal.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.hamcrest.Description;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u0013&\u0001QBQ!\u000f\u0001\u0005\u0002iB\u0011\u0002\u0010\u0001A\u0002\u0003\u0007I\u0011B\u001f\t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0005\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003?\u0011%a\u0006\u00011AA\u0002\u0013%Q\bC\u0005^\u0001\u0001\u0007\t\u0019!C\u0005=\"I\u0001\r\u0001a\u0001\u0002\u0003\u0006KA\u0010\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019a\u0007\u0001)A\u0005I\"9Q\u000e\u0001b\u0001\n\u0013\u0019\u0007B\u00028\u0001A\u0003%A\rC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"Y\u00111\u000e\u0001A\u0002\u0003\u0007I\u0011BA7\u0011)\t\t\b\u0001a\u0001\u0002\u0003\u0006K!\u001d\u0005\f\u0003g\u0002\u0001\u0019!a\u0001\n\u0013\t)\bC\u0006\u0002\u0004\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0005bCAE\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oBq!a#\u0001\t\u0003\ti\tC\u0004\u0002$\u0002!\t!!$\t\u000f\u00055\u0006\u0001\"\u0001\u0002\u000e\"9\u0011q\u0017\u0001\u0005\u0002\u00055\u0005bBA^\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003\u007f\u0003A\u0011AAG\u0011\u001d\tY\t\u0001C\u0005\u0003\u0007Dq!!3\u0001\t\u0013\tYM\u0002\u0003t\u0001\u0001!\b\u0002\u00032\u001b\u0005\u0003\u0005\u000b\u0011\u00023\t\u00115T\"\u0011!Q\u0001\n\u0011Da!\u000f\u000e\u0005\u0002\u0005\u0005\u0001\"CA\u00045\t\u0007I\u0011AA\u0005\u0011!\t9C\u0007Q\u0001\n\u0005-\u0001bBA\u00155\u0011\u0005\u00131\u0006\u0005\b\u0003gQB\u0011IA\u001b\u0011\u001d\tYD\u0007C!\u0003{Aq!!\u0011\u001b\t\u0003\n\u0019EA\u0015BEN$(/Y2u)^|\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;pe^KG\u000f\u001b+U\u0019R+7\u000f\u001e\u0006\u0003M\u001d\nq\u0001[1s]\u0016\u001c8O\u0003\u0002)S\u00059!/\u001e8uS6,'B\u0001\u0016,\u0003\u001d\u0001H.\u00198oKJT!\u0001L\u0017\u0002\u000bQ\f'\r\\3\u000b\u00059z\u0013!\u00024mS:\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001kA\u0011agN\u0007\u0002K%\u0011\u0001(\n\u0002\u0010\u0011\u0006\u0014h.Z:t)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003m\u0001\t!C]3d_J$\u0017IR8s\r&\u00148\u000f^&fsV\ta\bE\u0002@\u000b\u001ek\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bAb\u001d;sK\u0006l'/Z2pe\u0012T!\u0001K\"\u000b\u0005\u0011k\u0013!C:ue\u0016\fW.\u001b8h\u0013\t1\u0005I\u0001\u0007TiJ,\u0017-\u001c*fG>\u0014H\r\u0005\u0002I\u00176\t\u0011J\u0003\u0002KW\u0005!A-\u0019;b\u0013\ta\u0015JA\u0004S_^$\u0015\r^1\u0002-I,7m\u001c:e\u0003\u001a{'OR5sgR\\U-_0%KF$\"aT+\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\tUs\u0017\u000e\u001e\u0005\b-\u000e\t\t\u00111\u0001?\u0003\rAH%M\u0001\u0014e\u0016\u001cwN\u001d3B\r>\u0014h)\u001b:ti.+\u0017\u0010\t\u0015\u0003\te\u0003\"\u0001\u0015.\n\u0005m\u000b&!\u0003;sC:\u001c\u0018.\u001a8u\u0003I\u0011XmY8sI\n3uN\u001d$jeN$8*Z=\u0002-I,7m\u001c:e\u0005\u001a{'OR5sgR\\U-_0%KF$\"aT0\t\u000fY3\u0011\u0011!a\u0001}\u0005\u0019\"/Z2pe\u0012\u0014ei\u001c:GSJ\u001cHoS3zA!\u0012q!W\u0001\u0011[&t'+\u001a;f]RLwN\u001c+j[\u0016,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001^5nK*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005!!UO]1uS>t\u0017!E7j]J+G/\u001a8uS>tG+[7fA\u0005\u0001R.\u0019=SKR,g\u000e^5p]RKW.Z\u0001\u0012[\u0006D(+\u001a;f]RLwN\u001c+j[\u0016\u0004\u0013!E8qKJ\fGo\u001c:V]\u0012,'\u000fV3tiV\t\u0011\u000f\u0005\u0002s55\t\u0001A\u0001\rTiV\u0014w\n]3sCR|'oV5uQN#\u0018\r^3U)2\u001b\"AG;\u0011\u0005YtX\"A<\u000b\u0005aL\u0018\u0001\u0003;f[B|'/\u00197\u000b\u0005i\\\u0018\u0001\u00026pS:T!\u0001`?\u0002\u0013=\u0004XM]1u_J\u001c(B\u0001\u0015,\u0013\tyxO\u0001\u0017CCN,Gk^8J]B,Ho\u0015;sK\u0006lw\n]3sCR|'oV5uQN#\u0018\r^3SKR,g\u000e^5p]R)\u0011/a\u0001\u0002\u0006!)!-\ba\u0001I\")Q.\ba\u0001I\u0006\u0011b-\u001b:fI\u000ecW-\u00198VaRKW.\u001a:t+\t\tY\u0001\u0005\u0004\u0002\u000e\u0005]\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u00059Q.\u001e;bE2,'bAA\u000b#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\ti\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0012q\u0004\u0002\u0005\u0019>tw-A\ngSJ,Gm\u00117fC:,\u0006\u000fV5nKJ\u001c\b%\u0001\u0007dY\u0016\fg.\u001e9Ti\u0006$X\rF\u0002P\u0003[Aaa\u001a\u0011A\u0002\u0005=\u0002c\u0001)\u00022%\u0019\u0011QE)\u0002\u001fA\u0014xnY3tg\u0016cW-\\3oiF\"2aTA\u001c\u0011\u0019\tI$\ta\u0001}\u00059Q\r\\3nK:$\u0018a\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u001a\u0015\u0007=\u000by\u0004\u0003\u0004\u0002:\t\u0002\rAP\u0001\f_:,e/\u001a8u)&lW\rF\u0002P\u0003\u000bBq!a\u0012$\u0001\u0004\tI%A\u0003uS6,'\u000f\u0005\u0005\u0002L\u0005M\u0013qKA/\u001b\t\tiEC\u0002}\u0003\u001fR1!!\u0015D\u0003\r\t\u0007/[\u0005\u0005\u0003+\niEA\u0007J]R,'O\\1m)&lWM\u001d\t\u0005\u0003;\tI&\u0003\u0003\u0002\\\u0005}!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002`\u0005\u001dTBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u000bM$\u0018\r^3\u000b\u0005!j\u0013\u0002BA5\u0003C\u0012QBV8jI:\u000bW.Z:qC\u000e,\u0017!F8qKJ\fGo\u001c:V]\u0012,'\u000fV3ti~#S-\u001d\u000b\u0004\u001f\u0006=\u0004b\u0002,\u000e\u0003\u0003\u0005\r!]\u0001\u0013_B,'/\u0019;peVsG-\u001a:UKN$\b%A\u0006uKN$\b*\u0019:oKN\u001cXCAA<!%\tI(a \u0002\u001c\u001d;u)\u0004\u0002\u0002|)\u0019\u0011QP\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0014LKf,G\rV<p\u0013:\u0004X\u000f^*ue\u0016\fWn\u00149fe\u0006$xN\u001d+fgRD\u0015M\u001d8fgN\fq\u0002^3ti\"\u000b'O\\3tg~#S-\u001d\u000b\u0004\u001f\u0006\u001d\u0005\u0002\u0003,\u0011\u0003\u0003\u0005\r!a\u001e\u0002\u0019Q,7\u000f\u001e%be:,7o\u001d\u0011\u0002#\r\u0014X-\u0019;f)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fF\u0001PQ\r\u0011\u0012\u0011\u0013\t\u0005\u0003'\u000by*\u0004\u0002\u0002\u0016*!\u0011\u0011KAL\u0015\u0011\tI*a'\u0002\u000f),\b/\u001b;fe*\u0019\u0011QT\u0019\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u0016Q\u0013\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E2m_N,G+Z:u\u0011\u0006\u0014h.Z:tQ\r\u0019\u0012q\u0015\t\u0005\u0003'\u000bI+\u0003\u0003\u0002,\u0006U%!C!gi\u0016\u0014X)Y2i\u0003MqwN]7bYN\u001bWM\\1sS><vN]6tQ\r!\u0012\u0011\u0017\t\u0005\u0003'\u000b\u0019,\u0003\u0003\u00026\u0006U%\u0001\u0004+fgR$V-\u001c9mCR,\u0017\u0001U<iK:\u001cUO\u001d:f]R$\u0016.\\3QYV\u001cX*\u001b8SKR,g\u000e^5p]Nk\u0017\r\u001c7feRC\u0017M\\\"veJ,g\u000e^\"mK\u0006tW\u000f\u001d+j[\u0016tuNT3x)&lWM\u001d*fO&\u001cH/\u001a:fI\"\u001aQ#!-\u0002\u0013^DWM\\\"veJ,g\u000e\u001e+j[\u0016\u0004F.^:NS:\u0014V\r^3oi&|g\u000eT1sO\u0016\u0014H\u000b[1o\u0007V\u0014(/\u001a8u\u00072,\u0017M\\;q)&lW\rV5nKJL5/\u00169eCR,G\rK\u0002\u0017\u0003c\u000baf\u001c;iKJ\u001c\u0016\u000eZ3U_N\u000bW.Z&fsN#\u0018\r^3BYN|W\u000b\u001d3bi\u0016\u001c8\t\\3b]V\u0004H+[7fe\"\u001aq#!-\u0015\t\u0005]\u0014Q\u0019\u0005\u0007\u0003\u000fD\u0002\u0019A;\u0002\u0011=\u0004XM]1u_J\f!\u0005[1t\r&\u0014X\rZ\"mK\u0006tW\u000b\u001d+j[\u0016\u00148OR8s)&lWm\u001d;b[B\u001cH\u0003BAg\u00033\u0004R!a4\u0002VFl!!!5\u000b\u0007\u0005M\u0017'\u0001\u0005iC6\u001c'/Z:u\u0013\u0011\t9.!5\u0003\u001fQK\b/Z*bM\u0016l\u0015\r^2iKJDq!a7\u001a\u0001\u0004\ti.\u0001\u0004uS6,'o\u001d\t\u0006!\u0006}\u00171D\u0005\u0004\u0003C\f&A\u0003\u001fsKB,\u0017\r^3e}!:\u0001!!:\u0002r\u0006M\b\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u0018QS\u0001\nKb$XM\\:j_:LA!a<\u0002j\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005U8EAA|!\u0011\tIP!\u0003\u000e\u0005\u0005m(\u0002BA\u007f\u0003\u007f\fQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002\u0002B\u0001\u0005\u0007\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\u0011\tiJ!\u0002\u000b\u0007\t\u001dQ&A\u0005uKN$X\u000f^5mg&!!1BA~\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0001")
public class AbstractTwoInputStreamOperatorWithTTLTest
extends HarnessTestBase {
    private transient StreamRecord<RowData> recordAForFirstKey;
    private transient StreamRecord<RowData> recordBForFirstKey;
    private final Duration minRetentionTime = Duration.ofMillis(2L);
    private final Duration maxRetentionTime = Duration.ofMillis(4L);
    private StubOperatorWithStateTTL operatorUnderTest;
    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> testHarness;

    private StreamRecord<RowData> recordAForFirstKey() {
        return this.recordAForFirstKey;
    }

    private void recordAForFirstKey_$eq(StreamRecord<RowData> x$1) {
        this.recordAForFirstKey = x$1;
    }

    private StreamRecord<RowData> recordBForFirstKey() {
        return this.recordBForFirstKey;
    }

    private void recordBForFirstKey_$eq(StreamRecord<RowData> x$1) {
        this.recordBForFirstKey = x$1;
    }

    private Duration minRetentionTime() {
        return this.minRetentionTime;
    }

    private Duration maxRetentionTime() {
        return this.maxRetentionTime;
    }

    private StubOperatorWithStateTTL operatorUnderTest() {
        return this.operatorUnderTest;
    }

    private void operatorUnderTest_$eq(StubOperatorWithStateTTL x$1) {
        this.operatorUnderTest = x$1;
    }

    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> testHarness() {
        return this.testHarness;
    }

    private void testHarness_$eq(KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> x$1) {
        this.testHarness = x$1;
    }

    @BeforeEach
    public void createTestHarness() {
        this.operatorUnderTest_$eq(new StubOperatorWithStateTTL(this.minRetentionTime(), this.maxRetentionTime()));
        this.testHarness_$eq(this.createTestHarness(this.operatorUnderTest()));
        this.testHarness().open();
        this.recordAForFirstKey_$eq((StreamRecord<RowData>)StreamRecordUtils.insertRecord((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "hello"}));
        this.recordBForFirstKey_$eq((StreamRecord<RowData>)StreamRecordUtils.insertRecord((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "world"}));
    }

    @AfterEach
    public void closeTestHarness() {
        this.testHarness().close();
    }

    @TestTemplate
    public void normalScenarioWorks() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(10L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(5L)})));
    }

    @TestTemplate
    public void whenCurrentTimePlusMinRetentionSmallerThanCurrentCleanupTimeNoNewTimerRegistered() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(2L);
        this.testHarness().processElement1(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(5L)})));
    }

    @TestTemplate
    public void whenCurrentTimePlusMinRetentionLargerThanCurrentCleanupTimeTimerIsUpdated() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(4L);
        this.testHarness().processElement1(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(8L)})));
    }

    @TestTemplate
    public void otherSideToSameKeyStateAlsoUpdatesCleanupTimer() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(4L);
        this.testHarness().processElement2(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(8L)})));
    }

    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> createTestHarness(BaseTwoInputStreamOperatorWithStateRetention operator) {
        return new KeyedTwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator, (KeySelector)new HarnessTestBase.TestingRowDataKeySelector(0), (KeySelector)new HarnessTestBase.TestingRowDataKeySelector(0), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, 1, 1, 0);
    }

    private TypeSafeMatcher<StubOperatorWithStateTTL> hasFiredCleanUpTimersForTimestamps(Seq<Long> timers) {
        return new TypeSafeMatcher<StubOperatorWithStateTTL>(null, timers){
            private final Seq timers$1;

            public boolean matchesSafely(StubOperatorWithStateTTL operator) {
                IndexedSeq indexedSeq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operator.firedCleanUpTimers().toArray(ClassTag$.MODULE$.apply(Long.class)))).deep();
                IndexedSeq indexedSeq2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.timers$1.toArray(ClassTag$.MODULE$.apply(Long.class)))).deep();
                return !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
            }

            public void describeTo(Description description) {
                description.appendText("a list of timers with timestamps=").appendValue((Object)this.timers$1.mkString(","));
            }
            {
                this.timers$1 = timers$1;
            }
        };
    }

    public AbstractTwoInputStreamOperatorWithTTLTest() {
        super(StreamingWithStateTestBase$.MODULE$.HEAP_BACKEND());
    }

    public class StubOperatorWithStateTTL
    extends BaseTwoInputStreamOperatorWithStateRetention {
        private final Buffer<Long> firedCleanUpTimers;

        public Buffer<Long> firedCleanUpTimers() {
            return this.firedCleanUpTimers;
        }

        public void cleanupState(long time) {
            this.firedCleanUpTimers().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(time)}));
        }

        public void processElement1(StreamRecord<RowData> element) {
            this.registerProcessingCleanupTimer();
        }

        public void processElement2(StreamRecord<RowData> element) {
            this.registerProcessingCleanupTimer();
        }

        public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        }

        public /* synthetic */ AbstractTwoInputStreamOperatorWithTTLTest org$apache$flink$table$planner$runtime$harness$AbstractTwoInputStreamOperatorWithTTLTest$StubOperatorWithStateTTL$$$outer() {
            return AbstractTwoInputStreamOperatorWithTTLTest.this;
        }

        public StubOperatorWithStateTTL(Duration minRetentionTime, Duration maxRetentionTime) {
            if (AbstractTwoInputStreamOperatorWithTTLTest.this == null) {
                throw null;
            }
            super(minRetentionTime.toMillis(), maxRetentionTime.toMillis());
            this.firedCleanUpTimers = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
    }
}

