/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I4AAE\n\u0001G!)!\u0006\u0001C\u0001W!9a\u0006\u0001b\u0001\n\u0013y\u0003BB\u001f\u0001A\u0003%\u0001\u0007C\u0003L\u0001\u0011\u0005A\nC\u0003Y\u0001\u0011\u0005A\nC\u0003[\u0001\u0011\u0005A\nC\u0003]\u0001\u0011\u0005A\nC\u0003_\u0001\u0011\u0005A\nC\u0003a\u0001\u0011\u0005A\nC\u0003c\u0001\u0011\u0005A\nC\u0003e\u0001\u0011\u0005A\nC\u0003g\u0001\u0011\u0005A\nC\u0003i\u0001\u0011\u0005A\nC\u0003k\u0001\u0011\u0005A\nC\u0003m\u0001\u0011\u0005A\nC\u0003o\u0001\u0011\u0005A\nC\u0003q\u0001\u0011\u0005AJA\bUC\ndWmU5oW&#6)Y:f\u0015\t!R#A\u0003uC\ndWM\u0003\u0002\u0017/\u0005)!-\u0019;dQ*\u0011\u0001$G\u0001\beVtG/[7f\u0015\tQ2$A\u0004qY\u0006tg.\u001a:\u000b\u0005Qa\"BA\u000f\u001f\u0003\u00151G.\u001b8l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003O]\tQ!\u001e;jYNL!!\u000b\u0014\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\t1#A\u0001`+\u0005\u0001\u0004cA\u00197q5\t!G\u0003\u00024i\u0005IA/Z:ukRLGn\u001d\u0006\u0003kq\tAaY8sK&\u0011qG\r\u0002\u0014\u000b\u0006\u001c\u0007nQ1mY\n\f7m[,sCB\u0004XM\u001d\t\u0003smj\u0011A\u000f\u0006\u0003OmI!\u0001\u0010\u001e\u0003%1+w-Y2z%><X\t\u001f;f]NLwN\\\u0001\u0003?\u0002B#aA \u0011\u0005\u0001KU\"A!\u000b\u0005\t\u001b\u0015!C3yi\u0016t7/[8o\u0015\t!U)A\u0002ba&T!AR$\u0002\u000f),\b/\u001b;fe*\u0011\u0001\nI\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0015\u0006\u0013\u0011CU3hSN$XM]#yi\u0016t7/[8o\u0003\t\"Xm\u001d;EK\u000eLW.\u00197P]>+H\u000f];u\r>\u0014X.\u0019;UC\ndWmU5oWR\tQ\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0003V]&$\bF\u0001\u0003U!\t)f+D\u0001D\u0013\t96I\u0001\u0003UKN$\u0018A\t;fgR$UmY5nC2|enU5oW\u001a+hn\u0019;j_:$\u0016M\u00197f'&t7\u000e\u000b\u0002\u0006)\u0006yA/Z:u'&t7nV5uQ.+\u0017\u0010\u000b\u0002\u0007)\u0006\u0011B/Z:u'&t7nV5uQ>,HoS3zQ\t9A+\u0001\u0014uKN$8+\u001b8l/&$\b\u000eU1si&$\u0018n\u001c8B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#\u0001\u0003+\u0002#Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014H\u000f\u000b\u0002\n)\u0006yC/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD\u0007+\u0019:uSRLwN\\!oI\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012!\u0002V\u0001-i\u0016\u001cHOR;mY&s7/\u001a:u/&$\b\u000eU1si&$\u0018n\u001c8B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#a\u0003+\u0002oQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ\u0012Kh.Y7jGB\u000b'\u000f^5uS>t\u0017I\u001c3D_6\u0004X\u000f^3e\u0007>dW/\u001c82Q\taA+A\u001cuKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5Es:\fW.[2QCJ$\u0018\u000e^5p]\u0006sGmQ8naV$X\rZ\"pYVlgN\r\u0015\u0003\u001bQ\u000bA\u0004^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\bNU3pe\u0012,'\u000f\u000b\u0002\u000f)\u0006yC/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRDG)\u001f8b[&\u001c\u0017I\u001c3Ti\u0006$\u0018n\u0019)beRLG/[8oc!\u0012q\u0002V\u00010i\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\tft\u0017-\\5d\u0003:$7\u000b^1uS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0015\u0003!Q\u000bq\u0006^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\b\u000eR=oC6L7-\u00118e'R\fG/[2QCJ$\u0018\u000e^5p]NB#!\u0005+")
public class TableSinkITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testDecimalOnOutputFormatTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE sink (\n                       |  `c` VARCHAR(5),\n                       |  `b` DECIMAL(10, 0),\n                       |  `d` CHAR(5)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true',\n                       |  'runtime-sink' = 'OutputFormat'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("sink");
        Seq expected = (Seq)new .colon.colon((Object)"12345,55,12345", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalOnSinkFunctionTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE sink (\n                       |  `c` VARCHAR(5),\n                       |  `b` DECIMAL(10, 0),\n                       |  `d` CHAR(5)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("sink");
        Seq expected = (Seq)new .colon.colon((Object)"12345,55,12345", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE,\n                       |  PRIMARY KEY (a) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithoutKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1)\n                     |SELECT x, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsert() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` DOUBLE\n                       |)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (b)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,0.1", (List)new .colon.colon((Object)"null,0.4", (List)new .colon.colon((Object)"null,1.0", (List)new .colon.colon((Object)"null,2.2", (List)new .colon.colon((Object)"null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFullInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (a, e)\n                     |SELECT x, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,null,null,0.1", (List)new .colon.colon((Object)"null,null,null,0.4", (List)new .colon.colon((Object)"null,null,null,1.0", (List)new .colon.colon((Object)"null,null,null,2.2", (List)new .colon.colon((Object)"null,null,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (c, d, e)\n                     |SELECT '2021', 1, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithReorder() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink (e, d, c)\n                     |SELECT sum(y), 1, '2021' FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021') (d, e)\n                     |SELECT 1, sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |INSERT INTO testSink PARTITION(`c`='2021') (e)\n                     |SELECT sum(y) FROM MyTable GROUP BY x\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,null,0.1", (List)new .colon.colon((Object)"null,2021,null,0.4", (List)new .colon.colon((Object)"null,2021,null,1.0", (List)new .colon.colon((Object)"null,2021,null,2.2", (List)new .colon.colon((Object)"null,2021,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResultsAsStrings("testSink");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition3() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE TABLE testSink (\n                       |  `a` INT,\n                       |  `b` AS `a` + 1,\n                       |  `c` STRING,\n                       |  `d` INT,\n                       |  `e` DOUBLE\n                       |)\n                       |PARTITIONED BY (`c`, `d`)\n                       |WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'true'\n                       |)\n                       |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |INSERT INTO testSink PARTITION(`c`='2021') (e, e)\n                           |SELECT 1, sum(y) FROM MyTable GROUP BY x\n                           |")).stripMargin()).await()).hasMessageContaining("Target column 'e' is assigned more than once");
    }
}

