/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.List;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\n\u0015\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004?\u0001\u0001\u0006I!\r\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019q\u0007\u0001)A\u0005\u001d\")q\u000e\u0001C!a\")A\u0010\u0001C\u0001a\"1\u00111\u0001\u0001\u0005\u0002ADa!a\u0002\u0001\t\u0003\u0001\bBBA\u0006\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002\u0010\u0001!\t\u0001\u001d\u0005\u0007\u0003'\u0001A\u0011\u00019\t\r\u0005]\u0001\u0001\"\u0001q\u0011\u0019\tY\u0002\u0001C\u0001a\"1\u0011q\u0004\u0001\u0005\u0002ADa!a\t\u0001\t\u0003\u0001\bBBA\u0014\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002,\u0001!\t\u0001\u001d\u0002\u0013'\u0016$x\n]3sCR|'o]%U\u0007\u0006\u001cXM\u0003\u0002\u0016-\u0005)A/\u00192mK*\u0011q\u0003G\u0001\u0006E\u0006$8\r\u001b\u0006\u00033i\tqA];oi&lWM\u0003\u0002\u001c9\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u000b\u001e\u0015\tqr$A\u0003gY&t7N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\r\u0002\u000bU$\u0018\u000e\\:\n\u0005):#!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002[A\u0011a\u0006A\u0007\u0002)\u0005\tq,F\u00012!\r\u0011t'O\u0007\u0002g)\u0011A'N\u0001\ni\u0016\u001cH/\u001e;jYNT!AN\u000f\u0002\t\r|'/Z\u0005\u0003qM\u00121#R1dQ\u000e\u000bG\u000e\u001c2bG.<&/\u00199qKJ\u0004\"A\u000f\u001f\u000e\u0003mR!\u0001\u000b\u000f\n\u0005uZ$A\u0005'fO\u0006\u001c\u0017PU8x\u000bb$XM\\:j_:\f!a\u0018\u0011)\u0005\r\u0001\u0005CA!K\u001b\u0005\u0011%BA\"E\u0003%)\u0007\u0010^3og&|gN\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015a\u00026va&$XM\u001d\u0006\u0003\u0013\u0006\nQA[;oSRL!a\u0013\"\u0003#I+w-[:uKJ,\u0005\u0010^3og&|g.\u0001\tfqB,7\r^3e\u0015>Lg\u000eV=qKV\ta\n\u0005\u0002PW:\u0011\u0001\u000b\u001b\b\u0003#\u0016t!AU2\u000f\u0005M\u0013gB\u0001+b\u001d\t)\u0006M\u0004\u0002W?:\u0011qK\u0018\b\u00031vs!!\u0017/\u000e\u0003iS!aW\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002\u0016;%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005\u00114\u0012aA:rY&\u0011amZ\u0001\u0005U>LgN\u0003\u0002e-%\u0011\u0011N[\u0001\t\u0015>Lg\u000eV=qK*\u0011amZ\u0005\u0003Y6\u0014\u0001BS8j]RK\b/\u001a\u0006\u0003S*\f\u0011#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3!\u0003\u0019\u0011WMZ8sKR\t\u0011\u000f\u0005\u0002sk6\t1OC\u0001u\u0003\u0015\u00198-\u00197b\u0013\t18O\u0001\u0003V]&$\bF\u0001\u0004y!\tI(0D\u0001E\u0013\tYHI\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0002^3tiVs\u0017n\u001c8BY2D#a\u0002@\u0011\u0005e|\u0018bAA\u0001\t\n!A+Z:u\u0003i!Xm\u001d;V]&|g.\u00117m/&$\bnQ8n[>tG+\u001f9fQ\tAa0A\u0005uKN$XK\\5p]\"\u0012\u0011B`\u0001\u0014i\u0016\u001cH\u000fV3s]\u0006\u0014\u00180\u00168j_:\fE\u000e\u001c\u0015\u0003\u0015y\f\u0001\u0003^3tiR+'O\\1ssVs\u0017n\u001c8)\u0005-q\u0018\u0001\u0004;fgRl\u0015N\\;t\u00032d\u0007F\u0001\u0007\u007f\u0003%!Xm\u001d;NS:,8\u000f\u000b\u0002\u000e}\u0006aB/Z:u\u001b&tWo\u001d#jM\u001a,'/\u001a8u\r&,G\u000e\u001a(b[\u0016\u001c\bF\u0001\b\u007f\u00035!Xm\u001d;J]R,'o]3di\"\u0012qB`\u0001\u0011i\u0016\u001cH/\u00138uKJ\u001cXm\u0019;BY2D#\u0001\u0005@\u0002IQ,7\u000f^%oi\u0016\u00148/Z2u/&$\b\u000eR5gM\u0016\u0014XM\u001c;GS\u0016dGMT1nKND#!\u0005@\u0002CQ,7\u000f^%oi\u0016\u00148/Z2u/&$\bnU2bY\u0006\u0014X\t\u001f9sKN\u001c\u0018n\u001c8)\u0005Iq\b")
public class SetOperatorsITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.unionAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnionAllWithCommonType() {
        Table table1 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.int2Literal(12), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("")}))});
        Table table2 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.javaDec2Literal(new BigDecimal("1234.123")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("ABC")}))});
        Table unionTable = table1.unionAll(table2);
        List schema = unionTable.getResolvedSchema().getColumnDataTypes();
        Assertions.assertThat(schema.get(0)).isEqualTo((Object)DataTypes.DECIMAL((int)13, (int)3).notNull());
        Assertions.assertThat(schema.get(1)).isEqualTo((Object)DataTypes.VARCHAR((int)3).notNull());
        Seq<Row> results = this.executeQuery(unionTable);
        String expected = "12.000,\n1234.123,ABC\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.union(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.unionAll(ds2).unionAll(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.union(ds2).union(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minusAll(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hi\nHello\nHello world\nHello\nHello world\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinus() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersect() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello world!"));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom()), "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table intersectDS = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDS);
        String expected = "Hi\nHello\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectAll() {
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2, 3}));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data1, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data2, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table intersectDS = ds1.intersectAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        String expected = "1\n2\n2";
        Seq<Row> results = this.executeQuery(intersectDS);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "e, f, g");
        Table intersectDs = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithScalarExpression() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table intersectDs = ds1.intersect(ds2);
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "2,1,Hi\n3,2,Hello\n4,2,Hello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

