/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2AAB\u0004\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C!G!)Q\u0007\u0001C\u0001G!)!\b\u0001C\u0001G!)A\b\u0001C\u0001G\tYA*[7ji&#6)Y:f\u0015\tA\u0011\"A\u0003uC\ndWM\u0003\u0002\u000b\u0017\u0005)!-\u0019;dQ*\u0011A\"D\u0001\beVtG/[7f\u0015\tqq\"A\u0004qY\u0006tg.\u001a:\u000b\u0005!\u0001\"BA\t\u0013\u0003\u00151G.\u001b8l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00037-\tQ!\u001e;jYNL!!\b\u000e\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\tq!\u0001\u0004cK\u001a|'/\u001a\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5uQ\t\u00111\u0006\u0005\u0002-g5\tQF\u0003\u0002/_\u0005\u0019\u0011\r]5\u000b\u0005A\n\u0014a\u00026va&$XM\u001d\u0006\u0003eQ\tQA[;oSRL!\u0001N\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005uKN$h)\u001a;dQ\"\u00121a\u000e\t\u0003YaJ!!O\u0017\u0003\tQ+7\u000f^\u0001\u000bi\u0016\u001cHo\u00144gg\u0016$\bF\u0001\u00038\u0003I!Xm\u001d;PM\u001a\u001cX\r^!oI\u001a+Go\u00195)\u0005\u00159\u0004")
public class LimitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.data3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
    }

    @Test
    public void testFetch() {
        Assertions.assertThat((int)this.executeQuery(this.tEnv().from("LimitTable").fetch(5)).size()).isEqualTo(5);
    }

    @Test
    public void testOffset() {
        Assertions.assertThat((int)this.executeQuery(this.tEnv().from("LimitTable").offset(5)).size()).isEqualTo(16);
    }

    @Test
    public void testOffsetAndFetch() {
        Assertions.assertThat((int)this.executeQuery(this.tEnv().from("LimitTable").limit(5, 5)).size()).isEqualTo(5);
    }
}

