/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Enumeration;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\u000f\u001e\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004H\u0001\u0001\u0006IA\u000f\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u00199\b\u0001)A\u0005/\")\u0001\u0010\u0001C!s\"1\u00111\u0002\u0001\u0005\u0002eDa!!\u0006\u0001\t\u0003I\bBBA\r\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002\u001e\u0001!\t!\u001f\u0005\u0007\u0003C\u0001A\u0011A=\t\r\u0005\u0015\u0002\u0001\"\u0001z\u0011\u0019\tI\u0003\u0001C\u0001s\"1\u0011Q\u0006\u0001\u0005\u0002eDa!!\r\u0001\t\u0003I\bBBA\u001b\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002:\u0001!\t!\u001f\u0005\u0007\u0003{\u0001A\u0011A=\t\r\u0005\u0005\u0003\u0001\"\u0001z\u0011\u0019\t)\u0005\u0001C\u0001s\"1\u0011\u0011\n\u0001\u0005\u0002eDa!!\u0014\u0001\t\u0003I\bBBA)\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002V\u0001!\t!\u001f\u0005\u0007\u00033\u0002A\u0011A=\t\r\u0005u\u0003\u0001\"\u0001z\u0011\u0019\t\t\u0007\u0001C\u0001s\nQ!j\\5o\u0013R\u001b\u0015m]3\u000b\u0005yy\u0012!\u0002;bE2,'B\u0001\u0011\"\u0003\u0015\u0011\u0017\r^2i\u0015\t\u00113%A\u0004sk:$\u0018.\\3\u000b\u0005\u0011*\u0013a\u00029mC:tWM\u001d\u0006\u0003=\u0019R!a\n\u0015\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001G\u0003\u00022C\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005i\u0012!A0\u0016\u0003i\u00022a\u000f!C\u001b\u0005a$BA\u001f?\u0003%!Xm\u001d;vi&d7O\u0003\u0002@M\u0005!1m\u001c:f\u0013\t\tEHA\nFC\u000eD7)\u00197mE\u0006\u001c7n\u0016:baB,'\u000f\u0005\u0002D\u000b6\tAI\u0003\u00022K%\u0011a\t\u0012\u0002\u0013\u0019\u0016<\u0017mY=S_^,\u0005\u0010^3og&|g.\u0001\u0002`A!\u00121!\u0013\t\u0003\u0015Nk\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u00059{\u0015aA1qS*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011&&A\u0003kk:LG/\u0003\u0002U\u0017\n\t\"+Z4jgR,'/\u0012=uK:\u001c\u0018n\u001c8\u0002!\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,W#A,\u0011\u0005a#hBA-r\u001d\tQfN\u0004\u0002\\Y:\u0011Al\u001b\b\u0003;*t!AX5\u000f\u0005}CgB\u00011h\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002eY\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005y1\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011QnH\u0001\u0004gFd\u0017BA8q\u0003\u0011Qw.\u001b8\u000b\u00055|\u0012B\u0001:t\u0003!Qu.\u001b8UsB,'BA8q\u0013\t)hO\u0001\u0005K_&tG+\u001f9f\u0015\t\u00118/A\tfqB,7\r^3e\u0015>Lg\u000eV=qK\u0002\naAY3g_J,G#\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0003u\fQa]2bY\u0006L!a ?\u0003\tUs\u0017\u000e\u001e\u0015\u0004\r\u0005\r\u0001\u0003BA\u0003\u0003\u000fi\u0011!T\u0005\u0004\u0003\u0013i%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z:u\u0015>Lg\u000eK\u0002\b\u0003\u001f\u0001B!!\u0002\u0002\u0012%\u0019\u00111C'\u0003\tQ+7\u000f^\u0001\ni\u0016\u001cHOS8j]FB3\u0001CA\b\u0003I!Xm\u001d;K_&tw+\u001b;i\r&dG/\u001a:)\u0007%\ty!\u0001\fuKN$(j\\5o/&$\bNS8j]\u001aKG\u000e^3sQ\rQ\u0011qB\u0001&i\u0016\u001cH/\u00138oKJTu.\u001b8XSRDgj\u001c8FcVL'j\\5o!J,G-[2bi\u0016D3aCA\b\u0003a!Xm\u001d;K_&tw+\u001b;i\u001bVdG/\u001b9mK.+\u0017p\u001d\u0015\u0004\u0019\u0005=\u0011a\u0006;fgRTu.\u001b8XSRD\u0017iZ4sK\u001e\fG/[8oQ\ri\u0011qB\u0001\u001fi\u0016\u001cHOS8j]^KG\u000f[$s_V\u0004X\rZ!hOJ,w-\u0019;j_:D3ADA\b\u0003]!Xm\u001d;K_&t\u0007+^:i)\"\u0014x.^4i\u0015>Lg\u000eK\u0002\u0010\u0003\u001f\t1\u0004^3ti*{\u0017N\\,ji\"$\u0015n\u001d6v]\u000e$\u0018N^3Qe\u0016$\u0007f\u0001\t\u0002\u0010\u0005YB/Z:u\u0015>LgnV5uQ\u0016C\bO]3tg&|g\u000e\u0015:fIND3!EA\b\u0003q!Xm\u001d;MK\u001a$(j\\5o/&$\b.T;mi&\u0004H.Z&fsND3AEA\b\u0003}!Xm\u001d;MK\u001a$(j\\5o/&$\bNT8o\u000bF,\u0018NS8j]B\u0013X\r\u001a\u0015\u0004'\u0005=\u0011!\b;fgRdUM\u001a;K_&tw+\u001b;i\u0019\u00164G\u000fT8dC2\u0004&/\u001a3)\u0007Q\ty!A\u000fuKN$(+[4ii*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\r)\u0012qB\u0001!i\u0016\u001cHOU5hQRTu.\u001b8XSRDgj\u001c8FcVL'j\\5o!J,G\rK\u0002\u0017\u0003\u001f\ta\u0004^3tiJKw\r\u001b;K_&tw+\u001b;i\u0019\u00164G\u000fT8dC2\u0004&/\u001a3)\u0007]\ty!A\u0011uKN$h)\u001e7m\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000fK\u0002\u0019\u0003\u001f\tq\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5O_:,\u0015/^5K_&t\u0007K]3eQ\rI\u0012qB\u0001\u001ei\u0016\u001cHOR;mY*{\u0017N\\,ji\"dUM\u001a;M_\u000e\fG\u000e\u0015:fI\"\u001a!$a\u0004\u0002)Q,7\u000f^+E)\u001aSu.\u001b8P]R+\b\u000f\\3tQ\rY\u0012q\u0002")
public class JoinITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoin1() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        FuncWithOpen testOpenCall = new FuncWithOpen();
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)testOpenCall).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2()).as("a", new String[]{"b", "c"});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get5TupleDataSet$default$2()).as("d", new String[]{"e", "f", "g", "h"});
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithJoinFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nHello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq<Row> results = this.executeQuery(joinT);
        String expected = "Hello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nI am fine.,HIJ\nI am fine.,IJK\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithGroupedAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6,3\n4,2\n1,1";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinPushThroughJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "j, k, l");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.boolean2Literal(true)).join(ds3).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        String expected = "2,1,Hello\n2,1,Hello world\n1,0,Hi";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithDisjunctivePred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$minus(package$.MODULE$.int2Literal(10)))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nI am fine.,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithExpressionPreds() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$plus(package$.MODULE$.int2Literal(1)))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus(package$.MODULE$.int2Literal(1))).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$plus(package$.MODULE$.int2Literal(2))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "I am fine.,Hallo Welt\nLuke Skywalker,Hallo Welt wie gehts?\nLuke Skywalker,ABC\nComment#2,HIJ\nComment#2,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nHello world, how are you?,null\nI am fine.,HIJ\nI am fine.,IJK\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testLeftJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullOuterJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\nHello world, how are you?,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFullJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo Welt wie", "null,CDE", "null,DEF", "null,EFG", "null,FGH", "null,GHI", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater$eq(package$.MODULE$.int2Literal(2)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$eq$eq$eq(package$.MODULE$.int2Literal(1)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt wie", "Hello world, how are you?,DEF", "Hello world, how are you?,EFG", "I am fine.,GHI", "Hi,null", "Hello world,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo", "null,Hallo Welt", "null,Hallo Welt wie gehts?", "null,ABC", "null,BCD", "null,CDE", "null,FGH", "null,HIJ", "null,IJK", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testUDTFJoinOnTuples() {
        .colon.colon data = new .colon.colon((Object)"hi#world", (List)new .colon.colon((Object)"how#are#you", (List)Nil$.MODULE$));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a", ClassTag$.MODULE$.apply(String.class), BasicTypeInfo.getInfoFor(String.class));
        TableFunc2 func2 = new TableFunc2();
        Table joinDs = ds1.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "len")})));
        Seq<Row> results = this.executeQuery(joinDs);
        String expected = ((TraversableOnce)new .colon.colon((Object)"hi#world,hi,2", (List)new .colon.colon((Object)"hi#world,world,5", (List)new .colon.colon((Object)"how#are#you,how,3", (List)new .colon.colon((Object)"how#are#you,are,3", (List)new .colon.colon((Object)"how#are#you,you,3", (List)Nil$.MODULE$)))))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

