/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import java.time.LocalDateTime;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.IntAvgAggFunction;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001D\u0007\u0001A!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C!Y!)a\b\u0001C\u0001Y!)1\t\u0001C\u0001Y!)Q\t\u0001C\u0001Y!)q\t\u0001C\u0001Y!)\u0011\n\u0001C\u0001Y!)1\n\u0001C\u0001Y!)Q\n\u0001C\u0001Y!)q\n\u0001C\u0001Y!)\u0011\u000b\u0001C\u0001Y\t\trI]8va^Kg\u000eZ8x\u0013R\u001b\u0015m]3\u000b\u00059y\u0011aA1hO*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0015\u0011\u0017\r^2i\u0015\t!R#A\u0004sk:$\u0018.\\3\u000b\u0005Y9\u0012a\u00029mC:tWM\u001d\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%'\u0005)Q\u000f^5mg&\u0011ae\t\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005i\u0011A\u00022fM>\u0014X\rF\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0011)f.\u001b;)\u0005\t!\u0004CA\u001b=\u001b\u00051$BA\u001c9\u0003\r\t\u0007/\u001b\u0006\u0003si\nqA[;qSR,'O\u0003\u0002<;\u0005)!.\u001e8ji&\u0011QH\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0005;fgR$V/\u001c2mS:<w+\u001b8e_^D#a\u0001!\u0011\u0005U\n\u0015B\u0001\"7\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^\"bg\u000e\fG-\u001b8h)Vl'\r\\3XS:$wn\u001e\u0015\u0003\t\u0001\u000b\u0011\u0003^3tiNc\u0017\u000eZ5oO^Kg\u000eZ8xQ\t)\u0001)A\u000euKN$h*\u001e7m-\u0006dW/Z%oaV$H+[7fgR\fW\u000e\u001d\u0015\u0003\r\u0001\u000b!\u0004^3ti:+w-\u0019;jm\u0016Le\u000e];u)&lWm\u001d;b[BD#a\u0002!\u0002=Q,7\u000f\u001e+v[\ndWmV5oI><x+\u001b;i!J|\u0007/\u001a:uS\u0016\u001c\bF\u0001\u0005A\u0003m!Xm\u001d;I_B<\u0016N\u001c3po^KG\u000f\u001b)s_B,'\u000f^5fg\"\u0012\u0011\u0002Q\u0001 i\u0016\u001cHoU3tg&|gnV5oI><x+\u001b;i!J|\u0007/\u001a:uS\u0016\u001c\bF\u0001\u0006A\u0003}\"Xm\u001d;M_\u000e\fGn\u00127pE\u0006dw+\u001b8e_^\fum\u001a:fO\u0006$XmV5uQ>,Ho\u0012:pkBLgnZ!oI:\u000bW.\u001a3Qe>\u0004XM\u001d;jKND#a\u0003!")
public class GroupWindowITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("Table3WithTimestamp", TestData$.MODULE$.data3WithTimestamp(), TestData$.MODULE$.type3WithTimestamp(), "a, b, c, ts", TestData$.MODULE$.nullablesOfData3WithTimestamp());
        this.tEnv().createTemporarySystemFunction("countFun", (UserDefinedFunction)new CountAggFunction());
        this.tEnv().createTemporarySystemFunction("sumFun", (UserDefinedFunction)new IntSumAggFunction());
        this.tEnv().createTemporarySystemFunction("avgFun", (UserDefinedFunction)new IntAvgAggFunction());
        this.registerCollection("Table6", TestData$.MODULE$.data6(), TestData$.MODULE$.type6(), "a, b, c, d, e, f", TestData$.MODULE$.nullablesOfData6());
    }

    @Test
    public void testTumblingWindow() {
        this.checkResult("SELECT a, countFun(a), TUMBLE_START(ts, INTERVAL '3' SECOND)FROM Table3WithTimestamp GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT a, countFun(a), TUMBLE_START(ts, INTERVAL '3' SECOND), b FROM Table3WithTimestamp GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND), b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0"), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0"), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0"), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0"), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0"), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0"), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0"), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0"), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0"), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0"), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0"), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0"), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0"), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0"), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0"), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0"), BoxesRunTime.boxToInteger((int)6)}))}))), this.checkResult$default$3());
        this.checkResult("SELECT a, avg(b), min(b), TUMBLE_START(f, INTERVAL '10' SECOND) FROM Table6 GROUP BY a, TUMBLE(f, INTERVAL '10' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.1), BoxesRunTime.boxToDouble((double)1.1), DateTimeTestUtil$.MODULE$.localDateTime("2015-05-20 10:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)-2.4), BoxesRunTime.boxToDouble((double)-2.4), DateTimeTestUtil$.MODULE$.localDateTime("2016-09-01 23:07:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)2.5), BoxesRunTime.boxToDouble((double)2.5), DateTimeTestUtil$.MODULE$.localDateTime("2019-09-19 08:03:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)-4.885), BoxesRunTime.boxToDouble((double)-9.77), DateTimeTestUtil$.MODULE$.localDateTime("1999-12-12 10:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)0.08), BoxesRunTime.boxToDouble((double)0.08), DateTimeTestUtil$.MODULE$.localDateTime("1999-12-12 10:03:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToDouble((double)3.14), DateTimeTestUtil$.MODULE$.localDateTime("2017-11-20 09:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)3.145), BoxesRunTime.boxToDouble((double)3.14), DateTimeTestUtil$.MODULE$.localDateTime("2015-11-19 10:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)3.16), BoxesRunTime.boxToDouble((double)3.16), DateTimeTestUtil$.MODULE$.localDateTime("2015-11-20 08:59:50.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToDouble((double)-5.9), BoxesRunTime.boxToDouble((double)-5.9), DateTimeTestUtil$.MODULE$.localDateTime("1989-06-04 10:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToDouble((double)-2.8), BoxesRunTime.boxToDouble((double)-2.8), DateTimeTestUtil$.MODULE$.localDateTime("1937-07-07 08:08:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToDouble((double)0.7), BoxesRunTime.boxToDouble((double)0.7), DateTimeTestUtil$.MODULE$.localDateTime("2010-06-01 10:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToDouble((double)2.71), BoxesRunTime.boxToDouble((double)2.71), DateTimeTestUtil$.MODULE$.localDateTime("1997-07-01 09:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToDouble((double)3.9), BoxesRunTime.boxToDouble((double)3.9), DateTimeTestUtil$.MODULE$.localDateTime("2000-01-01 00:00:00.0")}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCascadingTumbleWindow() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT b, SUM(cnt)\n         |FROM (\n         |  SELECT b, COUNT(1) AS cnt, TUMBLE_ROWTIME(ts, INTERVAL '30' SECOND) AS ts\n         |  FROM Table3WithTimestamp\n         |  GROUP BY a, b, TUMBLE(ts, INTERVAL '30' SECOND)\n         |)\n         |GROUP BY b, TUMBLE(ts, INTERVAL '30' SECOND)\n         |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testSlidingWindow() {
        this.checkResult("SELECT b, sumFun(a), HOP_START(ts, INTERVAL '5' SECOND, INTERVAL '9' SECOND) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '5' SECOND, INTERVAL '9' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)11), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)10), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)34), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)36), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)65), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)111), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)41), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)51), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT b, sum(a), HOP_START(ts, INTERVAL '5' SECOND, INTERVAL '9' SECOND) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '5' SECOND, INTERVAL '9' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)11), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)10), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)34), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)36), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)65), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)111), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)41), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)51), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT b, sumFun(a) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)9)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)19)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)39)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)21)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)57)}))}))), this.checkResult$default$3());
        this.checkResult("SELECT b, sum(a) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)9)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)19)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)39)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)21)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)57)}))}))), this.checkResult$default$3());
        this.checkResult("SELECT b, sumFun(a), HOP_START(ts, INTERVAL '5.111' SECOND(1,3), INTERVAL '9' SECOND) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '5.111' SECOND(1,3), INTERVAL '9' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:54.889")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:54.889")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)34), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)50), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)65), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.222")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)111), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.333")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.444")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)70), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.222")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT b, sum(a), HOP_START(ts, INTERVAL '5.111' SECOND(1,3), INTERVAL '9' SECOND) FROM Table3WithTimestamp GROUP BY b, HOP(ts, INTERVAL '5.111' SECOND(1,3), INTERVAL '9' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:54.889")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:54.889")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)34), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)50), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.111")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)65), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.222")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)111), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.333")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.444")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)70), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.222")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT sumFun(a), HOP_START(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND), HOP_END(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)FROM Table3WithTimestamp GROUP BY HOP(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:24.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)30), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)39), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)48), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)57), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT SUM(a), HOP_START(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND), HOP_END(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)FROM Table3WithTimestamp GROUP BY HOP(ts, INTERVAL '3' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:24.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:03.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)30), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)39), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)48), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)57), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:21.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT avgFun(a), sumFun(a), HOP_START(ts, INTERVAL '2' SECOND, INTERVAL '3' SECOND) FROM Table3WithTimestamp GROUP BY HOP(ts, INTERVAL '2' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)33), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)39), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToInteger((int)45), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)51), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:16.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)57), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)41), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)9), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:02.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)27), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:08.0")}))}))), this.checkResult$default$3());
        this.checkResult("SELECT AVG(a), SUM(a), HOP_START(ts, INTERVAL '2' SECOND, INTERVAL '3' SECOND) FROM Table3WithTimestamp GROUP BY HOP(ts, INTERVAL '2' SECOND, INTERVAL '3' SECOND)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)33), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)39), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:12.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToInteger((int)45), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)51), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:16.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)57), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:18.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)41), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)9), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:02.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)21), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:06.0")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)27), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:08.0")}))}))), this.checkResult$default$3());
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.41"), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.62"), BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.715"), BoxesRunTime.boxToInteger((int)8)})), (List)Nil$.MODULE$)));
        this.registerCollection("T2", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO}), "ts, v");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |HOP_START(ts, INTERVAL '0.04' SECOND(1,2), INTERVAL '0.2' SECOND(1,1)),\n        |HOP_END(ts, INTERVAL '0.04' SECOND(1,2), INTERVAL '0.2' SECOND(1,1)),\n        |count(*)\n        |FROM T2\n        |GROUP BY HOP(ts, INTERVAL '0.04' SECOND(1,2), INTERVAL '0.2' SECOND(1,1))\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.24"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.44"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.28"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.48"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.32"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.52"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.36"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.56"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.4"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.6"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.44"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.64"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.48"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.68"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.52"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.72"), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.56"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.76"), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.6"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.8"), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.64"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.84"), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.68"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.88"), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNullValueInputTimestamp() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))));
        this.registerCollection("T1", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO}), "ts, v");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT v\n        |FROM T1\n        |GROUP BY HOP(ts, INTERVAL '2' SECOND, INTERVAL '3' SECOND), v\n      ")).stripMargin(), (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
        data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:05"), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:32"), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))));
        this.registerCollection("T2", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO}), "ts, v");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), TUMBLE_END(ts, INTERVAL '10' SECOND), v\n        |FROM T2\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND), v\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:10.0"), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:30.0"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 09:00:40.0"), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
        data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))));
        this.registerCollection("T3", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO}), "ts, v");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), TUMBLE_END(ts, INTERVAL '10' SECOND), v\n        |FROM T3\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND), v\n      ")).stripMargin(), (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testNegativeInputTimestamp() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 19:39:30"), BoxesRunTime.boxToInteger((int)1), "a"})), (List)Nil$.MODULE$);
        this.registerCollection("T1", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "ts, value, id");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), TUMBLE_END(ts, INTERVAL '10' SECOND),\n        |count(*)\n        |FROM T1\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 19:39:30.0"), DateTimeTestUtil$.MODULE$.localDateTime("2016-03-27 19:39:40.0"), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31"), BoxesRunTime.boxToInteger((int)1), "a"})), (List)Nil$.MODULE$);
        this.registerCollection("T2", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE_TIME, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "ts, value, id");
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), TUMBLE_END(ts, INTERVAL '10' SECOND),\n        |count(*)\n        |FROM T2\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:30.0"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:40.0"), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |HOP_START(ts, INTERVAL '10' SECOND, INTERVAL '11' SECOND),\n        |HOP_END(ts, INTERVAL '10' SECOND, INTERVAL '11' SECOND),\n        |count(*)\n        |FROM T2\n        |GROUP BY HOP(ts, INTERVAL '10' SECOND, INTERVAL '11' SECOND)\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:30.0"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:41.0"), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |HOP_START(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3)),\n        |HOP_END(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3)),\n        |count(*)\n        |FROM T2\n        |GROUP BY HOP(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3))\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:30.999"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.001"), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.0"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.002"), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |HOP_START(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3)),\n        |HOP_END(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3)),\n        |countFun(ts)\n        |FROM T2\n        |GROUP BY HOP(ts, INTERVAL '0.001' SECOND(1,3), INTERVAL '0.002' SECOND(1,3))\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:30.999"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.001"), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.0"), DateTimeTestUtil$.MODULE$.localDateTime("1916-03-27 19:39:31.002"), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testTumbleWindowWithProperties() {
        this.registerCollection("T", (Iterable<Row>)TestData$.MODULE$.data3WithTimestamp(), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE_TIME}), "a, b, c, ts");
        String sqlQuery = "SELECT b, COUNT(a), TUMBLE_START(ts, INTERVAL '5' SECOND), TUMBLE_END(ts, INTERVAL '5' SECOND), TUMBLE_ROWTIME(ts, INTERVAL '5' SECOND)FROM T GROUP BY b, TUMBLE(ts, INTERVAL '5' SECOND)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:19.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)4), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:25.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:24.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)4), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:19.999")}))}))), this.checkResult$default$3());
    }

    @Test
    public void testHopWindowWithProperties() {
        this.registerCollection("T", (Iterable<Row>)TestData$.MODULE$.data3WithTimestamp(), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE_TIME}), "a, b, c, ts");
        String sqlQuery = "SELECT b, COUNT(a), HOP_START(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND), HOP_END(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND), HOP_ROWTIME(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND) FROM T GROUP BY b, HOP(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1969-12-31 23:59:55.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:04.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:19.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:09.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:25.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:24.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)4), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:05.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:14.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:19.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)2), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:30.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:29.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)4), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:10.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:20.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:19.999")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:15.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:25.0"), DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:24.999")}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSessionWindowWithProperties() {
        this.registerCollection("T", (Iterable<Row>)TestData$.MODULE$.data3WithTimestamp(), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE_TIME}), "a, b, c, ts");
        String sqlQuery = "SELECT COUNT(a), SESSION_START(ts, INTERVAL '4' SECOND), SESSION_END(ts, INTERVAL '4' SECOND), SESSION_ROWTIME(ts, INTERVAL '4' SECOND) FROM T GROUP BY SESSION(ts, INTERVAL '4' SECOND)";
        Assertions.assertThatThrownBy(() -> this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3())).hasCauseInstanceOf(RuntimeException.class);
    }

    @Test
    public void testLocalGlobalWindowAggregateWithoutGroupingAndNamedProperties() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), LocalDateTime.of(2021, 7, 26, 0, 0, 0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), LocalDateTime.of(2021, 7, 26, 0, 0, 3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), LocalDateTime.of(2021, 7, 26, 0, 0, 6)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), LocalDateTime.of(2021, 7, 26, 0, 0, 4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), LocalDateTime.of(2021, 7, 26, 0, 0, 5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), LocalDateTime.of(2021, 7, 26, 0, 0, 8)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), LocalDateTime.of(2021, 7, 26, 0, 0, 10)})), (List)Nil$.MODULE$)))))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |CREATE TABLE MyTable (\n         |  a INT,\n         |  ts TIMESTAMP\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT sum(a) FROM MyTable\n        |GROUP BY\n        |TUMBLE(ts, interval '5' seconds)\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)14)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }
}

