/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkGroupProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.AggregateReduceGroupingRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153AAC\u0006\u0001=!)Q\u0005\u0001C\u0001M!)\u0011\u0006\u0001C!U!)A\b\u0001C\u0001U!)\u0011\t\u0001C\u0001U!)1\t\u0001C\u0001U!)Q\t\u0001C\u0001U!)q\t\u0001C\u0001U!)\u0011\n\u0001C\u0001U!)1\n\u0001C\u0001U\ta\u0012iZ4sK\u001e\fG/\u001a&pS:$&/\u00198ta>\u001cX-\u0013+DCN,'B\u0001\u0007\u000e\u0003\r\twm\u001a\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003cCR\u001c\u0007N\u0003\u0002\u0013'\u00059!/\u001e8uS6,'B\u0001\u000b\u0016\u0003\u001d\u0001H.\u00198oKJT!AF\f\u0002\u000bQ\f'\r\\3\u000b\u0005aI\u0012!\u00024mS:\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\u0011!%E\u0001\u0006kRLGn]\u0005\u0003I\u0005\u0012QBQ1uG\"$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\f\u0003\u0019\u0011WMZ8sKR\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0003V]&$\bF\u0001\u00023!\t\u0019$(D\u00015\u0015\t)d'A\u0002ba&T!a\u000e\u001d\u0002\u000f),\b/\u001b;fe*\u0011\u0011hG\u0001\u0006UVt\u0017\u000e^\u0005\u0003wQ\u0012!BQ3g_J,W)Y2i\u0003-\"Xm\u001d;QkND7i\\;oi\u0006;w\r\u00165s_V<\u0007NS8j]>3XM]+oSF,XmQ8mk6t\u0007FA\u0002?!\t\u0019t(\u0003\u0002Ai\t!A+Z:u\u0003%\"Xm\u001d;QkND7+^7BO\u001e$\u0006N]8vO\"Tu.\u001b8Pm\u0016\u0014XK\\5rk\u0016\u001cu\u000e\\;n]\"\u0012AAP\u00014i\u0016\u001cHoU8nK\u0006;wmQ1mY\u000e{G.^7og\u0006sGMS8j]\u000e{g\u000eZ5uS>t7i\u001c7v[:\u001c\u0018j]*b[\u0016D#!\u0002 \u0002UQ,7\u000f^!hOJ,w-\u0019;f/&$\b.Q;y\u000fJ|W\u000f]0K_&t7*Z=JgVs\u0017.];fc!\u0012aAP\u0001+i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRD\u0017)\u001e=He>,\bo\u0018&pS:\\U-_%t+:L\u0017/^33Q\t9a(A\u0017uKN$\u0018iZ4sK\u001e\fG/Z,ji\"\fU\u000f_$s_V\u0004xLS8j].+\u00170S:O_R,f.[9vKFB#\u0001\u0003 \u0002[Q,7\u000f^!hOJ,w-\u0019;f/&$\b.Q;y\u000fJ|W\u000f]0K_&t7*Z=Jg:{G/\u00168jcV,'\u0007\u000b\u0002\n}\u0001")
public class AggregateJoinTransposeITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.tEnv().getConfig());
        ((FlinkRuleSetProgram)programs.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.LOGICAL()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TableException(new StringBuilder(15).append(FlinkBatchProgram$.MODULE$.LOGICAL()).append(" does not exist").toString());
        })).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkAggregateJoinTransposeRule.EXTENDED}));
        programs.addBefore(FlinkBatchProgram$.MODULE$.LOGICAL(), "FlinkAggregateJoinTransposeRule", (FlinkOptimizeProgram)FlinkGroupProgramBuilder$.MODULE$.newBuilder().addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule.INSTANCE})).build(), "reduce unless grouping").addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule.INSTANCE, CoreRules.AGGREGATE_PROJECT_MERGE, FlinkAggregateJoinTransposeRule.EXTENDED})).build(), "aggregate join transpose").build());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.tEnv().getConfig());
        calciteConfig = CalciteConfig$.MODULE$.createBuilder(calciteConfig).replaceBatchProgram(programs).build();
        this.tEnv().getConfig().setPlannerConfig((PlannerConfig)calciteConfig);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin");
        this.registerCollection("T3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        this.registerCollection("MyTable", (Iterable)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "X"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "Y"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)4L), "Z"})), (List)Nil$.MODULE$)))), new RowTypeInfo(new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), "a2, b2, c2", new boolean[]{true, true, true}, FlinkStatistic$.MODULE$.builder().uniqueKeys((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.Set[]{(java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b2"}))).asJava()}))).asJava()).build());
    }

    @Test
    public void testPushCountAggThroughJoinOverUniqueColumn() {
        this.checkResult("SELECT COUNT(A.a) FROM (SELECT DISTINCT a FROM T3) AS A JOIN T3 AS B ON A.a=B.a", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testPushSumAggThroughJoinOverUniqueColumn() {
        this.checkResult("SELECT SUM(A.a) FROM (SELECT DISTINCT a FROM T3) AS A JOIN T3 AS B ON A.a=B.a", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)231)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testSomeAggCallColumnsAndJoinConditionColumnsIsSame() {
        this.checkResult("SELECT MIN(a2), MIN(b2), a, b, COUNT(c2) FROM (SELECT * FROM MyTable, T3 WHERE b2 = b) t GROUP BY b, a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique1() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c2, SUM(a) FROM (\n        | SELECT * FROM MyTable, T3 WHERE b2 = b\n        |) GROUP BY a2, b2, c2\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "X", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Y", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)15)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Z", BoxesRunTime.boxToInteger((int)34)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c2, SUM(a), COUNT(c) FROM (\n        | SELECT * FROM MyTable, T3 WHERE b2 = b\n        |) GROUP BY a2, b2, c2\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "X", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Y", BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Z", BoxesRunTime.boxToInteger((int)34), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique2() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c, SUM(a) FROM (\n        | SELECT * FROM MyTable, T3 WHERE b2 = b\n        |) GROUP BY a2, b2, c\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hello world", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hello", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Hello world, how are you?", BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "I am fine.", BoxesRunTime.boxToInteger((int)5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Luke Skywalker", BoxesRunTime.boxToInteger((int)6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#1", BoxesRunTime.boxToInteger((int)7)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#2", BoxesRunTime.boxToInteger((int)8)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#3", BoxesRunTime.boxToInteger((int)9)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#4", BoxesRunTime.boxToInteger((int)10)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c, SUM(a), MAX(b) FROM (\n        | SELECT * FROM MyTable, T3 WHERE b2 = b\n        |) GROUP BY a2, b2, c\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hello world", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hello", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Hello world, how are you?", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "I am fine.", BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Luke Skywalker", BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#1", BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#2", BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#3", BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)4)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Comment#4", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)4)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique1() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c2, SUM(a) FROM (\n        | SELECT * FROM MyTable, T3 WHERE a2 = a\n        |) GROUP BY a2, b2, c2\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "X", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Y", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Z", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c2, SUM(a), COUNT(c) FROM (\n        | SELECT * FROM MyTable, T3 WHERE a2 = a\n        |) GROUP BY a2, b2, c2\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "X", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Y", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Z", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique2() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c, SUM(a) FROM (\n        | SELECT * FROM MyTable, T3 WHERE a2 = a\n        |) GROUP BY a2, b2, c\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hi", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Hello", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Hello", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select a2, b2, c, SUM(a), MIN(b) FROM (\n        | SELECT * FROM MyTable, T3 WHERE a2 = a\n        |) GROUP BY a2, b2, c\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), "Hello", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), "Hello", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }
}

