/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.factories.TestUpdateDeleteTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TruncateTableITCase
extends BatchTestBase {
    private static final int ROW_NUM = 2;

    @Test
    void testTruncateTable() {
        String dataId = this.registerData();
        this.tEnv().executeSql(String.format("CREATE TABLE t (a int) WITH ('connector' = 'test-update-delete', 'data-id' = '%s', 'only-accept-equal-predicate' = 'true')", dataId));
        List<Row> rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat((String)rows.toString()).isEqualTo("[+I[0], +I[1]]");
        this.tEnv().executeSql("TRUNCATE TABLE t");
        rows = this.toRows(this.tEnv().executeSql("SELECT * FROM t"));
        Assertions.assertThat(rows).isEmpty();
    }

    @Test
    void testTruncateTableWithoutImplementation() {
        this.tEnv().executeSql("CREATE TABLE t (a int) WITH ('connector' = 'values')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("TRUNCATE TABLE t")).isInstanceOf(TableException.class)).hasMessage("TRUNCATE TABLE statement is not supported for the table default_catalog.default_database.t since the table hasn't implemented the interface org.apache.flink.table.connector.sink.abilities.SupportsTruncate.");
    }

    @Test
    void testTruncateLegacyTable() {
        this.tEnv().executeSql("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'COLLECTION')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("TRUNCATE TABLE t")).isInstanceOf(TableException.class)).hasMessage(String.format("Can't perform truncate table operation of the table %s because the corresponding table sink is the legacy TableSink. Please implement %s for it.", "`default_catalog`.`default_database`.`t`", DynamicTableSink.class.getName()));
    }

    private String registerData() {
        List<RowData> values = this.createValue();
        return TestUpdateDeleteTableFactory.registerRowData(values);
    }

    private List<RowData> createValue() {
        ArrayList<RowData> values = new ArrayList<RowData>();
        for (int i = 0; i < 2; ++i) {
            values.add((RowData)GenericRowData.of((Object[])new Object[]{i}));
        }
        return values;
    }

    private List<Row> toRows(TableResult result) {
        return CollectionUtil.iteratorToList((Iterator)result.collect());
    }
}

