/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.planner.factories.TestTimeTravelCatalog;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TimeTravelTestUtil;
import org.apache.flink.table.planner.utils.DateTimeTestUtil;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimeTravelITCase
extends BatchTestBase {
    private static final List<Tuple2<String, String>> EXPECTED_TIME_TRAVEL_RESULT = Arrays.asList(Tuple2.of((Object)"2023-01-01 01:00:00", (Object)"[+I[1]]"), Tuple2.of((Object)"2023-01-01 02:00:00", (Object)"[+I[1, 2]]"), Tuple2.of((Object)"2023-01-01 03:00:00", (Object)"[+I[1, 2, 3]]"));

    TimeTravelITCase() {
    }

    @Override
    @BeforeEach
    public void before() {
        String catalogName = "TimeTravelCatalog";
        TestTimeTravelCatalog catalog = TimeTravelTestUtil.getTestingCatalogWithVersionedTable(catalogName, "t1");
        this.tEnv().registerCatalog(catalogName, (Catalog)catalog);
        this.tEnv().useCatalog(catalogName);
        this.tEnv().getConfig().setLocalTimeZone(ZoneId.of("UTC"));
    }

    @Test
    void testTimeTravel() {
        for (Tuple2<String, String> res : EXPECTED_TIME_TRAVEL_RESULT) {
            TableResult tableResult = this.tEnv().executeSql(String.format("SELECT * FROM t1 FOR SYSTEM_TIME AS OF TIMESTAMP '%s'", res.f0));
            List<String> sortedResult = this.toSortedResults(tableResult);
            Assertions.assertThat((String)sortedResult.toString()).isEqualTo((String)res.f1);
        }
    }

    @Test
    void testTimeTravelWithAsExpression() {
        for (Tuple2<String, String> res : EXPECTED_TIME_TRAVEL_RESULT) {
            TableResult tableResult = this.tEnv().executeSql(String.format("SELECT\n    *\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '%s' AS t2", res.f0));
            List<String> sortedResult = this.toSortedResults(tableResult);
            Assertions.assertThat((String)sortedResult.toString()).isEqualTo((String)res.f1);
        }
    }

    @Test
    void testTimeTravelWithSimpleExpression() {
        TableResult tableResult = this.tEnv().executeSql("SELECT\n    *\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 00:00:00'+INTERVAL '60' DAY");
        List<String> sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[1, 2, 3]]");
    }

    @Test
    void testTimeTravelWithDifferentTimezone() {
        this.tEnv().getConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        for (Tuple2<String, String> res : EXPECTED_TIME_TRAVEL_RESULT) {
            TableResult tableResult = this.tEnv().executeSql(String.format("SELECT\n    *\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '%s' AS t2", DateTimeTestUtil.timezoneConvert((String)res.f0, "yyyy-MM-dd HH:mm:ss", ZoneId.of("UTC"), ZoneId.of("Asia/Shanghai"))));
            List<String> sortedResult = this.toSortedResults(tableResult);
            Assertions.assertThat((String)sortedResult.toString()).isEqualTo((String)res.f1);
        }
    }

    @Test
    void testTimeTravelOneTableMultiTimes() {
        TableResult tableResult = this.tEnv().executeSql("SELECT\n    f1\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 01:00:00'\nUNION ALL\nSELECT\n    f2\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00'");
        List<String> sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[1], +I[2]]");
        tableResult = this.tEnv().executeSql("SELECT\n    l.f1,\n    r.f2\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 01:00:00' l\n    LEFT JOIN t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00' r ON l.f1=r.f1");
        sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[1, 2]]");
    }

    @Test
    void testTimeTravelWithLookupJoin() {
        TableResult tableResult = this.tEnv().executeSql("SELECT\n    l.f2,\n    r.f3\nFROM\n    (\n        SELECT\n            *,\n            proctime () as p\n        FROM\n            t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00'\n    ) l\n    LEFT JOIN t1 FOR SYSTEM_TIME AS OF l.p r ON l.f1=r.f1");
        List<String> sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[2, 3]]");
    }

    @Test
    void testTimeTravelWithHints() {
        TableResult tableResult = this.tEnv().executeSql("SELECT * FROM t1 /*+ options('bounded'='true') */ FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 01:00:00'");
        List<String> sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[1]]");
        tableResult = this.tEnv().executeSql("SELECT * FROM t1 /*+ options('bounded'='true') */ FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00' AS t2");
        sortedResult = this.toSortedResults(tableResult);
        Assertions.assertThat((String)sortedResult.toString()).isEqualTo("[+I[1, 2]]");
    }

    private List<String> toSortedResults(TableResult result) {
        return CollectionUtil.iteratorToList((Iterator)result.collect()).stream().map(Row::toString).sorted().collect(Collectors.toList());
    }
}

