/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.LinkedList;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.legacy.RichSinkFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSinkITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Array$;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5h\u0001B\u001c9\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004d\u0001\u0001\u0006IA\u0016\u0005\u0006c\u0002!\tE\u001d\u0005\u0006}\u0002!\tA\u001d\u0005\u0007\u0003\u000f\u0001A\u0011\u0001:\t\r\u0005-\u0001\u0001\"\u0001s\u0011\u0019\ty\u0001\u0001C\u0001e\"1\u00111\u0003\u0001\u0005\u0002IDa!a\u0006\u0001\t\u0003\u0011\bBBA\u000e\u0001\u0011\u0005!\u000f\u0003\u0004\u0002 \u0001!\tA\u001d\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011%\tY\u0007AI\u0001\n\u0013\ti\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0003\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0012\u0002\u0013%\u00111\u0012\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0005\u0003#;q!!&9\u0011\u0003\t9J\u0002\u00048q!\u0005\u0011\u0011\u0014\u0005\u0007!N!\t!!)\t\u0013\u0005\r6C1A\u0005\u0002\u0005\u0015\u0006\u0002CAT'\u0001\u0006I!!\u0012\t\u0013\u0005%6C1A\u0005\u0002\u0005\u0015\u0006\u0002CAV'\u0001\u0006I!!\u0012\t\u0013\u000556C1A\u0005\u0002\u0005=\u0006\u0002CA`'\u0001\u0006I!!-\t\u0013\u0005\u00057C1A\u0005\u0002\u0005=\u0006\u0002CAb'\u0001\u0006I!!-\t\u0013\u0005\u00157C1A\u0005\u0002\u0005=\u0006\u0002CAd'\u0001\u0006I!!-\t\u0013\u0005%7C1A\u0005\u0002\u0005-\u0007\u0002CAj'\u0001\u0006I!!4\t\r\u0005U7\u0003\"\u0001s\r\u0019\t9n\u0005\u0001\u0002Z\"Q!\u0011\u0001\u0012\u0003\u0002\u0003\u0006IAa\u0001\t\rA\u0013C\u0011\u0001B\n\u0011-\u0011YB\ta\u0001\u0002\u0004%I!a,\t\u0017\tu!\u00051AA\u0002\u0013%!q\u0004\u0005\f\u0005K\u0011\u0003\u0019!A!B\u0013\t\t\fC\u0004\u0003(\t\"\tE!\u000b\t\u000f\te\"\u0005\"\u0011\u0003<!I!1R\nC\u0002\u0013\u0005!Q\u0012\u0005\t\u00057\u001b\u0002\u0015!\u0003\u0003\u0010\"I!QT\nC\u0002\u0013\u0005!q\u0014\u0005\t\u0005c\u001b\u0002\u0015!\u0003\u0003\"\"I!1W\nC\u0002\u0013\u0005!Q\u0017\u0005\t\u0005s\u001b\u0002\u0015!\u0003\u00038\"I!1X\nC\u0002\u0013\u0005!Q\u0018\u0005\t\u0005\u0017\u001c\u0002\u0015!\u0003\u0003@\"I!QZ\nC\u0002\u0013\u0005!Q\u0018\u0005\t\u0005\u001f\u001c\u0002\u0015!\u0003\u0003@\"I!\u0011[\nC\u0002\u0013\u0005!Q\u0018\u0005\t\u0005'\u001c\u0002\u0015!\u0003\u0003@\"9\u00111E\n\u0005\u0002\tU'a\u0006)beRLG/[8oC\ndWmU5oW&#6)Y:f\u0015\tI$(A\u0002tc2T!a\u000f\u001f\u0002\u000b\t\fGo\u00195\u000b\u0005ur\u0014a\u0002:v]RLW.\u001a\u0006\u0003\u007f\u0001\u000bq\u0001\u001d7b]:,'O\u0003\u0002B\u0005\u0006)A/\u00192mK*\u00111\tR\u0001\u0006M2Lgn\u001b\u0006\u0003\u000b\u001a\u000ba!\u00199bG\",'\"A$\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0005CA&O\u001b\u0005a%BA'=\u0003\u0015)H/\u001b7t\u0013\tyEJA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0003\"a\u0015\u0001\u000e\u0003a\n\u0011aX\u000b\u0002-B\u0019q\u000b\u00180\u000e\u0003aS!!\u0017.\u0002\u0013Q,7\u000f^;uS2\u001c(BA.C\u0003\u0011\u0019wN]3\n\u0005uC&aE#bG\"\u001c\u0015\r\u001c7cC\u000e\\wK]1qa\u0016\u0014\bCA0b\u001b\u0005\u0001'BA'A\u0013\t\u0011\u0007M\u0001\nMK\u001e\f7-\u001f*po\u0016CH/\u001a8tS>t\u0017AA0!Q\t\u0019Q\r\u0005\u0002g_6\tqM\u0003\u0002iS\u0006IQ\r\u001f;f]NLwN\u001c\u0006\u0003U.\f1!\u00199j\u0015\taW.A\u0004kkBLG/\u001a:\u000b\u000594\u0015!\u00026v]&$\u0018B\u00019h\u0005E\u0011VmZ5ti\u0016\u0014X\t\u001f;f]NLwN\\\u0001\u0007E\u00164wN]3\u0015\u0003M\u0004\"\u0001^<\u000e\u0003UT\u0011A^\u0001\u0006g\u000e\fG.Y\u0005\u0003qV\u0014A!\u00168ji\"\u0012AA\u001f\t\u0003wrl\u0011![\u0005\u0003{&\u0014!BQ3g_J,W)Y2i\u0003\t\"Xm\u001d;J]N,'\u000f^,ji\"|U\u000f\u001e)beRLG/[8o\u000fJ|W\u000f]5oO\"\u001aQ!!\u0001\u0011\u0007m\f\u0019!C\u0002\u0002\u0006%\u0014A\u0001V3ti\u0006yB/Z:u\u0013:\u001cXM\u001d;XSRD\u0007+\u0019:uSRLwN\\$s_V\u0004\u0018N\\4)\u0007\u0019\t\t!\u0001\u0010uKN$\u0018J\\:feR<\u0016\u000e\u001e5Ti\u0006$\u0018n\u0019)beRLG/[8og\"\u001aq!!\u0001\u0002QQ,7\u000f^%og\u0016\u0014HoV5uQN#\u0018\r^5d\u0003:$G)\u001f8b[&\u001c\u0007+\u0019:uSRLwN\\:)\u0007!\t\t!\u0001\u0016uKN$\u0018J\\:feR<\u0016\u000e\u001e5Ti\u0006$\u0018n\u0019)beRLG/[8o\u0003:$7\u000b^1s'>,(oY3)\u0007%\t\t!\u0001\u0017uKN$\u0018J\\:feR<\u0016\u000e\u001e5Ti\u0006$\u0018n\u0019)beRLG/[8o\u0003:$g+\u00197vKN\u001cv.\u001e:dK\"\u001a!\"!\u0001\u0002OQ,7\u000f^*uCRL7\rU1si&$\u0018n\u001c8O_RLe\u000eU1si&$\u0018n\u001c8GS\u0016dGm\u001d\u0015\u0004\u0017\u0005\u0005\u0011!\f;fgRLen]3siN#\u0018\r^5d!\u0006\u0014H/\u001b;j_:|eNT8o!\u0006\u0014H/\u001b;j_:,GmU5oW\"\u001aA\"!\u0001\u0002#I,w-[:uKJ$\u0016M\u00197f'&t7\u000eF\u0005t\u0003O\t\t%a\u0016\u0002b!I\u0011\u0011F\u0007\u0011\u0002\u0003\u0007\u00111F\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!!\f\u0002<9!\u0011qFA\u001c!\r\t\t$^\u0007\u0003\u0003gQ1!!\u000eI\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H;\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI$\u001e\u0005\n\u0003\u0007j\u0001\u0013!a\u0001\u0003\u000b\nqA]8x)f\u0004X\r\u0005\u0003\u0002H\u0005MSBAA%\u0015\u0011\tY%!\u0014\u0002\u0013QL\b/Z;uS2\u001c(\u0002BA(\u0003#\nAA[1wC*\u0011!NQ\u0005\u0005\u0003+\nIEA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\"CA-\u001bA\u0005\t\u0019AA.\u0003!9'o\\;qS:<\u0007c\u0001;\u0002^%\u0019\u0011qL;\u0003\u000f\t{w\u000e\\3b]\"I\u00111M\u0007\u0011\u0002\u0003\u0007\u0011QM\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u0004R\u0001^A4\u0003WI1!!\u001bv\u0005\u0015\t%O]1z\u0003m\u0011XmZ5ti\u0016\u0014H+\u00192mKNKgn\u001b\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000e\u0016\u0005\u0003W\t\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\ti(^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m\u0011XmZ5ti\u0016\u0014H+\u00192mKNKgn\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0011\u0016\u0005\u0003\u000b\n\t(A\u000esK\u001eL7\u000f^3s)\u0006\u0014G.Z*j].$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bSC!a\u0017\u0002r\u0005Y\"/Z4jgR,'\u000fV1cY\u0016\u001c\u0016N\\6%I\u00164\u0017-\u001e7uIQ*\"!a%+\t\u0005\u0015\u0014\u0011O\u0001\u0018!\u0006\u0014H/\u001b;j_:\f'\r\\3TS:\\\u0017\nV\"bg\u0016\u0004\"aU\n\u0014\u0007M\tY\nE\u0002u\u0003;K1!a(v\u0005\u0019\te.\u001f*fMR\u0011\u0011qS\u0001\u0006if\u0004X\rN\u000b\u0003\u0003\u000b\na\u0001^=qKR\u0002\u0013a\u0004;za\u0016|\u0016N\u001c;`gR\u0014\u0018N\\4\u0002!QL\b/Z0j]R|6\u000f\u001e:j]\u001e\u0004\u0013a\u0002*F'VcE+M\u000b\u0003\u0003c\u0003b!a-\u0002<\u0006-RBAA[\u0015\u0011\t9,!/\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001fJA!!0\u00026\nQA*\u001b8lK\u0012d\u0015n\u001d;\u0002\u0011I+5+\u0016'Uc\u0001\nqAU#T+2#&'\u0001\u0005S\u000bN+F\n\u0016\u001a!\u0003\u001d\u0011ViU+M)N\n\u0001BU#T+2#6\u0007I\u0001\r%\u0016\u001bV\u000b\u0014+`#V+U+R\u000b\u0003\u0003\u001b\u0004b!a-\u0002P\u0006E\u0016\u0002BAi\u0003k\u0013A\u0001T5ti\u0006i!+R*V\u0019R{\u0016+V#V\u000b\u0002\nA!\u001b8ji\nARK\\:bM\u0016lU-\\8ssNKgn\u001b$v]\u000e$\u0018n\u001c8\u0014\u0007\t\nY\u000e\u0005\u0004\u0002^\u0006E\u0018Q_\u0007\u0003\u0003?TA!!9\u0002d\u00061A.Z4bGfTA!!:\u0002h\u0006!1/\u001b8l\u0015\u0011\tI/a;\u0002\u0013\u0019,hn\u0019;j_:\u001c(b\u00016\u0002n*\u0019\u0011q\u001e\"\u0002\u0013M$(/Z1nS:<\u0017\u0002BAz\u0003?\u0014\u0001CU5dQNKgn\u001b$v]\u000e$\u0018n\u001c8\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?C\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty0!?\u0003\u0007I{w/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\u0004bA!\u0002\u0003\u0010\u0005UXB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\u0011QL\b/Z5oM>TAA!\u0004\u0002R\u000511m\\7n_:LAA!\u0005\u0003\b\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0006\u0003\u0003\u0016\te\u0001c\u0001B\fE5\t1\u0003C\u0004\u0003\u0002\u0011\u0002\rAa\u0001\u0002\u0013I,7/\u001e7u'\u0016$\u0018!\u0004:fgVdGoU3u?\u0012*\u0017\u000fF\u0002t\u0005CA\u0011Ba\t'\u0003\u0003\u0005\r!!-\u0002\u0007a$\u0013'\u0001\u0006sKN,H\u000e^*fi\u0002\nAa\u001c9f]R\u00191Oa\u000b\t\u000f\t5\u0002\u00061\u0001\u00030\u0005Yq\u000e]3o\u0007>tG/\u001a=u!\u0011\u0011\tD!\u000e\u000e\u0005\tM\"\u0002BAu\u0005\u0017IAAa\u000e\u00034\tYq\n]3o\u0007>tG/\u001a=u\u0003\u0019IgN^8lKR\u00191O!\u0010\t\u000f\t}\u0012\u00061\u0001\u0002v\u0006\u0019!o\\<)\u000b%\u0012\u0019Ea\u0017\u0011\u000bQ\u0014)E!\u0013\n\u0007\t\u001dSO\u0001\u0004uQJ|wo\u001d\t\u0005\u0005\u0017\u0012)F\u0004\u0003\u0003N\tEc\u0002BA\u0019\u0005\u001fJ\u0011A^\u0005\u0004\u0005'*\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005/\u0012IFA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019!1K;2\u000fy\tYC!\u0018\u0003\nFJ1Ea\u0018\u0003h\t}$\u0011N\u000b\u0005\u0005C\u0012\u0019'\u0006\u0002\u0002,\u00119!Q\r%C\u0002\t=$!\u0001+\n\t\t%$1N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\t5T/\u0001\u0004uQJ|wo]\t\u0005\u0005c\u00129\bE\u0002u\u0005gJ1A!\u001ev\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BA!\u001f\u0003|9\u0019AO!\u0015\n\t\tu$\u0011\f\u0002\n)\"\u0014xn^1cY\u0016\f\u0014b\tBA\u0005\u0007\u0013)I!\u001c\u000f\u0007Q\u0014\u0019)C\u0002\u0003nU\fTA\t;v\u0005\u000f\u0013Qa]2bY\u0006\f4A\nB%\u0003)1\u0017.\u001a7e\u001d\u0006lWm]\u000b\u0003\u0005\u001f\u0003R\u0001^A4\u0005#\u0003BAa%\u0003\u001a6\u0011!Q\u0013\u0006\u0005\u0005/\u000bI,\u0001\u0003mC:<\u0017\u0002BA\u001f\u0005+\u000b1BZ5fY\u0012t\u0015-\\3tA\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0003\"B)A/a\u001a\u0003$B!!Q\u0015BW\u001b\t\u00119K\u0003\u0003\u0003*\n-\u0016a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003w\u0004\u0015\u0002\u0002BX\u0005O\u00131\u0002T8hS\u000e\fG\u000eV=qK\u0006IA-\u0019;b)f\u0004X\rI\u0001\u000eI\u0006$\u0018MT;mY\u0006\u0014G.Z:\u0016\u0005\t]\u0006#\u0002;\u0002h\u0005m\u0013A\u00043bi\u0006tU\u000f\u001c7bE2,7\u000fI\u0001\ti\u0016\u001cH\u000fR1uCV\u0011!q\u0018\t\u0007\u0005\u0003\u00149-!>\u000e\u0005\t\r'b\u0001Bck\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%'1\u0019\u0002\u0004'\u0016\f\u0018!\u0003;fgR$\u0015\r^1!\u0003%!Xm\u001d;ECR\f\u0017'\u0001\u0006uKN$H)\u0019;bc\u0001\n\u0011\u0002^3ti\u0012\u000bG/\u0019\u001a\u0002\u0015Q,7\u000f\u001e#bi\u0006\u0014\u0004\u0005F\u0006t\u0005/\u0014)Oa:\u0003j\n-\bb\u0002Bmm\u0001\u0007!1\\\u0001\u0005i\u0016sg\u000f\u0005\u0003\u0003^\n\u0005XB\u0001Bp\u0015\tQ\u0007)\u0003\u0003\u0003d\n}'\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011\u001d\tIC\u000ea\u0001\u0003WAq!a\u00117\u0001\u0004\t)\u0005C\u0004\u0002ZY\u0002\r!a\u0017\t\u000f\u0005\rd\u00071\u0001\u0002f\u0001")
public class PartitionableSinkITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    public static Seq<Row> testData2() {
        return PartitionableSinkITCase$.MODULE$.testData2();
    }

    public static Seq<Row> testData1() {
        return PartitionableSinkITCase$.MODULE$.testData1();
    }

    public static Seq<Row> testData() {
        return PartitionableSinkITCase$.MODULE$.testData();
    }

    public static boolean[] dataNullables() {
        return PartitionableSinkITCase$.MODULE$.dataNullables();
    }

    public static LogicalType[] dataType() {
        return PartitionableSinkITCase$.MODULE$.dataType();
    }

    public static String[] fieldNames() {
        return PartitionableSinkITCase$.MODULE$.fieldNames();
    }

    public static void init() {
        PartitionableSinkITCase$.MODULE$.init();
    }

    public static java.util.List<LinkedList<String>> RESULT_QUEUE() {
        return PartitionableSinkITCase$.MODULE$.RESULT_QUEUE();
    }

    public static LinkedList<String> RESULT3() {
        return PartitionableSinkITCase$.MODULE$.RESULT3();
    }

    public static LinkedList<String> RESULT2() {
        return PartitionableSinkITCase$.MODULE$.RESULT2();
    }

    public static LinkedList<String> RESULT1() {
        return PartitionableSinkITCase$.MODULE$.RESULT1();
    }

    public static RowTypeInfo type_int_string() {
        return PartitionableSinkITCase$.MODULE$.type_int_string();
    }

    public static RowTypeInfo type4() {
        return PartitionableSinkITCase$.MODULE$.type4();
    }

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(3);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)3));
        this.tEnv().getConfig().set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.registerCollection("nonSortTable", PartitionableSinkITCase$.MODULE$.testData(), TestData$.MODULE$.type3(), "a, b, c", PartitionableSinkITCase$.MODULE$.dataNullables());
        this.registerCollection("sortTable", PartitionableSinkITCase$.MODULE$.testData1(), TestData$.MODULE$.type3(), "a, b, c", PartitionableSinkITCase$.MODULE$.dataNullables());
        this.registerCollection("starTable", PartitionableSinkITCase$.MODULE$.testData2(), PartitionableSinkITCase$.MODULE$.type_int_string(), "b, c", new boolean[]{true, true});
        PartitionableSinkITCase$.MODULE$.init();
    }

    @Test
    public void testInsertWithOutPartitionGrouping() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable select a, max(b), c from nonSortTable group by a, c").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyInAnyOrderElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,5,Hi", (List)new .colon.colon((Object)"1,5,Hi01", (List)new .colon.colon((Object)"1,5,Hi02", (List)Nil$.MODULE$)))));
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT2().isEmpty()).isTrue();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyInAnyOrderElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,1,Hello world01", "2,1,Hello world02", "2,1,Hello world03", "2,1,Hello world04", "2,2,Hello world, how are you?", "3,1,Hello world", "3,2,Hello", "3,2,Hello01", "3,2,Hello02", "3,2,Hello03", "3,2,Hello04"}))));
    }

    @Test
    public void testInsertWithPartitionGrouping() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable select a, b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)new .colon.colon((Object)"4,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,2,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,3,I'm fine, thank", (List)new .colon.colon((Object)"3,3,I'm fine, thank you", (List)new .colon.colon((Object)"3,3,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitions() {
        this.registerTableSink(this.registerTableSink$default$1(), this.registerTableSink$default$2(), this.registerTableSink$default$3(), this.registerTableSink$default$4());
        this.tEnv().executeSql("insert into sinkTable partition(a=1) select b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,Hi", "1,1,Hello world", "1,2,Hello", "1,1,Hello world, how are you?", "1,3,I'm fine, thank", "1,3,I'm fine, thank you", "1,3,I'm fine, thank you, and you?", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", "1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f"}))));
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT2().isEmpty()).isTrue();
        Assertions.assertThat((boolean)PartitionableSinkITCase$.MODULE$.RESULT3().isEmpty()).isTrue();
    }

    @Test
    public void testInsertWithStaticAndDynamicPartitions() {
        String[] x$1 = (String[])((Object[])new String[]{"a", "b"});
        String x$2 = this.registerTableSink$default$1();
        RowTypeInfo x$3 = this.registerTableSink$default$2();
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$2, x$3, x$4, x$1);
        this.tEnv().executeSql("insert into sinkTable partition(a=1) select b, c from sortTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)new .colon.colon((Object)"1,4,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,2,Hi", (List)new .colon.colon((Object)"1,2,Hello", (List)new .colon.colon((Object)"1,3,I'm fine, thank", (List)new .colon.colon((Object)"1,3,I'm fine, thank you", (List)new .colon.colon((Object)"1,3,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitionAndStarSource() {
        String[] x$1 = (String[])((Object[])new String[]{"b", "c"});
        String x$2 = this.registerTableSink$default$1();
        RowTypeInfo x$3 = this.registerTableSink$default$2();
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$2, x$3, x$4, x$1);
        this.tEnv().executeSql("insert into sinkTable partition(b=1) select * from starTable").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)new .colon.colon((Object)"3,1,I'm fine, thank you", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba", (List)Nil$.MODULE$))))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u4f60\u6765\u81ea\u54ea\u91cc\uff1f", (List)Nil$.MODULE$))));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,1,Hello", (List)new .colon.colon((Object)"1,1,Hello world", (List)new .colon.colon((Object)"2,1,Hi", (List)new .colon.colon((Object)"3,1,I'm fine, thank", (List)new .colon.colon((Object)"3,1,I'm fine, thank you, and you?", (List)Nil$.MODULE$)))))));
    }

    @Test
    public void testInsertWithStaticPartitionAndValuesSource() {
        String[] x$1 = (String[])((Object[])new String[]{"b", "c"});
        String x$2 = this.registerTableSink$default$1();
        RowTypeInfo x$3 = this.registerTableSink$default$2();
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$2, x$3, x$4, x$1);
        this.tEnv().executeSql("insert into sinkTable partition(b=1)\n(values (1, 'Hello world, how are you?'), (4, '\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f'), (2, 'Hello'))").await();
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT1()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"1,1,Hello world, how are you?", (List)Nil$.MODULE$)));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT2()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"4,1,\u4f60\u597d\uff0c\u964c\u751f\u4eba\uff0c\u6211\u662f", (List)Nil$.MODULE$)));
        Assertions.assertThatIterable(PartitionableSinkITCase$.MODULE$.RESULT3()).containsExactlyElementsOf((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"2,1,Hello", (List)Nil$.MODULE$)));
    }

    @Test
    public void testStaticPartitionNotInPartitionFields() {
        String x$1 = "sinkTable2";
        RowTypeInfo x$2 = PartitionableSinkITCase$.MODULE$.type4();
        String[] x$3 = (String[])((Object[])new String[]{"a", "b"});
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$1, x$2, x$4, x$3);
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("insert into sinkTable2 partition(c=1) select a, b from sortTable").await()).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testInsertStaticPartitionOnNonPartitionedSink() {
        String x$1 = "sinkTable2";
        RowTypeInfo x$2 = PartitionableSinkITCase$.MODULE$.type4();
        String[] x$3 = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        boolean x$4 = this.registerTableSink$default$3();
        this.registerTableSink(x$1, x$2, x$4, x$3);
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("insert into sinkTable2 partition(c=1) select a, b from sortTable").await()).isInstanceOf(TableException.class);
    }

    private void registerTableSink(String tableName, RowTypeInfo rowType, boolean grouping, String[] partitionColumns) {
        PartitionableSinkITCase$.MODULE$.registerTableSink(this.tEnv(), tableName, rowType, grouping, partitionColumns);
    }

    private String registerTableSink$default$1() {
        return "sinkTable";
    }

    private RowTypeInfo registerTableSink$default$2() {
        return TestData$.MODULE$.type3();
    }

    private boolean registerTableSink$default$3() {
        return true;
    }

    private String[] registerTableSink$default$4() {
        return (String[])((Object[])new String[]{"a"});
    }

    public static class UnsafeMemorySinkFunction
    extends RichSinkFunction<Row> {
        private LinkedList<String> resultSet;

        private LinkedList<String> resultSet() {
            return this.resultSet;
        }

        private void resultSet_$eq(LinkedList<String> x$1) {
            this.resultSet = x$1;
        }

        public void open(OpenContext openContext) {
            int taskId = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
            this.resultSet_$eq(PartitionableSinkITCase$.MODULE$.RESULT_QUEUE().get(taskId));
        }

        public void invoke(Row row) throws Exception {
            this.resultSet().add(row.toString());
        }

        public UnsafeMemorySinkFunction(TypeInformation<Row> outputType) {
        }
    }
}

