/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.stream.table.PythonAggregateTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.runtime.dataview.ListViewSpec;
import org.apache.flink.table.runtime.dataview.MapViewSpec;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00053A\u0001C\u0005\u00013!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0001K!)q\u0007\u0001C\u0001K!)\u0011\b\u0001C\u0001K!)1\b\u0001C\u0001K!)Q\b\u0001C\u0001K!)q\b\u0001C\u0001K\t\u0019\u0002+\u001f;i_:\fum\u001a:fO\u0006$X\rV3ti*\u0011!bC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00195\taa\u001d;sK\u0006l'B\u0001\b\u0010\u0003\u0011\u0001H.\u00198\u000b\u0005A\t\u0012a\u00029mC:tWM\u001d\u0006\u0003\u0015IQ!a\u0005\u000b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u001f\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005I\u0011a\t;fgR\u0004\u0016\u0010\u001e5p]\u001e\u0013x.\u001e9BO\u001e\u0014XmZ1uK^KG\u000f[8vi.+\u0017p\u001d\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t!QK\\5uQ\t\u0011Q\u0006\u0005\u0002/k5\tqF\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0005I\u001a\u0014a\u00026va&$XM\u001d\u0006\u0003iY\tQA[;oSRL!AN\u0018\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cH\u000fU=uQ>twI]8va\u0006;wM]3hCR,\u0007FA\u0002.\u0003}!Xm\u001d;NSb,G-V:f!f$\bn\u001c8BO\u001e\fe\u000e\u001a&bm\u0006\fum\u001a\u0015\u0003\t5\n\u0001\u0004^3ti\u0016CHO]1di\u0012\u000bG/\u0019,jK^\u001c\u0006/Z2tQ\t)Q&A\u0012uKN$X\t\u001f;sC\u000e$8+Z2p]\u0012dUM^3m\t\u0006$\u0018MV5foN\u0003XmY:)\u0005\u0019i\u0013A\u000b;fgR,\u0005\u0010\u001e:bGR$\u0015\r^1WS\u0016<8\u000b]3dg\u001a\u0013x.\\*ueV\u001cG/\u001e:fIRK\b/\u001a\u0015\u0003\u000f5\u0002")
public class PythonAggregateTest
extends TableTestBase {
    @Test
    public void testPythonGroupAggregateWithoutKeys() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table sourceTable = util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.table.PythonAggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        JavaUserDefinedAggFunctions.TestPythonAggregateFunction func = new JavaUserDefinedAggFunctions.TestPythonAggregateFunction();
        Table resultTable = sourceTable.select(new Expression[]{package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)func, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))});
        util.verifyExecPlan(resultTable);
    }

    @Test
    public void testPythonGroupAggregate() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table sourceTable = util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.table.PythonAggregateTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        JavaUserDefinedAggFunctions.TestPythonAggregateFunction func = new JavaUserDefinedAggFunctions.TestPythonAggregateFunction();
        Table resultTable = sourceTable.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)func, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))});
        util.verifyExecPlan(resultTable);
    }

    @Test
    public void testMixedUsePythonAggAndJavaAgg() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table sourceTable = util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.table.PythonAggregateTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        JavaUserDefinedAggFunctions.TestPythonAggregateFunction func = new JavaUserDefinedAggFunctions.TestPythonAggregateFunction();
        Table resultTable = sourceTable.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)func, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()});
        util.verifyExecPlan(resultTable);
    }

    @Test
    public void testExtractDataViewSpecs() {
        DataType accType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)ListView.newListViewDataType((DataType)DataTypes.STRING())), DataTypes.FIELD((String)"f2", (DataType)MapView.newMapViewDataType((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT()))});
        DataViewSpec[] specs = CommonPythonUtil.extractDataViewSpecs((int)0, (DataType)accType);
        DataViewSpec[] expected = (DataViewSpec[])((Object[])new DataViewSpec[]{new ListViewSpec("agg0$f1", 1, (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).bridgedTo(List.class)), new MapViewSpec("agg0$f2", 2, (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT()).bridgedTo(Map.class), false)});
        Assertions.assertThat((Object)specs[0]).hasSameClassAs((Object)expected[0]);
        Assertions.assertThat((Object)specs[0].getDataType()).isEqualTo((Object)expected[0].getDataType());
        Assertions.assertThat((String)specs[0].getStateId()).isEqualTo(expected[0].getStateId());
        Assertions.assertThat((int)specs[0].getFieldIndex()).isEqualTo(expected[0].getFieldIndex());
        Assertions.assertThat((Object)specs[1]).hasSameClassAs((Object)expected[1]);
        Assertions.assertThat((Object)specs[1].getDataType()).isEqualTo((Object)expected[1].getDataType());
        Assertions.assertThat((String)specs[1].getStateId()).isEqualTo(expected[1].getStateId());
        Assertions.assertThat((int)specs[1].getFieldIndex()).isEqualTo(expected[1].getFieldIndex());
    }

    @Test
    public void testExtractSecondLevelDataViewSpecs() {
        DataType accType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)ListView.newListViewDataType((DataType)DataTypes.STRING()))}))});
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> CommonPythonUtil.extractDataViewSpecs((int)0, (DataType)accType));
    }

    @Test
    public void testExtractDataViewSpecsFromStructuredType() {
        DataType accType = DataTypes.STRUCTURED(Tuple1.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)ListView.newListViewDataType((DataType)DataTypes.STRING()))});
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> CommonPythonUtil.extractDataViewSpecs((int)0, (DataType)accType));
    }
}

