/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ColumnExpansionTest {
    private TableEnvironment tableEnv;

    ColumnExpansionTest() {
    }

    @BeforeEach
    void before() {
        this.tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        this.tableEnv.executeSql("CREATE TABLE t1 (\n  t1_i INT,\n  t1_s STRING,\n  t1_m_virtual INT METADATA VIRTUAL,\n  t1_m_aliased_virtual STRING METADATA FROM 'k1' VIRTUAL,\n  t1_m_default INT METADATA,\n  t1_m_aliased STRING METADATA FROM 'k2'\n) WITH (\n 'connector' = 'values',\n 'readable-metadata' = 't1_m_virtual:INT,k1:STRING,t1_m_default:INT,k2:STRING'\n)");
        this.tableEnv.executeSql("CREATE TABLE t2 (\n  t2_i INT,\n  t2_s STRING,\n  t2_m_virtual INT METADATA VIRTUAL,\n  t2_m_aliased_virtual STRING METADATA FROM 'k1' VIRTUAL,\n  t2_m_default INT METADATA,\n  t2_m_aliased STRING METADATA FROM 'k2'\n) WITH (\n 'connector' = 'values',\n 'readable-metadata' = 't2_m_virtual:INT,k1:STRING,t2_m_default:INT,k2:STRING'\n)");
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.emptyList());
    }

    @Test
    void testExcludeDefaultVirtualMetadataColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames(this.tableEnv.from("t1"), "t1_i", "t1_s", "t1_m_virtual", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.withAllColumns()}), "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.$((String)"t1_m_virtual"), Expressions.withAllColumns()}), "t1_m_virtual", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.$((String)"t1_m_virtual"), Expressions.withAllColumns()}).select(new Expression[]{Expressions.withAllColumns()}), "t1_m_virtual", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
    }

    @Test
    void testExcludeAliasedVirtualMetadataColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames(this.tableEnv.from("t1"), "t1_i", "t1_s", "t1_m_virtual", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.withAllColumns()}), "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.$((String)"t1_m_aliased_virtual"), Expressions.withAllColumns()}), "t1_m_aliased_virtual", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.$((String)"t1_m_aliased_virtual"), Expressions.withAllColumns()}).select(new Expression[]{Expressions.withAllColumns()}), "t1_m_aliased_virtual", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased");
    }

    @Test
    void testExcludeViaView() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Arrays.asList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS, TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.tableEnv.executeSql("CREATE VIEW v1 AS SELECT * FROM t1");
        this.assertColumnNames(this.tableEnv.from("v1"), "t1_i", "t1_s", "t1_m_default", "t1_m_aliased");
    }

    @Test
    void testExcludeViaWithColumn() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Arrays.asList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS, TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.withColumns((Object)Expressions.range((String)"t1_i", (String)"t1_m_aliased"), (Object[])new Object[0])}), "t1_i", "t1_s", "t1_m_default", "t1_m_aliased");
    }

    @Test
    void testExcludeViaWithoutColumn() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Arrays.asList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS, TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames(this.tableEnv.from("t1").select(new Expression[]{Expressions.withoutColumns((Object)Expressions.$((String)"t1_i"), (Object[])new Object[]{Expressions.$((String)"t1_s")})}), "t1_m_default", "t1_m_aliased");
    }

    private void assertColumnNames(Table query, String ... columnNames) {
        Assertions.assertThat((List)query.getResolvedSchema().getColumnNames()).containsExactly((Object[])columnNames);
    }
}

