/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionResultType;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001\u0002\u001d:\u00011CQ!\u0017\u0001\u0005\u0002iCq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006g\u0002!\t\u0001\u001a\u0005\u0006q\u0002!\t\u0001\u001a\u0005\u0006u\u0002!\t\u0001\u001a\u0005\u0006y\u0002!\t\u0001\u001a\u0005\u0006}\u0002!\t\u0001\u001a\u0005\u0007\u0003\u0003\u0001A\u0011\u00013\t\r\u0005\u0015\u0001\u0001\"\u0001e\u0011\u0019\tI\u0001\u0001C\u0001I\"1\u0011Q\u0002\u0001\u0005\u0002\u0011Da!!\u0005\u0001\t\u0003!\u0007BBA\u000b\u0001\u0011\u0005A\r\u0003\u0004\u0002\u001a\u0001!\t\u0001\u001a\u0005\u0007\u0003;\u0001A\u0011\u00013\t\r\u0005\u0005\u0002\u0001\"\u0001e\u0011\u0019\t)\u0003\u0001C\u0001I\"1\u0011\u0011\u0006\u0001\u0005\u0002\u0011Da!!\f\u0001\t\u0003!\u0007BBA\u0019\u0001\u0011\u0005A\r\u0003\u0004\u00026\u0001!\t\u0001\u001a\u0005\u0007\u0003s\u0001A\u0011\u00013\t\r\u0005u\u0002\u0001\"\u0001e\u0011\u0019\t\t\u0005\u0001C\u0001I\"1\u0011Q\t\u0001\u0005\u0002\u0011Da!!\u0013\u0001\t\u0003!\u0007BBA'\u0001\u0011\u0005A\r\u0003\u0004\u0002R\u0001!\t\u0001\u001a\u0005\u0007\u0003+\u0002A\u0011\u00013\t\r\u0005e\u0003\u0001\"\u0001e\u0011\u0019\ti\u0006\u0001C\u0001I\"1\u0011\u0011\r\u0001\u0005\u0002\u0011Da!!\u001a\u0001\t\u0003!\u0007BBA5\u0001\u0011\u0005A\r\u0003\u0004\u0002n\u0001!\t\u0001\u001a\u0005\u0007\u0003c\u0002A\u0011\u00013\t\r\u0005U\u0004\u0001\"\u0001e\u0011\u0019\tI\b\u0001C\u0001I\"1\u0011Q\u0010\u0001\u0005\u0002\u0011Da!!!\u0001\t\u0003!\u0007BBAC\u0001\u0011\u0005A\r\u0003\u0004\u0002\n\u0002!\t\u0001\u001a\u0005\u0007\u0003\u001b\u0003A\u0011\u00013\t\r\u0005E\u0005\u0001\"\u0001e\u0011\u0019\t)\n\u0001C\u0001I\"1\u0011\u0011\u0014\u0001\u0005\u0002\u0011Da!!(\u0001\t\u0003!\u0007BBAQ\u0001\u0011\u0005A\r\u0003\u0004\u0002&\u0002!\t\u0001\u001a\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\t9\u000e\u0001C\u0005\u00033D\u0011Ba\u0004\u0001#\u0003%IA!\u0005\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e\tqAj\\8lkBTu.\u001b8UKN$(B\u0001\u001e<\u0003\u0011Qw.\u001b8\u000b\u0005qj\u0014aA:rY*\u0011ahP\u0001\u0007gR\u0014X-Y7\u000b\u0005\u0001\u000b\u0015\u0001\u00029mC:T!AQ\"\u0002\u000fAd\u0017M\u001c8fe*\u0011A)R\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\r\u001e\u000bQA\u001a7j].T!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sO\u000e\u00011c\u0001\u0001N'B\u0011a*U\u0007\u0002\u001f*\u0011\u0001+Q\u0001\u0006kRLGn]\u0005\u0003%>\u0013Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001\\!\ta\u0006!D\u0001:\u0003\u0011)H/\u001b7\u0016\u0003}\u0003\"A\u00141\n\u0005\u0005|%aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013A\u00022fM>\u0014X\rF\u0001f!\t!f-\u0003\u0002h+\n!QK\\5uQ\t!\u0011\u000e\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u0019\u0011\r]5\u000b\u00059|\u0017a\u00026va&$XM\u001d\u0006\u0003a&\u000bQA[;oSRL!A]6\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0011uKN$(j\\5o\u0013:4\u0018\r\\5e\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007FA\u0003v!\tQg/\u0003\u0002xW\n!A+Z:u\u0003\t\"Xm\u001d;O_R$\u0015n\u001d;j]\u000e$hI]8n\u0013:Tu.\u001b8D_:$\u0017\u000e^5p]\"\u0012a!^\u0001\u001fi\u0016\u001cH/\u00138wC2LG\rT8pWV\u0004H+\u00192mK\u001a+hn\u0019;j_:D#aB;\u00027Q,7\u000f\u001e&pS:|e\u000eR5gM\u0016\u0014XM\u001c;LKf$\u0016\u0010]3tQ\tAQ/A\u000buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005%)\u0018!\u0007;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016D#AC;\u0002IQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b(fgR,G-U;fefD#aC;\u0002WQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)s_*,7\r^5p]B+8\u000f\u001b#po:D#\u0001D;\u0002OQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0003\u001bU\fQ\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e\u000bGn\u0019)vg\"$un\u001e8)\u00059)\u0018!\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"lU\u000f\u001c;j\u0013:$W\r_\"pYVlg\u000e\u000b\u0002\u0010k\u0006QB/Z:u\u0003Z|\u0017\u000eZ!hOJ,w-\u0019;f!V\u001c\b\u000eR8x]\"\u0012\u0001#^\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000e\u0016:vK\u000e{g\u000eZ5uS>t\u0007FA\tv\u0003U\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Gk:\u001cG/[8o\u0003:$7i\u001c8ti\u0006tGoQ8oI&$\u0018n\u001c8)\u0005I)\u0018A\u000f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"lU\u000f\u001c;j\rVt7\r^5p]\u0006sGmQ8ogR\fg\u000e^\"p]\u0012LG/[8oQ\t\u0019R/\u0001\u001cuKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDg)\u001e8di&|g.\u00118e%\u00164WM]3oG\u0016\u001cuN\u001c3ji&|g\u000e\u000b\u0002\u0015k\u00069C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i+\u00124W)];bY\u001aKG\u000e^3sQ\t)R/A\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0007F\u0001\fv\u0003I\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8B]\u0012\u0004Vo\u001d5E_^t\u0007FA\fv\u0003U\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018nQ8oI&$\u0018n\u001c8P]N\u000bW.\u001a#j[\u001aKW\r\u001c3)\u0005a)\u0018A\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u001c\u0015m\u001d;P]2{wn[;q)\u0006\u0014G.\u001a\u0015\u00033U\fq\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ&sG/\u001a:pa\u0016\u0014\u0018M\u00197f\u0007\u0006\u001cHo\u00148M_>\\W\u000f\u001d+bE2,\u0007F\u0001\u000ev\u0003q!Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D)\u0016C#aG;\u0002aQ,7\u000f^!hO\u0006sG-\u00117m\u0007>t7\u000f^1oi2{wn[;q\u0017\u0016Lx+\u001b;i)JL(+Z:pYZ,Wj\u001c3fQ\taR/A\nuKN$\u0018J\u001c<bY&$'j\\5o\u0011&tG\u000f\u000b\u0002\u001ek\u0006QB/Z:u\u0015>Lg\u000eS5oi^KG\u000f\u001b+bE2,\u0017\t\\5bg\"\u0012a$^\u0001\u001ei\u0016\u001cHOS8j]\"Kg\u000e^,ji\"$\u0016M\u00197f\u001d\u0006lWm\u00148ms\"\u0012q$^\u0001'i\u0016\u001cH/T;mi&\u0004H.\u001a&pS:D\u0015N\u001c;t/&$\bnU1nKR\u000b'\r\\3OC6,\u0007F\u0001\u0011v\u0003\u001d\"Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0015>Lg\u000eS5oiN<\u0016\u000e\u001e5TC6,G+\u00192mK\u0006c\u0017.Y:)\u0005\u0005*\u0018a\u000b;fgRlU\u000f\u001c;ja2,'j\\5o\u0011&tGo],ji\"$\u0015N\u001a4fe\u0016tG\u000fV1cY\u0016t\u0015-\\3)\u0005\t*\u0018\u0001\f;fgRlU\u000f\u001c;ja2,'j\\5o\u0011&tGo],ji\"$\u0015N\u001a4fe\u0016tG\u000fV1cY\u0016\fE.[1tQ\t\u0019S/\u0001\u0010uKN$(j\\5o'ft7\rV1cY\u0016<\u0016\u000e\u001e5Bgft7\rS5oi\"\u0012A%^\u0001 i\u0016\u001cHOS8j]\u0006\u001b\u0018P\\2UC\ndWmV5uQ\u0006\u001b\u0018P\\2IS:$\bFA\u0013v\u0003y!Xm\u001d;K_&t\u0017i]=oGR\u000b'\r\\3XSRD7+\u001f8d\u0011&tG\u000f\u000b\u0002'k\u0006\u0001C/Z:u\u0003\u001e<\u0017I\u001c3MK\u001a$(j\\5o\u00032dwn^+o_J$WM]3eQ\t9S/\u0001\u0013uKN$\u0018iZ4B]\u0012dUM\u001a;K_&tw+\u001b;i)JL(+Z:pYZ,Wj\u001c3fQ\tAS/\u0001\u0010uKN$\u0018i]=oG*{\u0017N\\,ji\"$UMZ1vYR\u0004\u0016M]1ng\"\u0012\u0011&^\u0001\u0016i\u0016\u001cHOS8j]^KG\u000f[!ts:\u001c\u0007*\u001b8uQ\tQS/A\u000buKN$(j\\5o/&$\bNU3uefD\u0015N\u001c;)\u0005-*\u0018!\b;fgRTu.\u001b8XSRD\u0017i]=oG\u0006sGMU3uefD\u0015N\u001c;)\u00051*\u0018!\b;fgRTu.\u001b8XSRDW*\u001b=fI\u000e\u000b7/\u001a&pS:D\u0015N\u001c;)\u00055*\u0018a\n;fgRTu.\u001b8IS:$x+\u001b;i\u001d>\u0004&o\u001c9bO\u0006$\u0018N\\4U_N+(-U;fefD#AL;\u0002UQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[*ik\u001a4G.\u001a'p_.,\b\u000fS5oi\"\u0012q&^\u0001.i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bNT8u'\",hM\u001a7f\u0019>|7.\u001e9IS:$\bF\u0001\u0019v\u0003i\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5TQV4g\r\\3M_>\\W\u000f\u001d%j]R,U\u000e\u001d;z!\u0006\u0014H/\u001b;j_:,'\u000f\u000b\u00022k\u0006)E/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000eLen]3si>sG._%oaV$8)^:u_6\u001c\u0006.\u001e4gY\u0016D#AM;\u0002\u0003R,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d+B\u001cXM\u001d;J]B,HoQ;ti>l7\u000b[;gM2,\u0007FA\u001av\u0003E\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u000b\u0006K\u00065\u0016q\u0019\u0005\b\u0003_#\u0004\u0019AAY\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0003\u00024\u0006\u0005g\u0002BA[\u0003{\u00032!a.V\u001b\t\tILC\u0002\u0002<.\u000ba\u0001\u0010:p_Rt\u0014bAA`+\u00061\u0001K]3eK\u001aLA!a1\u0002F\n11\u000b\u001e:j]\u001eT1!a0V\u0011\u001d\tI\r\u000ea\u0001\u0003\u0017\fa\u0002\\8pWV\u0004h)\u001e8di&|g\u000e\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\tnQ\u0001\nMVt7\r^5p]NLA!!6\u0002P\n\u0019Rk]3s\t\u00164\u0017N\\3e\rVt7\r^5p]\u0006)R\r\u001f9fGR,\u0005pY3qi&|g\u000e\u00165s_^tGcB3\u0002\\\u0006u\u0017\u0011\u001d\u0005\u0007yU\u0002\r!!-\t\u000f\u0005}W\u00071\u0001\u00022\u00069Q.Z:tC\u001e,\u0007\"CArkA\u0005\t\u0019AAs\u0003\u0015\u0019G.\u0019>{a\u0011\t9/!=\u0011\r\u0005M\u0016\u0011^Aw\u0013\u0011\tY/!2\u0003\u000b\rc\u0017m]:\u0011\t\u0005=\u0018\u0011\u001f\u0007\u0001\t1\t\u00190!9\u0002\u0002\u0003\u0005)\u0011AA{\u0005\ryF%M\t\u0005\u0003o\fi\u0010E\u0002U\u0003sL1!a?V\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a@\u0003\n9!!\u0011\u0001B\u0003\u001d\u0011\t9La\u0001\n\u0003YK1Aa\u0002V\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0003\u0003\u000e\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u000f)\u0016aH3ya\u0016\u001cG/\u0012=dKB$\u0018n\u001c8UQJ|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0003\u0019\u0005\u0005+\u0011I\u0002\u0005\u0004\u00024\u0006%(q\u0003\t\u0005\u0003_\u0014I\u0002B\u0006\u0002tZ\n\t\u0011!A\u0003\u0002\u0005U\u0018\u0001\u0007<fe&4\u0017\u0010\u0016:b]Nd\u0017\r^5p]N+8mY3tgR\u0019QMa\b\t\rq:\u0004\u0019AAY\u0001")
public class LookupJoinTest
extends TableTestBase
implements scala.Serializable {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE AsyncLookupTable (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'async' = 'true'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTableWithComputedColumn (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT,\n                    |  `nominal_age` as age + 1\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTableWithCustomShuffle1 (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT,\n                    |  PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'enable-custom-shuffle' = 'true'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTableWithCustomShuffle2 (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT,\n                    |  PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'enable-custom-shuffle' = 'true',\n                    |  'custom-shuffle-deterministic' = 'false'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTableWithCustomShuffle3 (\n                    |  `id` INT,\n                    |  `name` STRING,\n                    |  `age` INT,\n                    |  PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'enable-custom-shuffle' = 'true',\n                    |  'custom-shuffle-empty-partitioner' = 'true'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE UpsertSource (\n                    |  `a` int,\n                    |  `b` varchar,\n                    |  `c` bigint,\n                    |  `proctime` AS PROCTIME()\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'changelog-mode' = 'I,UA,UB,D'\n                    |)")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Sink1 (\n                    |  a int,\n                    |  name varchar,\n                    |  age int\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'sink-insert-only' = 'false'\n                    |)")).stripMargin());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proctime AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", "Correlate has invalid join type RIGHT", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 2", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testInvalidLookupTableFunction() {
        this.util().addDataStream("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.createLookupTable("LookupTable1", (UserDefinedFunction)new InvalidTableFunctionResultType());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "output class can simply be a Row or RowData class", ValidationException.class);
        this.createLookupTable("LookupTable2", (UserDefinedFunction)new InvalidTableFunctionEvalSignature());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature' for function 'default_catalog.default_database.LookupTable2' that matches the following signature:\nvoid eval(java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable3", (UserDefinedFunction)new TableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable4", (UserDefinedFunction)new TableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable4 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable5", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable5 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable6", (UserDefinedFunction)new AsyncTableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable6 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable7", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature1());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable7 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1' for function 'default_catalog.default_database.LookupTable7' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable8", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature2());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable8 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2' for function 'default_catalog.default_database.LookupTable8' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, java.lang.String, java.time.LocalDateTime)", ValidationException.class);
        this.createLookupTable("LookupTable9", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable9 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable10", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature3());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable10 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3' for function 'default_catalog.default_database.LookupTable10' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
    }

    @Test
    public void testJoinOnDifferentKeyTypes() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id")).hasMessageContaining("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now") instanceof TableException;
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCalcPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE cast(D.name as bigint) > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiIndexColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND D.name = 'AAA'\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proc\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proc AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]") instanceof TableException;
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id + 1 AND T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndReferenceCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND T.b = concat(D.name, '!')\n        |WHERE D.name LIKE 'Jack%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name\n        |FROM\n        |  MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiConditionOnSameDimField() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id and CAST(T.c as INT) = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` decimal(38, 18),\n                    |  `name` STRING,\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.a = CAST(LookupTable2.`id` as INT)\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.verifyTranslationSuccess(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable2]") instanceof TableException;
    }

    @Test
    public void testJoinTemporalTableWithInteroperableCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` INT,\n                    |  `name` char(10),\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.b = CAST(LookupTable2.`name` as String)\n        |")).stripMargin();
        this.verifyTranslationSuccess(sql);
    }

    @Test
    public void testJoinTemporalTableWithCTE() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH MyLookupTable AS (SELECT * FROM MyTable),\n        |OtherLookupTable AS (SELECT * FROM LookupTable)\n        |SELECT MyLookupTable.b FROM MyLookupTable\n        |JOIN OtherLookupTable FOR SYSTEM_TIME AS OF MyLookupTable.proctime AS D\n        |ON MyLookupTable.a = D.id AND D.age = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggAndAllConstantLookupKeyWithTryResolveMode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        | LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON D.id = 100\n      ")).stripMargin();
        String actual = this.util().tableEnv().explainSql(sql, new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expected = TableTestUtil$.MODULE$.readFromResource("explain/stream/join/lookup/testAggAndAllConstantLookupKeyWithTryResolveMode_newSource.out");
        Assertions.assertThat((String)TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(actual)))).isEqualTo(TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(expected))));
    }

    @Test
    public void testInvalidJoinHint() {
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('tableName'='LookupTable') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: incomplete required option(s): [Key: 'table' , default: null (fallback keys: [])]", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='yes') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'yes' for key 'async'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'output-mode'='allow-unordered') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'allow-unordered' for key 'output-mode'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'timeout'='300 si') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '300 si' for key 'timeout'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-strategy'='fixed-delay') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'fixed-delay'='100 nano sec') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100 nano sec' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100.0') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100.0' for key 'max-attempts'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: retry options can be both null or all not null", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='exception', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'exception', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: max-attempts value should be positive integer but was -3", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='-10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '-10s' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup-miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'lookup-miss', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed-delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
    }

    @Test
    public void testJoinHintWithTableAlias() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinHintWithTableNameOnly() {
        String sql = "SELECT /*+ LOOKUP('table'='LookupTable') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime ON T.a = LookupTable.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleJoinHintsWithSameTableName() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='AsyncLookupTable', 'output-mode'='ordered') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime\n        | ON T.a = AsyncLookupTable.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleJoinHintsWithSameTableAlias() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='D', 'output-mode'='ordered') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D \n        | ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleJoinHintsWithDifferentTableName() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime\n        |  ON T.a = AsyncLookupTable.id\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime\n        |  ON T.a = LookupTable.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleJoinHintsWithDifferentTableAlias() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered'),\n        |           LOOKUP('table'='D1', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D \n        |  ON T.a = D.id\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D1 \n        |  ON T.a = D1.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinSyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='true') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinAsyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='true') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinAsyncTableWithSyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'async'='false') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggAndLeftJoinAllowUnordered() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAggAndLeftJoinWithTryResolveMode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}))).hasMessageContaining("Required sync lookup function by planner, but table") instanceof TableException;
    }

    @Test
    public void testAsyncJoinWithDefaultParams() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |INSERT INTO Sink1\n                        |SELECT T.a, D.name, D.age\n                        |FROM MyTable T\n                        |JOIN AsyncLookupTable\n                        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n                        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithAsyncHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN LookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithAsyncAndRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithMixedCaseJoinHint() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LookuP('table'='D', 'retry-predicate'='lookup_miss',\n        |'retry-strategy'='fixed_delay', 'fixed-delay'='155 ms', 'max-attempts'='10',\n        |'async'='true', 'output-mode'='allow_unordered','capacity'='1000', 'time-out'='300 s')\n        |*/\n        |T.a\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n        |")).stripMargin());
    }

    @Test
    public void testJoinHintWithNoPropagatingToSubQuery() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='D', 'output-mode'='ordered','capacity'='200') */ T1.a\n        |FROM (\n        |   SELECT /*+ LOOKUP('table'='D', 'output-mode'='allow_unordered', 'capacity'='1000') */\n        |     T.a a, T.proctime\n        |   FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |     ON T.a = D.id\n        |) T1\n        |JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T1.proctime AS D\n        |ON T1.a=D.id\n        |")).stripMargin());
    }

    @Test
    public void testJoinTemporalTableWithShuffleLookupHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithNotShuffleLookupHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='false') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithShuffleLookupHintEmptyPartitioner() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithNonDeterministicInsertOnlyInputCustomShuffle() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithNonDeterministicUpsertInputCustomShuffle() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM UpsertSource AS T JOIN LookupTableWithCustomShuffle2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    private void createLookupTable(String tableName, UserDefinedFunction lookupFunction) {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("\n                     |CREATE TABLE ").append(tableName).append(" (\n                     |  `id` INT,\n                     |  `name` STRING,\n                     |  `age` INT,\n                     |  `ts` TIMESTAMP(3)\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'lookup-function-class' = '").append(lookupFunction.getClass().getName()).append("'\n                     |)\n                     |").toString())).stripMargin());
    }

    private void expectExceptionThrown(String sql, String message, Class<? extends Throwable> clazz) {
        Assertions.assertThatExceptionOfType(clazz).isThrownBy(() -> this.verifyTranslationSuccess(sql)).withMessageContaining(message);
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    private void verifyTranslationSuccess(String sql) {
        this.util().tableEnv().sqlQuery(sql).explain(new ExplainDetail[0]);
    }
}

