/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.agg.WindowAggregateTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\r-b\u0001\u00021b\u0001QD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0012\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0014\u0001\t\u0003\t\u0019\u0004C\u0004\u0002Z\u0001!\t!a\r\t\u000f\u0005u\u0003\u0001\"\u0001\u00024!9\u0011\u0011\r\u0001\u0005\u0002\u0005M\u0002bBA3\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003S\u0002A\u0011AA\u001a\u0011\u001d\ti\u0007\u0001C\u0001\u0003gAq!!\u001d\u0001\t\u0003\t\u0019\u0004C\u0004\u0002v\u0001!\t!a\r\t\u000f\u0005e\u0004\u0001\"\u0001\u00024!9\u0011Q\u0010\u0001\u0005\u0002\u0005M\u0002bBAA\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000b\u0003A\u0011AA\u001a\u0011\u001d\tI\t\u0001C\u0001\u0003gAq!!$\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\u0012\u0002!\t!a\r\t\u000f\u0005U\u0005\u0001\"\u0001\u00024!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005M\u0002bBAO\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003C\u0003A\u0011AA\u001a\u0011\u001d\t)\u000b\u0001C\u0001\u0003gAq!!+\u0001\t\u0003\t\u0019\u0004C\u0004\u0002.\u0002!\t!a\r\t\u000f\u0005E\u0006\u0001\"\u0001\u00024!9\u0011Q\u0017\u0001\u0005\u0002\u0005M\u0002bBA]\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003{\u0003A\u0011AA\u001a\u0011\u001d\t\t\r\u0001C\u0001\u0003gAq!!2\u0001\t\u0003\t\u0019\u0004C\u0004\u0002J\u0002!\t!a\r\t\u000f\u00055\u0007\u0001\"\u0001\u00024!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0002bBAk\u0001\u0011\u0005\u00111\u0007\u0005\b\u00033\u0004A\u0011AA\u001a\u0011\u001d\ti\u000e\u0001C\u0001\u0003gAq!!9\u0001\t\u0003\t\u0019\u0004C\u0004\u0002f\u0002!\t!a\r\t\u000f\u0005%\b\u0001\"\u0001\u00024!9\u0011Q\u001e\u0001\u0005\u0002\u0005M\u0002bBAy\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003k\u0004A\u0011AA\u001a\u0011\u001d\tI\u0010\u0001C\u0001\u0003gAq!!@\u0001\t\u0003\t\u0019\u0004C\u0004\u0003\u0002\u0001!\t!a\r\t\u000f\t\u0015\u0001\u0001\"\u0001\u00024!9!\u0011\u0002\u0001\u0005\u0002\u0005M\u0002b\u0002B\u0007\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005#\u0001A\u0011AA\u001a\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003gAqA!\u0007\u0001\t\u0003\t\u0019\u0004C\u0004\u0003\u001e\u0001!\t!a\r\t\u000f\t\u0005\u0002\u0001\"\u0001\u00024!9!Q\u0005\u0001\u0005\u0002\u0005M\u0002b\u0002B\u0015\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005[\u0001A\u0011AA\u001a\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0003gAqA!\u000e\u0001\t\u0003\t\u0019\u0004C\u0004\u0003:\u0001!\t!a\r\t\u000f\tu\u0002\u0001\"\u0001\u00024!9!\u0011\t\u0001\u0005\u0002\u0005M\u0002b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005[\u0002A\u0011AA\u001a\u0011\u001d\u0011\t\b\u0001C\u0001\u0003gAqA!\u001e\u0001\t\u0003\t\u0019\u0004C\u0004\u0003z\u0001!\t!a\r\t\u000f\tu\u0004\u0001\"\u0003\u00024!9!q\u0010\u0001\u0005\u0002\u0005M\u0002b\u0002BB\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005\u000f\u0003A\u0011AA\u001a\u0011\u001d\u0011Y\t\u0001C\u0001\u0003gAqAa$\u0001\t\u0003\t\u0019\u0004C\u0004\u0003\u0014\u0002!\t!a\r\t\u000f\t]\u0005\u0001\"\u0001\u00024!9!1\u0014\u0001\u0005\u0002\u0005M\u0002b\u0002BP\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005G\u0003A\u0011AA\u001a\u0011\u001d\u00119\u000b\u0001C\u0001\u0003gAqAa+\u0001\t\u0003\t\u0019\u0004C\u0004\u00030\u0002!\t!a\r\t\u000f\tM\u0006\u0001\"\u0001\u00024!9!q\u0017\u0001\u0005\u0002\u0005M\u0002b\u0002B^\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005\u007f\u0003A\u0011AA\u001a\u0011\u001d\u0011\u0019\r\u0001C\u0001\u0003g9qA!=b\u0011\u0003\u0011\u0019P\u0002\u0004aC\"\u0005!Q\u001f\u0005\b\u0003\u0013iF\u0011\u0001B\u007f\u0011\u001d\u0011y0\u0018C\u0001\u0007\u0003\u00111cV5oI><\u0018iZ4sK\u001e\fG/\u001a+fgRT!AY2\u0002\u0007\u0005<wM\u0003\u0002eK\u0006\u00191/\u001d7\u000b\u0005\u0019<\u0017AB:ue\u0016\fWN\u0003\u0002iS\u0006!\u0001\u000f\\1o\u0015\tQ7.A\u0004qY\u0006tg.\u001a:\u000b\u00051l\u0017!\u0002;bE2,'B\u00018p\u0003\u00151G.\u001b8l\u0015\t\u0001\u0018/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0006\u0019qN]4\u0004\u0001M\u0011\u0001!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003q&\fQ!\u001e;jYNL!A_<\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003A\twm\u001a)iCN,WI\u001c4pe\u000e,'\u000fE\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011AB2p]\u001aLwMC\u0002\u0002\u0004-\f1!\u00199j\u0013\r\t9A \u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\u00061A(\u001b8jiz\"B!!\u0004\u0002\u0012A\u0019\u0011q\u0002\u0001\u000e\u0003\u0005DQa\u001f\u0002A\u0002q\fA!\u001e;jYV\u0011\u0011q\u0003\t\u0004m\u0006e\u0011bAA\u000eo\n\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005Q\u0011n\u001d+x_BC\u0017m]3\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0005\u0005%\u0012!B:dC2\f\u0017\u0002BA\u0017\u0003O\u0011qAQ8pY\u0016\fg.A\u0006jgR;x\u000e\u00155bg\u0016\u0004\u0013A\u00022fM>\u0014X\r\u0006\u0002\u00026A!\u0011QEA\u001c\u0013\u0011\tI$a\n\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u000f\u0005u\u0002\u0003BA \u0003\u0017j!!!\u0011\u000b\t\u0005\r\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004kkBLG/\u001a:\u000b\u0007\u0005%\u0013/A\u0003kk:LG/\u0003\u0003\u0002N\u0005\u0005#A\u0003\"fM>\u0014X-R1dQ\u0006!B/Z:u)Vl'\r\\3`\u001f:\u0014vn\u001e;j[\u0016D3\u0001CA*!\u0011\ty$!\u0016\n\t\u0005]\u0013\u0011\t\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001\"i\u0016\u001cH\u000fV;nE2,wl\u00148S_^$\u0018.\\3XSRD7\tR\"T_V\u00148-\u001a\u0015\u0004\u0013\u0005M\u0013!\u0006;fgR$V/\u001c2mK~{e\u000e\u0015:pGRLW.\u001a\u0015\u0004\u0015\u0005M\u0013A\t;fgR$V/\u001c2mK~{e\u000e\u0015:pGRLW.Z,ji\"\u001cEiQ*pkJ\u001cW\rK\u0002\f\u0003'\nA\u0003^3tiR+XN\u00197f?\u000e\u000bGnY(o)Z3\u0005f\u0001\u0007\u0002T\u0005iB/Z:u)Vl'\r\\3`/&tGm\\<D_2,XN\\:Bi\u0016sG\rK\u0002\u000e\u0003'\nQ\u0005^3tiR+XN\u00197f?\u001e\u0013x.\u001e9Nk2$\u0018\u000e\u001d7f/&tGm\\<D_2,XN\\:)\u00079\t\u0019&\u0001\u000fuKN$H+^7cY\u0016|vI]8va6+H\u000e^5qY\u0016\\U-_:)\u0007=\t\u0019&A\u0011uKN$H+^7cY\u0016|vI]8va>sG._,j]\u0012|woQ8mk6t7\u000fK\u0002\u0011\u0003'\na\u0004^3tiR+XN\u00197f?\u001e\u0013x.\u001e9P]2KG/\u001a:bYZ\u000bG.^3)\u0007E\t\u0019&A\u000fuKN$H+^7cY\u0016|\u0006K]8kK\u000e$\u0018n\u001c8QkNDGi\\<oQ\r\u0011\u00121K\u0001\u001bi\u0016\u001cH\u000fV;nE2,wlQ1tG\u0006$\u0017N\\4XS:$wn\u001e\u0015\u0004'\u0005M\u0013\u0001\n;fgR$V/\u001c2mK~\u001b\u0015m]2bI&twmV5oI><xLU3mCb4uN]7)\u0007Q\t\u0019&A\u0010uKN$H+^7cY\u0016|F)[:uS:\u001cGo\u00159mSR,e.\u00192mK\u0012D3!FA*\u0003\t\"Xm\u001d;Uk6\u0014G.Z0ESN$\u0018N\\2u\u001f:<\u0016N\u001c3po\u000e{G.^7og\"\u001aa#a\u0015\u0002SQ,7\u000f\u001e+v[\ndWm\u0018#p\u001d>$8\u000b\u001d7jiB\u0013xnY3tg&tw\rV5nK^Kg\u000eZ8xQ\r9\u00121K\u0001\"i\u0016\u001cH\u000fV;nE2,wLT8u\u001fV$\b/\u001e;XS:$wn^\"pYVlgn\u001d\u0015\u00041\u0005M\u0013a\u0007;fgR$V/\u001c2mK~+F-\u00194XSRDw.\u001e;NKJ<W\rK\u0002\u001a\u0003'\na\u0003^3ti\u000e+X.\u001e7bi\u0016|vJ\u001c*poRLW.\u001a\u0015\u00045\u0005M\u0013a\t;fgR\u001cU/\\;mCR,wl\u00148S_^$\u0018.\\3XSRD7\tR\"T_V\u00148-\u001a\u0015\u00047\u0005M\u0013a\u0006;fgR\u001cU/\\;mCR,wl\u00148Qe>\u001cG/[7fQ\ra\u00121K\u0001%i\u0016\u001cHoQ;nk2\fG/Z0P]B\u0013xn\u0019;j[\u0016<\u0016\u000e\u001e5D\t\u000e\u001bv.\u001e:dK\"\u001aQ$a\u0015\u0002CQ,7\u000f^\"v[Vd\u0017\r^3`\t&\u001cH/\u001b8diN\u0003H.\u001b;F]\u0006\u0014G.\u001a3)\u0007y\t\u0019&A\tuKN$\bj\u001c9`\u001f:\u0014vn\u001e;j[\u0016D3aHA*\u0003y!Xm\u001d;I_B|vJ\u001c*poRLW.Z,ji\"\u001cEiQ*pkJ\u001cW\rK\u0002!\u0003'\n!\u0003^3ti\"{\u0007oX(o!J|7\r^5nK\"\u001a\u0011%a\u0015\u0002?Q,7\u000f\u001e%pa~{e\u000e\u0015:pGRLW.Z,ji\"\u001cEiQ*pkJ\u001cW\rK\u0002#\u0003'\nA\u0004^3ti\"{\u0007o\u0018#jgRLgn\u0019;Ta2LG/\u00128bE2,G\rK\u0002$\u0003'\nA\u0005^3ti6+H\u000e^5qY\u0016\fum\u001a:fO\u0006$Xm\u00148TC6,w+\u001b8e_^$fK\u0012\u0015\u0004I\u0005M\u0013A\u000b;fgR\u001c\u0015M\u001c;NKJ<WmV5oI><HK\u0016$`\r&dG/\u001a:P]^Kg\u000eZ8x'R\f'\u000f\u001e\u0015\u0004K\u0005M\u0013A\n;fgR\u001c\u0015M\u001c;NKJ<WmV5oI><HK\u0016$`+\u0012$hm\u00148XS:$wn\u001e+W\r\"\u001aa%a\u0015\u0002[Q,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~;%o\\;q\u001f:|e\u000e\\=Ti\u0006\u0014H\u000fK\u0002(\u0003'\n\u0001\u0007^3ti\u000e\u000bg\u000e\u001e+sC:\u001cH.\u0019;f)><\u0016N\u001c3po\u0006;wm\u0018)zi\"|g.Q4he\u0016<\u0017\r^3DC2d\u0007f\u0001\u0015\u0002T\u0005\u0011C/Z:u+:\u001cX\u000f\u001d9peR,G-\u0012=dKB$\u0018n\u001c8`\u000b\u0006\u0014H.\u001f$je\u0016D3!KA*\u0003\u0005\"Xm\u001d;V]N,\b\u000f]8si\u0016$W\t_2faRLwN\\0MCR,g)\u001b:fQ\rQ\u00131K\u0001-i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fI\u0016C8-\u001a9uS>tw\fS8q'&TXMT8o\t&4\u0018n]5cY\u0016D3aKA*\u0003E\"Xm\u001d;V]N,\b\u000f]8si\u0016$W\t_2faRLwN\\0Dk6,H.\u0019;f'&TXMT8o\t&4\u0018n]5cY\u0016D3\u0001LA*\u0003y\"Xm\u001d;DC:$HK]1og2\fG/\u001a+p/&tGm\\<BO\u001e|vI]8va&twmU3ug^KG\u000f[8vi^Kg\u000eZ8x'R\f'\u000f^#oI\"\u001aQ&a\u0015\u0002yQ,7\u000f^\"b]R$&/\u00198tY\u0006$X\rV8XS:$wn^!hO~;%o\\;qS:<7+\u001a;t\u001f:d\u0017pV5uQ^Kg\u000eZ8x'R\f'\u000f\u001e\u0015\u0004]\u0005M\u0013a\u0006;fgR$V/\u001c2mK~;%o\\;qS:<7+\u001a;tQ\ry\u00131K\u0001\u0019i\u0016\u001cH\u000fV;nE2,wl\u0012:pkBLgnZ*fiN\f\u0004f\u0001\u0019\u0002T\u0005YC/Z:u)Vl'\r\\3`\u000fJ|W\u000f]5oON+Go\u001d#jgRLgn\u0019;Ta2LG/\u00128bE2,G\rK\u00022\u0003'\na\u0007^3ti\u000e\u000bg\u000e\u001e+sC:\u001cH.\u0019;f)><\u0016N\u001c3po\u0006;wmX\"vE\u0016<\u0016\u000e\u001e5pkR<\u0016N\u001c3poN#\u0018M\u001d;F]\u0012D3AMA*\u0003a\"Xm\u001d;DC:$HK]1og2\fG/\u001a+p/&tGm\\<BO\u001e|&k\u001c7mkB<\u0016\u000e\u001e5pkR<\u0016N\u001c3poN#\u0018M\u001d;F]\u0012D3aMA*\u0003E!Xm\u001d;Uk6\u0014G.Z0S_2dW\u000f\u001d\u0015\u0004i\u0005M\u0013A\u000f;fgR\u001c\u0015M\u001c;NKJ<WmV5oI><HK\u0016$`\u000fJ|W\u000f]5oON+Go\u001d#jgRLgn\u0019;P]^Kg\u000eZ8x\u0007>dW/\u001c8tQ\r)\u00141K\u0001\u0015i\u0016\u001cH\u000fS8q?\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\u0007Y\n\u0019&A\u0015uKN$\bj\u001c9`\u000fJ|W\u000f]5oON+Go]0ESN$\u0018N\\2u'Bd\u0017\u000e^#oC\ndW\r\u001a\u0015\u0004o\u0005M\u0013\u0001\u0004;fgRDu\u000e]0Dk\n,\u0007f\u0001\u001d\u0002T\u0005qA/Z:u\u0011>\u0004xLU8mYV\u0004\bfA\u001d\u0002T\u0005IB/Z:u\u0007VlW\u000f\\1uK~;%o\\;qS:<7+\u001a;tQ\rQ\u00141K\u0001/i\u0016\u001cHoQ;nk2\fG/Z0He>,\b/\u001b8h'\u0016$8o\u0018#jgRLgn\u0019;Ta2LG/\u00128bE2,G\rK\u0002<\u0003'\n\u0011\u0003^3ti\u000e+X.\u001e7bi\u0016|6)\u001e2fQ\ra\u00141K\u0001\u0014i\u0016\u001cHoQ;nk2\fG/Z0S_2dW\u000f\u001d\u0015\u0004{\u0005M\u0013!\u0006;fgR4\u0015.\u001a7e\u001d\u0006lWmQ8oM2L7\r\u001e\u0015\u0004}\u0005M\u0013\u0001\b;fgR\u0004&o\\2uS6,w+\u001b8e_^<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0004\u007f\u0005M\u0013a\f;fgR$V/\u001c2mK~\u001b\u0015m]2bI&twmV5oI><xl\u00148J]\u0012Lg/\u001b3vC2\u0004&o\\2uS6,\u0007f\u0001!\u0002T\u0005aC/Z:u)Vl'\r\\3`\u0007\u0006\u001c8-\u00193j]\u001e<\u0016N\u001c3po~{e.\u00138iKJLG\u000f\u0015:pGRLW.\u001a\u0015\u0004\u0003\u0006M\u0013!\u000b;fgRLeN^1mS\u0012\u0014V\r\\1y\r>\u0014XnQ1tG\u0006$W\r\u0015:pGRLW.Z,j]\u0012|w\u000fK\u0002C\u0003'\nQ\u0006^3tiR+XN\u00197f?\u000e\u000b7oY1eKB\u0013xn\u0019;j[\u0016<\u0016N\u001c3po~{enV5oI><(+\u00198lQ\r\u0019\u00151K\u0001\u0019GJ,\u0017\r^3Qe>\u001cG/[7f/&tGm\\<U_BtECBA\u001b\u0005\u0013\u0012\u0019\u0007C\u0004\u0003L\u0011\u0003\rA!\u0014\u0002\u0011YLWm\u001e(b[\u0016\u0004BAa\u0014\u0003^9!!\u0011\u000bB-!\u0011\u0011\u0019&a\n\u000e\u0005\tU#b\u0001B,g\u00061AH]8pizJAAa\u0017\u0002(\u00051\u0001K]3eK\u001aLAAa\u0018\u0003b\t11\u000b\u001e:j]\u001eTAAa\u0017\u0002(!9!Q\r#A\u0002\t\u001d\u0014A\u0002;pa:+X\u000e\u0005\u0003\u0002&\t%\u0014\u0002\u0002B6\u0003O\u00111!\u00138u\u0003Y\"Xm\u001d;J]Z\fG.\u001b3SK2\f\u0007PR8s[\u000e\u000b7oY1eKB\u0013xn\u0019;j[\u0016<\u0016N\u001c3po~{enV5oI><(+\u00198lQ\r)\u00151K\u0001/i\u0016\u001cH\u000fV;nE2,wlQ1tG\u0006$W\r\u0015:pGRLW.Z,j]\u0012|woX(o/&tGm\\<EK\u0012,\b\u000fK\u0002G\u0003'\nq\u0007^3ti&sg/\u00197jIJ+G.\u0019=G_Jl7)Y:dC\u0012,\u0007K]8di&lWmV5oI><xl\u00148XS:$wn\u001e#fIV\u0004\bfA$\u0002T\u0005iC/Z:u)Vl'\r\\3`\u0007\u0006\u001c8-\u00193f!J|7\r^5nK^Kg\u000eZ8x?>sw+\u001b8e_^Tu.\u001b8)\u0007!\u000b\u0019&\u0001\tde\u0016\fG/Z,j]\u0012|wOS8j]\u00061D/Z:u\u0013:4\u0018\r\\5e%\u0016d\u0017\r\u001f$pe6\u001c\u0015m]2bI\u0016\u0004&o\\2uS6,w+\u001b8e_^|vJ\\,j]\u0012|wOS8j]\"\u001a!*a\u0015\u0002+Q,7\u000f^*fgNLwN\\0P]J{w\u000f^5nK\"\u001a1*a\u0015\u0002-Q,7\u000f^*fgNLwN\\0P]B\u0013xn\u0019;j[\u0016D3\u0001TA*\u0003\u0001\"Xm\u001d;TKN\u001c\u0018n\u001c8`\t&\u001cH/\u001b8diN\u0003H.\u001b;F]\u0006\u0014G.\u001a3)\u00075\u000b\u0019&A\u0013uKN$8+Z:tS>tw+\u001b8e_^<\u0016\u000e\u001e5Uo>\u0004\u0016M\u001d;ji&|gnS3zg\"\u001aa*a\u0015\u0002_Q,7\u000f^$s_V\u00048*Z=N_J,G\u000b[1o!\u0006\u0014H/\u001b;j_:\\U-_%o'\u0016\u001c8/[8o/&tGm\\<)\u0007=\u000b\u0019&A\u0018uKN$xI]8va.+\u0017\u0010T3tgRC\u0017M\u001c)beRLG/[8o\u0017\u0016L\u0018J\\*fgNLwN\\,j]\u0012|w\u000fK\u0002Q\u0003'\nA\u0007^3ti\u0012+\u0007O]3dCR,GmU=oi\u0006D\u0018IY8viB\u000b'\u000f^5uS>t7*Z=J]N+7o]5p]^Kg\u000eZ8xQ\r\t\u00161K\u0001+i\u0016\u001cHo\u0012:pkB\\U-_:J]\u0012L7-Z:DQ\u0006tw-Z:J]N+7o]5p]^Kg\u000eZ8xQ\r\u0011\u00161K\u00012i\u0016\u001cHoU3tg&|gnV5oI><HK\u0016$XSRD\u0007+\u0019:uSRLwN\\&fs^CWM\\\"b]RlUM]4fQ\r\u0019\u00161K\u00015i\u0016\u001cHoU3tg&|gnV5oI><HK\u0016$XSRDw.\u001e;QCJ$\u0018\u000e^5p].+\u0017p\u00165f]\u000e\u000bg\u000e^'fe\u001e,\u0007f\u0001+\u0002T\u0005AD/Z:u!J|7\r^5nK^Kg\u000eZ8x)Z3u+\u001b;i\u0007\u0006d7m\u00148XS:$wn^\"pYVlgn\u00165f]\u000e\u000bg\u000e^'fe\u001e,\u0007fA+\u0002T\u0005QC/Z:u!J|7\r^5nK^Kg\u000eZ8x)Z3u+\u001b;i%\u0006t7n\u00165f]\u000e\u000bg\u000e^'fe\u001e,\u0007f\u0001,\u0002T\u0005YC/Z:u!J|7\r^5nK^Kg\u000eZ8x)Z3u+\u001b;i\t\u0016$W\u000f],iK:\u001c\u0015M\u001c;NKJ<W\rK\u0002X\u0003'\nQ\u0006^3tiB\u0013xn\u0019;j[\u0016<\u0016N\u001c3poR3fiV5uQ>3XM]!hO^CWM\\\"b]RlUM]4fQ\rA\u00161K\u0001+i\u0016\u001cH\u000f\u0015:pGRLW.Z,j]\u0012|w\u000f\u0016,G/&$\bNS8j]^CWM\\\"b]RlUM]4fQ\rI\u00161K\u00010i\u0016\u001cH\u000f\u0015:pGRLW.Z,j]\u0012|w\u000f\u0016,G/&$\bnQ8se\u0016d\u0017\r^3XQ\u0016t7)\u00198u\u001b\u0016\u0014x-\u001a\u0015\u00045\u0006M\u0013a\u000b;fgR\u0004&o\\2uS6,w+\u001b8e_^$fKR,ji\",f.[8o/\",gnQ1oi6+'oZ3)\u0007m\u000b\u0019\u0006K\u0004\u0001\u0005\u0013\u0014)Na6\u0011\t\t-'\u0011[\u0007\u0003\u0005\u001bTAAa4\u0002B\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0005'\u0014iM\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#A!7$\u0005\tm\u0007\u0003\u0002Bo\u0005[l!Aa8\u000b\t\t\u0005(1]\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\t\u0015(q]\u0001\u000bKb$XM\\:j_:\u001c(\u0002BA%\u0005ST1Aa;n\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0003p\n}'A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017aE,j]\u0012|w/Q4he\u0016<\u0017\r^3UKN$\bcAA\b;N\u0019QLa>\u0011\t\u0005\u0015\"\u0011`\u0005\u0005\u0005w\f9C\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005g\f!\u0002]1sC6,G/\u001a:t)\t\u0019\u0019\u0001\u0005\u0004\u0004\u0006\r51\u0011C\u0007\u0003\u0007\u000fQA!a\u0005\u0004\n)\u001111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004\u0010\r\u001d!AC\"pY2,7\r^5p]B1\u0011QEB\n\u0007/IAa!\u0006\u0002(\t)\u0011I\u001d:bsB!\u0011QEB\r\u0013\u0011\u0019Y\"a\n\u0003\u0007\u0005s\u0017\u0010K\u0004`\u0007?\u0019)ca\n\u0011\t\tu7\u0011E\u0005\u0005\u0007G\u0011yN\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u00121\u0011F\u0001\u0015C\u001e<\u0007\u000b[1tK\u0016sgm\u001c:dKJl4\u0010M?")
public class WindowAggregateTest
extends TableTestBase {
    private final AggregatePhaseStrategy aggPhaseEnforcer;
    private final StreamTableTestUtil util;
    private final boolean isTwoPhase;

    @Parameters(name="aggPhaseEnforcer={0}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    private boolean isTwoPhase() {
        return this.isTwoPhase;
    }

    @BeforeEach
    public void before() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().addTemporarySystemFunction("weightedAvgWithoutMerge", JavaUserDefinedAggFunctions.WeightedAvg.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyCDCTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values',\n                                |  'changelog-mode' = 'I,UA,UB,D'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW proctime_win AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start as ws,\n        |   window_end as we,\n        |   window_time as wt,\n        |   proctime() as new_proctime,\n        |   count(*) as cnt,\n        |   sum(d) as sum_d,\n        |   max(d) as max_d\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end, window_time, b\n      ")).stripMargin());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhaseEnforcer);
    }

    @TestTemplate
    public void testTumble_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testTumble_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testTumble_CalcOnTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE b > 1000\n        |)\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_WindowColumnsAtEnd() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv,\n        |   window_start,\n        |   window_end\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupMultipleWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   ws,\n        |   window_end,\n        |   window_time,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT *, window_start as ws\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |GROUP BY a, window_start, window_end, ws, window_time\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupMultipleKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, a, window_end, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupOnlyWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupOnLiteralValue() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY 'literal', window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_ProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d)\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_CascadingWindow() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW window1 AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_time as rowtime,\n        |   count(*) as cnt,\n        |   sum(d) as sum_d,\n        |   max(d) as max_d\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end, window_time, b\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  sum(sum_d),\n        |  max(max_d)\n        |FROM TABLE(TUMBLE(TABLE window1, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_CascadingWindow_RelaxForm() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |  FROM\n        |  (\n        |    SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    COUNT(DISTINCT c) AS cnt\n        |    FROM TABLE(\n        |      TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '1' DAY, INTERVAL '8' HOUR))\n        |    GROUP BY a, b, window_start, window_end\n        |) GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_DistinctOnWindowColumns() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct window_time) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_DoNotSplitProcessingTimeWindow() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_NotOutputWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_UdafWithoutMerge() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvgWithoutMerge(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testCumulate_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testCumulate_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnRowtimeWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyCDCTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testHop_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_OnProctimeWithCDCSource() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyCDCTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testHop_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testMultipleAggregateOnSameWindowTVF() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tvf AS\n        |SELECT * FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin());
        StatementSet statementSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE s1 (\n                               |  wstart TIMESTAMP(3),\n                               |  wend TIMESTAMP(3),\n                               |  `result` BIGINT\n                               |) WITH (\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO s1\n                                |SELECT\n                                |   window_start,\n                                |   window_end,\n                                |   weightedAvg(b, e) AS wAvg\n                                |FROM tvf\n                                |GROUP BY window_start, window_end\n                                |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO s1\n                                |SELECT\n                                |   window_start,\n                                |   window_end,\n                                |   count(*)\n                                |FROM tvf\n                                |GROUP BY window_start, window_end\n                                |")).stripMargin());
        this.util().verifyExecPlan(statementSet);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_FilterOnWindowStart() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_UdtfOnWindowTVF() {
        this.util().tableEnv().createTemporaryFunction("len_udtf", JavaUserDefinedTableFunctions.JavaTableFunc1.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(len),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE)),\n        |  LATERAL TABLE(len_udtf(c)) AS T(len)\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupOnOnlyStart() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_PythonAggregateCall() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        this.util().tableEnv().createTemporaryFunction("python_agg", JavaUserDefinedAggFunctions.TestPythonAggregateFunction.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   python_agg(1, 1)\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testUnsupportedException_EarlyFire() {
        Configuration conf = new Configuration();
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED().key(), "true");
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY().key(), "5s");
        this.util().tableEnv().getConfig().addConfiguration(conf);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Currently, window table function based aggregate doesn't support early-fire and late-fire configuration 'table.exec.emit.early-fire.enabled' and 'table.exec.emit.late-fire.enabled'.") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_LateFire() {
        Configuration conf = new Configuration();
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED().key(), "true");
        conf.setString(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY().key(), "5s");
        this.util().tableEnv().getConfig().addConfiguration(conf);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Currently, window table function based aggregate doesn't support early-fire and late-fire configuration 'table.exec.emit.early-fire.enabled' and 'table.exec.emit.late-fire.enabled'.") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_HopSizeNonDivisible() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*)\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '4' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("HOP table function based aggregate requires size must be an integral multiple of slide, but got size 600000 ms and slide 240000 ms") instanceof TableException;
    }

    @TestTemplate
    public void testUnsupportedException_CumulateSizeNonDivisible() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*)\n        |FROM TABLE(\n        |   CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '25' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("CUMULATE table function based aggregate requires maxSize must be an integral multiple of step, but got maxSize 3600000 ms and step 1500000 ms") instanceof TableException;
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupingSetsWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (window_start), (window_end))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_GroupingSetsOnlyWithWindowStart() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a, window_start), (window_start))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a, window_start, window_end), (b, window_start, window_end))\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSets1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_GroupingSetsDistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_CubeWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY CUBE (a, b, window_start, window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantTranslateToWindowAgg_RollupWithoutWindowStartEnd() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY ROLLUP (a, b, window_start, window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testTumble_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCantMergeWindowTVF_GroupingSetsDistinctOnWindowColumns() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct window_time) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_GroupingSets_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY CUBE (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testHop_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '25' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_GroupingSets_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(*),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY GROUPING SETS ((a), (b)), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY CUBE (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCumulate_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY ROLLUP (a, b), window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testFieldNameConflict() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_time,\n        |  MIN(rowtime) as start_time,\n        |  MAX(rowtime) as end_time\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY window_start, window_end, window_time\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testProctimeWindowWithFilter() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TEMPORARY TABLE source (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d BIGINT,\n                                |  proctime as PROCTIME()\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TEMPORARY TABLE sink(\n                               |    ws TIMESTAMP,\n                               |    we TIMESTAMP,\n                               |    b bigint,\n                               |    c bigint\n                               |)\n                               |WITH (\n                               |    'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |    select\n        |        window_start,\n        |        window_end,\n        |        b,\n        |        COALESCE(sum(case\n        |            when a = 11\n        |            then 1\n        |        end), 0) c\n        |    from\n        |        TABLE(\n        |            TUMBLE(TABLE source, DESCRIPTOR(proctime), INTERVAL '10' SECONDS)\n        |        )\n        |    where\n        |        a in (1, 5, 7, 9, 11)\n        |    GROUP BY\n        |        window_start, window_end, b\n        |")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadingWindow_OnIndividualProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  count(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_win, DESCRIPTOR(new_proctime), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadingWindow_OnInheritProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  sum(cnt),\n        |  count(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_win, DESCRIPTOR(wt), INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n        |")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_win\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowRank() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_winrank", 10);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_winrank, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    private void createProctimeWindowTopN(String viewName, int topNum) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(474).append("\n         |CREATE VIEW ").append(viewName).append(" AS\n         |SELECT *\n         |FROM(\n         | SELECT\n         |    a,\n         |    b,\n         |    window_start as ws,\n         |    window_end as we,\n         |    window_time as wt,\n         |    proctime() as new_proctime,\n         |    ROW_NUMBER() OVER (PARTITION BY window_start, window_end ORDER BY proctime DESC) AS rn\n         | FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n         |) WHERE rn <= ").append(topNum).append("\n     ").toString())).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowRank() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_winrank", 10);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_winrank\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowDedup() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_windedup", 1);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE proctime_windedup, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n  ")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowDedup() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createProctimeWindowTopN("proctime_windedup", 1);
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM proctime_windedup\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testTumble_CascadeProctimeWindow_OnWindowJoin() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createWindowJoin();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM TABLE(TUMBLE(TABLE win_join, DESCRIPTOR(new_proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin());
    }

    private void createWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW proctime_window AS\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n    ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW win_join AS\n        |SELECT\n        |   w1.a as a,\n        |   w1.b as b,\n        |   COALESCE(w1.window_start, w2.window_start) as ws,\n        |   COALESCE(w1.window_end, w2.window_end) as we,\n        |   proctime() as new_proctime\n        |FROM proctime_window w1 join proctime_window w2\n        |ON w1.window_start = w2.window_start AND w1.window_end = w2.window_end\n    ")).stripMargin());
    }

    @TestTemplate
    public void testInvalidRelaxFormCascadeProctimeWindow_OnWindowJoin() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isFalse();
        this.createWindowJoin();
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n                         |SELECT\n                         |  a,\n                         |  ws,\n                         |  we,\n                         |  COUNT(*)\n                         |FROM win_join\n                         |GROUP BY a, ws, we\n      ")).stripMargin());
    }

    @TestTemplate
    public void testSession_OnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSession_OnProctime() {
        Assumptions.assumeThat((boolean)this.isTwoPhase()).isTrue();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSession_DistinctSplitEnabled() {
        this.util().tableEnv().getConfig().getConfiguration().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(proctime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSessionWindowWithTwoPartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   b,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY b, a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testGroupKeyMoreThanPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testGroupKeyLessThanPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |GROUP BY b, window_start, window_end\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testDeprecatedSyntaxAboutPartitionKeyInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable, DESCRIPTOR(proctime), DESCRIPTOR(a), INTERVAL '5' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Invalid number of arguments to function 'SESSION'. Was expecting 3 arguments") instanceof ValidationException;
    }

    @TestTemplate
    public void testGroupKeysIndicesChangesInSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   a\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable partition by a, DESCRIPTOR(proctime), INTERVAL '10' MINUTE))\n        |GROUP BY window_start, window_end, a\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @TestTemplate
    public void testSessionWindowTVFWithPartitionKeyWhenCantMerge() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   a,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(SESSION(TABLE MyTable PARTITION BY a, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testSessionWindowTVFWithoutPartitionKeyWhenCantMerge() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM (\n        |  SELECT window_start, rowtime, d, proctime, e, b, c, window_end, window_time, a\n        |  FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE))\n        |  WHERE window_start >= TIMESTAMP '2021-01-01 10:10:00.000'\n        |)\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testProctimeWindowTVFWithCalcOnWindowColumnWhenCantMerge() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select c, count(a)\n        |from\n        | TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes))\n        |where window_start <> '123'\n        |group by window_start, window_end, c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithRankWhenCantMerge() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select c, count(a)\n        |from (\n        | select *, row_number() over (partition by c order by proctime desc) as rn\n        | from\n        |  TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes))\n        |)\n        |where rn = 2\n        |group by window_start, window_end, c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithDedupWhenCantMerge() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select c, count(a)\n        |from (\n        | select *, row_number() over (partition by c order by proctime desc) as rn\n        | from\n        |  TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes))\n        |)\n        |where rn = 1\n        |group by window_start, window_end, c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithOverAggWhenCantMerge() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select c, max(c1), count(a)\n        |from (\n        | select *, count(*) over (partition by c order by proctime desc) as c1\n        | from\n        |  TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes))\n        |)\n        |group by window_start, window_end, c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithJoinWhenCantMerge() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select t.c, max(t2.e), count(t.a)\n        |from (\n        |  TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes)) AS t\n        |  join MyTable t2 on t2.a = t.a\n        |)\n        |group by window_start, window_end, t.c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithCorrelateWhenCantMerge() {
        this.util().addTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select t.c, max(t2.x), count(t.a)\n        |from (\n        |  TABLE(CUMULATE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds, interval '5' minutes)) AS t\n        |  Left JOIN LATERAL TABLE(str_split('Jack,John', ',')) AS t2(x) ON TRUE\n        |)\n        |group by window_start, window_end, t.c, window_time\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProctimeWindowTVFWithUnionWhenCantMerge() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |select c, count(a)\n        |from (\n        |  select * from\n        |  TABLE(TUMBLE(table MyTable, DESCRIPTOR(proctime), interval '10' seconds))\n        |  union all\n        |  select * from\n        |  TABLE(TUMBLE(table MyTable, DESCRIPTOR(proctime), interval '5' seconds))\n        |) t\n        |group by window_start, window_end, c, window_time\n        |")).stripMargin());
    }

    public WindowAggregateTest(AggregatePhaseStrategy aggPhaseEnforcer) {
        this.aggPhaseEnforcer = aggPhaseEnforcer;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        AggregatePhaseStrategy aggregatePhaseStrategy = aggPhaseEnforcer;
        AggregatePhaseStrategy aggregatePhaseStrategy2 = AggregatePhaseStrategy.TWO_PHASE;
        this.isTwoPhase = !(aggregatePhaseStrategy != null ? !aggregatePhaseStrategy.equals(aggregatePhaseStrategy2) : aggregatePhaseStrategy2 != null);
    }
}

