/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A\u0001D\u0007\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!GA\u000bUo>\u001cF/Y4f\u0003\u001e<'/Z4bi\u0016$Vm\u001d;\u000b\u00059y\u0011aA1hO*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0019\u0019HO]3b[*\u0011A#F\u0001\u0005a2\fgN\u0003\u0002\u0017/\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\r\u001a\u0003\u0015!\u0018M\u00197f\u0015\tQ2$A\u0003gY&t7N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001J\u000b\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001a#!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u001b\u0005!Q\u000f^5m+\u0005i\u0003C\u0001\u0012/\u0013\ty3EA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%\u0001\u0004cK\u001a|'/\u001a\u000b\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t!QK\\5uQ\t!!\b\u0005\u0002<\u00056\tAH\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003v\tQA[;oSRL!a\u0011\u001f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u000buKN$8i\\;oi^KG\u000f[$s_V\u0004()\u001f\u0015\u0003\u000b\u0019\u0003\"aO$\n\u0005!c$\u0001\u0002+fgR\fq\u0003^3ti\u000e{WO\u001c;XSRDw.\u001e;He>,\bOQ=)\u0005\u00191\u0015A\u0005;fgR\feoZ,ji\"<%o\\;q\u0005fD#a\u0002$\u0002+Q,7\u000f^!wO^KG\u000f[8vi\u001e\u0013x.\u001e9Cs\"\u0012\u0001BR\u0001\u001di\u0016\u001cHo\u0012:pkB\fum\u001a:fO\u0006$XmV5uQ\u001aKG\u000e^3sQ\tIa)\u0001\u0015uKN$xI]8va\u0006;wM]3hCR,w+\u001b;i\u000bb\u0004(/Z:tS>t\u0017J\\*fY\u0016\u001cG\u000f\u000b\u0002\u000b\r\u0006qB/Z:u\u000fJ|W\u000f]!hOJ,w-\u0019;f/&$\bnQ8ogR\fg\u000e\u001e\u0015\u0003\u0017\u0019\u0003")
public class TwoStageAggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
    }

    @Test
    public void testCountWithGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testCountWithoutGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable");
    }

    @Test
    public void testAvgWithGroupBy() {
        this.util().verifyExecPlan("SELECT AVG(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testAvgWithoutGroupBy() {
        this.util().verifyRelPlanWithType("SELECT AVG(CAST(a AS DOUBLE)) FROM MyTable");
    }

    @Test
    public void testGroupAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT b, SUM(a) FROM MyTable GROUP BY b) WHERE b = 2");
    }

    @Test
    public void testGroupAggregateWithExpressionInSelect() {
        this.util().verifyExecPlan("SELECT MIN(c), AVG(a) FROM (SELECT a, b + 3 AS d, c FROM MyTable) GROUP BY d");
    }

    @Test
    public void testGroupAggregateWithConstant() {
        this.util().verifyExecPlan("SELECT four, SUM(a) FROM (SELECT b, 4 AS four, a FROM MyTable) GROUP BY b, four");
    }

    public TwoStageAggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

