/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0013'\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u00067\u0002!\t!\u0013\u0005\u0006;\u0002!\t!\u0013\u0005\u0006?\u0002!\t!\u0013\u0005\u0006C\u0002!\t!\u0013\u0005\u0006G\u0002!\t!\u0013\u0005\u0006K\u0002!\t!\u0013\u0005\u0006O\u0002!\t!\u0013\u0005\u0006S\u0002!\t!\u0013\u0005\u0006W\u0002!\t!\u0013\u0005\u0006[\u0002!\t!\u0013\u0005\u0006_\u0002!\t!\u0013\u0005\u0006c\u0002!\t!\u0013\u0005\u0006g\u0002!\t!\u0013\u0005\u0006k\u0002!\t!\u0013\u0005\u0006o\u0002!\t!\u0013\u0005\u0006s\u0002!\t!\u0013\u0005\u0006w\u0002!\t!\u0013\u0005\u0006{\u0002!\t!\u0013\u0005\u0006\u007f\u0002!\t!\u0013\u0005\u0007\u0003\u0007\u0001A\u0011A%\t\r\u0005\u001d\u0001\u0001\"\u0001J\u0011\u0019\tY\u0001\u0001C\u0001\u0013\"1\u0011q\u0002\u0001\u0005\u0002%Ca!a\u0005\u0001\t\u0003I\u0005BBA\f\u0001\u0011\u0005\u0011\n\u0003\u0004\u0002\u001c\u0001!\t!\u0013\u0005\u0007\u0003?\u0001A\u0011A%\t\r\u0005\r\u0002\u0001\"\u0001J\u0011\u0019\t9\u0003\u0001C\u0001\u0013\"1\u00111\u0006\u0001\u0005\u0002%Ca!a\f\u0001\t\u0003I\u0005BBA\u001a\u0001\u0011\u0005\u0011JA\u0007UC\ndWmU5oWR+7\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003W1\nA\u0001\u001d7b]*\u0011QFL\u0001\ba2\fgN\\3s\u0015\ty\u0003'A\u0003uC\ndWM\u0003\u00022e\u0005)a\r\\5oW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mb\u0013!B;uS2\u001c\u0018BA\u001f;\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\u0011\t\u0003\u0003\u0002i\u0011AJ\u0001\u0005kRLG.F\u0001E!\tIT)\u0003\u0002Gu\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005)C/Z:u\u0013:\u001cXM\u001d;XSRDG+\u0019:hKR\u001cu\u000e\\;n]N\fe\u000eZ*rY\"Kg\u000e\u001e\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n!QK\\5uQ\t!\u0011\u000b\u0005\u0002S36\t1K\u0003\u0002U+\u0006\u0019\u0011\r]5\u000b\u0005Y;\u0016a\u00026va&$XM\u001d\u0006\u00031R\nQA[;oSRL!AW*\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH/\u00138tKJ$X*[:nCR\u001c\u0007\u000eV=qK\u001a{'/R7qif\u001c\u0005.\u0019:)\u0005\u0015\t\u0016A\u0007;fgR,\u0005pY3qi&|gNR8s\u0003B\u0004XM\u001c3TS:\\\u0007F\u0001\u0004R\u0003u!Xm\u001d;Fq\u000e,\u0007\u000f^5p]\u001a{'o\u0014<fe\u0006;wM]3hCR,\u0007FA\u0004R\u00039!Xm\u001d;BaB,g\u000eZ*j].D#\u0001C)\u0002!Q,7\u000f\u001e*fiJ\f7\r^*j].\f\u0004FA\u0005R\u0003A!Xm\u001d;SKR\u0014\u0018m\u0019;TS:\\'\u0007\u000b\u0002\u000b#\u0006qA/Z:u+B\u001cXM\u001d;TS:\\\u0007FA\u0006R\u0003a!Xm\u001d;VaN,'\u000f^*j].<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u0019E\u000b\u0001\u0004^3tiJ+GO]1di\u0006sG-\u00169tKJ$8+\u001b8lQ\ti\u0011+\u0001\u0010uKN$\u0018\t\u001d9f]\u0012,\u0006o]3si\u0006sGMU3ue\u0006\u001cGoU5oW\"\u0012a\"U\u0001-i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8G_J<&/\u001b;j]\u001e4\u0016N\u001d;vC2lU\r^1eCR\f7i\u001c7v[:D#aD)\u0002YQ,7\u000f^#yG\u0016\u0004H/[8o\r>\u0014xK]5uS:<\u0017J\u001c<bY&$W*\u001a;bI\u0006$\u0018mQ8mk6t\u0007F\u0001\tR\u0003I!Xm\u001d;NKR\fG-\u0019;b\u0007>dW/\u001c8)\u0005E\t\u0016!\r;fgRlU\r^1eCR\f7i\u001c7v[:$\u0006.\u0019;D_:4G.[2ug^KG\u000f\u001b)isNL7-\u00197D_2,XN\u001c\u0015\u0003%E\u000b\u0011\u0005^3tiNKgn\u001b#jg>\u0014H-\u001a:DQ\u0006tw-\u001a'pO^KG\u000f\u001b&pS:D#aE)\u0002CQ,7\u000f^*j].$\u0015n]8sI\u0016\u00148\t[1oO\u0016dunZ,ji\"\u0014\u0016M\\6)\u0005Q\t\u0016!\n;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRD\u0007k[!vi>\\U-\u001f\"zQ\t)\u0012+A\u0012uKN$\u0018\t\u001d9f]\u0012\u001cFO]3b[R{7+\u001b8l/&$\b\u000eU6O_.+\u0017PQ=)\u0005Y\t\u0016A\n;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRD\u0007k\u001b$pe\u000e,7*Z=Cs\"\u0012q#U\u00018i\u0016\u001cHoU5oO2,\u0007+\u0019:bY2,G.[:n\u0003B\u0004XM\u001c3TiJ,\u0017-\u001c+p'&t7nV5uQB[gi\u001c:dK.+\u0017PQ=)\u0005a\t\u0016!\u000b;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRDw.\u001e;QW\u001a{'oY3LKf\u0014\u0015\u0010\u000b\u0002\u001a#\u0006QD/Z:u\u0003B\u0004XM\u001c3TiJ,\u0017-\u001c+p'&t7nV5uQ>,H\u000fU6G_J\u001cWmS3z\u0005f\u001c\u0016N\\4mKB\u000b'/\u00197mK2L7/\u001c\u0015\u00035E\u000b1\u0007^3ti\u000eC\u0017M\\4fY><7\u000b\u001e:fC6$vnU5oW^KG\u000f\u001b)l\t&4g-\u001a:f]R\u0004\u0016M]1mY\u0016d\u0017n]7)\u0005m\t\u0016\u0001\r;fgR\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGk\\*j].<\u0016\u000e\u001e5QWNKgn\u001a7f!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000e\u000b\u0002\u001d#\u0006!B/Z:u\u0013:\u001cXM\u001d;QCJ$8i\u001c7v[:D#!H)\u0002!Q,7\u000f\u001e#jgR\u0014\u0018NY;uS>t\u0007F\u0001\u0010R\u0003\u001d\"Xm\u001d;ESN$(/\u001b2vi&|gnV5uQJ+\u0017/^5sK\u0012\u0014UoY6fi\u000e{WO\u001c;)\u0005}\t\u0016\u0001\u000e;fgR$\u0015n\u001d;sS\n,H/[8o/&$\b.\u00168tkB\u0004xN\u001d;fI\u0012K7\u000f\u001e:jEV$\u0018n\u001c8BY\u001e|'/\u001b;i[\"\u0012\u0001%U\u0001\u001fi\u0016\u001cH/\u0012=qY\u0006Lgn\u0011:fCR,G+\u00192mK\u0006\u001b8+\u001a7fGRD#!I)\u0002?Q,7\u000f^#ya2\f\u0017N\u001c*fa2\f7-\u001a+bE2,\u0017i]*fY\u0016\u001cG\u000f\u000b\u0002##\u0006qD/Z:u\u000bb\u0004H.Y5o\u0007J,\u0017\r^3UC\ndW-Q:TK2,7\r^,ji\"\u001cu\u000e\\;n]NLen\u0011:fCR,\u0017I\u001c3Rk\u0016\u0014\u0018\u0010U1siND#aI)\u0002\u007fQ,7\u000f^#ya2\f\u0017N\u001c*fa2\f7-\u001a+bE2,\u0017i]*fY\u0016\u001cGoV5uQ\u000e{G.^7og&s7I]3bi\u0016\fe\u000eZ)vKJL\b+\u0019:ug\"\u0012A%\u0015")
public class TableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInsertWithTargetColumnsAndSqlHint() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink /*+ OPTIONS('sink.parallelism' = '1') */(a, b) SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInsertMismatchTypeForEmptyChar() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE my_sink (\n                     |  name STRING,\n                     |  email STRING,\n                     |  message_offset BIGINT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO my_sink SELECT a, '', '' FROM MyTable")).hasMessageContaining("Query schema: [a: INT, EXPR$1: CHAR(0) NOT NULL, EXPR$2: CHAR(0) NOT NULL]\nSink schema:  [name: STRING, email: STRING, message_offset: BIGINT]") instanceof ValidationException;
    }

    @Test
    public void testExceptionForAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).hasMessageContaining("Table sink 'default_catalog.default_database.appendSink' doesn't support consuming update changes which is produced by node GroupAggregate(groupBy=[a], select=[a, COUNT(*) AS cnt])") instanceof TableException;
    }

    @Test
    public void testExceptionForOverAggregate() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink1 (\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink2 (\n                     |  `cnt` BIGINT,\n                     |  `total` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink1 SELECT * FROM TempTable");
        stmtSet.addInsertSql("INSERT INTO retractSink2 SELECT cnt, SUM(cnt) OVER (ORDER BY PROCTIME()) FROM TempTable");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).hasMessageContaining("OverAggregate doesn't support consuming update changes which is produced by node Calc(select=[cnt])") instanceof TableException;
    }

    @Test
    public void testAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink1() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink2() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `cnt` BIGINT,\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO retractSink\n        |SELECT cnt, COUNT(a) AS a FROM (\n        |    SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a) t\n        |GROUP BY cnt\n      ")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(dml);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSinkWithFilter() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO upsertSink\n        |SELECT *\n        |FROM (SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a)\n        |WHERE cnt < 10\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractAndUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (b) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT b, COUNT(a) AS cnt FROM MyTable GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT b, cnt FROM TempTable WHERE b < 4");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT b, cnt FROM TempTable WHERE b >= 4 AND b < 6");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT cnt, COUNT(b) AS frequency FROM TempTable WHERE b < 4 GROUP BY cnt");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testAppendUpsertAndRetractSink() {
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT a, b FROM MyTable UNION ALL SELECT d, e FROM MyTable2");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT * FROM TempTable");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `total_sum` INT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable UNION ALL SELECT i, j FROM MyTable3");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT SUM(a) AS total_sum FROM TempTable1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `total_min` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, MIN(b) AS total_min FROM TempTable1 GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testExceptionForWritingVirtualMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT *\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet)).hasMessageContaining("Query schema: [a: INT, m_3: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]\nSink schema:  [a: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]") instanceof ValidationException;
    }

    @Test
    public void testExceptionForWritingInvalidMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `a` INT,\n                     |  `metadata_1` TIMESTAMP(3) METADATA\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'writable-metadata' = 'metadata_1:BOOLEAN'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT TIMESTAMP '1990-10-14 06:00:00.000'\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet)).hasMessageContaining("Invalid data type for metadata column 'metadata_1' of table 'default_catalog.default_database.MetadataTable'. The column cannot be declared as 'TIMESTAMP(3)' because the type must be castable to metadata type 'BOOLEAN'.") instanceof ValidationException;
    }

    @Test
    public void testMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `a`, `m_2`, `b`, `c`, `metadata_1`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMetadataColumnThatConflictsWithPhysicalColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `metadata_1` DOUBLE,\n                     |  `m_1` STRING METADATA FROM 'metadata_1' VIRTUAL,\n                     |  `m_2` BIGINT METADATA FROM 'metadata_2',\n                     |  `metadata_2` DOUBLE,\n                     |  `other` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT',\n                     |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `metadata_1`, `m_2`, `metadata_2`, `other`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testSinkDisorderChangeLogWithJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkJoinChangeLog (\n                               |  person STRING, votes BIGINT, prize DOUBLE,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkJoinChangeLog\n        |SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T, award\n        |   WHERE T.sum_votes = award.votes\n        |")).stripMargin());
    }

    @Test
    public void testSinkDisorderChangeLogWithRank() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkRankChangeLog (\n                               |  person STRING, votes BIGINT,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkRankChangeLog\n        |SELECT person, sum_votes FROM\n        | (SELECT person, sum_votes,\n        |   ROW_NUMBER() OVER (PARTITION BY vote_section ORDER BY sum_votes DESC) AS rank_number\n        |   FROM (SELECT person, SUM(votes) AS sum_votes, SUM(votes) / 2 AS vote_section FROM src\n        |      GROUP BY person))\n        |   WHERE rank_number < 10\n        |")).stripMargin());
    }

    @Test
    public void testAppendStreamToSinkWithPkAutoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkNoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.NONE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testSingleParallelismAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBySingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkDifferentParallelism() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.AUTO);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I,UB,UA,D'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '2'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkSingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint,\n                      | rn bigint,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                            |insert into sink\n                            |select * from (\n                            |  select *, row_number() over (partition by id order by ts desc) rn\n                            |  from source\n                            |) where rn=1")).stripMargin());
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testInsertPartColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE zm_test (\n                     |  `a` BIGINT,\n                     |  `m1` MAP<STRING, BIGINT>,\n                     |  `m2` MAP<STRING NOT NULL, BIGINT>,\n                     |  `m3` MAP<STRING, BIGINT NOT NULL>,\n                     |  `m4` MAP<STRING NOT NULL, BIGINT NOT NULL>\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO zm_test(`a`) SELECT `a` FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testDistribution() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) DISTRIBUTED BY (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testDistributionWithRequiredBucketCount() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) DISTRIBUTED BY (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink.bucket-count-required' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(stmtSet)).hasMessageContaining("Table 'default_catalog.default_database.sink' is a bucketed table, but the underlying DynamicTableSink requires the number of buckets to be set.");
    }

    @Test
    public void testDistributionWithUnsupportedDistributionAlgorithm() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) DISTRIBUTED BY RANGE (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(stmtSet)).hasMessageContaining("Table 'default_catalog.default_database.sink' is a bucketed table and it supports [HASH, UNKNOWN], but algorithm RANGE was requested.");
    }

    @Test
    public void testExplainCreateTableAsSelect() {
        String actual = this.util().tableEnv().explainSql(new StringOps(Predef$.MODULE$.augmentString("\n                                            |CREATE TABLE MyCtasTable\n                                            | WITH (\n                                            |   'connector' = 'values'\n                                            |) AS\n                                            |  SELECT\n                                            |    `a`,\n                                            |    `b`\n                                            |  FROM\n                                            |    MyTable\n                                            |")).stripMargin(), new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainCtas.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testExplainReplaceTableAsSelect() {
        String actual = this.util().tableEnv().explainSql(new StringOps(Predef$.MODULE$.augmentString("\n                                            |REPLACE TABLE MyCtasTable\n                                            | WITH (\n                                            |   'connector' = 'values'\n                                            |) AS\n                                            |  SELECT\n                                            |    `a`,\n                                            |    `b`\n                                            |  FROM\n                                            |    MyTable\n                                            |")).stripMargin(), new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainCtas.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testExplainCreateTableAsSelectWithColumnsInCreateAndQueryParts() {
        String actual = this.util().tableEnv().explainSql(new StringOps(Predef$.MODULE$.augmentString("\n                                 |CREATE TABLE MyCtasTable(`votes` INT, `votes_2x` AS `b` * 2)\n                                 | WITH (\n                                 |   'connector' = 'values'\n                                 |) AS\n                                 |  SELECT\n                                 |    `a`,\n                                 |    `b`\n                                 |  FROM\n                                 |    MyTable\n                                 |")).stripMargin(), new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainCtasWithColumnsInCreateAndQueryParts.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testExplainReplaceTableAsSelectWithColumnsInCreateAndQueryParts() {
        String actual = this.util().tableEnv().explainSql(new StringOps(Predef$.MODULE$.augmentString("\n                                 |REPLACE TABLE MyCtasTable(`votes` INT, `votes_2x` AS `b` * 2)\n                                 | WITH (\n                                 |   'connector' = 'values'\n                                 |) AS\n                                 |  SELECT\n                                 |    `a`,\n                                 |    `b`\n                                 |  FROM\n                                 |    MyTable\n                                 |")).stripMargin(), new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainCtasWithColumnsInCreateAndQueryParts.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    public TableSinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE src (person String, votes BIGINT) WITH(\n                             |  'connector' = 'values'\n                             |)\n                             |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
    }
}

