/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.stream.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001BC\u0002\u0013\u0005a\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00030\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Baa\u0011\u0001!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005\"\u0002+\u0001\t\u0003)\u0005\"B-\u0001\t\u0003)\u0005\"B.\u0001\t\u0003)\u0005\"B/\u0001\t\u0003)\u0005\"B0\u0001\t\u0003)\u0005\"B1\u0001\t\u0003)\u0005\"B2\u0001\t\u0003)u!\u0002>\u0016\u0011\u0003Yh!\u0002\u000b\u0016\u0011\u0003a\bB\u0002\u001d\u0012\t\u0003\t\t\u0001C\u0004\u0002\u0004E!\t!!\u0002\u0003/A\u000b'\u000f^5uS>t\u0017M\u00197f'>,(oY3UKN$(B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\taa\u001d;sK\u0006l'B\u0001\u000e\u001c\u0003\u0011\u0001H.\u00198\u000b\u0005qi\u0012a\u00029mC:tWM\u001d\u0006\u0003=}\tQ\u0001^1cY\u0016T!\u0001I\u0011\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+7\u0005)Q\u000f^5mg&\u0011A&\u000b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002+M|WO]2f\r\u0016$8\r\u001b)beRLG/[8ogV\tq\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004C_>dW-\u00198\u0002-M|WO]2f\r\u0016$8\r\u001b)beRLG/[8og\u0002\n\u0001#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:\u0002#U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004uqj\u0004CA\u001e\u0001\u001b\u0005)\u0002\"B\u0017\u0006\u0001\u0004y\u0003\"\u0002\u001c\u0006\u0001\u0004y\u0013\u0001B;uS2,\u0012\u0001\u0011\t\u0003Q\u0005K!AQ\u0015\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u0003\u0019\u0003\"\u0001M$\n\u0005!\u000b$\u0001B+oSRD#\u0001\u0003&\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015aA1qS*\u0011q\nU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t6%A\u0003kk:LG/\u0003\u0002T\u0019\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002EQ,7\u000f^*j[BdW\rU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^32Q\tIa\u000b\u0005\u0002L/&\u0011\u0001\f\u0014\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001+i\u0016\u001cH\u000fU1si&\fG\u000eU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^3QkNDGi\\<oQ\tQa+A\u000euKN$x+\u001b;i+\u00124\u0017I\u001c3WSJ$X/\u00197D_2,XN\u001c\u0015\u0003\u0017Y\u000b\u0011\u0004^3tiVs7m\u001c8wKJ$X\rZ#yaJ,7o]5p]\"\u0012ABV\u00014i\u0016\u001cH\u000fU;tQ\u0012{wO\u001c)beRLG/[8o\u0003:$g)\u001b7uKJ\u001c8i\u001c8uC&t\u0007+\u0019:uSRLwN\\&fsND#!\u0004,\u0002\u000fR,7\u000f\u001e)vg\"$un\u001e8QCJ$\u0018\u000e^5p]\u0006sGMR5mi\u0016\u00148oQ8oi\u0006Lg\u000eU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'&tw\r\\3Qe>TWm\u0019;j_:D#A\u0004,\u0002AQ,7\u000f\u001e)vg\"$un\u001e8O_:,\u00050[:uK:$\b+\u0019:uSRLwN\u001c\u0015\u0003\u001fYCC\u0001\u00014m[B\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eT\u0001\nKb$XM\\:j_:L!a\u001b5\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001oG\u0005y\u0007C\u00019y\u001b\u0005\t(B\u0001:t\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011A/^\u0001\u000bKb$XM\\:j_:\u001c(BA)w\u0015\t9x$A\u0005uKN$X\u000f^5mg&\u0011\u00110\u001d\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0001\u0018!\u0006\u0014H/\u001b;j_:\f'\r\\3T_V\u00148-\u001a+fgR\u0004\"aO\t\u0014\u0005Ei\bC\u0001\u0019\u007f\u0013\ty\u0018G\u0001\u0004B]f\u0014VM\u001a\u000b\u0002w\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005\u001d\u0001CBA\u0005\u0003#\t)\"\u0004\u0002\u0002\f)\u0019a(!\u0004\u000b\u0005\u0005=\u0011\u0001\u00026bm\u0006LA!a\u0005\u0002\f\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u000bA\n9\"a\u0007\n\u0007\u0005e\u0011GA\u0003BeJ\f\u0017\u0010E\u00021\u0003;I1!a\b2\u0005\r\te.\u001f\u0015\b'\u0005\r\u0012\u0011FA\u0016!\r\u0001\u0018QE\u0005\u0004\u0003O\t(A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\ti#A\u0018t_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:>wBjH\u0006I;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s{m\fT\u0010")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final StreamTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableAndFilterableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s',\n        |    'filterable-fields' = 'id;part1;part2'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(partitionableTable, partitions));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
            return;
        }
        TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
        this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
        this.util().tableEnv().useCatalog("test_catalog");
        this.util().tableEnv().executeSql(String.format(partitionableTable, ""));
        this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
        ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
        ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
        Seq partitions = (Seq)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)Nil$.MODULE$))));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionableSourceTest.$anonfun$setup$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.util().verifyExecPlan("select * from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.util().verifyExecPlan("select name from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownNonExistentPartition() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 = 4");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

