/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}3Aa\u0003\u0007\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003BB\u0017\u0001A\u0003%!\u0006C\u0003/\u0001\u0011%q\u0006C\u0003I\u0001\u0011\u0005\u0011\nC\u0003V\u0001\u0011\u0005\u0011\nC\u0003X\u0001\u0011\u0005\u0011\nC\u0003Z\u0001\u0011\u0005\u0011\nC\u0003\\\u0001\u0011\u0005\u0011\nC\u0003^\u0001\u0011\u0005\u0011JA\u000bQCJ$\u0018\u000e^5p]\u0006\u0014G.Z*j].$Vm\u001d;\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0007gR\u0014X-Y7\u000b\u0005E\u0011\u0012\u0001\u00029mC:T!a\u0005\u000b\u0002\u000fAd\u0017M\u001c8fe*\u0011QCF\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003/a\tQA\u001a7j].T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\t\t##A\u0003vi&d7/\u0003\u0002$A\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\u0007\u0002\tU$\u0018\u000e\\\u000b\u0002UA\u0011qdK\u0005\u0003Y\u0001\u00121c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\n1b\u0019:fCR,G+\u00192mKR\u0019\u0001GN\"\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006o\u0011\u0001\r\u0001O\u0001\u0005]\u0006lW\r\u0005\u0002:\u0001:\u0011!H\u0010\t\u0003wIj\u0011\u0001\u0010\u0006\u0003{q\ta\u0001\u0010:p_Rt\u0014BA 3\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011I\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}\u0012\u0004\"\u0002#\u0005\u0001\u0004)\u0015!C:ik\u001a4G.\u001a\"z!\t\td)\u0003\u0002He\t9!i\\8mK\u0006t\u0017A\u0003;fgR\u001cF/\u0019;jGR\t\u0001\u0007\u000b\u0002\u0006\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0004CBL'B\u0001)R\u0003\u001dQW\u000f]5uKJT!A\u0015\u000e\u0002\u000b),h.\u001b;\n\u0005Qk%\u0001\u0002+fgR\f1\u0002^3ti\u0012Kh.Y7jG\"\u0012aaS\u0001\u0015i\u0016\u001cH\u000fR=oC6L7m\u00155vM\u001adWMQ=)\u0005\u001dY\u0015a\u0003;fgR\u0004\u0016M\u001d;jC2D#\u0001C&\u0002\u001fQ,7\u000f^,s_:<7\u000b^1uS\u000eD#!C&\u0002\u001fQ,7\u000f^,s_:<g)[3mIND#AC&")
public class PartitionableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n         |create table ").append(name).append(" (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ").append((Object)(shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : "")).append("\n         |  'format' = 'testcsv'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test
    public void testWrongStatic() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable"));
    }

    @Test
    public void testWrongFields() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable"));
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.PartitionableSinkTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.createTable("sink", false);
    }
}

