/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n#a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!G\u0001\nNCR\u001c\u0007NU3d_\u001et\u0017N_3UKN$(B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\taa\u001d;sK\u0006l'B\u0001\u000b\u0016\u0003\u0011\u0001H.\u00198\u000b\u0005Y9\u0012a\u00029mC:tWM\u001d\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%+\u0005)Q\u000f^5mg&\u0011ae\t\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005y\u0011\u0001B;uS2,\u0012!\f\t\u0003E9J!aL\u0012\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\r\t,gm\u001c:f)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\u0002\u001e\u0011\u0005m\u0012U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\tU$A\u0003kk:LG/\u0003\u0002Dy\tQ!)\u001a4pe\u0016,\u0015m\u00195\u00027Q,7\u000f^'bi\u000eD'+Z2pO:L'0Z(o%><H/[7fQ\t)a\t\u0005\u0002<\u000f&\u0011\u0001\n\u0010\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$X*\u0019;dQJ+7m\\4oSj,wJ\u001c*poRLW.\u001a'U5\"\u0012aAR\u0001*i\u0016\u001cHoV5oI><HK\u0016$P]6\u000bGo\u00195SK\u000e|wM\\5{K>s'k\\<uS6,G\n\u0016.)\u0005\u001d1\u0015A\u000b;fgR|e/\u001a:XS:$wn^(o\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u001f:\u0014vn\u001e;j[\u0016dEK\u0017\u0015\u0003\u0011\u0019\u000b\u0001\u0003^3ti\u000e\u000b7oY1eK6\u000bGo\u00195)\u0005%1\u0015a\u000b;fgRl\u0015\r^2i%><H/[7f/&$\bn\\;u\u0003J<W/\\3oi>s'k\\<uS6,G\n\u0016.)\u0005)1\u0015\u0001\t;fgRl\u0015\r^2i%><H/[7f/&$\b.T;mi&\u0004H.Z!sOND#a\u0003$\u0002[Q,7\u000f^'bi\u000eD'k\\<uS6,w+\u001b;i\u001d>t'k\\<US6,\u0017\t\u001e;sS\n,H/Z!t\u0003J<7\u000f\u000b\u0002\r\r\u0006\u0001C/Z:u\u001b\u0006$8\r\u001b*poRLW.Z,ji\"\u0014V\r_\"bY2\f5/\u0011:hQ\tia\t")
public class MatchRecognizeTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker (\n        | `symbol` STRING,\n        | `ts_ltz` TIMESTAMP_LTZ(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts_ltz` AS `ts_ltz` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testMatchRecognizeOnRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker1 (\n        | `symbol` STRING,\n        | `ts` TIMESTAMP(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts` AS `ts` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker1\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWindowTVFOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM TABLE(TUMBLE(TABLE T, DESCRIPTOR(matchRowtime), INTERVAL '3' second))\n         |")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testOverWindowOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  symbol,\n        |  price,\n        |  tax,\n        |  matchRowtime,\n        |  SUM(price) OVER (\n        |    PARTITION BY symbol ORDER BY matchRowtime RANGE UNBOUNDED PRECEDING) as price_sum\n        |FROM T\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testCascadeMatch() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |  SELECT\n         |    symbol,\n         |    matchRowtime,\n         |    price,\n         |    TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |  FROM Ticker\n         |  MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, matchRowtime, price, TUMBLE(matchRowtime, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY matchRowtime\n         |  MEASURES\n         |    A.price as dPrice,\n         |    A.matchRowtime as matchRowtime\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.matchRowtime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithoutArgumentOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("MATCH_ROWTIME(rowtimeField) should be used when input stream contains rowtime attribute with TIMESTAMP_LTZ type.\nPlease pass rowtime attribute field as input argument of MATCH_ROWTIME(rowtimeField) function.") instanceof AssertionError;
    }

    @Test
    public void testMatchRowtimeWithMultipleArgs() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz, price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("Invalid number of arguments to function 'MATCH_ROWTIME'.") instanceof ValidationException;
    }

    @Test
    public void testMatchRowtimeWithNonRowTimeAttributeAsArgs() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("The function MATCH_ROWTIME requires argument to be a row time attribute type, but is 'INTEGER'.") instanceof ValidationException;
    }

    @Test
    public void testMatchRowtimeWithRexCallAsArg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz + INTERVAL '1' SECOND) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("The function MATCH_ROWTIME requires a field reference as argument, but actual argument is not a simple field reference.") instanceof ValidationException;
    }
}

