/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.LimitTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0015+\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013Eq\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006?\u0002!\t!\u0014\u0005\u0006I\u0002!\t!\u0014\u0005\u0006M\u0002!\t!\u0014\u0005\u0006Q\u0002!\t!\u0014\u0005\u0006U\u0002!\t!\u0014\u0005\u0006Y\u0002!\t!\u0014\u0005\u0006]\u0002!\t!\u0014\u0005\u0006a\u0002!\t!\u0014\u0005\u0006e\u0002!\t!\u0014\u0005\u0006i\u0002!\t!\u0014\u0005\u0006m\u0002!\t!\u0014\u0005\u0006q\u0002!\t!\u0014\u0005\u0006u\u0002!\t!\u0014\u0005\u0006y\u0002!\t!\u0014\u0005\u0006}\u0002!\t!\u0014\u0005\u0007\u0003\u0003\u0001A\u0011A'\t\r\u0005\u0015\u0001\u0001\"\u0001N\u0011\u0019\tI\u0001\u0001C\u0001\u001b\"1\u0011Q\u0002\u0001\u0005\u00025Ca!!\u0005\u0001\t\u0003i\u0005BBA\u000b\u0001\u0011\u0005Q\n\u0003\u0004\u0002\u001a\u0001!\t!\u0014\u0005\u0007\u0003;\u0001A\u0011A'\t\r\u0005\u0005\u0002\u0001\"\u0001N\u0011\u0019\t)\u0003\u0001C\u0001\u001b\"1\u0011\u0011\u0006\u0001\u0005\u00025Ca!!\f\u0001\t\u0003i\u0005BBA\u0019\u0001\u0011\u0005Q\n\u0003\u0004\u00026\u0001!\t!\u0014\u0005\u0007\u0003s\u0001A\u0011A'\t\r\u0005u\u0002\u0001\"\u0001N\u0011\u0019\t\t\u0005\u0001C\u0001\u001b\"1\u0011Q\t\u0001\u0005\u00025Ca!!\u0013\u0001\t\u0003i\u0005BBA'\u0001\u0011\u0005Q\n\u0003\u0004\u0002R\u0001!\t!\u0014\u0002\n\u0019&l\u0017\u000e\u001e+fgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u000511\u000f\u001e:fC6T!a\f\u0019\u0002\tAd\u0017M\u001c\u0006\u0003cI\nq\u0001\u001d7b]:,'O\u0003\u00024i\u0005)A/\u00192mK*\u0011QGN\u0001\u0006M2Lgn\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0004CA\u001fA\u001b\u0005q$BA 1\u0003\u0015)H/\u001b7t\u0013\t\teHA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"!\u0012\u0001\u000e\u0003)\nA!\u001e;jYV\t\u0001\n\u0005\u0002>\u0013&\u0011!J\u0010\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n!QK\\5uQ\t!Q\u000b\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039b\nQA[;oSRL!AX,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fuKN$H*[7ji^KG\u000f[8vi>3gm]3uQ\t)\u0011\r\u0005\u0002WE&\u00111m\u0016\u0002\u0005)\u0016\u001cH/A\fuKN$H*[7jiB:\u0016\u000e\u001e5pkR|eMZ:fi\"\u0012a!Y\u0001\u001fi\u0016\u001cHOT3hCRLg/\u001a'j[&$x+\u001b;i_V$xJ\u001a4tKRD#aB1\u0002'Q,7\u000f\u001e'j[&$x+\u001b;i\u001f\u001a47/\u001a;)\u0005!\t\u0017\u0001\u0006;fgRd\u0015.\\5u/&$\bn\u00144gg\u0016$\b\u0007\u000b\u0002\nC\u0006)B/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRDwJ\u001a4tKR\u0004\u0004F\u0001\u0006b\u0003Q!Xm\u001d;MS6LG\u000fM,ji\"|eMZ:fi\"\u00121\"Y\u0001\u001ci\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f\u001f\u001a47/\u001a;)\u00051\t\u0017a\u0005;fgR4U\r^2i/&$\bn\u00144gg\u0016$\bFA\u0007b\u0003Y!Xm\u001d;GKR\u001c\u0007nV5uQ>,Ho\u00144gg\u0016$\bF\u0001\bb\u0003]!Xm\u001d;GKR\u001c\u0007\u000eM,ji\"|W\u000f^(gMN,G\u000f\u000b\u0002\u0010C\u0006qA/Z:u\u001f:d\u0017p\u00144gg\u0016$\bF\u0001\tb\u0003Q!Xm\u001d;MS6LGoV5uQJ{w\u000fV5nK\"\u0012\u0011#Y\u0001\u0016i\u0016\u001cH\u000fT5nSR\u0004t+\u001b;i%><H+[7fQ\t\u0011\u0012-A\u000buKN$xJ\u001a4tKR<\u0016\u000e\u001e5S_^$\u0016.\\3)\u0005M\t\u0017\u0001\b;fgRd\u0015.\\5ua]KG\u000f\u001b)s_\u000e,7o]5oORKW.\u001a\u0015\u0003)\u0005\f1\u0004^3ti2KW.\u001b;XSRD\u0007K]8dKN\u001c\u0018N\\4US6,\u0007FA\u000bb\u0003q!Xm\u001d;PM\u001a\u001cX\r^,ji\"\u0004&o\\2fgNLgn\u001a+j[\u0016D#AF1\u00027Q,7\u000f\u001e'j[&$\bgV5uQJ{w\u000fV5nKN+7m\u001c8eQ\t9\u0012-\u0001\u000euKN$H*[7ji^KG\u000f\u001b*poRKW.Z*fG>tG\r\u000b\u0002\u0019C\u0006YB/Z:u\u001f\u001a47/\u001a;XSRD'k\\<US6,7+Z2p]\u0012D#!G1\u0002EQ,7\u000f\u001e'j[&$\bgV5uQB\u0013xnY3tg&tw\rV5nKN+7m\u001c8eQ\tQ\u0012-A\u0011uKN$H*[7ji^KG\u000f\u001b)s_\u000e,7o]5oORKW.Z*fG>tG\r\u000b\u0002\u001cC\u0006\u0011C/Z:u\u001f\u001a47/\u001a;XSRD\u0007K]8dKN\u001c\u0018N\\4US6,7+Z2p]\u0012D#\u0001H1\u00023Q,7\u000f\u001e'j[&$\bgV5uQJ{w\u000fV5nK\u0012+7o\u0019\u0015\u0003;\u0005\f\u0001\u0004^3ti2KW.\u001b;XSRD'k\\<US6,G)Z:dQ\tq\u0012-A\ruKN$xJ\u001a4tKR<\u0016\u000e\u001e5S_^$\u0016.\\3EKN\u001c\u0007FA\u0010b\u0003\u0001\"Xm\u001d;MS6LG\u000fM,ji\"\u0004&o\\2fgNLgn\u001a+j[\u0016$Um]2)\u0005\u0001\n\u0017a\b;fgRd\u0015.\\5u/&$\b\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rR3tG\"\u0012\u0011%Y\u0001!i\u0016\u001cHo\u00144gg\u0016$x+\u001b;i!J|7-Z:tS:<G+[7f\t\u0016\u001c8\r\u000b\u0002#C\u0006yB/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRD'k\\<US6,G)Z:d'\u0016\u001cwN\u001c3)\u0005\r\n\u0017A\b;fgRd\u0015.\\5u/&$\bNU8x)&lW\rR3tGN+7m\u001c8eQ\t!\u0013-A\u0010uKN$xJ\u001a4tKR<\u0016\u000e\u001e5S_^$\u0016.\\3EKN\u001c7+Z2p]\u0012D#!J1\u0002MQ,7\u000f\u001e'j[&$\bgV5uQB\u0013xnY3tg&tw\rV5nK\u0012+7oY*fG>tG\r\u000b\u0002'C\u0006)C/Z:u\u0019&l\u0017\u000e^,ji\"\u0004&o\\2fgNLgn\u001a+j[\u0016$Um]2TK\u000e|g\u000e\u001a\u0015\u0003O\u0005\fa\u0005^3ti>3gm]3u/&$\b\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rR3tGN+7m\u001c8eQ\tA\u0013\r")
public class LimitTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.LimitTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLimitWithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 5");
    }

    @Test
    public void testLimit0WithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 0");
    }

    @Test
    public void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT -1"));
    }

    @Test
    public void testLimitWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testLimitWithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 10");
    }

    @Test
    public void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET -1"));
    }

    @Test
    public void testFetchWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testFetchWithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testFetch0WithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 0 ROWS ONLY");
    }

    @Test
    public void testOnlyOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS");
    }

    @Test
    public void testLimitWithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testLimit0WithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testOffsetWithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable OFFSET 2");
    }
}

