/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d4AAE\n\u0001I!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%\t\u0001\r\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002UB\u0011B\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u000b}\u0002A\u0011\u0001!\t\u000b1\u0003A\u0011\u0001!\t\u000bE\u0003A\u0011\u0001!\t\u000bM\u0003A\u0011\u0001!\t\u000bU\u0003A\u0011\u0001!\t\u000b]\u0003A\u0011\u0001!\t\u000be\u0003A\u0011\u0001!\t\u000bm\u0003A\u0011\u0001!\t\u000bu\u0003A\u0011\u0001!\t\u000b}\u0003A\u0011\u0001!\t\u000b\u0005\u0004A\u0011\u0001!\t\u000b\r\u0004A\u0011\u0001!\t\u000b\u0015\u0004A\u0011\u0001!\u0003\u001f\u0011+G-\u001e9mS\u000e\fG/\u001a+fgRT!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u000511\u000f\u001e:fC6T!\u0001G\r\u0002\tAd\u0017M\u001c\u0006\u00035m\tq\u0001\u001d7b]:,'O\u0003\u0002\u001d;\u0005)A/\u00192mK*\u0011adH\u0001\u0006M2Lgn\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u001a\u0003\u0015)H/\u001b7t\u0013\tQsEA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003M\tA!\u001e;jYV\t\u0011\u0007\u0005\u0002'e%\u00111g\n\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\\\u0001\tkRLGn\u0018\u0013fcR\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0004>\u0007\u0005\u0005\t\u0019A\u0019\u0002\u0007a$\u0013'A\u0003vi&d\u0007%A\u0003tKR,\u0006\u000fF\u00017Q\t)!\t\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015a\u00026va&$XM\u001d\u0006\u0003\u0013\u0006\nQA[;oSRL!a\u0013#\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0014uKN$\u0018J\u001c<bY&$'k\\<Ok6\u0014WM]\"p]\u0012LG/[8o\u001f:\u0004&o\\2uS6,\u0007F\u0001\u0004O!\t\u0019u*\u0003\u0002Q\t\n!A+Z:u\u0003\u0019\"Xm\u001d;J]Z\fG.\u001b3S_^tU/\u001c2fe\u000e{g\u000eZ5uS>twJ\u001c*poRLW.\u001a\u0015\u0003\u000f9\u000b\u0011\u0004^3ti&sg/\u00197jI\u000eC\u0017M\\4fY><\u0017J\u001c9vi\"\u0012\u0001BT\u0001\u001fi\u0016\u001cH\u000fT1tiJ{woV5uQ^Kg\u000eZ8x\u001f:\u0014vn\u001e;j[\u0016D#!\u0003(\u00027Q,7\u000f^*j[BdWMR5sgR\u0014vn^(o%><H/[7fQ\tQa*A\u0012uKN$X*\u001b8j\u0005\u0006$8\r[%oM\u0016\u0014h)\u001b:tiJ{wo\u00148S_^$\u0018.\\3)\u0005-q\u0015A\u0007;fgR\u001c\u0016.\u001c9mK2\u000b7\u000f\u001e*po>s'k\\<uS6,\u0007F\u0001\u0007O\u0003\t\"Xm\u001d;NS:L')\u0019;dQ&sg-\u001a:MCN$(k\\<P]J{w\u000f^5nK\"\u0012QBT\u0001\u001ci\u0016\u001cHoU5na2,G*Y:u%><xJ\u001c)s_\u000e$\u0018.\\3)\u00059q\u0015A\t;fgR\u001c\u0016.\u001c9mK2\u000b7\u000f\u001e*po>s')^5mi&t\u0007K]8di&lW\r\u000b\u0002\u0010\u001d\u0006aB/Z:u'&l\u0007\u000f\\3GSJ\u001cHOU8x\u001f:\u0004&o\\2uS6,\u0007F\u0001\tO\u0003\r\"Xm\u001d;TS6\u0004H.\u001a$jeN$(k\\<P]\n+\u0018\u000e\u001c;j]B\u0013xn\u0019;j[\u0016D#!\u0005(")
public class DeduplicateTest
extends TableTestBase {
    private StreamTableTestUtil util;

    public StreamTableTestUtil util() {
        return this.util;
    }

    public void util_$eq(StreamTableTestUtil x$1) {
        this.util = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.util_$eq(this.streamTestUtil(this.streamTestUtil$default$1()));
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testInvalidRowNumberConditionOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInvalidRowNumberConditionOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInvalidChangelogInput() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create temporary table cdc (\n                               | a int,\n                               | b bigint,\n                               | ts timestamp_ltz(3),\n                               | primary key (a) not enforced,\n                               | watermark for ts as ts - interval '5' second\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,UB,D'\n                               |)")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY ts DESC) as rank_num\n        |  FROM cdc)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLastRowWithWindowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(500L));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T (\n        | `a` INT,\n        | `b` STRING,\n        | `ts` TIMESTAMP(3),\n        | WATERMARK FOR `ts` AS `ts`\n        |) WITH (\n        | 'connector' = 'COLLECTION',\n        | 'is-bounded' = 'false'\n        |)\n      ")).stripMargin());
        String deduplicateSQl = new StringOps(Predef$.MODULE$.augmentString("\n        |(\n        |SELECT a, b, ts\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n        |  FROM T\n        |)\n        |WHERE rowNum = 1\n        |)\n      ")).stripMargin();
        String windowSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n         |select b, sum(a), TUMBLE_START(ts, INTERVAL '0.004' SECOND)\n         |FROM ").append(deduplicateSQl).append("\n         |GROUP BY b, TUMBLE(ts, INTERVAL '0.004' SECOND)\n      ").toString())).stripMargin();
        this.util().verifyExplain(windowSql);
    }

    @Test
    public void testSimpleFirstRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferFirstRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num <= 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferLastRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num = 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (ORDER BY PROCTIME() DESC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleFirstRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleFirstRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY PROCTIME() ASC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

