/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0012$\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004E\u0001\u0001\u0006I!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u00061\u0002!\tA\u0012\u0005\u0006;\u0002!\tA\u0012\u0005\u0006?\u0002!\tA\u0012\u0005\u0006C\u0002!\tA\u0012\u0005\u0006G\u0002!\tA\u0012\u0005\u0006K\u0002!\tA\u0012\u0005\u0006O\u0002!\tA\u0012\u0005\u0006S\u0002!\tA\u0012\u0005\u0006W\u0002!\tA\u0012\u0005\u0006[\u0002!\tA\u0012\u0005\u0006_\u0002!\tA\u0012\u0005\u0006c\u0002!\tA\u0012\u0005\u0006g\u0002!\tA\u0012\u0005\u0006k\u0002!\tA\u0012\u0005\u0006o\u0002!\tA\u0012\u0005\u0006s\u0002!\tA\u0012\u0005\u0006w\u0002!\tA\u0012\u0005\u0006{\u0002!\tA\u0012\u0005\u0006\u007f\u0002!\tA\u0012\u0005\u0007\u0003\u0007\u0001A\u0011\u0001$\t\r\u0005\u001d\u0001\u0001\"\u0001G\u0011\u0019\tY\u0001\u0001C\u0001\r\"1\u0011q\u0002\u0001\u0005\u0002\u0019Ca!a\u0005\u0001\t\u00031\u0005BBA\f\u0001\u0011\u0005a\t\u0003\u0004\u0002\u001c\u0001!\tA\u0012\u0005\u0007\u0003?\u0001A\u0011\u0001$\t\r\u0005\r\u0002\u0001\"\u0001G\u0011\u0019\t9\u0003\u0001C\u0001\r\nA1)\u00197d)\u0016\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013AB:ue\u0016\fWN\u0003\u0002)S\u0005!\u0001\u000f\\1o\u0015\tQ3&A\u0004qY\u0006tg.\u001a:\u000b\u00051j\u0013!\u0002;bE2,'B\u0001\u00180\u0003\u00151G.\u001b8l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003q%\nQ!\u001e;jYNL!AO\u001c\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002?\u00015\t1%\u0001\u0003vi&dW#A!\u0011\u0005Y\u0012\u0015BA\"8\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%\u0001B+oSRD#\u0001\u0002(\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016aA1qS*\u00111\u000bV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)\u0016'A\u0003kk:LG/\u0003\u0002X!\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001fQ,7\u000f^(oYf\u0004&o\u001c6fGRD#!\u0002.\u0011\u0005=[\u0016B\u0001/Q\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f\u001e)s_*,7\r^,ji\"t\u0015-\\5oO\"\u0012aAW\u0001\u0012i\u0016\u001cH/T;mi&\u0004&o\u001c6fGR\u001c\bFA\u0004[\u00039!Xm\u001d;P]2Lh)\u001b7uKJD#\u0001\u0003.\u0002+Q,7\u000f\u001e#jg*,hn\u0019;jm\u00164\u0015\u000e\u001c;fe\"\u0012\u0011BW\u0001\u0016i\u0016\u001cHoQ8oUVt7\r^5wK\u001aKG\u000e^3sQ\tQ!,\u0001\tuKN$X*\u001e7uS\u001aKG\u000e^3sg\"\u00121BW\u0001\u0015i\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/\u00118e\r&dG/\u001a:)\u00051Q\u0016A\u0002;fgRLe\u000e\u000b\u0002\u000e5\u0006YB/Z:u\r&dG/\u001a:P]:{g.Q:dS&d\u0015\u000e^3sC2D#A\u0004.\u0002\u0013Q,7\u000f\u001e(pi&s\u0007FA\b[\u0003Y!Xm\u001d;Nk2$\u0018\u000e\u001d7f\r2\fG\u000f^3oS:<\u0007F\u0001\t[\u0003E!Xm\u001d;J]Z\fG.\u001b3GS\u0016dGm\u001d\u0015\u0003#i\u000bA\u0003^3tiB\u0013\u0018.\\5uSZ,W*\u00199UsB,\u0007F\u0001\n[\u0003]!Xm\u001d;O_:\u0004&/[7ji&4X-T1q)f\u0004X\r\u000b\u0002\u00145\u0006YA/Z:u%><H+\u001f9fQ\t!\",A\u0007uKN$\u0018I\u001d:bsRK\b/\u001a\u0015\u0003+i\u000bq\u0003^3tiB\u0013xN[3di^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005YQ\u0016A\u0006;fgR4\u0015\u000e\u001c;fe^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005]Q\u0016\u0001\u0004;fgR\u0004vN[8UsB,\u0007F\u0001\r[\u00035!Xm\u001d;NSb,G\rV=qK\"\u0012\u0011DW\u0001\u001ai\u0016\u001cHo\u0014:XSRD\u0017j\u001d(vY2\u0004&/\u001a3jG\u0006$X\r\u000b\u0002\u001b5\u0006!B/Z:u\u001fJ<\u0016\u000e\u001e5Jg:+H\u000e\\%o\u0013\u001aD#a\u0007.\u0002MQ,7\u000f\u001e#fG&l\u0017\r\\!se\u0006Lx+\u001b;i\t&4g-\u001a:f]R\u0004&/Z2jg&|g\u000e\u000b\u0002\u001d5\u0006!C/Z:u\t\u0016\u001c\u0017.\\1m\u001b\u0006\u0004x+\u001b;i\t&4g-\u001a:f]R\u0004&/Z2jg&|g\u000e\u000b\u0002\u001e5\u0006)C/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5O_:$U\r^3s[&t\u0017n\u001d;jG\u0016C\bO\u001d\u0015\u0003=i\u000ba\u0005^3ti\u000e\u000bGnY'fe\u001e,w+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:3Q\ty\",\u0001\u000euKN$8)\u00197d\u001b\u0016\u0014x-Z,ji\"\u001cuN\u001d:fY\u0006$X\r\u000b\u0002!5\u0006\u0019B/Z:u%><H+\u001f9f\u000bF,\u0018\r\\5us\"\u0012\u0011E\u0017")
public class CalcTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterOnNonAsciiLiteral() {
        String sql = "SELECT a, b, c, c || TRIM(' \u4e16\u754c ') FROM MyTable WHERE c = '\u4f60\u597d'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = "SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test
    public void testInvalidFields() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable"));
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (AbstractDataType[])((Object[])new AbstractDataType[]{DataTypes.RAW(MyPojo.class)}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT ARRAY[0.12, 0.5, 0.99]");
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT MAP['a', 0.12, 'b', 0.5]");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(b) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a, b FROM MyTable) t WHERE random_udf(b) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithCorrelate() {
        this.util().addTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, r FROM (\n        | SELECT a, random_udf(b) r FROM (\n        |  select a, b, c1 FROM MyTable, LATERAL TABLE(str_split(c)) AS T(c1)\n        | ) t\n        |)\n        |WHERE r > 10\n        |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRowTypeEquality() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE src (\n                     |  my_row ROW(a INT, b STRING)\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |  )\n                     |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT my_row = ROW(1, 'str') from src\n                           |")).stripMargin());
    }
}

