/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule;
import org.apache.flink.table.planner.plan.rules.physical.FlinkExpandConversionRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.ExpandWindowTableFunctionTransposeRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCalcRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalExpandRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalTableSourceScanRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWatermarkAssignerRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWindowAggregateRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWindowTableFunctionRule$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3A\u0001C\u0005\u00019!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003B\u0002\u0017\u0001A\u0003%\u0011\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u0003A\u0001\u0011\u0005a\u0006C\u0003F\u0001\u0011\u0005a\u0006C\u0003H\u0001\u0011\u0005aF\u0001\u0016FqB\fg\u000eZ,j]\u0012|w\u000fV1cY\u00164UO\\2uS>tGK]1ogB|7/\u001a*vY\u0016$Vm\u001d;\u000b\u0005)Y\u0011AB:ue\u0016\fWN\u0003\u0002\r\u001b\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\u000f\u001f\u0005)!/\u001e7fg*\u0011\u0001#E\u0001\u0005a2\fgN\u0003\u0002\u0013'\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015!\u0018M\u00197f\u0015\t1r#A\u0003gY&t7N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\t\u0002\u000bU$\u0018\u000e\\:\n\u0005\tz\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0013\u0005!Q\u000f^5m+\u0005I\u0003C\u0001\u0010+\u0013\tYsDA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0011)f.\u001b;)\u0005\u00111\u0004CA\u001c?\u001b\u0005A$BA\u001d;\u0003\r\t\u0007/\u001b\u0006\u0003wq\nqA[;qSR,'O\u0003\u0002>3\u0005)!.\u001e8ji&\u0011q\b\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\b;fgR$V/\u001c2mK~#\u0015n\u001d;j]\u000e$8\u000b\u001d7ji\u0016s\u0017M\u00197fI\"\u0012QA\u0011\t\u0003o\rK!\u0001\u0012\u001d\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH\u000fS8q?\u0012K7\u000f^5oGR\u001c\u0006\u000f\\5u\u000b:\f'\r\\3eQ\t1!)A\u0011uKN$8)^7vY\u0006$Xm\u0018#jgRLgn\u0019;Ta2LG/\u00128bE2,G\r\u000b\u0002\b\u0005\u0002")
public class ExpandWindowTableFunctionTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        FlinkChainedProgram<StreamOptimizeContext> chainedProgram = this.util().getStreamProgram();
        chainedProgram.addLast(FlinkStreamProgram$.MODULE$.PHYSICAL(), (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkExpandConversionRule$.MODULE$.STREAM_INSTANCE(), StreamPhysicalWindowTableFunctionRule$.MODULE$.INSTANCE(), StreamPhysicalWindowAggregateRule$.MODULE$.INSTANCE(), StreamPhysicalCalcRule$.MODULE$.INSTANCE(), StreamPhysicalExpandRule$.MODULE$.INSTANCE(), StreamPhysicalTableSourceScanRule$.MODULE$.INSTANCE(), StreamPhysicalWatermarkAssignerRule$.MODULE$.INSTANCE()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.STREAM_PHYSICAL()})).build());
        chainedProgram.addLast("test_rule", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkCalcMergeRule.STREAM_PHYSICAL_INSTANCE, ExpandWindowTableFunctionTransposeRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceStreamProgram(chainedProgram);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testTumble_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHop_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulate_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

