/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.rules.physical.batch.RemoveRedundantLocalRankRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001%3A\u0001C\u0005\u00019!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003B\u0002\u0017\u0001A\u0003%\u0011\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u0003A\u0001\u0011\u0005a\u0006C\u0003F\u0001\u0011\u0005a\u0006C\u0003H\u0001\u0011\u0005aF\u0001\u0011SK6|g/\u001a*fIVtG-\u00198u\u0019>\u001c\u0017\r\u001c*b].\u0014V\u000f\\3UKN$(B\u0001\u0006\f\u0003\u0015\u0011\u0017\r^2i\u0015\taQ\"\u0001\u0005qQf\u001c\u0018nY1m\u0015\tqq\"A\u0003sk2,7O\u0003\u0002\u0011#\u0005!\u0001\u000f\\1o\u0015\t\u00112#A\u0004qY\u0006tg.\u001a:\u000b\u0005Q)\u0012!\u0002;bE2,'B\u0001\f\u0018\u0003\u00151G.\u001b8l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003AE\tQ!\u001e;jYNL!AI\u0010\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t\u0011\"\u0001\u0003vi&dW#A\u0015\u0011\u0005yQ\u0013BA\u0016 \u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012A!\u00168ji\"\u0012AA\u000e\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\n1!\u00199j\u0015\tYD(A\u0004kkBLG/\u001a:\u000b\u0005uJ\u0012!\u00026v]&$\u0018BA 9\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHoU1nKJ\u000bgn\u001b*b]\u001e,\u0007FA\u0003C!\t94)\u0003\u0002Eq\t!A+Z:u\u0003E!Xm\u001d;ES\u001a4'+\u00198l%\u0006tw-\u001a\u0015\u0003\r\t\u000ba\u0002^3ti6+H\u000e^5SC:\\7\u000f\u000b\u0002\b\u0005\u0002")
public class RemoveRedundantLocalRankRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.physical.batch.RemoveRedundantLocalRankRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSameRankRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        | SELECT a, RANK() OVER(PARTITION BY a ORDER BY SUM(b)) rk FROM x GROUP BY a\n        |) WHERE rk <= 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffRankRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        | SELECT a, RANK() OVER(PARTITION BY a ORDER BY SUM(b)) rk FROM x GROUP BY a\n        |) WHERE rk <= 5 and rk >= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiRanks() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, rk, RANK() OVER(PARTITION BY a ORDER BY b) rk1 FROM (\n        |   SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM x\n        | ) WHERE rk <= 5\n        |) WHERE rk1 <= 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

